/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.sql.executor;

import com.orientechnologies.orient.core.command.OCommandContext;
import com.orientechnologies.orient.core.db.ODatabaseDocumentInternal;
import com.orientechnologies.orient.core.db.OSharedContextEmbedded;
import com.orientechnologies.orient.core.db.viewmanager.ViewManager;
import com.orientechnologies.orient.core.exception.OCommandExecutionException;
import com.orientechnologies.orient.core.metadata.schema.OView;
import com.orientechnologies.orient.core.sql.executor.FetchFromClassExecutionStep;
import com.orientechnologies.orient.core.sql.executor.OExecutionStepInternal;
import com.orientechnologies.orient.core.sql.executor.QueryPlanningInfo;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;

public class FetchFromViewExecutionStep
extends FetchFromClassExecutionStep {
    List<Integer> usedClusters = new ArrayList<Integer>();

    public FetchFromViewExecutionStep(String className, Set<String> clusters, QueryPlanningInfo planningInfo, OCommandContext ctx, Boolean ridOrder, boolean profilingEnabled) {
        super(className, clusters, planningInfo, ctx, ridOrder, profilingEnabled);
        int[] classClusters;
        OSharedContextEmbedded sharedContext = (OSharedContextEmbedded)((ODatabaseDocumentInternal)ctx.getDatabase()).getSharedContext();
        ViewManager viewManager = sharedContext.getViewManager();
        OView view = this.loadClassFromSchema(className, ctx);
        for (int clusterId : classClusters = view.getPolymorphicClusterIds()) {
            String clusterName = ctx.getDatabase().getClusterNameById(clusterId);
            if (clusters != null && !clusters.contains(clusterName)) continue;
            this.usedClusters.add(clusterId);
            viewManager.startUsingViewCluster(clusterId);
        }
    }

    @Override
    public void close() {
        super.close();
        OSharedContextEmbedded sharedContext = (OSharedContextEmbedded)((ODatabaseDocumentInternal)this.ctx.getDatabase()).getSharedContext();
        ViewManager viewManager = sharedContext.getViewManager();
        this.usedClusters.forEach(x -> viewManager.endUsingViewCluster((Integer)x));
    }

    @Override
    protected OView loadClassFromSchema(String className, OCommandContext ctx) {
        OView clazz = ctx.getDatabase().getMetadata().getSchema().getView(className);
        if (clazz == null) {
            throw new OCommandExecutionException("View " + className + " not found");
        }
        return clazz;
    }

    @Override
    public String prettyPrint(int depth, int indent) {
        StringBuilder builder = new StringBuilder();
        String ind = OExecutionStepInternal.getIndent(depth, indent);
        builder.append(ind);
        builder.append("+ FETCH FROM VIEW " + this.className);
        if (this.profilingEnabled) {
            builder.append(" (" + this.getCostFormatted() + ")");
        }
        builder.append("\n");
        for (int i = 0; i < this.getSubSteps().size(); ++i) {
            OExecutionStepInternal step = (OExecutionStepInternal)this.getSubSteps().get(i);
            builder.append(step.prettyPrint(depth + 1, indent));
            if (i >= this.getSubSteps().size() - 1) continue;
            builder.append("\n");
        }
        return builder.toString();
    }

    @Override
    public boolean canBeCached() {
        return false;
    }
}

