/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.sql.executor;

import com.orientechnologies.common.concur.OTimeoutException;
import com.orientechnologies.common.exception.OException;
import com.orientechnologies.orient.core.command.OCommandContext;
import com.orientechnologies.orient.core.db.ODatabaseDocumentInternal;
import com.orientechnologies.orient.core.db.OExecutionThreadLocal;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.exception.OCommandExecutionException;
import com.orientechnologies.orient.core.exception.OCommandInterruptedException;
import com.orientechnologies.orient.core.id.ORID;
import com.orientechnologies.orient.core.iterator.ORecordIteratorCluster;
import com.orientechnologies.orient.core.sql.executor.AbstractExecutionStep;
import com.orientechnologies.orient.core.sql.executor.OExecutionPlan;
import com.orientechnologies.orient.core.sql.executor.OExecutionStep;
import com.orientechnologies.orient.core.sql.executor.OExecutionStepInternal;
import com.orientechnologies.orient.core.sql.executor.OResult;
import com.orientechnologies.orient.core.sql.executor.OResultInternal;
import com.orientechnologies.orient.core.sql.executor.OResultSet;
import com.orientechnologies.orient.core.sql.executor.QueryPlanningInfo;
import com.orientechnologies.orient.core.sql.parser.OBinaryCompareOperator;
import com.orientechnologies.orient.core.sql.parser.OBinaryCondition;
import com.orientechnologies.orient.core.sql.parser.OBooleanExpression;
import com.orientechnologies.orient.core.sql.parser.OGeOperator;
import com.orientechnologies.orient.core.sql.parser.OGtOperator;
import com.orientechnologies.orient.core.sql.parser.OLeOperator;
import com.orientechnologies.orient.core.sql.parser.OLtOperator;
import com.orientechnologies.orient.core.sql.parser.ORid;
import java.util.Map;
import java.util.Optional;

public class FetchFromClusterExecutionStep
extends AbstractExecutionStep {
    public static final Object ORDER_ASC = "ASC";
    public static final Object ORDER_DESC = "DESC";
    private final QueryPlanningInfo queryPlanning;
    private int clusterId;
    private Object order;
    private ORecordIteratorCluster iterator;
    private long cost = 0L;

    public FetchFromClusterExecutionStep(int clusterId, OCommandContext ctx, boolean profilingEnabled) {
        this(clusterId, null, ctx, profilingEnabled);
    }

    public FetchFromClusterExecutionStep(int clusterId, QueryPlanningInfo queryPlanning, OCommandContext ctx, boolean profilingEnabled) {
        super(ctx, profilingEnabled);
        this.clusterId = clusterId;
        this.queryPlanning = queryPlanning;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OResultSet syncPull(final OCommandContext ctx, final int nRecords) throws OTimeoutException {
        this.getPrev().ifPresent(x -> x.syncPull(ctx, nRecords));
        long begin = this.profilingEnabled ? System.nanoTime() : 0L;
        try {
            OResultSet rs;
            if (this.iterator == null) {
                long minClusterPosition = this.calculateMinClusterPosition();
                long maxClusterPosition = this.calculateMaxClusterPosition();
                this.iterator = new ORecordIteratorCluster((ODatabaseDocumentInternal)ctx.getDatabase(), this.clusterId, minClusterPosition, maxClusterPosition);
                if (ORDER_DESC == this.order) {
                    this.iterator.last();
                }
            }
            OResultSet oResultSet = rs = new OResultSet(){
                int nFetched = 0;

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public boolean hasNext() {
                    long begin = FetchFromClusterExecutionStep.this.profilingEnabled ? System.nanoTime() : 0L;
                    try {
                        if (this.nFetched >= nRecords) {
                            boolean bl = false;
                            return bl;
                        }
                        if (ORDER_DESC == FetchFromClusterExecutionStep.this.order) {
                            boolean bl = FetchFromClusterExecutionStep.this.iterator.hasPrevious();
                            return bl;
                        }
                        boolean bl = FetchFromClusterExecutionStep.this.iterator.hasNext();
                        return bl;
                    }
                    finally {
                        if (FetchFromClusterExecutionStep.this.profilingEnabled) {
                            FetchFromClusterExecutionStep.this.cost = FetchFromClusterExecutionStep.this.cost + (System.nanoTime() - begin);
                        }
                    }
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public OResult next() {
                    if (this.nFetched % 100 == 0 && OExecutionThreadLocal.isInterruptCurrentOperation()) {
                        throw new OCommandInterruptedException("The command has been interrupted");
                    }
                    long begin = FetchFromClusterExecutionStep.this.profilingEnabled ? System.nanoTime() : 0L;
                    try {
                        if (this.nFetched >= nRecords) {
                            throw new IllegalStateException();
                        }
                        if (ORDER_DESC == FetchFromClusterExecutionStep.this.order && !FetchFromClusterExecutionStep.this.iterator.hasPrevious()) {
                            throw new IllegalStateException();
                        }
                        if (ORDER_DESC != FetchFromClusterExecutionStep.this.order && !FetchFromClusterExecutionStep.this.iterator.hasNext()) {
                            throw new IllegalStateException();
                        }
                        Object record = null;
                        record = ORDER_DESC == FetchFromClusterExecutionStep.this.order ? FetchFromClusterExecutionStep.this.iterator.previous() : FetchFromClusterExecutionStep.this.iterator.next();
                        ++this.nFetched;
                        OResultInternal result = new OResultInternal();
                        result.element = record;
                        ctx.setVariable("$current", result);
                        OResultInternal oResultInternal = result;
                        return oResultInternal;
                    }
                    finally {
                        if (FetchFromClusterExecutionStep.this.profilingEnabled) {
                            FetchFromClusterExecutionStep.this.cost = FetchFromClusterExecutionStep.this.cost + (System.nanoTime() - begin);
                        }
                    }
                }

                @Override
                public void close() {
                }

                @Override
                public Optional<OExecutionPlan> getExecutionPlan() {
                    return null;
                }

                @Override
                public Map<String, Long> getQueryStats() {
                    return null;
                }
            };
            return oResultSet;
        }
        finally {
            if (this.profilingEnabled) {
                this.cost += System.nanoTime() - begin;
            }
        }
    }

    private long calculateMinClusterPosition() {
        if (this.queryPlanning == null || this.queryPlanning.ridRangeConditions == null || this.queryPlanning.ridRangeConditions.isEmpty()) {
            return -1L;
        }
        long maxValue = -1L;
        for (OBooleanExpression ridRangeCondition : this.queryPlanning.ridRangeConditions.getSubBlocks()) {
            if (!(ridRangeCondition instanceof OBinaryCondition)) continue;
            OBinaryCondition cond = (OBinaryCondition)ridRangeCondition;
            ORid condRid = cond.getRight().getRid();
            OBinaryCompareOperator operator = cond.getOperator();
            if (condRid == null || condRid.getCluster().getValue().intValue() != this.clusterId || !(operator instanceof OGtOperator) && !(operator instanceof OGeOperator)) continue;
            maxValue = Math.max(maxValue, condRid.getPosition().getValue().longValue());
        }
        return maxValue;
    }

    private long calculateMaxClusterPosition() {
        if (this.queryPlanning == null || this.queryPlanning.ridRangeConditions == null || this.queryPlanning.ridRangeConditions.isEmpty()) {
            return -1L;
        }
        long minValue = Long.MAX_VALUE;
        for (OBooleanExpression ridRangeCondition : this.queryPlanning.ridRangeConditions.getSubBlocks()) {
            if (!(ridRangeCondition instanceof OBinaryCondition)) continue;
            OBinaryCondition cond = (OBinaryCondition)ridRangeCondition;
            Object obj = ((OBinaryCondition)ridRangeCondition).getRight().getRid() != null ? ((OBinaryCondition)ridRangeCondition).getRight().getRid().toRecordId((OResult)null, this.ctx) : ((OBinaryCondition)ridRangeCondition).getRight().execute((OResult)null, this.ctx);
            ORID conditionRid = ((OIdentifiable)obj).getIdentity();
            OBinaryCompareOperator operator = cond.getOperator();
            if (conditionRid == null || conditionRid.getClusterId() != this.clusterId || !(operator instanceof OLtOperator) && !(operator instanceof OLeOperator)) continue;
            minValue = Math.min(minValue, conditionRid.getClusterPosition());
        }
        return minValue == Long.MAX_VALUE ? -1L : minValue;
    }

    @Override
    public void sendTimeout() {
        super.sendTimeout();
    }

    @Override
    public void close() {
        super.close();
    }

    @Override
    public String prettyPrint(int depth, int indent) {
        String result = OExecutionStepInternal.getIndent(depth, indent) + "+ FETCH FROM CLUSTER " + this.clusterId + " " + (ORDER_DESC.equals(this.order) ? "DESC" : "ASC");
        if (this.profilingEnabled) {
            result = result + " (" + this.getCostFormatted() + ")";
        }
        return result;
    }

    public void setOrder(Object order) {
        this.order = order;
    }

    @Override
    public long getCost() {
        return this.cost;
    }

    @Override
    public OResult serialize() {
        OResultInternal result = OExecutionStepInternal.basicSerialize(this);
        result.setProperty("clusterId", this.clusterId);
        result.setProperty("order", this.order);
        return result;
    }

    @Override
    public void deserialize(OResult fromResult) {
        try {
            OExecutionStepInternal.basicDeserialize(fromResult, this);
            this.clusterId = (Integer)fromResult.getProperty("clusterId");
            Object orderProp = fromResult.getProperty("order");
            if (orderProp != null) {
                this.order = ORDER_ASC.equals(fromResult.getProperty("order")) ? ORDER_ASC : ORDER_DESC;
            }
        }
        catch (Exception e) {
            throw OException.wrapException(new OCommandExecutionException(""), e);
        }
    }

    @Override
    public boolean canBeCached() {
        return true;
    }

    @Override
    public OExecutionStep copy(OCommandContext ctx) {
        FetchFromClusterExecutionStep result = new FetchFromClusterExecutionStep(this.clusterId, this.queryPlanning == null ? null : this.queryPlanning.copy(), ctx, this.profilingEnabled);
        return result;
    }
}

