/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.sql.executor;

import com.orientechnologies.orient.core.command.OCommandContext;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.id.ORID;
import com.orientechnologies.orient.core.sql.executor.AbstractTraverseStep;
import com.orientechnologies.orient.core.sql.executor.OExecutionStepInternal;
import com.orientechnologies.orient.core.sql.executor.OResult;
import com.orientechnologies.orient.core.sql.executor.OResultInternal;
import com.orientechnologies.orient.core.sql.executor.OResultSet;
import com.orientechnologies.orient.core.sql.executor.OTraverseResult;
import com.orientechnologies.orient.core.sql.parser.OInteger;
import com.orientechnologies.orient.core.sql.parser.OTraverseProjectionItem;
import com.orientechnologies.orient.core.sql.parser.OWhereClause;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public class DepthFirstTraverseStep
extends AbstractTraverseStep {
    public DepthFirstTraverseStep(List<OTraverseProjectionItem> projections, OWhereClause whileClause, OInteger maxDepth, OCommandContext ctx, boolean profilingEnabled) {
        super(projections, whileClause, maxDepth, ctx, profilingEnabled);
    }

    @Override
    protected void fetchNextEntryPoints(OCommandContext ctx, int nRecords) {
        OResultSet nextN = this.getPrev().get().syncPull(ctx, nRecords);
        while (nextN.hasNext()) {
            OResult item = this.toTraverseResult(nextN.next());
            if (item == null) continue;
            ((OResultInternal)item).setMetadata("$depth", 0);
            ArrayList stack = new ArrayList();
            item.getIdentity().ifPresent(x -> stack.add(x));
            ((OResultInternal)item).setMetadata("$stack", stack);
            ArrayList<ORID> path = new ArrayList<ORID>();
            if (item.getIdentity().isPresent()) {
                path.add(item.getIdentity().get());
            } else if (item.getProperty("@rid") != null) {
                path.add((ORID)item.getProperty("@rid"));
            }
            ((OResultInternal)item).setMetadata("$path", path);
            if (item != null && item.isElement() && !this.traversed.contains(item.getElement().get().getIdentity())) {
                this.tryAddEntryPoint(item, ctx);
                this.traversed.add(item.getElement().get().getIdentity());
                continue;
            }
            if (item.getProperty("@rid") == null || !(item.getProperty("@rid") instanceof OIdentifiable)) continue;
            this.tryAddEntryPoint(item, ctx);
            this.traversed.add(((OIdentifiable)item.getProperty("@rid")).getIdentity());
        }
    }

    private OResult toTraverseResult(OResult item) {
        OTraverseResult res = null;
        if (item instanceof OTraverseResult) {
            res = (OTraverseResult)item;
        } else if (item.isElement() && item.getElement().get().getIdentity().isPersistent()) {
            res = new OTraverseResult();
            res.setElement(item.getElement().get());
            res.depth = 0;
        } else if (item.getPropertyNames().size() == 1) {
            Object val = item.getProperty(item.getPropertyNames().iterator().next());
            if (val instanceof OIdentifiable) {
                res = new OTraverseResult();
                res.setElement((OIdentifiable)val);
                res.depth = 0;
                res.setMetadata("$depth", 0);
            }
        } else {
            res = new OTraverseResult();
            for (String key : item.getPropertyNames()) {
                res.setProperty(key, item.getProperty(key));
            }
            for (String md : item.getMetadataKeys()) {
                res.setMetadata(md, item.getMetadata(md));
            }
        }
        return res;
    }

    @Override
    protected void fetchNextResults(OCommandContext ctx, int nRecords) {
        if (!this.entryPoints.isEmpty()) {
            OTraverseResult item = (OTraverseResult)this.entryPoints.remove(0);
            this.results.add(item);
            for (OTraverseProjectionItem proj : this.projections) {
                Integer depth;
                Object nextStep = proj.execute(item, ctx);
                Integer n = depth = item.depth != null ? item.depth : (Integer)item.getMetadata("$depth");
                if (this.maxDepth != null && this.maxDepth.getValue().intValue() <= depth) continue;
                this.addNextEntryPoints(nextStep, depth + 1, (List<OIdentifiable>)((List)item.getMetadata("$path")), (List<OIdentifiable>)((List)item.getMetadata("$stack")), ctx);
            }
        }
    }

    private void addNextEntryPoints(Object nextStep, int depth, List<OIdentifiable> path, List<OIdentifiable> stack, OCommandContext ctx) {
        if (nextStep instanceof OIdentifiable) {
            this.addNextEntryPoint((OIdentifiable)nextStep, depth, path, stack, ctx);
        } else if (nextStep instanceof Iterable) {
            this.addNextEntryPoints(((Iterable)nextStep).iterator(), depth, path, stack, ctx);
        } else if (nextStep instanceof OResult) {
            this.addNextEntryPoint((OResult)nextStep, depth, path, stack, ctx);
        }
    }

    private void addNextEntryPoints(Iterator nextStep, int depth, List<OIdentifiable> path, List<OIdentifiable> stack, OCommandContext ctx) {
        while (nextStep.hasNext()) {
            this.addNextEntryPoints(nextStep.next(), depth, path, stack, ctx);
        }
    }

    private void addNextEntryPoint(OIdentifiable nextStep, int depth, List<OIdentifiable> path, List<OIdentifiable> stack, OCommandContext ctx) {
        if (this.traversed.contains(nextStep.getIdentity())) {
            return;
        }
        OTraverseResult res = new OTraverseResult();
        res.setElement(nextStep);
        res.depth = depth;
        res.setMetadata("$depth", depth);
        ArrayList<OIdentifiable> newPath = new ArrayList<OIdentifiable>(path);
        newPath.add(res.getIdentity().get());
        res.setMetadata("$path", newPath);
        ArrayList<OIdentifiable> newStack = new ArrayList<OIdentifiable>();
        newStack.add(res.getIdentity().get());
        newStack.addAll(stack);
        res.setMetadata("$stack", newStack);
        this.tryAddEntryPoint(res, ctx);
    }

    private void addNextEntryPoint(OResult nextStep, int depth, List<OIdentifiable> path, List<OIdentifiable> stack, OCommandContext ctx) {
        if (!nextStep.isElement()) {
            return;
        }
        if (this.traversed.contains(nextStep.getElement().get().getIdentity())) {
            return;
        }
        if (nextStep instanceof OTraverseResult) {
            ((OTraverseResult)nextStep).depth = depth;
            ((OTraverseResult)nextStep).setMetadata("$depth", depth);
            ArrayList<OIdentifiable> newPath = new ArrayList<OIdentifiable>();
            newPath.addAll(path);
            nextStep.getIdentity().ifPresent(x -> newPath.add(x.getIdentity()));
            ((OTraverseResult)nextStep).setMetadata("$path", newPath);
            ArrayList<OIdentifiable> reverseStack = new ArrayList<OIdentifiable>();
            reverseStack.addAll(newPath);
            Collections.reverse(reverseStack);
            ArrayList<OIdentifiable> newStack = new ArrayList<OIdentifiable>();
            newStack.addAll(reverseStack);
            ((OTraverseResult)nextStep).setMetadata("$stack", newStack);
            this.tryAddEntryPoint(nextStep, ctx);
        } else {
            OTraverseResult res = new OTraverseResult();
            res.setElement(nextStep.getElement().get());
            res.depth = depth;
            res.setMetadata("$depth", depth);
            ArrayList<OIdentifiable> newPath = new ArrayList<OIdentifiable>();
            newPath.addAll(path);
            nextStep.getIdentity().ifPresent(x -> newPath.add(x.getIdentity()));
            ((OTraverseResult)nextStep).setMetadata("$path", newPath);
            ArrayList<OIdentifiable> reverseStack = new ArrayList<OIdentifiable>();
            reverseStack.addAll(newPath);
            Collections.reverse(reverseStack);
            ArrayList<OIdentifiable> newStack = new ArrayList<OIdentifiable>();
            newStack.addAll(reverseStack);
            ((OTraverseResult)nextStep).setMetadata("$stack", newStack);
            this.tryAddEntryPoint(res, ctx);
        }
    }

    private void tryAddEntryPoint(OResult res, OCommandContext ctx) {
        if (this.whileClause == null || this.whileClause.matchesFilters(res, ctx)) {
            this.entryPoints.add(0, res);
        }
        if (res.isElement()) {
            this.traversed.add(res.getElement().get().getIdentity());
        } else if (res.getProperty("@rid") != null && res.getProperty("@rid") instanceof OIdentifiable) {
            this.traversed.add(((OIdentifiable)res.getProperty("@rid")).getIdentity());
        }
    }

    @Override
    public String prettyPrint(int depth, int indent) {
        String spaces = OExecutionStepInternal.getIndent(depth, indent);
        StringBuilder result = new StringBuilder();
        result.append(spaces);
        result.append("+ DEPTH-FIRST TRAVERSE \n");
        result.append(spaces);
        result.append("  " + this.projections.toString());
        if (this.whileClause != null) {
            result.append("\n");
            result.append(spaces);
            result.append("WHILE " + this.whileClause.toString());
        }
        return result.toString();
    }
}

