/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.sql;

import com.orientechnologies.common.collection.OMultiCollectionIterator;
import com.orientechnologies.common.collection.OMultiValue;
import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.common.util.OCallable;
import com.orientechnologies.common.util.OClassLoaderHelper;
import com.orientechnologies.common.util.OCollections;
import com.orientechnologies.orient.core.collate.OCollate;
import com.orientechnologies.orient.core.collate.OCollateFactory;
import com.orientechnologies.orient.core.command.OCommandContext;
import com.orientechnologies.orient.core.command.OCommandExecutor;
import com.orientechnologies.orient.core.command.OCommandExecutorAbstract;
import com.orientechnologies.orient.core.db.ODatabaseDocumentInternal;
import com.orientechnologies.orient.core.db.document.ODatabaseDocument;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.exception.ODatabaseException;
import com.orientechnologies.orient.core.id.ORecordId;
import com.orientechnologies.orient.core.serialization.serializer.OStringSerializerHelper;
import com.orientechnologies.orient.core.sql.OCommandExecutorSQLFactory;
import com.orientechnologies.orient.core.sql.OCommandSQLParsingException;
import com.orientechnologies.orient.core.sql.ODynamicSQLElementFactory;
import com.orientechnologies.orient.core.sql.executor.OResult;
import com.orientechnologies.orient.core.sql.filter.OSQLFilter;
import com.orientechnologies.orient.core.sql.filter.OSQLTarget;
import com.orientechnologies.orient.core.sql.functions.OSQLFunction;
import com.orientechnologies.orient.core.sql.functions.OSQLFunctionFactory;
import com.orientechnologies.orient.core.sql.method.OSQLMethod;
import com.orientechnologies.orient.core.sql.method.OSQLMethodFactory;
import com.orientechnologies.orient.core.sql.operator.OQueryOperator;
import com.orientechnologies.orient.core.sql.operator.OQueryOperatorFactory;
import com.orientechnologies.orient.core.sql.parser.OStatement;
import com.orientechnologies.orient.core.sql.parser.OStatementCache;
import com.orientechnologies.orient.core.sql.parser.OrientSql;
import com.orientechnologies.orient.core.sql.parser.ParseException;
import com.orientechnologies.orient.core.sql.query.OSQLSynchQuery;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;

public class OSQLEngine {
    protected static final OSQLEngine INSTANCE = new OSQLEngine();
    private static volatile List<OSQLFunctionFactory> FUNCTION_FACTORIES = null;
    private static List<OSQLMethodFactory> METHOD_FACTORIES = null;
    private static List<OCommandExecutorSQLFactory> EXECUTOR_FACTORIES = null;
    private static List<OQueryOperatorFactory> OPERATOR_FACTORIES = null;
    private static List<OCollateFactory> COLLATE_FACTORIES = null;
    private static OQueryOperator[] SORTED_OPERATORS = null;
    private static ClassLoader orientClassLoader = OSQLEngine.class.getClassLoader();

    public static OStatement parse(String query, ODatabaseDocumentInternal db) {
        return OStatementCache.get(query, db);
    }

    public static List<OStatement> parseScript(String script, ODatabaseDocumentInternal db) {
        ByteArrayInputStream is = new ByteArrayInputStream(script.getBytes());
        return OSQLEngine.parseScript(is, db);
    }

    public static List<OStatement> parseScript(InputStream script, ODatabaseDocumentInternal db) {
        try {
            OrientSql osql = new OrientSql(script);
            List<OStatement> result = osql.parseScript();
            return result;
        }
        catch (ParseException e) {
            throw new OCommandSQLParsingException(e, "");
        }
    }

    protected OSQLEngine() {
    }

    public static void registerOperator(OQueryOperator iOperator) {
        ODynamicSQLElementFactory.OPERATORS.add(iOperator);
        SORTED_OPERATORS = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Iterator<OSQLFunctionFactory> getFunctionFactories() {
        if (FUNCTION_FACTORIES == null) {
            OSQLEngine oSQLEngine = INSTANCE;
            synchronized (oSQLEngine) {
                if (FUNCTION_FACTORIES == null) {
                    Iterator<OSQLFunctionFactory> ite = OClassLoaderHelper.lookupProviderWithOrientClassLoader(OSQLFunctionFactory.class, orientClassLoader);
                    ArrayList<OSQLFunctionFactory> factories = new ArrayList<OSQLFunctionFactory>();
                    while (ite.hasNext()) {
                        factories.add(ite.next());
                    }
                    FUNCTION_FACTORIES = Collections.unmodifiableList(factories);
                }
            }
        }
        return FUNCTION_FACTORIES.iterator();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Iterator<OSQLMethodFactory> getMethodFactories() {
        if (METHOD_FACTORIES == null) {
            OSQLEngine oSQLEngine = INSTANCE;
            synchronized (oSQLEngine) {
                if (METHOD_FACTORIES == null) {
                    Iterator<OSQLMethodFactory> ite = OClassLoaderHelper.lookupProviderWithOrientClassLoader(OSQLMethodFactory.class, orientClassLoader);
                    ArrayList<OSQLMethodFactory> factories = new ArrayList<OSQLMethodFactory>();
                    while (ite.hasNext()) {
                        factories.add(ite.next());
                    }
                    METHOD_FACTORIES = Collections.unmodifiableList(factories);
                }
            }
        }
        return METHOD_FACTORIES.iterator();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Iterator<OCollateFactory> getCollateFactories() {
        if (COLLATE_FACTORIES == null) {
            OSQLEngine oSQLEngine = INSTANCE;
            synchronized (oSQLEngine) {
                if (COLLATE_FACTORIES == null) {
                    Iterator<OCollateFactory> ite = OClassLoaderHelper.lookupProviderWithOrientClassLoader(OCollateFactory.class, orientClassLoader);
                    ArrayList<OCollateFactory> factories = new ArrayList<OCollateFactory>();
                    while (ite.hasNext()) {
                        factories.add(ite.next());
                    }
                    COLLATE_FACTORIES = Collections.unmodifiableList(factories);
                }
            }
        }
        return COLLATE_FACTORIES.iterator();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Iterator<OQueryOperatorFactory> getOperatorFactories() {
        if (OPERATOR_FACTORIES == null) {
            OSQLEngine oSQLEngine = INSTANCE;
            synchronized (oSQLEngine) {
                if (OPERATOR_FACTORIES == null) {
                    Iterator<OQueryOperatorFactory> ite = OClassLoaderHelper.lookupProviderWithOrientClassLoader(OQueryOperatorFactory.class, orientClassLoader);
                    ArrayList<OQueryOperatorFactory> factories = new ArrayList<OQueryOperatorFactory>();
                    while (ite.hasNext()) {
                        factories.add(ite.next());
                    }
                    OPERATOR_FACTORIES = Collections.unmodifiableList(factories);
                }
            }
        }
        return OPERATOR_FACTORIES.iterator();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Iterator<OCommandExecutorSQLFactory> getCommandFactories() {
        if (EXECUTOR_FACTORIES == null) {
            OSQLEngine oSQLEngine = INSTANCE;
            synchronized (oSQLEngine) {
                if (EXECUTOR_FACTORIES == null) {
                    Iterator<OCommandExecutorSQLFactory> ite = OClassLoaderHelper.lookupProviderWithOrientClassLoader(OCommandExecutorSQLFactory.class, orientClassLoader);
                    ArrayList<OCommandExecutorSQLFactory> factories = new ArrayList<OCommandExecutorSQLFactory>();
                    while (ite.hasNext()) {
                        try {
                            factories.add(ite.next());
                        }
                        catch (Exception e) {
                            OLogManager.instance().warn(null, "Cannot load OCommandExecutorSQLFactory instance from service registry", e, new Object[0]);
                        }
                    }
                    EXECUTOR_FACTORIES = Collections.unmodifiableList(factories);
                }
            }
        }
        return EXECUTOR_FACTORIES.iterator();
    }

    public static Set<String> getFunctionNames() {
        HashSet<String> types = new HashSet<String>();
        Iterator<OSQLFunctionFactory> ite = OSQLEngine.getFunctionFactories();
        while (ite.hasNext()) {
            types.addAll(ite.next().getFunctionNames());
        }
        return types;
    }

    public static Set<String> getMethodNames() {
        HashSet<String> types = new HashSet<String>();
        Iterator<OSQLMethodFactory> ite = OSQLEngine.getMethodFactories();
        while (ite.hasNext()) {
            types.addAll(ite.next().getMethodNames());
        }
        return types;
    }

    public static Set<String> getCollateNames() {
        HashSet<String> types = new HashSet<String>();
        Iterator<OCollateFactory> ite = OSQLEngine.getCollateFactories();
        while (ite.hasNext()) {
            types.addAll(ite.next().getNames());
        }
        return types;
    }

    public static Set<String> getCommandNames() {
        HashSet<String> types = new HashSet<String>();
        Iterator<OCommandExecutorSQLFactory> ite = OSQLEngine.getCommandFactories();
        while (ite.hasNext()) {
            types.addAll(ite.next().getCommandNames());
        }
        return types;
    }

    public static void scanForPlugins() {
        FUNCTION_FACTORIES = null;
    }

    public static Object foreachRecord(OCallable<Object, OIdentifiable> iCallable, Object iCurrent, OCommandContext iContext) {
        if (iCurrent == null) {
            return null;
        }
        if (!OCommandExecutorAbstract.checkInterruption(iContext)) {
            return null;
        }
        if (iCurrent instanceof Iterable && !(iCurrent instanceof OIdentifiable)) {
            iCurrent = ((Iterable)((Object)iCurrent)).iterator();
        }
        if (OMultiValue.isMultiValue(iCurrent) || iCurrent instanceof Iterator) {
            OMultiCollectionIterator result = new OMultiCollectionIterator();
            for (Object o : OMultiValue.getMultiValueIterable(iCurrent, false)) {
                if (iContext != null && !iContext.checkTimeout()) {
                    return null;
                }
                if (OMultiValue.isMultiValue(o) || o instanceof Iterator) {
                    for (Object inner : OMultiValue.getMultiValueIterable(o, false)) {
                        result.add(iCallable.call((OIdentifiable)inner));
                    }
                    continue;
                }
                result.add(iCallable.call((OIdentifiable)o));
            }
            return result;
        }
        if (iCurrent instanceof OIdentifiable) {
            return iCallable.call((OIdentifiable)((Object)iCurrent));
        }
        if (iCurrent instanceof OResult) {
            return iCallable.call(((OResult)((Object)iCurrent)).toElement());
        }
        return null;
    }

    public static OSQLEngine getInstance() {
        return INSTANCE;
    }

    public static OCollate getCollate(String name) {
        Iterator<OCollateFactory> iter = OSQLEngine.getCollateFactories();
        while (iter.hasNext()) {
            OCollateFactory f = iter.next();
            OCollate c = f.getCollate(name);
            if (c == null) continue;
            return c;
        }
        return null;
    }

    public static OSQLMethod getMethod(String iMethodName) {
        iMethodName = iMethodName.toLowerCase(Locale.ENGLISH);
        Iterator<OSQLMethodFactory> ite = OSQLEngine.getMethodFactories();
        while (ite.hasNext()) {
            OSQLMethodFactory factory = ite.next();
            if (!factory.hasMethod(iMethodName)) continue;
            return factory.createMethod(iMethodName);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OQueryOperator[] getRecordOperators() {
        if (SORTED_OPERATORS == null) {
            OSQLEngine oSQLEngine = INSTANCE;
            synchronized (oSQLEngine) {
                if (SORTED_OPERATORS == null) {
                    boolean added;
                    Iterator<OQueryOperatorFactory> ite = OSQLEngine.getOperatorFactories();
                    ArrayList<OQueryOperator> operators = new ArrayList<OQueryOperator>();
                    while (ite.hasNext()) {
                        OQueryOperatorFactory factory = ite.next();
                        operators.addAll(factory.getOperators());
                    }
                    ArrayList<OQueryOperator> sorted = new ArrayList<OQueryOperator>();
                    LinkedHashSet<Pair> pairs = new LinkedHashSet<Pair>();
                    for (OQueryOperator ca : operators) {
                        for (OQueryOperator oQueryOperator : operators) {
                            if (ca == oQueryOperator) continue;
                            switch (ca.compare(oQueryOperator)) {
                                case BEFORE: {
                                    pairs.add(new Pair(ca, oQueryOperator));
                                    break;
                                }
                                case AFTER: {
                                    pairs.add(new Pair(oQueryOperator, ca));
                                }
                            }
                            switch (oQueryOperator.compare(ca)) {
                                case BEFORE: {
                                    pairs.add(new Pair(oQueryOperator, ca));
                                    break;
                                }
                                case AFTER: {
                                    pairs.add(new Pair(ca, oQueryOperator));
                                }
                            }
                        }
                    }
                    do {
                        added = false;
                        Iterator it = operators.iterator();
                        block15: while (it.hasNext()) {
                            OQueryOperator candidate = (OQueryOperator)it.next();
                            for (Pair pair : pairs) {
                                if (pair.after != candidate) continue;
                                continue block15;
                            }
                            sorted.add(candidate);
                            it.remove();
                            Iterator iterator = pairs.iterator();
                            while (iterator.hasNext()) {
                                if (((Pair)iterator.next()).before != candidate) continue;
                                iterator.remove();
                            }
                            added = true;
                        }
                    } while (added);
                    if (!operators.isEmpty()) {
                        throw new ODatabaseException("Invalid sorting. " + OCollections.toString(pairs));
                    }
                    SORTED_OPERATORS = sorted.toArray(new OQueryOperator[sorted.size()]);
                }
            }
        }
        return SORTED_OPERATORS;
    }

    public void registerFunction(String iName, OSQLFunction iFunction) {
        ODynamicSQLElementFactory.FUNCTIONS.put(iName.toLowerCase(Locale.ENGLISH), iFunction);
    }

    public void registerFunction(String iName, Class<? extends OSQLFunction> iFunctionClass) {
        ODynamicSQLElementFactory.FUNCTIONS.put(iName.toLowerCase(Locale.ENGLISH), iFunctionClass);
    }

    public OSQLFunction getFunction(String iFunctionName) {
        if ((iFunctionName = iFunctionName.toLowerCase(Locale.ENGLISH)).equalsIgnoreCase("any") || iFunctionName.equalsIgnoreCase("all")) {
            return null;
        }
        Iterator<OSQLFunctionFactory> ite = OSQLEngine.getFunctionFactories();
        while (ite.hasNext()) {
            OSQLFunctionFactory factory = ite.next();
            if (!factory.hasFunction(iFunctionName)) continue;
            return factory.createFunction(iFunctionName);
        }
        throw new OCommandSQLParsingException("No function with name '" + iFunctionName + "', available names are : " + OCollections.toString(OSQLEngine.getFunctionNames()));
    }

    public void unregisterFunction(String iName) {
        iName = iName.toLowerCase(Locale.ENGLISH);
        ODynamicSQLElementFactory.FUNCTIONS.remove(iName);
    }

    public OCommandExecutor getCommand(String candidate) {
        candidate = candidate.trim();
        Set<String> names = OSQLEngine.getCommandNames();
        String commandName = candidate;
        boolean found = names.contains(commandName);
        int pos = -1;
        while (!found && (pos = OStringSerializerHelper.getLowerIndexOf(candidate, pos + 1, " ", "\n", "\r", "\t", "(", "[")) > -1) {
            commandName = candidate.substring(0, pos);
            commandName = commandName.replaceAll(" +", " ");
            found = names.contains(commandName);
        }
        if (found) {
            Iterator<OCommandExecutorSQLFactory> ite = OSQLEngine.getCommandFactories();
            while (ite.hasNext()) {
                OCommandExecutorSQLFactory factory = ite.next();
                if (!factory.getCommandNames().contains(commandName)) continue;
                return factory.createCommand(commandName);
            }
        }
        return null;
    }

    public OSQLFilter parseCondition(String iText, OCommandContext iContext, String iFilterKeyword) {
        return new OSQLFilter(iText, iContext, iFilterKeyword);
    }

    public OSQLTarget parseTarget(String iText, OCommandContext iContext) {
        return new OSQLTarget(iText, iContext);
    }

    public Set<OIdentifiable> parseRIDTarget(ODatabaseDocument database, String iTarget, OCommandContext iContext, Map<Object, Object> iArgs) {
        Set<Object> ids;
        if (iTarget.startsWith("(")) {
            OSQLSynchQuery query = new OSQLSynchQuery(iTarget.substring(1, iTarget.length() - 1));
            query.setContext(iContext);
            Object result = database.query(query, iArgs);
            if (result == null || result.isEmpty()) {
                ids = Collections.emptySet();
            } else {
                ids = new HashSet((int)((double)result.size() * 1.3));
                for (OIdentifiable aResult : result) {
                    ids.add(aResult.getIdentity());
                }
            }
        } else if (iTarget.startsWith("[")) {
            String[] idsAsStrings = iTarget.substring(1, iTarget.length() - 1).split(",");
            ids = new HashSet<OIdentifiable>((int)((double)idsAsStrings.length * 1.3));
            for (String idsAsString : idsAsStrings) {
                if (idsAsString.startsWith("$")) {
                    Object r = iContext.getVariable(idsAsString);
                    if (r instanceof OIdentifiable) {
                        ids.add((OIdentifiable)r);
                        continue;
                    }
                    OMultiValue.add(ids, r);
                    continue;
                }
                ids.add(new ORecordId(idsAsString));
            }
        } else {
            Object r;
            ids = iTarget.startsWith("$") ? ((r = iContext.getVariable(iTarget)) instanceof OIdentifiable ? Collections.singleton((OIdentifiable)r) : (Set)OMultiValue.add(new HashSet(OMultiValue.getSize(r)), r)) : Collections.singleton(new ORecordId(iTarget));
        }
        return ids;
    }

    private static final class Pair {
        final OQueryOperator before;
        final OQueryOperator after;

        public Pair(OQueryOperator before, OQueryOperator after) {
            this.before = before;
            this.after = after;
        }

        public boolean equals(Object obj) {
            if (obj instanceof Pair) {
                Pair that = (Pair)obj;
                return this.before == that.before && this.after == that.after;
            }
            return false;
        }

        public int hashCode() {
            return System.identityHashCode(this.before) + 31 * System.identityHashCode(this.after);
        }

        public String toString() {
            return this.before + " > " + this.after;
        }
    }
}

