/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.sql;

import com.orientechnologies.common.types.OModifiableBoolean;
import com.orientechnologies.common.util.OPair;
import com.orientechnologies.orient.core.command.OCommandDistributedReplicateRequest;
import com.orientechnologies.orient.core.command.OCommandRequest;
import com.orientechnologies.orient.core.command.OCommandRequestText;
import com.orientechnologies.orient.core.db.ODatabaseDocumentInternal;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.exception.OCommandExecutionException;
import com.orientechnologies.orient.core.id.ORID;
import com.orientechnologies.orient.core.metadata.schema.OClass;
import com.orientechnologies.orient.core.metadata.schema.OType;
import com.orientechnologies.orient.core.record.OElement;
import com.orientechnologies.orient.core.record.OVertex;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.sql.OCommandExecutorSQLSetAware;
import com.orientechnologies.orient.core.sql.OCommandParameters;
import com.orientechnologies.orient.core.sql.OCommandSQLParsingException;
import com.orientechnologies.orient.core.sql.OSQLEngine;
import com.orientechnologies.orient.core.sql.OSQLHelper;
import com.orientechnologies.orient.core.sql.functions.OSQLFunctionRuntime;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class OCommandExecutorSQLMoveVertex
extends OCommandExecutorSQLSetAware
implements OCommandDistributedReplicateRequest {
    public static final String NAME = "MOVE VERTEX";
    private static final String KEYWORD_MERGE = "MERGE";
    private static final String KEYWORD_BATCH = "BATCH";
    private String source = null;
    private String clusterName;
    private String className;
    private OClass clazz;
    private List<OPair<String, Object>> fields;
    private ODocument merge;
    private int batch = 100;

    public OCommandExecutorSQLMoveVertex parse(OCommandRequest iRequest) {
        ODatabaseDocumentInternal database = OCommandExecutorSQLMoveVertex.getDatabase();
        this.init((OCommandRequestText)iRequest);
        this.parserRequiredKeyword("MOVE");
        this.parserRequiredKeyword("VERTEX");
        this.source = this.parserRequiredWord(false, "Syntax error", " =><,\r\n");
        if (this.source == null) {
            throw new OCommandSQLParsingException("Cannot find source");
        }
        this.parserRequiredKeyword("TO");
        String temp = this.parseOptionalWord(true, new String[0]);
        while (temp != null) {
            if (temp.startsWith("CLUSTER:")) {
                if (this.className != null) {
                    throw new OCommandSQLParsingException("Cannot define multiple sources. Found both cluster and class.");
                }
                this.clusterName = temp.substring("CLUSTER:".length());
                if (database.getClusterIdByName(this.clusterName) == -1) {
                    throw new OCommandSQLParsingException("Cluster '" + this.clusterName + "' was not found");
                }
            } else if (temp.startsWith("CLASS:")) {
                if (this.clusterName != null) {
                    throw new OCommandSQLParsingException("Cannot define multiple sources. Found both cluster and class.");
                }
                this.className = temp.substring("CLASS:".length());
                this.clazz = database.getMetadata().getSchema().getClass(this.className);
                if (this.clazz == null) {
                    throw new OCommandSQLParsingException("Class '" + this.className + "' was not found");
                }
            } else if (temp.equals("SET")) {
                this.fields = new ArrayList<OPair<String, Object>>();
                this.parseSetFields(this.clazz, this.fields);
            } else if (temp.equals(KEYWORD_MERGE)) {
                this.merge = this.parseJSON();
            } else if (temp.equals(KEYWORD_BATCH) && (temp = this.parserNextWord(true)) != null) {
                this.batch = Integer.parseInt(temp);
            }
            temp = this.parserOptionalWord(true);
            if (!this.parserIsEnded()) continue;
            break;
        }
        return this;
    }

    @Override
    public Object execute(Map<Object, Object> iArgs) {
        ODatabaseDocumentInternal db = OCommandExecutorSQLMoveVertex.getDatabase();
        db.begin();
        if (this.className == null && this.clusterName == null) {
            throw new OCommandExecutionException("Cannot execute the command because it has not been parsed yet");
        }
        OModifiableBoolean shutdownGraph = new OModifiableBoolean();
        boolean txAlreadyBegun = OCommandExecutorSQLMoveVertex.getDatabase().getTransaction().isActive();
        Set<OIdentifiable> sourceRIDs = OSQLEngine.getInstance().parseRIDTarget(db, this.source, this.context, iArgs);
        ArrayList<ODocument> result = new ArrayList<ODocument>(sourceRIDs.size());
        for (OIdentifiable from : sourceRIDs) {
            OVertex fromVertex = this.toVertex(from);
            if (fromVertex == null) continue;
            ORID oldVertex = fromVertex.getIdentity().copy();
            ORID newVertex = fromVertex.moveTo(this.className, this.clusterName);
            ODocument newVertexDoc = (ODocument)newVertex.getRecord();
            if (this.fields != null) {
                for (OPair<String, Object> f : this.fields) {
                    if (!(f.getValue() instanceof OSQLFunctionRuntime)) continue;
                    f.setValue(((OSQLFunctionRuntime)f.getValue()).getValue((OIdentifiable)newVertex.getRecord(), null, this.context));
                }
                OSQLHelper.bindParameters(newVertexDoc, this.fields, new OCommandParameters(iArgs), this.context);
            }
            if (this.merge != null) {
                newVertexDoc.merge(this.merge, true, false);
            }
            newVertexDoc.save();
            result.add(new ODocument().setTrackingChanges(false).field("old", oldVertex, OType.LINK).field("new", newVertex, OType.LINK));
            if (this.batch <= 0 || result.size() % this.batch != 0) continue;
            db.commit();
            db.begin();
        }
        db.commit();
        return result;
    }

    @Override
    public OCommandDistributedReplicateRequest.QUORUM_TYPE getQuorumType() {
        return OCommandDistributedReplicateRequest.QUORUM_TYPE.WRITE;
    }

    @Override
    public String getSyntax() {
        return "MOVE VERTEX <source> TO <destination> [SET [<field>=<value>]* [,]] [MERGE <JSON>] [BATCH <batch-size>]";
    }

    private OVertex toVertex(OIdentifiable item) {
        if (item != null && item instanceof OElement) {
            return ((OElement)item).asVertex().orElse(null);
        }
        item = (OIdentifiable)OCommandExecutorSQLMoveVertex.getDatabase().load(item.getIdentity());
        if (item != null && item instanceof OElement) {
            return ((OElement)item).asVertex().orElse(null);
        }
        return null;
    }
}

