/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.serialization.serializer.record.binary;

import com.orientechnologies.common.serialization.types.OByteSerializer;
import com.orientechnologies.orient.core.db.ODatabaseDocumentInternal;
import com.orientechnologies.orient.core.db.ODatabaseRecordThreadLocal;
import com.orientechnologies.orient.core.db.record.ORecordElement;
import com.orientechnologies.orient.core.db.record.OTrackedMap;
import com.orientechnologies.orient.core.db.record.ridbag.ORidBag;
import com.orientechnologies.orient.core.exception.OSerializationException;
import com.orientechnologies.orient.core.metadata.OMetadataInternal;
import com.orientechnologies.orient.core.metadata.schema.OClass;
import com.orientechnologies.orient.core.metadata.schema.OGlobalProperty;
import com.orientechnologies.orient.core.metadata.schema.OImmutableClass;
import com.orientechnologies.orient.core.metadata.schema.OImmutableSchema;
import com.orientechnologies.orient.core.metadata.schema.OProperty;
import com.orientechnologies.orient.core.metadata.schema.OType;
import com.orientechnologies.orient.core.record.ORecordInternal;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.record.impl.ODocumentEntry;
import com.orientechnologies.orient.core.record.impl.ODocumentInternal;
import com.orientechnologies.orient.core.serialization.serializer.record.binary.BytesContainer;
import com.orientechnologies.orient.core.serialization.serializer.record.binary.HelperClasses;
import com.orientechnologies.orient.core.serialization.serializer.record.binary.OBinaryField;
import com.orientechnologies.orient.core.serialization.serializer.record.binary.ORecordSerializationDebug;
import com.orientechnologies.orient.core.serialization.serializer.record.binary.ORecordSerializationDebugProperty;
import com.orientechnologies.orient.core.serialization.serializer.record.binary.ORecordSerializerBinaryV0;
import com.orientechnologies.orient.core.serialization.serializer.record.binary.OVarIntSerializer;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ORecordSerializerBinaryV1
extends ORecordSerializerBinaryV0 {
    private HelperClasses.Tuple<Boolean, String> processNamedFieldInDeserializePartial(String[] iFields, BytesContainer bytes, int len, byte[][] fields) {
        boolean match = false;
        String fieldName = null;
        for (int i = 0; i < iFields.length; ++i) {
            if (iFields[i] == null || iFields[i].length() != len) continue;
            boolean matchField = true;
            for (int j = 0; j < len; ++j) {
                if (bytes.bytes[bytes.offset + j] == fields[i][j]) continue;
                matchField = false;
                break;
            }
            if (!matchField) continue;
            match = true;
            break;
        }
        if (match) {
            fieldName = HelperClasses.stringFromBytes(bytes.bytes, bytes.offset, len).intern();
        }
        bytes.skip(len);
        return new HelperClasses.Tuple<Boolean, String>(match, fieldName);
    }

    private HelperClasses.Tuple<Boolean, String> checkIfPropertyNameMatchSome(OGlobalProperty prop, String[] iFields) {
        String fieldName = prop.getName();
        boolean matchField = false;
        for (String f : iFields) {
            if (!fieldName.equals(f)) continue;
            matchField = true;
            break;
        }
        return new HelperClasses.Tuple<Boolean, String>(matchField, fieldName);
    }

    private HelperClasses.Triple<Signal, HelperClasses.Triple<Integer, OType, String>, Integer> processPropertyFiledInDeserializePartial(ODocument document, int len, String[] iFields, BytesContainer bytes, int cumulativeLength, int headerStart, int headerLength) {
        OGlobalProperty prop = HelperClasses.getGlobalProperty(document, len);
        HelperClasses.Tuple<Boolean, String> matchFieldName = this.checkIfPropertyNameMatchSome(prop, iFields);
        boolean matchField = matchFieldName.getFirstVal();
        String fieldName = matchFieldName.getSecondVal();
        Integer fieldLength = OVarIntSerializer.readAsInteger(bytes);
        OType type = this.getPropertyTypeFromStream(prop, bytes);
        if (!matchField) {
            return new HelperClasses.Triple<Signal, Object, Integer>(Signal.CONTINUE, null, cumulativeLength + fieldLength);
        }
        int valuePos = fieldLength == 0 ? 0 : cumulativeLength + headerStart + headerLength;
        HelperClasses.Triple<Integer, OType, String> value = new HelperClasses.Triple<Integer, OType, String>(valuePos, type, fieldName);
        return new HelperClasses.Triple<Signal, HelperClasses.Triple<Integer, OType, String>, Integer>(Signal.RETURN_VALUE, value, cumulativeLength + fieldLength);
    }

    @Override
    public void deserializePartial(ODocument document, BytesContainer bytes, String[] iFields) {
        byte[][] fields = new byte[iFields.length][];
        for (int i = 0; i < iFields.length; ++i) {
            fields[i] = iFields[i].getBytes();
        }
        int unmarshalledFields = 0;
        int headerLength = OVarIntSerializer.readAsInteger(bytes);
        int headerStart = bytes.offset;
        int cumulativeLength = 0;
        block4: while (bytes.offset < headerStart + headerLength) {
            int valuePos;
            OType type;
            String fieldName;
            int len = OVarIntSerializer.readAsInteger(bytes);
            if (len > 0) {
                HelperClasses.Tuple<Boolean, String> matchFieldName = this.processNamedFieldInDeserializePartial(iFields, bytes, len, fields);
                boolean match = matchFieldName.getFirstVal();
                fieldName = matchFieldName.getSecondVal();
                HelperClasses.Tuple<Integer, OType> pointerAndType = this.getFieldSizeAndTypeFromCurrentPosition(bytes);
                int fieldLength = pointerAndType.getFirstVal();
                if (!match) {
                    cumulativeLength += fieldLength;
                    continue;
                }
                type = pointerAndType.getSecondVal();
                valuePos = fieldLength == 0 ? 0 : headerStart + headerLength + cumulativeLength;
                cumulativeLength += fieldLength;
            } else {
                HelperClasses.Triple<Signal, HelperClasses.Triple<Integer, OType, String>, Integer> actionSignal = this.processPropertyFiledInDeserializePartial(document, len, iFields, bytes, cumulativeLength, headerStart, headerLength);
                cumulativeLength = actionSignal.getThirdVal();
                switch (actionSignal.getFirstVal()) {
                    case CONTINUE: {
                        continue block4;
                    }
                }
                valuePos = actionSignal.getSecondVal().getFirstVal();
                type = actionSignal.getSecondVal().getSecondVal();
                fieldName = actionSignal.getSecondVal().getThirdVal();
            }
            if (valuePos != 0) {
                int headerCursor = bytes.offset;
                bytes.offset = valuePos;
                Object value = this.deserializeValue(bytes, type, document);
                bytes.offset = headerCursor;
                ODocumentInternal.rawField(document, fieldName, value, type);
            } else {
                ODocumentInternal.rawField(document, fieldName, null, null);
            }
            if (++unmarshalledFields != iFields.length) continue;
            break;
        }
    }

    @Override
    public void deserializePartialWithClassName(ODocument document, BytesContainer bytes, String[] iFields) {
        String className = HelperClasses.readString(bytes);
        if (className.length() != 0) {
            ODocumentInternal.fillClassNameIfNeeded(document, className);
        }
        this.deserializePartial(document, bytes, iFields);
    }

    private boolean checkMatchForLargerThenZero(BytesContainer bytes, byte[] field, int len) {
        if (field.length != len) {
            return false;
        }
        boolean match = true;
        for (int j = 0; j < len; ++j) {
            if (bytes.bytes[bytes.offset + j] == field[j]) continue;
            match = false;
            break;
        }
        return match;
    }

    private OType getPropertyTypeFromStream(OGlobalProperty prop, BytesContainer bytes) {
        OType type = prop.getType() != OType.ANY ? prop.getType() : HelperClasses.readOType(bytes, false);
        return type;
    }

    private HelperClasses.Triple<Signal, OBinaryField, Integer> processNamedFieldDeserializeField(BytesContainer bytes, String iFieldName, byte[] field, int len, Integer cumulativeLength, int headerStart, int headerLength) {
        int valuePos;
        boolean match = this.checkMatchForLargerThenZero(bytes, field, len);
        bytes.skip(len);
        HelperClasses.Tuple<Integer, OType> pointerAndType = this.getFieldSizeAndTypeFromCurrentPosition(bytes);
        int fieldLength = pointerAndType.getFirstVal();
        OType type = pointerAndType.getSecondVal();
        if (fieldLength == 0) {
            return new HelperClasses.Triple<Signal, Object, Integer>(Signal.RETURN_VALUE, null, cumulativeLength);
        }
        if (!match) {
            return new HelperClasses.Triple<Signal, Object, Integer>(Signal.CONTINUE, null, cumulativeLength + fieldLength);
        }
        if (!this.getComparator().isBinaryComparable(type)) {
            return new HelperClasses.Triple<Signal, Object, Integer>(Signal.RETURN_VALUE, null, cumulativeLength + fieldLength);
        }
        bytes.offset = valuePos = headerStart + headerLength + cumulativeLength;
        return new HelperClasses.Triple<Signal, OBinaryField, Integer>(Signal.RETURN_VALUE, new OBinaryField(iFieldName, type, bytes, null), cumulativeLength + fieldLength);
    }

    private HelperClasses.Triple<Signal, OBinaryField, Integer> processPropertyDeserializeField(int len, OImmutableSchema _schema, String iFieldName, OClass iClass, BytesContainer bytes, int cumulativeLength, int headerStart, int headerLength) {
        int id = len * -1 - 1;
        OGlobalProperty prop = _schema.getGlobalPropertyById(id);
        int fieldLength = OVarIntSerializer.readAsInteger(bytes);
        OType type = this.getPropertyTypeFromStream(prop, bytes);
        if (!iFieldName.equals(prop.getName())) {
            return new HelperClasses.Triple<Signal, Object, Integer>(Signal.NO_ACTION, null, cumulativeLength + fieldLength);
        }
        int valuePos = headerStart + headerLength + cumulativeLength;
        if (fieldLength == 0 || valuePos == 0 || !this.getComparator().isBinaryComparable(type)) {
            return new HelperClasses.Triple<Signal, Object, Integer>(Signal.RETURN_VALUE, null, cumulativeLength + fieldLength);
        }
        bytes.offset = valuePos;
        OProperty classProp = iClass.getProperty(iFieldName);
        return new HelperClasses.Triple<Signal, OBinaryField, Integer>(Signal.RETURN_VALUE, new OBinaryField(iFieldName, type, bytes, classProp != null ? classProp.getCollate() : null), cumulativeLength + fieldLength);
    }

    @Override
    public OBinaryField deserializeField(BytesContainer bytes, OClass iClass, String iFieldName) {
        byte[] field = iFieldName.getBytes();
        OMetadataInternal metadata = ODatabaseRecordThreadLocal.instance().get().getMetadata();
        OImmutableSchema _schema = metadata.getImmutableSchemaSnapshot();
        int headerLength = OVarIntSerializer.readAsInteger(bytes);
        int headerStart = bytes.offset;
        int cumulativeLength = 0;
        while (bytes.offset < headerStart + headerLength) {
            HelperClasses.Triple<Signal, OBinaryField, Integer> actionSignal;
            int len = OVarIntSerializer.readAsInteger(bytes);
            if (len > 0) {
                actionSignal = this.processNamedFieldDeserializeField(bytes, iFieldName, field, len, cumulativeLength, headerStart, headerLength);
                cumulativeLength = actionSignal.getThirdVal();
                switch (actionSignal.getFirstVal()) {
                    case RETURN_VALUE: {
                        return actionSignal.getSecondVal();
                    }
                }
                continue;
            }
            actionSignal = this.processPropertyDeserializeField(len, _schema, iFieldName, iClass, bytes, cumulativeLength, headerStart, headerLength);
            cumulativeLength = actionSignal.getThirdVal();
            switch (actionSignal.getFirstVal()) {
                case RETURN_VALUE: {
                    return actionSignal.getSecondVal();
                }
            }
        }
        return null;
    }

    @Override
    public OBinaryField deserializeFieldWithClassName(BytesContainer bytes, OClass iClass, String iFieldName) {
        int classNameLen = OVarIntSerializer.readAsInteger(bytes);
        bytes.skip(classNameLen);
        return this.deserializeField(bytes, iClass, iFieldName);
    }

    @Override
    public void deserialize(ODocument document, BytesContainer bytes) {
        int headerLength = OVarIntSerializer.readAsInteger(bytes);
        int headerStart = bytes.offset;
        int last = 0;
        int cumulativeSize = 0;
        while (bytes.offset < headerStart + headerLength) {
            OType type;
            int fieldLength;
            String fieldName;
            int len = OVarIntSerializer.readAsInteger(bytes);
            if (len > 0) {
                fieldName = HelperClasses.stringFromBytes(bytes.bytes, bytes.offset, len).intern();
                bytes.skip(len);
                HelperClasses.Tuple<Integer, OType> pointerAndType = this.getFieldSizeAndTypeFromCurrentPosition(bytes);
                fieldLength = pointerAndType.getFirstVal();
                type = pointerAndType.getSecondVal();
            } else {
                OGlobalProperty prop = HelperClasses.getGlobalProperty(document, len);
                fieldName = prop.getName();
                fieldLength = OVarIntSerializer.readAsInteger(bytes);
                type = this.getPropertyTypeFromStream(prop, bytes);
            }
            if (ODocumentInternal.rawContainsField(document, fieldName)) {
                cumulativeSize += fieldLength;
                continue;
            }
            if (fieldLength != 0) {
                int valuePos;
                int headerCursor = bytes.offset;
                bytes.offset = valuePos = cumulativeSize + headerStart + headerLength;
                Object value = this.deserializeValue(bytes, type, document);
                if (bytes.offset > last) {
                    last = bytes.offset;
                }
                bytes.offset = headerCursor;
                ODocumentInternal.rawField(document, fieldName, value, type);
            } else {
                ODocumentInternal.rawField(document, fieldName, null, null);
            }
            cumulativeSize += fieldLength;
        }
        ORecordInternal.clearSource(document);
        if (last > bytes.offset) {
            bytes.offset = last;
        }
    }

    @Override
    public void deserializeWithClassName(ODocument document, BytesContainer bytes) {
        String className = HelperClasses.readString(bytes);
        if (className.length() != 0) {
            ODocumentInternal.fillClassNameIfNeeded(document, className);
        }
        this.deserialize(document, bytes);
    }

    @Override
    public String[] getFieldNames(ODocument reference, BytesContainer bytes, boolean readClassName) {
        if (readClassName) {
            int classNameLen = OVarIntSerializer.readAsInteger(bytes);
            bytes.skip(classNameLen);
        }
        int headerLength = OVarIntSerializer.readAsInteger(bytes);
        int headerStart = bytes.offset;
        ArrayList<String> result = new ArrayList<String>();
        while (bytes.offset < headerStart + headerLength) {
            int len = OVarIntSerializer.readAsInteger(bytes);
            if (len > 0) {
                String fieldName = HelperClasses.stringFromBytes(bytes.bytes, bytes.offset, len).intern();
                result.add(fieldName);
                bytes.skip(len);
                OVarIntSerializer.readAsInteger(bytes);
                bytes.skip(1);
                continue;
            }
            int id = len * -1 - 1;
            OGlobalProperty prop = ODocumentInternal.getGlobalPropertyById(reference, id);
            if (prop == null) {
                throw new OSerializationException("Missing property definition for property id '" + id + "'");
            }
            result.add(prop.getName());
            OVarIntSerializer.readAsInteger(bytes);
            if (prop.getType() != OType.ANY) continue;
            bytes.skip(1);
        }
        return result.toArray(new String[result.size()]);
    }

    private void serializeWriteValues(BytesContainer headerBuffer, BytesContainer valuesBuffer, ODocument document, Set<Map.Entry<String, ODocumentEntry>> fields, Map<String, OProperty> props) {
        for (Map.Entry<String, ODocumentEntry> field : fields) {
            OType type;
            OProperty prop;
            ODocumentEntry docEntry = field.getValue();
            if (!field.getValue().exist()) continue;
            if (docEntry.property == null && props != null && (prop = props.get(field.getKey())) != null && docEntry.type == prop.getType()) {
                docEntry.property = prop;
            }
            if (docEntry.property == null) {
                String fieldName = field.getKey();
                HelperClasses.writeString(headerBuffer, fieldName);
            } else {
                OVarIntSerializer.write(headerBuffer, (docEntry.property.getId() + 1) * -1);
            }
            Object value = field.getValue().value;
            if (value != null) {
                type = this.getFieldType(field.getValue());
                if (type == null) {
                    throw new OSerializationException("Impossible serialize value of type " + value.getClass() + " with the ODocument binary serializer");
                }
                HelperClasses.Tuple<Integer, Integer> dataPointerAndLength = this.serializeValue(valuesBuffer, value, type, this.getLinkedType(document, type, field.getKey()));
                int valueLength = dataPointerAndLength.getSecondVal();
                OVarIntSerializer.write(headerBuffer, valueLength);
            } else {
                OVarIntSerializer.write(headerBuffer, 0L);
                type = OType.ANY;
            }
            if (field.getValue().property != null && field.getValue().property.getType() != OType.ANY) continue;
            int typeOffset = headerBuffer.alloc(1);
            OByteSerializer.INSTANCE.serialize((byte)type.getId(), headerBuffer.bytes, typeOffset, new Object[0]);
        }
    }

    private void merge(BytesContainer destinationBuffer, BytesContainer sourceBuffer1, BytesContainer sourceBuffer2) {
        destinationBuffer.offset = destinationBuffer.allocExact(sourceBuffer1.offset + sourceBuffer2.offset);
        System.arraycopy(sourceBuffer1.bytes, 0, destinationBuffer.bytes, destinationBuffer.offset, sourceBuffer1.offset);
        System.arraycopy(sourceBuffer2.bytes, 0, destinationBuffer.bytes, destinationBuffer.offset + sourceBuffer1.offset, sourceBuffer2.offset);
        destinationBuffer.offset += sourceBuffer1.offset + sourceBuffer2.offset;
    }

    private void serializeDocument(ODocument document, BytesContainer bytes, OClass clazz) {
        Map<String, OProperty> props = clazz != null ? clazz.propertiesMap() : null;
        Set<Map.Entry<String, ODocumentEntry>> fields = ODocumentInternal.rawEntries(document);
        BytesContainer valuesBuffer = new BytesContainer();
        BytesContainer headerBuffer = new BytesContainer();
        this.serializeWriteValues(headerBuffer, valuesBuffer, document, fields, props);
        int headerLength = headerBuffer.offset;
        OVarIntSerializer.write(bytes, headerLength);
        this.merge(bytes, headerBuffer, valuesBuffer);
    }

    @Override
    public void serializeWithClassName(ODocument document, BytesContainer bytes, boolean iClassOnly) {
        OClass clazz = this.serializeClass(document, bytes, true);
        if (iClassOnly) {
            this.writeEmptyString(bytes);
            return;
        }
        this.serializeDocument(document, bytes, clazz);
    }

    @Override
    public void serialize(ODocument document, BytesContainer bytes, boolean iClassOnly) {
        OClass clazz = this.serializeClass(document, bytes, false);
        if (iClassOnly) {
            this.writeEmptyString(bytes);
            return;
        }
        this.serializeDocument(document, bytes, clazz);
    }

    protected OClass serializeClass(ODocument document, BytesContainer bytes, boolean serializeClassName) {
        OImmutableClass clazz = ODocumentInternal.getImmutableSchemaClass(document);
        if (serializeClassName) {
            if (clazz != null && document.isEmbedded()) {
                HelperClasses.writeString(bytes, clazz.getName());
            } else {
                this.writeEmptyString(bytes);
            }
        }
        return clazz;
    }

    @Override
    public boolean isSerializingClassNameByDefault() {
        return false;
    }

    @Override
    public <RET> RET deserializeFieldTyped(BytesContainer bytes, String iFieldName, boolean isEmbedded, int serializerVersion) {
        if (isEmbedded) {
            this.skipClassName(bytes);
        }
        return this.deserializeFieldTypedLoopAndReturn(bytes, iFieldName, serializerVersion);
    }

    @Override
    protected <RET> RET deserializeFieldTypedLoopAndReturn(BytesContainer bytes, String iFieldName, int serializerVersion) {
        int valuePos;
        OType type;
        int fieldLength;
        byte[] field = iFieldName.getBytes();
        int headerLength = OVarIntSerializer.readAsInteger(bytes);
        int headerStart = bytes.offset;
        int cumulativeLength = 0;
        OMetadataInternal metadata = ODatabaseRecordThreadLocal.instance().get().getMetadata();
        OImmutableSchema _schema = metadata.getImmutableSchemaSnapshot();
        while (true) {
            if (bytes.offset >= headerStart + headerLength) {
                return null;
            }
            int len = OVarIntSerializer.readAsInteger(bytes);
            if (len > 0) {
                boolean match = this.checkMatchForLargerThenZero(bytes, field, len);
                bytes.skip(len);
                HelperClasses.Tuple<Integer, OType> pointerAndType = this.getFieldSizeAndTypeFromCurrentPosition(bytes);
                fieldLength = pointerAndType.getFirstVal();
                type = pointerAndType.getSecondVal();
                valuePos = cumulativeLength + headerStart + headerLength;
                cumulativeLength += fieldLength;
                if (valuePos == 0 || fieldLength == 0) {
                    return null;
                }
                if (!match) continue;
                bytes.offset = valuePos;
                Object value = this.deserializeValue(bytes, type, null, false, fieldLength, serializerVersion, false);
                return (RET)value;
            }
            int id = len * -1 - 1;
            OGlobalProperty prop = _schema.getGlobalPropertyById(id);
            fieldLength = OVarIntSerializer.readAsInteger(bytes);
            type = this.getPropertyTypeFromStream(prop, bytes);
            valuePos = cumulativeLength + headerStart + headerLength;
            cumulativeLength += fieldLength;
            if (iFieldName.equals(prop.getName())) break;
        }
        if (valuePos == 0 || fieldLength == 0) {
            return null;
        }
        bytes.offset = valuePos;
        Object value = this.deserializeValue(bytes, type, null, false, fieldLength, serializerVersion, false);
        return (RET)value;
    }

    @Override
    public boolean isSerializingClassNameForEmbedded() {
        return true;
    }

    private HelperClasses.Tuple<Integer, OType> getFieldSizeAndTypeFromCurrentPosition(BytesContainer bytes) {
        int fieldSize = OVarIntSerializer.readAsInteger(bytes);
        byte typeId = HelperClasses.readByte(bytes);
        OType type = OType.getById(typeId);
        return new HelperClasses.Tuple<Integer, OType>(fieldSize, type);
    }

    @Override
    public void deserializeDebug(BytesContainer bytes, ODatabaseDocumentInternal db, ORecordSerializationDebug debugInfo, OImmutableSchema schema) {
        int headerLength = OVarIntSerializer.readAsInteger(bytes);
        int headerPos = bytes.offset;
        debugInfo.properties = new ArrayList();
        int last = 0;
        int cumulativeLength = 0;
        while (true) {
            ORecordSerializationDebugProperty debugProperty = new ORecordSerializationDebugProperty();
            try {
                OType type;
                int fieldLength;
                String fieldName;
                if (bytes.offset >= headerPos + headerLength) break;
                int len = OVarIntSerializer.readAsInteger(bytes);
                debugInfo.properties.add(debugProperty);
                if (len > 0) {
                    fieldName = HelperClasses.stringFromBytes(bytes.bytes, bytes.offset, len).intern();
                    bytes.skip(len);
                    HelperClasses.Tuple<Integer, OType> valuePositionAndType = this.getFieldSizeAndTypeFromCurrentPosition(bytes);
                    fieldLength = valuePositionAndType.getFirstVal();
                    type = valuePositionAndType.getSecondVal();
                } else {
                    int id;
                    debugProperty.globalId = id = len * -1 - 1;
                    OGlobalProperty prop = schema.getGlobalPropertyById(id);
                    fieldLength = OVarIntSerializer.readAsInteger(bytes);
                    debugProperty.valuePos = headerPos + headerLength + cumulativeLength;
                    if (prop != null) {
                        fieldName = prop.getName();
                        type = this.getPropertyTypeFromStream(prop, bytes);
                    } else {
                        cumulativeLength += fieldLength;
                        continue;
                    }
                }
                debugProperty.name = fieldName;
                debugProperty.type = type;
                int valuePos = fieldLength > 0 ? headerPos + headerLength + cumulativeLength : 0;
                cumulativeLength += fieldLength;
                if (valuePos != 0) {
                    int headerCursor = bytes.offset;
                    bytes.offset = valuePos;
                    try {
                        debugProperty.value = this.deserializeValue(bytes, type, new ODocument());
                    }
                    catch (RuntimeException ex) {
                        debugProperty.faildToRead = true;
                        debugProperty.readingException = ex;
                        debugProperty.failPosition = bytes.offset;
                    }
                    if (bytes.offset > last) {
                        last = bytes.offset;
                    }
                    bytes.offset = headerCursor;
                    continue;
                }
                debugProperty.value = null;
            }
            catch (RuntimeException ex) {
                debugInfo.readingFailure = true;
                debugInfo.readingException = ex;
                debugInfo.failPosition = bytes.offset;
            }
        }
    }

    @Override
    protected int writeEmbeddedMap(BytesContainer bytes, Map<Object, Object> map) {
        int fullPos = OVarIntSerializer.write(bytes, map.size());
        for (Map.Entry<Object, Object> entry : map.entrySet()) {
            OType type = OType.STRING;
            HelperClasses.writeOType(bytes, bytes.alloc(1), type);
            HelperClasses.writeString(bytes, entry.getKey().toString());
            Object value = entry.getValue();
            if (value != null) {
                type = HelperClasses.getTypeFromValueEmbedded(value);
                if (type == null) {
                    throw new OSerializationException("Impossible serialize value of type " + value.getClass() + " with the ODocument binary serializer");
                }
                HelperClasses.writeOType(bytes, bytes.alloc(1), type);
                this.serializeValue(bytes, value, type, null);
                continue;
            }
            OByteSerializer.INSTANCE.serialize((byte)-1, bytes.bytes, bytes.alloc(1), new Object[0]);
        }
        return fullPos;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Object readEmbeddedMap(BytesContainer bytes, ODocument document) {
        int size = OVarIntSerializer.readAsInteger(bytes);
        OTrackedMap<Object> result = new OTrackedMap<Object>(document);
        result.setInternalStatus(ORecordElement.STATUS.UNMARSHALLING);
        try {
            for (int i = 0; i < size; ++i) {
                OType keyType = HelperClasses.readOType(bytes, false);
                Object key = this.deserializeValue(bytes, keyType, document);
                byte typeId = HelperClasses.readByte(bytes);
                if (typeId != -1) {
                    OType type = OType.getById(typeId);
                    Object value = this.deserializeValue(bytes, type, document);
                    result.put(key, value);
                    continue;
                }
                result.put(key, (Object)null);
            }
            OTrackedMap<Object> oTrackedMap = result;
            return oTrackedMap;
        }
        finally {
            result.setInternalStatus(ORecordElement.STATUS.LOADED);
        }
    }

    @Override
    protected List<HelperClasses.MapRecordInfo> getPositionsFromEmbeddedMap(BytesContainer bytes, int serializerVersion) {
        ArrayList<HelperClasses.MapRecordInfo> retList = new ArrayList<HelperClasses.MapRecordInfo>();
        int numberOfElements = OVarIntSerializer.readAsInteger(bytes);
        for (int i = 0; i < numberOfElements; ++i) {
            byte keyTypeId = HelperClasses.readByte(bytes);
            String key = HelperClasses.readString(bytes);
            byte valueTypeId = HelperClasses.readByte(bytes);
            if (valueTypeId == -1) continue;
            OType valueType = OType.getById(valueTypeId);
            HelperClasses.MapRecordInfo recordInfo = new HelperClasses.MapRecordInfo();
            recordInfo.fieldStartOffset = bytes.offset;
            recordInfo.fieldType = valueType;
            recordInfo.key = key;
            recordInfo.keyType = OType.getById(keyTypeId);
            int currentOffset = bytes.offset;
            this.deserializeValue(bytes, valueType, null, true, -1, serializerVersion, true);
            recordInfo.fieldLength = bytes.offset - currentOffset;
            retList.add(recordInfo);
        }
        return retList;
    }

    @Override
    protected int writeRidBag(BytesContainer bytes, ORidBag ridbag) {
        int positionOffset = bytes.offset;
        HelperClasses.writeRidBag(bytes, ridbag);
        return positionOffset;
    }

    @Override
    protected ORidBag readRidbag(BytesContainer bytes) {
        return HelperClasses.readRidbag(bytes);
    }

    private static enum Signal {
        CONTINUE,
        RETURN,
        RETURN_VALUE,
        NO_ACTION;

    }
}

