/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.record.impl;

import com.orientechnologies.orient.core.db.record.OMultiValueChangeEvent;
import com.orientechnologies.orient.core.db.record.OMultiValueChangeTimeLine;
import com.orientechnologies.orient.core.metadata.schema.OProperty;
import com.orientechnologies.orient.core.metadata.schema.OType;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.record.impl.ODocumentHelper;
import com.orientechnologies.orient.core.record.impl.OSimpleMultiValueChangeListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;

public class ODocumentEntry {
    public Object value;
    public Object original;
    public OType type;
    public OProperty property;
    public OSimpleMultiValueChangeListener<Object, Object> changeListener;
    public OMultiValueChangeTimeLine<Object, Object> timeLine;
    public boolean changed = false;
    public boolean exist = true;
    public boolean created = false;

    public boolean isChanged() {
        return this.changed;
    }

    public boolean isChangedTree(List<Object> ownersTrace) {
        List<OMultiValueChangeEvent<Object, Object>> timeline;
        if (this.changed && this.exist) {
            return true;
        }
        ownersTrace.add(this.value);
        if (this.value instanceof ODocument) {
            ODocument doc = (ODocument)this.value;
            return doc.isChangedInDepth();
        }
        if (this.value instanceof Collection) {
            Collection list = (Collection)this.value;
            for (Object e : list) {
                if (e instanceof ODocument) {
                    ODocument doc = (ODocument)e;
                    for (Map.Entry<String, ODocumentEntry> field : doc._fields.entrySet()) {
                        if (!field.getValue().isChangedTree(new ArrayList<Object>())) continue;
                        return true;
                    }
                    continue;
                }
                if (!(e instanceof Collection ? ODocumentHelper.isChangedCollection((Collection)e, this, ownersTrace, 1) : e instanceof Map && ODocumentHelper.isChangedMap((Map)e, this, ownersTrace, 1))) continue;
                return true;
            }
        }
        if (this.value instanceof Map) {
            Map map = (Map)this.value;
            for (Map.Entry entry : map.entrySet()) {
                Object element = entry.getValue();
                if (element instanceof ODocument) {
                    ODocument doc = (ODocument)element;
                    for (Map.Entry<String, ODocumentEntry> field : doc._fields.entrySet()) {
                        if (!field.getValue().isChangedTree(new ArrayList<Object>())) continue;
                        return true;
                    }
                    continue;
                }
                if (!(element instanceof Collection ? ODocumentHelper.isChangedCollection((List)element, this, ownersTrace, 1) : element instanceof Map && ODocumentHelper.isChangedMap((Map)element, this, ownersTrace, 1))) continue;
                return true;
            }
        }
        if (this.timeLine != null && (timeline = this.timeLine.getMultiValueChangeEvents()) != null) {
            for (OMultiValueChangeEvent oMultiValueChangeEvent : timeline) {
                if (oMultiValueChangeEvent.getChangeType() != OMultiValueChangeEvent.OChangeType.ADD && oMultiValueChangeEvent.getChangeType() != OMultiValueChangeEvent.OChangeType.NESTED && oMultiValueChangeEvent.getChangeType() != OMultiValueChangeEvent.OChangeType.UPDATE && oMultiValueChangeEvent.getChangeType() != OMultiValueChangeEvent.OChangeType.REMOVE) continue;
                return true;
            }
        }
        return false;
    }

    public boolean hasNonExistingTree() {
        if (!this.exist) {
            return true;
        }
        if (this.value instanceof ODocument) {
            ODocument doc = (ODocument)this.value;
            for (Map.Entry<String, ODocumentEntry> field : doc._fields.entrySet()) {
                if (!field.getValue().hasNonExistingTree()) continue;
                return true;
            }
        }
        if (this.value instanceof List) {
            List list = (List)this.value;
            for (Map.Entry<String, ODocumentEntry> element : list) {
                if (element instanceof ODocument) {
                    ODocument doc = (ODocument)((Object)element);
                    for (Map.Entry<String, ODocumentEntry> field : doc._fields.entrySet()) {
                        if (!field.getValue().hasNonExistingTree()) continue;
                        return true;
                    }
                    continue;
                }
                if (!(element instanceof List) || !ODocumentHelper.hasNonExistingInList((List)((Object)element))) continue;
                return true;
            }
        }
        return false;
    }

    public void setChanged(boolean changed) {
        this.changed = changed;
    }

    public boolean exist() {
        return this.exist;
    }

    public void setExist(boolean exist) {
        this.exist = exist;
    }

    public boolean isCreated() {
        return this.created;
    }

    public void setCreated(boolean created) {
        this.created = created;
    }

    protected ODocumentEntry clone() {
        ODocumentEntry entry = new ODocumentEntry();
        entry.type = this.type;
        entry.property = this.property;
        entry.value = this.value;
        entry.changed = this.changed;
        entry.created = this.created;
        entry.exist = this.exist;
        return entry;
    }
}

