/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.record;

import com.orientechnologies.common.exception.OSystemException;
import com.orientechnologies.orient.core.db.ODatabaseDocumentInternal;
import com.orientechnologies.orient.core.record.ORecord;
import com.orientechnologies.orient.core.record.impl.OBlob;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.record.impl.OEdgeDocument;
import com.orientechnologies.orient.core.record.impl.ORecordBytes;
import com.orientechnologies.orient.core.record.impl.ORecordFlat;
import com.orientechnologies.orient.core.record.impl.OVertexDocument;
import com.orientechnologies.orient.core.record.impl.OViewDocument;

public class ORecordFactoryManager {
    protected final String[] recordTypeNames = new String[127];
    protected final Class<? extends ORecord>[] recordTypes = new Class[127];
    protected final ORecordFactory[] recordFactories = new ORecordFactory[127];

    public ORecordFactoryManager() {
        this.declareRecordType((byte)100, "document", ODocument.class, (cluster, database) -> {
            if (database != null && cluster >= 0) {
                if (database.isClusterVertex(cluster)) {
                    return new OVertexDocument();
                }
                if (database.isClusterEdge(cluster)) {
                    return new OEdgeDocument();
                }
                if (database.isClusterView(cluster)) {
                    return new OViewDocument(database, cluster);
                }
            }
            return new ODocument();
        });
        this.declareRecordType((byte)98, "bytes", OBlob.class, (cluster, database) -> new ORecordBytes());
        this.declareRecordType((byte)102, "flat", ORecordFlat.class, (cluster, database) -> new ORecordFlat());
    }

    public String getRecordTypeName(byte iRecordType) {
        String name = this.recordTypeNames[iRecordType];
        if (name == null) {
            throw new IllegalArgumentException("Unsupported record type: " + iRecordType);
        }
        return name;
    }

    public Class<? extends ORecord> getRecordTypeClass(byte iRecordType) {
        Class<? extends ORecord> cls = this.recordTypes[iRecordType];
        if (cls == null) {
            throw new IllegalArgumentException("Unsupported record type: " + iRecordType);
        }
        return cls;
    }

    public ORecord newInstance(int cluster, ODatabaseDocumentInternal database) {
        try {
            return this.getFactory(database.getRecordType()).newRecord(cluster, database);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Unsupported record type: " + database.getRecordType(), e);
        }
    }

    public ORecord newInstance(byte iRecordType, int cluster, ODatabaseDocumentInternal database) {
        try {
            return this.getFactory(iRecordType).newRecord(cluster, database);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Unsupported record type: " + iRecordType, e);
        }
    }

    public void declareRecordType(byte iByte, String iName, Class<? extends ORecord> iClass, ORecordFactory iFactory) {
        if (this.recordTypes[iByte] != null) {
            throw new OSystemException("Record type byte '" + iByte + "' already in use : " + this.recordTypes[iByte].getName());
        }
        this.recordTypeNames[iByte] = iName;
        this.recordTypes[iByte] = iClass;
        this.recordFactories[iByte] = iFactory;
    }

    protected ORecordFactory getFactory(byte iRecordType) {
        ORecordFactory factory = this.recordFactories[iRecordType];
        if (factory == null) {
            throw new IllegalArgumentException("Record type '" + iRecordType + "' is not supported");
        }
        return factory;
    }

    public static interface ORecordFactory {
        public ORecord newRecord(int var1, ODatabaseDocumentInternal var2);
    }

    private static enum RecType {
        RECORD,
        VERTEX,
        EDGE;

    }
}

