/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.query.live;

import com.orientechnologies.common.concur.resource.OCloseable;
import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.orient.core.config.OGlobalConfiguration;
import com.orientechnologies.orient.core.db.ODatabaseInternal;
import com.orientechnologies.orient.core.db.document.ODatabaseDocument;
import com.orientechnologies.orient.core.query.live.OLiveQueryListenerV2;
import com.orientechnologies.orient.core.query.live.OLiveQueryQueueThreadV2;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.sql.executor.OResult;
import com.orientechnologies.orient.core.sql.executor.OResultInternal;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.LinkedBlockingQueue;

public class OLiveQueryHookV2 {
    public static OLiveQueryOps getOpsReference(ODatabaseInternal db) {
        return db.getSharedContext().getLiveQueryOpsV2();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Integer subscribe(Integer token, OLiveQueryListenerV2 iListener, ODatabaseInternal db) {
        if (Boolean.FALSE.equals(db.getConfiguration().getValue(OGlobalConfiguration.QUERY_LIVE_SUPPORT))) {
            OLogManager.instance().warn((Object)db, "Live query support is disabled impossible to subscribe a listener, set '%s' to true for enable the live query support", OGlobalConfiguration.QUERY_LIVE_SUPPORT.getKey());
            return -1;
        }
        OLiveQueryOps ops = OLiveQueryHookV2.getOpsReference(db);
        Object object = ops.threadLock;
        synchronized (object) {
            if (!ops.queueThread.isAlive()) {
                ops.queueThread = ops.queueThread.clone();
                ops.queueThread.start();
            }
        }
        return ops.subscribe(token, iListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void unsubscribe(Integer id, ODatabaseInternal db) {
        if (Boolean.FALSE.equals(db.getConfiguration().getValue(OGlobalConfiguration.QUERY_LIVE_SUPPORT))) {
            OLogManager.instance().warn((Object)db, "Live query support is disabled impossible to unsubscribe a listener, set '%s' to true for enable the live query support", OGlobalConfiguration.QUERY_LIVE_SUPPORT.getKey());
            return;
        }
        try {
            OLiveQueryOps ops = OLiveQueryHookV2.getOpsReference(db);
            Object object = ops.threadLock;
            synchronized (object) {
                ops.unsubscribe(id);
            }
        }
        catch (Exception e) {
            OLogManager.instance().warn(OLiveQueryHookV2.class, "Error on unsubscribing client", e, new Object[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void notifyForTxChanges(ODatabaseDocument database) {
        List<OLiveQueryOp> list;
        if (Boolean.FALSE.equals(database.getConfiguration().getValue(OGlobalConfiguration.QUERY_LIVE_SUPPORT))) {
            return;
        }
        OLiveQueryOps ops = OLiveQueryHookV2.getOpsReference((ODatabaseInternal)((Object)database));
        Map<ODatabaseDocument, List<OLiveQueryOp>> map = ops.pendingOps;
        synchronized (map) {
            list = ops.pendingOps.remove(database);
        }
        if (list != null) {
            for (OLiveQueryOp item : list) {
                item.originalDoc = item.originalDoc.copy();
                ops.enqueue(item);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removePendingDatabaseOps(ODatabaseDocument database) {
        if (Boolean.FALSE.equals(database.getConfiguration().getValue(OGlobalConfiguration.QUERY_LIVE_SUPPORT))) {
            return;
        }
        OLiveQueryOps ops = OLiveQueryHookV2.getOpsReference((ODatabaseInternal)((Object)database));
        Map<ODatabaseDocument, List<OLiveQueryOp>> map = ops.pendingOps;
        synchronized (map) {
            ops.pendingOps.remove(database);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addOp(ODocument iDocument, byte iType, ODatabaseDocument database) {
        if (Boolean.FALSE.equals(database.getConfiguration().getValue(OGlobalConfiguration.QUERY_LIVE_SUPPORT))) {
            return;
        }
        ODatabaseDocument db = database;
        OLiveQueryOps ops = OLiveQueryHookV2.getOpsReference((ODatabaseInternal)((Object)db));
        if (!ops.hasListeners()) {
            return;
        }
        OResultInternal before = iType == 3 ? null : OLiveQueryHookV2.calculateBefore(iDocument);
        OResultInternal after = iType == 2 ? null : OLiveQueryHookV2.calculateAfter(iDocument);
        OLiveQueryOp result = new OLiveQueryOp(iDocument, before, after, iType);
        Map<ODatabaseDocument, List<OLiveQueryOp>> map = ops.pendingOps;
        synchronized (map) {
            List<OLiveQueryOp> list = ops.pendingOps.get(db);
            if (list == null) {
                list = new ArrayList<OLiveQueryOp>();
                ops.pendingOps.put(db, list);
            }
            if (result.type == 1) {
                OLiveQueryOp prev = OLiveQueryHookV2.prevousUpdate(list, result.originalDoc);
                if (prev == null) {
                    list.add(result);
                } else {
                    prev.after = result.after;
                }
            } else {
                list.add(result);
            }
        }
    }

    private static OLiveQueryOp prevousUpdate(List<OLiveQueryOp> list, ODocument doc) {
        for (OLiveQueryOp oLiveQueryOp : list) {
            if (oLiveQueryOp.originalDoc != doc) continue;
            return oLiveQueryOp;
        }
        return null;
    }

    private static OResultInternal calculateBefore(ODocument iDocument) {
        OResultInternal result = new OResultInternal();
        for (String prop : iDocument.getPropertyNames()) {
            result.setProperty(prop, iDocument.getProperty(prop));
        }
        result.setProperty("@rid", iDocument.getIdentity());
        result.setProperty("@class", iDocument.getClassName());
        result.setProperty("@version", iDocument.getVersion());
        for (String prop : iDocument.getDirtyFields()) {
            result.setProperty(prop, iDocument.getOriginalValue(prop));
        }
        return result;
    }

    private static OResultInternal calculateAfter(ODocument iDocument) {
        OResultInternal result = new OResultInternal();
        for (String prop : iDocument.getPropertyNames()) {
            result.setProperty(prop, iDocument.getProperty(prop));
        }
        result.setProperty("@rid", iDocument.getIdentity());
        result.setProperty("@class", iDocument.getClassName());
        result.setProperty("@version", iDocument.getVersion() + 1);
        return result;
    }

    public static class OLiveQueryOps
    implements OCloseable {
        protected Map<ODatabaseDocument, List<OLiveQueryOp>> pendingOps = new ConcurrentHashMap<ODatabaseDocument, List<OLiveQueryOp>>();
        private OLiveQueryQueueThreadV2 queueThread = new OLiveQueryQueueThreadV2(this);
        private Object threadLock = new Object();
        private BlockingQueue<OLiveQueryOp> queue = new LinkedBlockingQueue<OLiveQueryOp>();
        private ConcurrentMap<Integer, OLiveQueryListenerV2> subscribers = new ConcurrentHashMap<Integer, OLiveQueryListenerV2>();

        @Override
        public void close() {
            this.queueThread.stopExecution();
            try {
                this.queueThread.join();
            }
            catch (InterruptedException ignore) {
                Thread.currentThread().interrupt();
            }
            this.pendingOps.clear();
        }

        public OLiveQueryQueueThreadV2 getQueueThread() {
            return this.queueThread;
        }

        public Map<Integer, OLiveQueryListenerV2> getSubscribers() {
            return this.subscribers;
        }

        public BlockingQueue<OLiveQueryOp> getQueue() {
            return this.queue;
        }

        public void enqueue(OLiveQueryOp item) {
            this.queue.offer(item);
        }

        public Integer subscribe(Integer id, OLiveQueryListenerV2 iListener) {
            this.subscribers.put(id, iListener);
            return id;
        }

        public void unsubscribe(Integer id) {
            OLiveQueryListenerV2 res = (OLiveQueryListenerV2)this.subscribers.remove(id);
            if (res != null) {
                res.onLiveResultEnd();
            }
        }

        public boolean hasListeners() {
            return !this.subscribers.isEmpty();
        }
    }

    public static class OLiveQueryOp {
        public OResult before;
        public OResult after;
        public byte type;
        protected ODocument originalDoc;

        OLiveQueryOp(ODocument originalDoc, OResult before, OResult after, byte type) {
            this.originalDoc = originalDoc;
            this.type = type;
            this.before = before;
            this.after = after;
        }
    }
}

