/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.query.live;

import com.orientechnologies.common.concur.resource.OCloseable;
import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.orient.core.config.OGlobalConfiguration;
import com.orientechnologies.orient.core.db.ODatabase;
import com.orientechnologies.orient.core.db.ODatabaseInternal;
import com.orientechnologies.orient.core.db.document.ODatabaseDocument;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.db.record.ORecordOperation;
import com.orientechnologies.orient.core.query.live.OLiveQueryListener;
import com.orientechnologies.orient.core.query.live.OLiveQueryQueueThread;
import com.orientechnologies.orient.core.record.impl.ODocument;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class OLiveQueryHook {
    public static OLiveQueryOps getOpsReference(ODatabaseInternal db) {
        return db.getSharedContext().getLiveQueryOps();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Integer subscribe(Integer token, OLiveQueryListener iListener, ODatabaseInternal db) {
        if (Boolean.FALSE.equals(db.getConfiguration().getValue(OGlobalConfiguration.QUERY_LIVE_SUPPORT))) {
            OLogManager.instance().warn((Object)db, "Live query support is disabled impossible to subscribe a listener, set '%s' to true for enable the live query support", OGlobalConfiguration.QUERY_LIVE_SUPPORT.getKey());
            return -1;
        }
        OLiveQueryOps ops = OLiveQueryHook.getOpsReference(db);
        Object object = ops.threadLock;
        synchronized (object) {
            if (!ops.queueThread.isAlive()) {
                ops.queueThread = ops.queueThread.clone();
                ops.queueThread.start();
            }
        }
        return ops.queueThread.subscribe(token, iListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void unsubscribe(Integer id, ODatabaseInternal db) {
        if (Boolean.FALSE.equals(db.getConfiguration().getValue(OGlobalConfiguration.QUERY_LIVE_SUPPORT))) {
            OLogManager.instance().warn((Object)db, "Live query support is disabled impossible to unsubscribe a listener, set '%s' to true for enable the live query support", OGlobalConfiguration.QUERY_LIVE_SUPPORT.getKey());
            return;
        }
        try {
            OLiveQueryOps ops = OLiveQueryHook.getOpsReference(db);
            Object object = ops.threadLock;
            synchronized (object) {
                ops.queueThread.unsubscribe(id);
            }
        }
        catch (Exception e) {
            OLogManager.instance().warn(OLiveQueryHook.class, "Error on unsubscribing client", e, new Object[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void notifyForTxChanges(ODatabase iDatabase) {
        List<ORecordOperation> list;
        if (Boolean.FALSE.equals(iDatabase.getConfiguration().getValue(OGlobalConfiguration.QUERY_LIVE_SUPPORT))) {
            return;
        }
        OLiveQueryOps ops = OLiveQueryHook.getOpsReference((ODatabaseInternal)iDatabase);
        Map<ODatabaseDocument, List<ORecordOperation>> map = ops.pendingOps;
        synchronized (map) {
            list = ops.pendingOps.remove(iDatabase);
        }
        if (list != null) {
            for (ORecordOperation item : list) {
                item.setRecord((OIdentifiable)item.getRecord().copy());
                ops.queueThread.enqueue(item);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removePendingDatabaseOps(ODatabase iDatabase) {
        if (Boolean.FALSE.equals(iDatabase.getConfiguration().getValue(OGlobalConfiguration.QUERY_LIVE_SUPPORT))) {
            return;
        }
        OLiveQueryOps ops = OLiveQueryHook.getOpsReference((ODatabaseInternal)iDatabase);
        Map<ODatabaseDocument, List<ORecordOperation>> map = ops.pendingOps;
        synchronized (map) {
            ops.pendingOps.remove(iDatabase);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addOp(ODocument iDocument, byte iType, ODatabaseDocument database) {
        if (Boolean.FALSE.equals(database.getConfiguration().getValue(OGlobalConfiguration.QUERY_LIVE_SUPPORT))) {
            return;
        }
        ODatabaseDocument db = database;
        OLiveQueryOps ops = OLiveQueryHook.getOpsReference((ODatabaseInternal)((Object)db));
        if (!ops.queueThread.hasListeners()) {
            return;
        }
        ORecordOperation result = new ORecordOperation(iDocument, iType);
        Map<ODatabaseDocument, List<ORecordOperation>> map = ops.pendingOps;
        synchronized (map) {
            List<ORecordOperation> list = ops.pendingOps.get(db);
            if (list == null) {
                list = new ArrayList<ORecordOperation>();
                ops.pendingOps.put(db, list);
            }
            list.add(result);
        }
    }

    public static class OLiveQueryOps
    implements OCloseable {
        protected Map<ODatabaseDocument, List<ORecordOperation>> pendingOps = new ConcurrentHashMap<ODatabaseDocument, List<ORecordOperation>>();
        private OLiveQueryQueueThread queueThread = new OLiveQueryQueueThread();
        private Object threadLock = new Object();

        @Override
        public void close() {
            this.queueThread.stopExecution();
            try {
                this.queueThread.join();
            }
            catch (InterruptedException ignore) {
                Thread.currentThread().interrupt();
            }
            this.pendingOps.clear();
        }

        public OLiveQueryQueueThread getQueueThread() {
            return this.queueThread;
        }
    }
}

