/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.metadata.sequence;

import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.orient.core.db.ODatabaseDocumentInternal;
import com.orientechnologies.orient.core.metadata.schema.OType;
import com.orientechnologies.orient.core.metadata.sequence.OSequence;
import com.orientechnologies.orient.core.metadata.sequence.OSequenceLimitReachedException;
import com.orientechnologies.orient.core.metadata.sequence.SequenceOrderType;
import com.orientechnologies.orient.core.record.impl.ODocument;
import java.util.concurrent.Callable;

public class OSequenceCached
extends OSequence {
    private static final String FIELD_CACHE = "cache";
    private long cacheStart;
    private long cacheEnd;
    private boolean firstCache;
    private int increment;
    private Long limitValue = null;
    private Long startValue;
    private SequenceOrderType orderType;
    private boolean recyclable;
    private String name = null;

    public OSequenceCached() {
        this(null, null);
    }

    public OSequenceCached(ODocument iDocument) {
        this(iDocument, null);
    }

    public OSequenceCached(ODocument iDocument, OSequence.CreateParams params) {
        super(iDocument, params);
        if (iDocument != null) {
            this.firstCache = true;
            this.cacheStart = this.cacheEnd = OSequenceCached.getValue(iDocument).longValue();
        }
    }

    @Override
    public synchronized boolean updateParams(OSequence.CreateParams params) {
        boolean any = super.updateParams(params);
        if (params.cacheSize != null && this.getCacheSize() != params.cacheSize.intValue()) {
            this.setCacheSize(params.cacheSize);
            any = true;
        }
        this.firstCache = true;
        this.save();
        return any;
    }

    @Override
    protected void initSequence(OSequence.CreateParams params) {
        super.initSequence(params);
        this.setCacheSize(params.cacheSize);
        this.cacheEnd = 0L;
        this.cacheStart = 0L;
        this.allocateCache(this.getCacheSize(), this.getDatabase());
    }

    private void doRecycle(ODatabaseDocumentInternal finalDb) {
        if (!this.recyclable) {
            throw new OSequenceLimitReachedException("Limit reached");
        }
        this.setValue(this.getStart());
        this.allocateCache(this.getCacheSize(), finalDb);
    }

    private void reloadCrucialValues() {
        this.increment = this.getIncrement();
        this.limitValue = this.getLimitValue();
        this.orderType = this.getOrderType();
        this.recyclable = this.getRecyclable();
        this.startValue = this.getStart();
        if (this.name == null) {
            this.name = this.getName();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long next() throws OSequenceLimitReachedException {
        ODatabaseDocumentInternal mainDb = this.getDatabase();
        boolean tx = mainDb.getTransaction().isActive();
        try {
            long l;
            block9: {
                ODatabaseDocumentInternal db = mainDb;
                if (tx) {
                    db = mainDb.copy();
                    db.activateOnCurrentThread();
                }
                try {
                    final ODatabaseDocumentInternal finalDb = db;
                    l = this.callRetry(new Callable<Long>(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public Long call() throws Exception {
                            OSequenceCached oSequenceCached = OSequenceCached.this;
                            synchronized (oSequenceCached) {
                                float delta;
                                float tillEnd;
                                boolean cachedbefore;
                                boolean detectedCrucialValueChange = false;
                                if (OSequenceCached.this.getCrucilaValueChanged()) {
                                    OSequenceCached.this.reloadCrucialValues();
                                    detectedCrucialValueChange = true;
                                }
                                if (OSequenceCached.this.orderType == SequenceOrderType.ORDER_POSITIVE) {
                                    if (OSequenceCached.this.cacheStart + (long)OSequenceCached.this.increment > OSequenceCached.this.cacheEnd && (OSequenceCached.this.limitValue == null || OSequenceCached.this.cacheStart + (long)OSequenceCached.this.increment <= OSequenceCached.this.limitValue)) {
                                        cachedbefore = !OSequenceCached.this.firstCache;
                                        OSequenceCached.this.allocateCache(OSequenceCached.this.getCacheSize(), finalDb);
                                        if (!cachedbefore) {
                                            if (OSequenceCached.this.limitValue != null && OSequenceCached.this.cacheStart + (long)OSequenceCached.this.increment > OSequenceCached.this.limitValue) {
                                                OSequenceCached.this.doRecycle(finalDb);
                                            } else {
                                                OSequenceCached.this.cacheStart = OSequenceCached.this.cacheStart + (long)OSequenceCached.this.increment;
                                            }
                                        }
                                    } else if (OSequenceCached.this.limitValue != null && OSequenceCached.this.cacheStart + (long)OSequenceCached.this.increment > OSequenceCached.this.limitValue) {
                                        OSequenceCached.this.doRecycle(finalDb);
                                    } else {
                                        OSequenceCached.this.cacheStart = OSequenceCached.this.cacheStart + (long)OSequenceCached.this.increment;
                                    }
                                } else if (OSequenceCached.this.cacheStart - (long)OSequenceCached.this.increment < OSequenceCached.this.cacheEnd && (OSequenceCached.this.limitValue == null || OSequenceCached.this.cacheStart - (long)OSequenceCached.this.increment >= OSequenceCached.this.limitValue)) {
                                    cachedbefore = !OSequenceCached.this.firstCache;
                                    OSequenceCached.this.allocateCache(OSequenceCached.this.getCacheSize(), finalDb);
                                    if (!cachedbefore) {
                                        if (OSequenceCached.this.limitValue != null && OSequenceCached.this.cacheStart - (long)OSequenceCached.this.increment < OSequenceCached.this.limitValue) {
                                            OSequenceCached.this.doRecycle(finalDb);
                                        } else {
                                            OSequenceCached.this.cacheStart = OSequenceCached.this.cacheStart - (long)OSequenceCached.this.increment;
                                        }
                                    }
                                } else if (OSequenceCached.this.limitValue != null && OSequenceCached.this.cacheStart - (long)OSequenceCached.this.increment < OSequenceCached.this.limitValue) {
                                    OSequenceCached.this.doRecycle(finalDb);
                                } else {
                                    OSequenceCached.this.cacheStart = OSequenceCached.this.cacheStart - (long)OSequenceCached.this.increment;
                                }
                                if (detectedCrucialValueChange) {
                                    OSequenceCached.this.setCrucialValueChanged(false);
                                }
                                if (OSequenceCached.this.limitValue != null && !OSequenceCached.this.recyclable && ((tillEnd = (float)Math.abs(OSequenceCached.this.limitValue - OSequenceCached.this.cacheStart) / (float)OSequenceCached.this.increment) <= (delta = (float)Math.abs(OSequenceCached.this.limitValue - OSequenceCached.this.startValue) / (float)OSequenceCached.this.increment) / 100.0f || tillEnd <= 1.0f)) {
                                    String warningMessage = "Non-recyclable sequence: " + OSequenceCached.this.name + " reaching limt, current value: " + OSequenceCached.this.cacheStart + " limit value: " + OSequenceCached.this.limitValue + " with step: " + OSequenceCached.this.increment;
                                    OLogManager.instance().warn((Object)this, warningMessage, new Object[0]);
                                }
                                OSequenceCached.this.firstCache = false;
                                return OSequenceCached.this.cacheStart;
                            }
                        }
                    }, "next");
                    if (!tx) break block9;
                }
                catch (Throwable throwable) {
                    if (tx) {
                        db.close();
                    }
                    throw throwable;
                }
                db.close();
            }
            return l;
        }
        finally {
            if (tx) {
                mainDb.activateOnCurrentThread();
            }
        }
    }

    @Override
    public synchronized long current() {
        return this.cacheStart;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long reset() {
        ODatabaseDocumentInternal mainDb = this.getDatabase();
        boolean tx = mainDb.getTransaction().isActive();
        try {
            long l;
            block9: {
                ODatabaseDocumentInternal db = mainDb;
                if (tx) {
                    db = mainDb.copy();
                    db.activateOnCurrentThread();
                }
                try {
                    final ODatabaseDocumentInternal finalDb = db;
                    l = this.callRetry(new Callable<Long>(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public Long call() throws Exception {
                            OSequenceCached oSequenceCached = OSequenceCached.this;
                            synchronized (oSequenceCached) {
                                long newValue = OSequenceCached.this.getStart();
                                OSequenceCached.this.setValue(newValue);
                                OSequenceCached.this.save(finalDb);
                                OSequenceCached.this.firstCache = true;
                                OSequenceCached.this.allocateCache(OSequenceCached.this.getCacheSize(), finalDb);
                                return newValue;
                            }
                        }
                    }, "reset");
                    if (!tx) break block9;
                }
                catch (Throwable throwable) {
                    if (tx) {
                        db.close();
                    }
                    throw throwable;
                }
                db.close();
            }
            return l;
        }
        finally {
            if (tx) {
                mainDb.activateOnCurrentThread();
            }
        }
    }

    @Override
    public OSequence.SEQUENCE_TYPE getSequenceType() {
        return OSequence.SEQUENCE_TYPE.CACHED;
    }

    public int getCacheSize() {
        return (Integer)this.getDocument().field(FIELD_CACHE, OType.INTEGER);
    }

    public void setCacheSize(int cacheSize) {
        this.getDocument().field(FIELD_CACHE, cacheSize);
    }

    private void allocateCache(int cacheSize, ODatabaseDocumentInternal db) {
        long newValue;
        if (this.getCrucilaValueChanged()) {
            this.reloadCrucialValues();
            this.setCrucialValueChanged(false);
        }
        SequenceOrderType orederType = this.getOrderType();
        long value = this.getValue();
        if (orederType == SequenceOrderType.ORDER_POSITIVE) {
            newValue = value + (long)(this.getIncrement() * cacheSize);
            if (this.limitValue != null && newValue > this.limitValue) {
                newValue = this.limitValue;
            }
        } else {
            newValue = value - (long)(this.getIncrement() * cacheSize);
            if (this.limitValue != null && newValue < this.limitValue) {
                newValue = this.limitValue;
            }
        }
        this.setValue(newValue);
        this.save(db);
        this.cacheStart = value;
        this.cacheEnd = orederType == SequenceOrderType.ORDER_POSITIVE ? newValue - 1L : newValue + 1L;
        this.firstCache = false;
    }
}

