/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.metadata.sequence;

import com.orientechnologies.common.exception.OException;
import com.orientechnologies.orient.core.config.OGlobalConfiguration;
import com.orientechnologies.orient.core.db.ODatabaseDocumentInternal;
import com.orientechnologies.orient.core.db.ODatabaseRecordThreadLocal;
import com.orientechnologies.orient.core.db.document.ODatabaseDocument;
import com.orientechnologies.orient.core.exception.OConcurrentModificationException;
import com.orientechnologies.orient.core.exception.OSequenceException;
import com.orientechnologies.orient.core.exception.OStorageException;
import com.orientechnologies.orient.core.metadata.schema.OClassImpl;
import com.orientechnologies.orient.core.metadata.schema.OType;
import com.orientechnologies.orient.core.metadata.sequence.OSequenceLimitReachedException;
import com.orientechnologies.orient.core.metadata.sequence.SequenceOrderType;
import com.orientechnologies.orient.core.record.impl.ODocument;
import java.util.Random;
import java.util.concurrent.Callable;

public abstract class OSequence {
    public static final long DEFAULT_START = 0L;
    public static final int DEFAULT_INCREMENT = 1;
    public static final int DEFAULT_CACHE = 20;
    public static final Long DEFAULT_LIMIT_VALUE = null;
    public static final boolean DEFAULT_RECYCLABLE_VALUE = false;
    protected static final int DEF_MAX_RETRY = OGlobalConfiguration.SEQUENCE_MAX_RETRY.getValueAsInteger();
    public static final String CLASS_NAME = "OSequence";
    private static final String FIELD_START = "start";
    private static final String FIELD_INCREMENT = "incr";
    private static final String FIELD_VALUE = "value";
    private static final String FIELD_LIMIT_VALUE = "lvalue";
    private static final String FIELD_ORDER_TYPE = "otype";
    private static final String FIELD_RECYCLABLE = "recycle";
    private static final String FIELD_NAME = "name";
    private static final String FIELD_TYPE = "type";
    private ODocument document;
    private ThreadLocal<ODocument> tlDocument = new ThreadLocal();
    private boolean cruacialValueChanged = false;
    public static final SequenceOrderType DEFAULT_ORDER_TYPE = SequenceOrderType.ORDER_POSITIVE;
    private int maxRetry = DEF_MAX_RETRY;

    protected OSequence() {
        this(null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setCrucialValueChanged(boolean val) {
        OSequence oSequence = this;
        synchronized (oSequence) {
            this.cruacialValueChanged = val;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean getCrucilaValueChanged() {
        OSequence oSequence = this;
        synchronized (oSequence) {
            return this.cruacialValueChanged;
        }
    }

    protected OSequence(ODocument iDocument) {
        this(iDocument, null);
    }

    protected OSequence(ODocument iDocument, CreateParams params) {
        this.document = iDocument != null ? iDocument : new ODocument(CLASS_NAME);
        this.bindOnLocalThread();
        if (iDocument == null) {
            if (params == null) {
                params = new CreateParams().setDefaults();
            }
            this.initSequence(params);
            this.document = this.getDocument();
        }
        this.cruacialValueChanged = true;
    }

    public void save() {
        ODocument doc = this.tlDocument.get();
        doc.save();
        this.onUpdate(doc);
    }

    public void save(ODatabaseDocument database) {
        database.save(this.tlDocument.get());
    }

    void bindOnLocalThread() {
        if (this.tlDocument.get() == null) {
            this.tlDocument.set(this.document.copy());
        }
    }

    public ODocument getDocument() {
        return this.tlDocument.get();
    }

    protected synchronized void initSequence(CreateParams params) {
        this.setStart(params.start);
        this.setIncrement(params.increment);
        this.setValue(params.start);
        this.setLimitValue(params.limitValue);
        this.setOrderType(params.orderType);
        this.setRecyclable(params.recyclable);
        this.setSequenceType();
    }

    public synchronized boolean updateParams(CreateParams params) {
        boolean any = false;
        if (params.start != null && this.getStart() != params.start.longValue()) {
            this.setStart(params.start);
            any = true;
        }
        if (params.increment != null && this.getIncrement() != params.increment.intValue()) {
            this.setIncrement(params.increment);
            any = true;
        }
        if (params.limitValue != null && this.getLimitValue() != params.limitValue) {
            this.setLimitValue(params.limitValue);
            any = true;
        }
        if (params.orderType != null && this.getOrderType() != params.orderType) {
            this.setOrderType(params.orderType);
            any = true;
        }
        if (params.recyclable != null && this.getRecyclable() != params.recyclable.booleanValue()) {
            this.setRecyclable(params.recyclable);
            any = true;
        }
        if (params.turnLimitOff != null && params.turnLimitOff.booleanValue()) {
            this.setLimitValue(null);
        }
        this.save();
        return any;
    }

    public void onUpdate(ODocument iDocument) {
        this.document = iDocument;
        this.tlDocument.set(iDocument);
    }

    protected static Long getValue(ODocument doc) {
        if (!doc.containsField(FIELD_VALUE)) {
            return null;
        }
        return (Long)doc.field(FIELD_VALUE, OType.LONG);
    }

    protected synchronized Long getValue() {
        return OSequence.getValue(this.tlDocument.get());
    }

    protected synchronized void setValue(long value) {
        this.tlDocument.get().field(FIELD_VALUE, value);
        this.setCrucialValueChanged(true);
    }

    protected synchronized int getIncrement() {
        return (Integer)this.tlDocument.get().field(FIELD_INCREMENT, OType.INTEGER);
    }

    protected synchronized void setLimitValue(Long limitValue) {
        this.tlDocument.get().field(FIELD_LIMIT_VALUE, limitValue);
        this.setCrucialValueChanged(true);
    }

    protected synchronized Long getLimitValue() {
        return (Long)this.tlDocument.get().field(FIELD_LIMIT_VALUE, OType.LONG);
    }

    protected synchronized void setOrderType(SequenceOrderType orderType) {
        this.tlDocument.get().field(FIELD_ORDER_TYPE, orderType.getValue());
        this.setCrucialValueChanged(true);
    }

    protected synchronized SequenceOrderType getOrderType() {
        byte val = (Byte)this.tlDocument.get().field(FIELD_ORDER_TYPE);
        return SequenceOrderType.fromValue(val);
    }

    protected synchronized void setIncrement(int value) {
        this.tlDocument.get().field(FIELD_INCREMENT, value);
        this.setCrucialValueChanged(true);
    }

    protected synchronized long getStart() {
        return (Long)this.tlDocument.get().field(FIELD_START, OType.LONG);
    }

    protected synchronized void setStart(long value) {
        this.tlDocument.get().field(FIELD_START, value);
        this.setCrucialValueChanged(true);
    }

    public synchronized int getMaxRetry() {
        return this.maxRetry;
    }

    public synchronized void setMaxRetry(int maxRetry) {
        this.maxRetry = maxRetry;
    }

    public synchronized String getName() {
        return OSequence.getSequenceName(this.tlDocument.get());
    }

    public synchronized OSequence setName(String name) {
        this.tlDocument.get().field(FIELD_NAME, name);
        return this;
    }

    public synchronized boolean getRecyclable() {
        return (Boolean)this.tlDocument.get().field(FIELD_RECYCLABLE, OType.BOOLEAN);
    }

    public synchronized void setRecyclable(boolean recyclable) {
        this.tlDocument.get().field(FIELD_RECYCLABLE, recyclable);
        this.setCrucialValueChanged(true);
    }

    private synchronized void setSequenceType() {
        this.tlDocument.get().field(FIELD_TYPE, (Object)this.getSequenceType());
        this.setCrucialValueChanged(true);
    }

    protected synchronized ODatabaseDocumentInternal getDatabase() {
        return ODatabaseRecordThreadLocal.instance().get();
    }

    public static String getSequenceName(ODocument iDocument) {
        return (String)iDocument.field(FIELD_NAME, OType.STRING);
    }

    public static SEQUENCE_TYPE getSequenceType(ODocument document) {
        String sequenceTypeStr = (String)document.field(FIELD_TYPE);
        if (sequenceTypeStr != null) {
            return SEQUENCE_TYPE.valueOf(sequenceTypeStr);
        }
        return null;
    }

    public static void initClass(OClassImpl sequenceClass) {
        sequenceClass.createProperty(FIELD_START, OType.LONG, (OType)null, true);
        sequenceClass.createProperty(FIELD_INCREMENT, OType.INTEGER, (OType)null, true);
        sequenceClass.createProperty(FIELD_VALUE, OType.LONG, (OType)null, true);
        sequenceClass.createProperty(FIELD_NAME, OType.STRING, (OType)null, true);
        sequenceClass.createProperty(FIELD_TYPE, OType.STRING, (OType)null, true);
        sequenceClass.createProperty(FIELD_LIMIT_VALUE, OType.INTEGER, (OType)null, true);
        sequenceClass.createProperty(FIELD_ORDER_TYPE, OType.BYTE, (OType)null, true);
        sequenceClass.createProperty(FIELD_RECYCLABLE, OType.BOOLEAN, (OType)null, true);
    }

    public abstract long next() throws OSequenceLimitReachedException;

    public abstract long current();

    public abstract long reset();

    public abstract SEQUENCE_TYPE getSequenceType();

    protected void reloadSequence() {
        this.tlDocument.set(this.tlDocument.get().reload(null, true));
    }

    protected <T> T callRetry(Callable<T> callable, String method) {
        for (int retry = 0; retry < this.maxRetry; ++retry) {
            try {
                this.reloadSequence();
                return callable.call();
            }
            catch (OConcurrentModificationException ignore) {
                try {
                    Thread.sleep(1 + new Random().nextInt(this.getDatabase().getConfiguration().getValueAsInteger(OGlobalConfiguration.SEQUENCE_RETRY_DELAY)));
                    continue;
                }
                catch (InterruptedException ignored) {
                    Thread.currentThread().interrupt();
                    break;
                }
            }
            catch (OStorageException e) {
                if (e.getCause() instanceof OConcurrentModificationException) {
                    this.reloadSequence();
                    continue;
                }
                throw OException.wrapException(new OSequenceException("Error in transactional processing of " + this.getName() + "." + method + "()"), e);
            }
            catch (OSequenceLimitReachedException exc) {
                throw exc;
            }
            catch (OException ignore) {
                this.reloadSequence();
                continue;
            }
            catch (Exception e) {
                throw OException.wrapException(new OSequenceException("Error in transactional processing of " + this.getName() + "." + method + "()"), e);
            }
        }
        try {
            return callable.call();
        }
        catch (Exception e) {
            if (e.getCause() instanceof OConcurrentModificationException) {
                throw (OConcurrentModificationException)e.getCause();
            }
            throw OException.wrapException(new OSequenceException("Error in transactional processing of " + this.getName() + "." + method + "()"), e);
        }
    }

    public static enum SEQUENCE_TYPE {
        CACHED,
        ORDERED;

    }

    public static class CreateParams {
        public Long start = 0L;
        public Integer increment = 1;
        public Integer cacheSize = 20;
        public Long limitValue = DEFAULT_LIMIT_VALUE;
        public SequenceOrderType orderType = DEFAULT_ORDER_TYPE;
        public Boolean recyclable = false;
        public Boolean turnLimitOff = false;

        public CreateParams setStart(Long start) {
            this.start = start;
            return this;
        }

        public CreateParams setIncrement(Integer increment) {
            this.increment = increment;
            return this;
        }

        public CreateParams setCacheSize(Integer cacheSize) {
            this.cacheSize = cacheSize;
            return this;
        }

        public CreateParams setLimitValue(Long limitValue) {
            this.limitValue = limitValue;
            return this;
        }

        public CreateParams setOrderType(SequenceOrderType orderType) {
            this.orderType = orderType;
            return this;
        }

        public CreateParams setRecyclable(boolean recyclable) {
            this.recyclable = recyclable;
            return this;
        }

        public CreateParams setTurnLimitOff(Boolean turnLimitOff) {
            this.turnLimitOff = turnLimitOff;
            return this;
        }

        public CreateParams resetNull() {
            this.start = null;
            this.increment = null;
            this.cacheSize = null;
            this.limitValue = null;
            this.orderType = null;
            this.recyclable = null;
            this.turnLimitOff = false;
            return this;
        }

        public CreateParams setDefaults() {
            this.start = this.start != null ? this.start : 0L;
            this.increment = this.increment != null ? this.increment : 1;
            this.cacheSize = this.cacheSize != null ? this.cacheSize : 20;
            this.limitValue = this.limitValue == null ? DEFAULT_LIMIT_VALUE : this.limitValue;
            this.orderType = this.orderType == null ? DEFAULT_ORDER_TYPE : this.orderType;
            this.recyclable = this.recyclable == null ? false : this.recyclable;
            this.turnLimitOff = this.turnLimitOff == null ? false : this.turnLimitOff;
            return this;
        }
    }
}

