/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.metadata.schema;

import com.orientechnologies.common.util.OPair;
import com.orientechnologies.orient.core.metadata.schema.OType;
import java.util.ArrayList;
import java.util.List;

public class OViewConfig {
    public static String UPDATE_STRATEGY_BATCH = "batch";
    public static String UPDATE_STRATEGY_LIVE = "live";
    protected String name;
    protected String query;
    protected boolean updatable;
    protected List<OViewIndexConfig> indexes = new ArrayList<OViewIndexConfig>();
    protected String updateStrategy = UPDATE_STRATEGY_BATCH;
    protected List<String> watchClasses = new ArrayList<String>();
    protected List<String> nodes = null;
    protected int updateIntervalSeconds = 30;
    protected String originRidField = null;

    public OViewConfig(String name, String query) {
        this.name = name;
        this.query = query;
    }

    public OViewConfig copy() {
        OViewConfig result = new OViewConfig(this.name, this.query);
        result.updatable = this.updatable;
        for (OViewIndexConfig index : this.indexes) {
            OViewIndexConfig idx = result.addIndex(index.type, index.engine);
            index.props.forEach(x -> idx.addProperty((String)x.key, (OType)x.value));
        }
        result.updateStrategy = this.updateStrategy;
        result.watchClasses = this.watchClasses == null ? null : new ArrayList<String>(this.watchClasses);
        result.updateIntervalSeconds = this.updateIntervalSeconds;
        result.originRidField = this.originRidField;
        result.nodes = this.nodes == null ? null : new ArrayList<String>(this.nodes);
        return result;
    }

    public OViewIndexConfig addIndex(String type, String engine) {
        OViewIndexConfig result = new OViewIndexConfig(type, engine);
        this.indexes.add(result);
        return result;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getQuery() {
        return this.query;
    }

    public void setQuery(String query) {
        this.query = query;
    }

    public boolean isUpdatable() {
        return this.updatable;
    }

    public void setUpdatable(boolean updatable) {
        this.updatable = updatable;
    }

    public List<OViewIndexConfig> getIndexes() {
        return this.indexes;
    }

    public String getUpdateStrategy() {
        return this.updateStrategy;
    }

    public void setUpdateStrategy(String updateStrategy) {
        this.updateStrategy = updateStrategy;
    }

    public List<String> getWatchClasses() {
        return this.watchClasses;
    }

    public void setWatchClasses(List<String> watchClasses) {
        this.watchClasses = watchClasses;
    }

    public int getUpdateIntervalSeconds() {
        return this.updateIntervalSeconds;
    }

    public void setUpdateIntervalSeconds(int updateIntervalSeconds) {
        this.updateIntervalSeconds = updateIntervalSeconds;
    }

    public String getOriginRidField() {
        return this.originRidField;
    }

    public void setOriginRidField(String originRidField) {
        this.originRidField = originRidField;
    }

    public List<String> getNodes() {
        return this.nodes;
    }

    public void setNodes(List<String> nodes) {
        this.nodes = nodes;
    }

    public static class OViewIndexConfig {
        protected final String type;
        protected final String engine;
        protected List<OPair<String, OType>> props = new ArrayList<OPair<String, OType>>();

        OViewIndexConfig(String type, String engine) {
            this.type = type;
            this.engine = engine;
        }

        public void addProperty(String name, OType type) {
            this.props.add(new OPair<String, OType>(name, type));
        }

        public List<OPair<String, OType>> getProperties() {
            return this.props;
        }

        public String getType() {
            return this.type;
        }

        public String getEngine() {
            return this.engine;
        }
    }
}

