/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.metadata.schema;

import com.orientechnologies.common.concur.lock.OReadersWriterSpinLock;
import com.orientechnologies.common.concur.resource.OCloseable;
import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.common.types.OModifiableInteger;
import com.orientechnologies.common.util.OArrays;
import com.orientechnologies.orient.core.db.ODatabaseDocumentInternal;
import com.orientechnologies.orient.core.db.ODatabaseRecordThreadLocal;
import com.orientechnologies.orient.core.db.OMetadataUpdateListener;
import com.orientechnologies.orient.core.db.OScenarioThreadLocal;
import com.orientechnologies.orient.core.db.record.ORecordElement;
import com.orientechnologies.orient.core.db.viewmanager.ViewCreationListener;
import com.orientechnologies.orient.core.exception.OConcurrentModificationException;
import com.orientechnologies.orient.core.exception.OConfigurationException;
import com.orientechnologies.orient.core.exception.OSchemaException;
import com.orientechnologies.orient.core.exception.OSchemaNotCreatedException;
import com.orientechnologies.orient.core.id.ORID;
import com.orientechnologies.orient.core.id.ORecordId;
import com.orientechnologies.orient.core.metadata.schema.OClass;
import com.orientechnologies.orient.core.metadata.schema.OClassImpl;
import com.orientechnologies.orient.core.metadata.schema.OGlobalProperty;
import com.orientechnologies.orient.core.metadata.schema.OGlobalPropertyImpl;
import com.orientechnologies.orient.core.metadata.schema.OImmutableSchema;
import com.orientechnologies.orient.core.metadata.schema.OType;
import com.orientechnologies.orient.core.metadata.schema.OView;
import com.orientechnologies.orient.core.metadata.schema.OViewConfig;
import com.orientechnologies.orient.core.metadata.schema.OViewImpl;
import com.orientechnologies.orient.core.metadata.schema.clusterselection.OClusterSelectionFactory;
import com.orientechnologies.orient.core.metadata.security.ORole;
import com.orientechnologies.orient.core.metadata.security.ORule;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.storage.OAutoshardedStorage;
import com.orientechnologies.orient.core.storage.OStorageProxy;
import com.orientechnologies.orient.core.storage.impl.local.OAbstractPaginatedStorage;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;

public abstract class OSchemaShared
implements OCloseable {
    private static final int NOT_EXISTENT_CLUSTER_ID = -1;
    public static final int CURRENT_VERSION_NUMBER = 4;
    public static final int VERSION_NUMBER_V4 = 4;
    public static final int VERSION_NUMBER_V5 = 5;
    private static final long serialVersionUID = 1L;
    private final OReadersWriterSpinLock rwSpinLock = new OReadersWriterSpinLock();
    protected final Map<String, OClass> classes = new HashMap<String, OClass>();
    protected final Map<Integer, OClass> clustersToClasses = new HashMap<Integer, OClass>();
    protected final Map<String, OView> views = new HashMap<String, OView>();
    protected final Map<Integer, OView> clustersToViews = new HashMap<Integer, OView>();
    private final OClusterSelectionFactory clusterSelectionFactory = new OClusterSelectionFactory();
    private final OModifiableInteger modificationCounter = new OModifiableInteger();
    private final List<OGlobalProperty> properties = new ArrayList<OGlobalProperty>();
    private final Map<String, OGlobalProperty> propertiesByNameType = new HashMap<String, OGlobalProperty>();
    private Set<Integer> blobClusters = new HashSet<Integer>();
    private volatile int version = 0;
    private volatile boolean acquiredDistributed = false;
    protected volatile OImmutableSchema snapshot;
    protected volatile ODocument document = new ODocument().setTrackingChanges(false);
    protected static Set<String> internalClasses = new HashSet<String>();

    public static Character checkClassNameIfValid(String iName) throws OSchemaException {
        if (iName == null) {
            throw new IllegalArgumentException("Name is null");
        }
        return null;
    }

    public static Character checkFieldNameIfValid(String iName) {
        if (iName == null) {
            throw new IllegalArgumentException("Name is null");
        }
        int nameSize = (iName = iName.trim()).length();
        if (nameSize == 0) {
            throw new IllegalArgumentException("Name is empty");
        }
        for (int i = 0; i < nameSize; ++i) {
            char c = iName.charAt(i);
            if (c != ':' && c != ',' && c != ';' && c != ' ' && c != '=') continue;
            return Character.valueOf(c);
        }
        return null;
    }

    public OImmutableSchema makeSnapshot(ODatabaseDocumentInternal database) {
        if (this.snapshot == null) {
            this.acquireSchemaReadLock();
            try {
                if (this.snapshot == null) {
                    this.snapshot = new OImmutableSchema(this, database);
                }
            }
            finally {
                this.releaseSchemaReadLock();
            }
        }
        return this.snapshot;
    }

    public void forceSnapshot(ODatabaseDocumentInternal database) {
        this.acquireSchemaReadLock();
        try {
            if (this.document.getInternalStatus() == ORecordElement.STATUS.LOADED) {
                this.snapshot = new OImmutableSchema(this, database);
            }
        }
        finally {
            this.releaseSchemaReadLock();
        }
    }

    public OClusterSelectionFactory getClusterSelectionFactory() {
        return this.clusterSelectionFactory;
    }

    public int countClasses(ODatabaseDocumentInternal database) {
        database.checkSecurity(ORule.ResourceGeneric.SCHEMA, ORole.PERMISSION_READ, new Object[0]);
        this.acquireSchemaReadLock();
        try {
            int n = this.classes.size();
            return n;
        }
        finally {
            this.releaseSchemaReadLock();
        }
    }

    public int countViews(ODatabaseDocumentInternal database) {
        database.checkSecurity(ORule.ResourceGeneric.SCHEMA, ORole.PERMISSION_READ, new Object[0]);
        this.acquireSchemaReadLock();
        try {
            int n = this.views.size();
            return n;
        }
        finally {
            this.releaseSchemaReadLock();
        }
    }

    public void onPostIndexManagement() {
        for (OClass oClass : this.classes.values()) {
            if (!(oClass instanceof OClassImpl)) continue;
            ((OClassImpl)oClass).onPostIndexManagement();
        }
        for (OClass oClass : this.views.values()) {
            if (!(oClass instanceof OClassImpl)) continue;
            ((OClassImpl)oClass).onPostIndexManagement();
        }
    }

    public OClass createClass(ODatabaseDocumentInternal database, String className) {
        return this.createClass(database, className, (OClass)null, (int[])null);
    }

    public OClass createClass(ODatabaseDocumentInternal database, String iClassName, OClass iSuperClass) {
        return this.createClass(database, iClassName, iSuperClass, (int[])null);
    }

    public OClass createClass(ODatabaseDocumentInternal database, String iClassName, OClass ... superClasses) {
        return this.createClass(database, iClassName, (int[])null, superClasses);
    }

    public OClass getOrCreateClass(ODatabaseDocumentInternal database, String iClassName) {
        return this.getOrCreateClass(database, iClassName, (OClass)null);
    }

    public OClass getOrCreateClass(ODatabaseDocumentInternal database, String iClassName, OClass superClass) {
        OClass[] oClassArray;
        if (superClass == null) {
            oClassArray = new OClass[]{};
        } else {
            OClass[] oClassArray2 = new OClass[1];
            oClassArray = oClassArray2;
            oClassArray2[0] = superClass;
        }
        return this.getOrCreateClass(database, iClassName, oClassArray);
    }

    public abstract OClass getOrCreateClass(ODatabaseDocumentInternal var1, String var2, OClass ... var3);

    public OClass createAbstractClass(ODatabaseDocumentInternal database, String className) {
        return this.createClass(database, className, null, new int[]{-1});
    }

    public OClass createAbstractClass(ODatabaseDocumentInternal database, String className, OClass superClass) {
        return this.createClass(database, className, superClass, new int[]{-1});
    }

    public OClass createAbstractClass(ODatabaseDocumentInternal database, String iClassName, OClass ... superClasses) {
        return this.createClass(database, iClassName, new int[]{-1}, superClasses);
    }

    public OClass createClass(ODatabaseDocumentInternal database, String className, OClass superClass, int[] clusterIds) {
        return this.createClass(database, className, clusterIds, superClass);
    }

    public abstract OClass createClass(ODatabaseDocumentInternal var1, String var2, int[] var3, OClass ... var4);

    public abstract OClass createClass(ODatabaseDocumentInternal var1, String var2, int var3, OClass ... var4);

    public abstract OView createView(ODatabaseDocumentInternal var1, String var2, String var3, Map<String, Object> var4);

    public abstract OView createView(ODatabaseDocumentInternal var1, OViewConfig var2);

    public abstract OView createView(ODatabaseDocumentInternal var1, OViewConfig var2, ViewCreationListener var3) throws UnsupportedOperationException;

    public abstract void checkEmbedded();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void checkClusterCanBeAdded(int clusterId, OClass cls) {
        this.acquireSchemaReadLock();
        try {
            if (clusterId < 0) {
                return;
            }
            if (this.blobClusters.contains(clusterId)) {
                throw new OSchemaException("Cluster with id " + clusterId + " already belongs to Blob");
            }
            OClass existingCls = this.clustersToClasses.get(clusterId);
            if (!(existingCls == null || cls != null && cls.equals(existingCls))) {
                throw new OSchemaException("Cluster with id " + clusterId + " already belongs to the class '" + this.clustersToClasses.get(clusterId) + "'");
            }
            OView existingView = this.clustersToViews.get(clusterId);
            if (!(existingView == null || cls != null && cls.equals(existingView))) {
                throw new OSchemaException("Cluster with id " + clusterId + " already belongs to the view '" + this.clustersToViews.get(clusterId) + "'");
            }
        }
        finally {
            this.releaseSchemaReadLock();
        }
    }

    public OClass getClassByClusterId(int clusterId) {
        this.acquireSchemaReadLock();
        try {
            OClass oClass = this.clustersToClasses.get(clusterId);
            return oClass;
        }
        finally {
            this.releaseSchemaReadLock();
        }
    }

    public OView getViewByClusterId(int clusterId) {
        this.acquireSchemaReadLock();
        try {
            OView oView = this.clustersToViews.get(clusterId);
            return oView;
        }
        finally {
            this.releaseSchemaReadLock();
        }
    }

    public abstract void dropClass(ODatabaseDocumentInternal var1, String var2);

    public abstract void dropView(ODatabaseDocumentInternal var1, String var2);

    public void reload(ODatabaseDocumentInternal database) {
        this.rwSpinLock.acquireWriteLock();
        try {
            this.document = (ODocument)database.reload(this.document, null, true, true);
            this.fromStream();
            this.forceSnapshot(database);
        }
        finally {
            this.rwSpinLock.releaseWriteLock();
        }
    }

    public boolean existsClass(String iClassName) {
        if (iClassName == null) {
            return false;
        }
        this.acquireSchemaReadLock();
        try {
            boolean bl = this.classes.containsKey(iClassName.toLowerCase(Locale.ENGLISH));
            return bl;
        }
        finally {
            this.releaseSchemaReadLock();
        }
    }

    public boolean existsView(String viewName) {
        if (viewName == null) {
            return false;
        }
        this.acquireSchemaReadLock();
        try {
            boolean bl = this.views.containsKey(viewName.toLowerCase(Locale.ENGLISH));
            return bl;
        }
        finally {
            this.releaseSchemaReadLock();
        }
    }

    public OClass getClass(Class<?> iClass) {
        if (iClass == null) {
            return null;
        }
        return this.getClass(iClass.getSimpleName());
    }

    public OClass getClass(String iClassName) {
        if (iClassName == null) {
            return null;
        }
        this.acquireSchemaReadLock();
        try {
            OClass oClass = this.classes.get(iClassName.toLowerCase(Locale.ENGLISH));
            return oClass;
        }
        finally {
            this.releaseSchemaReadLock();
        }
    }

    public OView getView(String viewName) {
        if (viewName == null) {
            return null;
        }
        this.acquireSchemaReadLock();
        try {
            OView oView = this.views.get(viewName.toLowerCase(Locale.ENGLISH));
            return oView;
        }
        finally {
            this.releaseSchemaReadLock();
        }
    }

    public void acquireSchemaReadLock() {
        this.rwSpinLock.acquireReadLock();
    }

    public void releaseSchemaReadLock() {
        this.rwSpinLock.releaseReadLock();
    }

    public void acquireSchemaWriteLock(ODatabaseDocumentInternal database) {
        this.rwSpinLock.acquireWriteLock();
        this.modificationCounter.increment();
    }

    public void releaseSchemaWriteLock(ODatabaseDocumentInternal database) {
        this.releaseSchemaWriteLock(database, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releaseSchemaWriteLock(ODatabaseDocumentInternal database, boolean iSave) {
        int count;
        try {
            if (this.modificationCounter.intValue() == 1) {
                if (iSave) {
                    if (database.getStorage().getUnderlying() instanceof OAbstractPaginatedStorage) {
                        this.saveInternal(database);
                    } else {
                        this.reload(database);
                    }
                } else {
                    this.snapshot = new OImmutableSchema(this, database);
                }
                ++this.version;
            }
        }
        finally {
            this.modificationCounter.decrement();
            count = this.modificationCounter.intValue();
            this.rwSpinLock.releaseWriteLock();
        }
        assert (count >= 0);
        if (count == 0 && database.getStorage().getUnderlying() instanceof OStorageProxy) {
            database.getStorage().reload();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void changeClassName(ODatabaseDocumentInternal database, String oldName, String newName, OClass cls) {
        if (oldName != null && oldName.equalsIgnoreCase(newName)) {
            throw new IllegalArgumentException("Class '" + oldName + "' cannot be renamed with the same name");
        }
        this.acquireSchemaWriteLock(database);
        try {
            this.checkEmbedded();
            if (newName != null && (this.classes.containsKey(newName.toLowerCase(Locale.ENGLISH)) || this.views.containsKey(newName.toLowerCase(Locale.ENGLISH)))) {
                throw new IllegalArgumentException("Class '" + newName + "' is already present in schema");
            }
            if (oldName != null) {
                this.classes.remove(oldName.toLowerCase(Locale.ENGLISH));
            }
            if (newName != null) {
                this.classes.put(newName.toLowerCase(Locale.ENGLISH), cls);
            }
        }
        finally {
            this.releaseSchemaWriteLock(database);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void changeViewName(ODatabaseDocumentInternal database, String oldName, String newName, OView view) {
        if (oldName != null && oldName.equalsIgnoreCase(newName)) {
            throw new IllegalArgumentException("View '" + oldName + "' cannot be renamed with the same name");
        }
        this.acquireSchemaWriteLock(database);
        try {
            this.checkEmbedded();
            if (newName != null && (this.classes.containsKey(newName.toLowerCase(Locale.ENGLISH)) || this.views.containsKey(newName.toLowerCase(Locale.ENGLISH)))) {
                throw new IllegalArgumentException("View '" + newName + "' is already present in schema");
            }
            if (oldName != null) {
                this.views.remove(oldName.toLowerCase(Locale.ENGLISH));
            }
            if (newName != null) {
                this.views.put(newName.toLowerCase(Locale.ENGLISH), view);
            }
        }
        finally {
            this.releaseSchemaWriteLock(database);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fromStream() {
        this.rwSpinLock.acquireWriteLock();
        this.modificationCounter.increment();
        try {
            ODatabaseDocumentInternal database;
            Integer schemaVersion = (Integer)this.document.field("schemaVersion");
            if (schemaVersion == null) {
                OLogManager.instance().error(this, "Database's schema is empty! Recreating the system classes and allow the opening of the database but double check the integrity of the database", null, new Object[0]);
                return;
            }
            if (schemaVersion != 4 && 5 != schemaVersion) {
                throw new OConfigurationException("Database schema is different. Please export your old database with the previous version of OrientDB and reimport it using the current one.");
            }
            this.properties.clear();
            this.propertiesByNameType.clear();
            List globalProperties = (List)this.document.field("globalProperties");
            boolean hasGlobalProperties = false;
            if (globalProperties != null) {
                hasGlobalProperties = true;
                for (ODocument oDocument : globalProperties) {
                    OGlobalPropertyImpl prop = new OGlobalPropertyImpl();
                    prop.fromDocument(oDocument);
                    this.ensurePropertiesSize(prop.getId());
                    this.properties.set(prop.getId(), prop);
                    this.propertiesByNameType.put(prop.getName() + "|" + prop.getType().name(), prop);
                }
            }
            this.clustersToClasses.clear();
            HashMap<String, OClassImpl> newClasses = new HashMap<String, OClassImpl>();
            HashMap<String, OViewImpl> newViews = new HashMap<String, OViewImpl>();
            Collection storedClasses = (Collection)this.document.field("classes");
            for (ODocument c : storedClasses) {
                OClassImpl cls;
                String name = (String)c.field("name");
                if (this.classes.containsKey(name.toLowerCase(Locale.ENGLISH))) {
                    cls = (OClassImpl)this.classes.get(name.toLowerCase(Locale.ENGLISH));
                    cls.fromStream(c);
                } else {
                    cls = this.createClassInstance(c);
                    cls.fromStream();
                }
                newClasses.put(cls.getName().toLowerCase(Locale.ENGLISH), cls);
                if (cls.getShortName() != null) {
                    newClasses.put(cls.getShortName().toLowerCase(Locale.ENGLISH), cls);
                }
                this.addClusterClassMap(cls);
            }
            this.classes.clear();
            this.classes.putAll(newClasses);
            for (Object c : storedClasses) {
                ArrayList<String> superClassNames = (ArrayList<String>)((ODocument)c).field("superClasses");
                String legacySuperClassName = (String)((ODocument)c).field("superClass");
                if (superClassNames == null) {
                    superClassNames = new ArrayList<String>();
                }
                if (legacySuperClassName != null && !superClassNames.contains(legacySuperClassName)) {
                    superClassNames.add(legacySuperClassName);
                }
                if (superClassNames.isEmpty()) continue;
                OClassImpl cls = (OClassImpl)this.classes.get(((String)((ODocument)c).field("name")).toLowerCase(Locale.ENGLISH));
                ArrayList<OClass> superClasses = new ArrayList<OClass>(superClassNames.size());
                for (String superClassName : superClassNames) {
                    OClass superClass = this.classes.get(superClassName.toLowerCase(Locale.ENGLISH));
                    if (superClass == null) {
                        throw new OConfigurationException("Super class '" + superClassName + "' was declared in class '" + cls.getName() + "' but was not found in schema. Remove the dependency or create the class to continue.");
                    }
                    superClasses.add(superClass);
                }
                cls.setSuperClassesInternal(superClasses);
            }
            this.clustersToViews.clear();
            Collection storedViews = (Collection)this.document.field("views");
            if (storedViews != null) {
                for (ODocument v : storedViews) {
                    OViewImpl view;
                    String name = (String)v.field("name");
                    if (this.views.containsKey(name.toLowerCase(Locale.ENGLISH))) {
                        view = (OViewImpl)this.views.get(name.toLowerCase(Locale.ENGLISH));
                        view.fromStream(v);
                    } else {
                        view = this.createViewInstance(v);
                        view.fromStream();
                    }
                    newViews.put(view.getName().toLowerCase(Locale.ENGLISH), view);
                    if (view.getShortName() != null) {
                        newViews.put(view.getShortName().toLowerCase(Locale.ENGLISH), view);
                    }
                    this.addClusterViewMap(view);
                }
            }
            this.views.clear();
            this.views.putAll(newViews);
            if (this.document.containsField("blobClusters")) {
                this.blobClusters = (Set)this.document.field("blobClusters");
            }
            if (!hasGlobalProperties && (database = ODatabaseRecordThreadLocal.instance().get()).getStorage().getUnderlying() instanceof OAbstractPaginatedStorage) {
                this.saveInternal(database);
            }
        }
        finally {
            ++this.version;
            this.modificationCounter.decrement();
            this.rwSpinLock.releaseWriteLock();
        }
    }

    protected abstract OClassImpl createClassInstance(ODocument var1);

    protected abstract OViewImpl createViewInstance(ODocument var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ODocument toNetworkStream() {
        this.rwSpinLock.acquireReadLock();
        try {
            ODocument doc = new ODocument();
            this.document.setInternalStatus(ORecordElement.STATUS.UNMARSHALLING);
            try {
                this.document.field("schemaVersion", 4);
                HashSet<ODocument> cc = new HashSet<ODocument>();
                for (OClass oClass : this.classes.values()) {
                    cc.add(((OClassImpl)oClass).toNetworkStream());
                }
                this.document.field("classes", cc, OType.EMBEDDEDSET);
                HashSet<ODocument> vv = new HashSet<ODocument>();
                for (OView v : this.views.values()) {
                    vv.add(((OViewImpl)v).toNetworkStream());
                }
                this.document.field("views", vv, OType.EMBEDDEDSET);
                ArrayList<ODocument> arrayList = new ArrayList<ODocument>();
                for (OGlobalProperty globalProperty : this.properties) {
                    if (globalProperty == null) continue;
                    arrayList.add(((OGlobalPropertyImpl)globalProperty).toDocument());
                }
                this.document.field("globalProperties", arrayList, OType.EMBEDDEDLIST);
                this.document.field("blobClusters", this.blobClusters, OType.EMBEDDEDSET);
            }
            finally {
                this.document.setInternalStatus(ORecordElement.STATUS.LOADED);
            }
            ODocument oDocument = this.document;
            return oDocument;
        }
        finally {
            this.rwSpinLock.releaseReadLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ODocument toStream() {
        this.rwSpinLock.acquireReadLock();
        try {
            this.document.setInternalStatus(ORecordElement.STATUS.UNMARSHALLING);
            try {
                this.document.field("schemaVersion", 4);
                HashSet<ODocument> cc = new HashSet<ODocument>();
                for (OClass oClass : this.classes.values()) {
                    cc.add(((OClassImpl)oClass).toStream());
                }
                this.document.field("classes", cc, OType.EMBEDDEDSET);
                HashSet<ODocument> vv = new HashSet<ODocument>();
                for (OView v : this.views.values()) {
                    vv.add(((OViewImpl)v).toStream());
                }
                this.document.field("views", vv, OType.EMBEDDEDSET);
                ArrayList<ODocument> arrayList = new ArrayList<ODocument>();
                for (OGlobalProperty globalProperty : this.properties) {
                    if (globalProperty == null) continue;
                    arrayList.add(((OGlobalPropertyImpl)globalProperty).toDocument());
                }
                this.document.field("globalProperties", arrayList, OType.EMBEDDEDLIST);
                this.document.field("blobClusters", this.blobClusters, OType.EMBEDDEDSET);
            }
            finally {
                this.document.setInternalStatus(ORecordElement.STATUS.LOADED);
            }
            ODocument oDocument = this.document;
            return oDocument;
        }
        finally {
            this.rwSpinLock.releaseReadLock();
        }
    }

    public Collection<OClass> getClasses(ODatabaseDocumentInternal database) {
        database.checkSecurity(ORule.ResourceGeneric.SCHEMA, ORole.PERMISSION_READ, new Object[0]);
        this.acquireSchemaReadLock();
        try {
            HashSet<OClass> hashSet = new HashSet<OClass>(this.classes.values());
            return hashSet;
        }
        finally {
            this.releaseSchemaReadLock();
        }
    }

    public Collection<OView> getViews(ODatabaseDocumentInternal database) {
        database.checkSecurity(ORule.ResourceGeneric.SCHEMA, ORole.PERMISSION_READ, new Object[0]);
        this.acquireSchemaReadLock();
        try {
            HashSet<OView> hashSet = new HashSet<OView>(this.views.values());
            return hashSet;
        }
        finally {
            this.releaseSchemaReadLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<OClass> getClassesRelyOnCluster(ODatabaseDocumentInternal database, String clusterName) {
        database.checkSecurity(ORule.ResourceGeneric.SCHEMA, ORole.PERMISSION_READ, new Object[0]);
        this.acquireSchemaReadLock();
        try {
            int clusterId = database.getClusterIdByName(clusterName);
            HashSet<OClass> result = new HashSet<OClass>();
            for (OClass c : this.classes.values()) {
                if (!OArrays.contains(c.getPolymorphicClusterIds(), clusterId)) continue;
                result.add(c);
            }
            HashSet<OClass> hashSet = result;
            return hashSet;
        }
        finally {
            this.releaseSchemaReadLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<OView> getViewsRelyOnCluster(ODatabaseDocumentInternal database, String clusterName) {
        database.checkSecurity(ORule.ResourceGeneric.SCHEMA, ORole.PERMISSION_READ, new Object[0]);
        this.acquireSchemaReadLock();
        try {
            int clusterId = database.getClusterIdByName(clusterName);
            HashSet<OView> result = new HashSet<OView>();
            for (OView c : this.views.values()) {
                if (!OArrays.contains(c.getPolymorphicClusterIds(), clusterId)) continue;
                result.add(c);
            }
            HashSet<OView> hashSet = result;
            return hashSet;
        }
        finally {
            this.releaseSchemaReadLock();
        }
    }

    public OSchemaShared load(ODatabaseDocumentInternal database) {
        this.rwSpinLock.acquireWriteLock();
        try {
            if (!new ORecordId(database.getStorage().getConfiguration().getSchemaRecordId()).isValid()) {
                throw new OSchemaNotCreatedException("Schema is not created and cannot be loaded");
            }
            ((ORecordId)this.document.getIdentity()).fromString(database.getStorage().getConfiguration().getSchemaRecordId());
            this.document = (ODocument)database.reload(this.document, "*:-1 index:0", true);
            this.fromStream();
            OSchemaShared oSchemaShared = this;
            return oSchemaShared;
        }
        finally {
            this.rwSpinLock.releaseWriteLock();
        }
    }

    public void create(ODatabaseDocumentInternal database) {
        this.rwSpinLock.acquireWriteLock();
        try {
            this.document = (ODocument)database.save(this.document, "internal");
            database.getStorage().setSchemaRecordId(this.document.getIdentity().toString());
            this.snapshot = new OImmutableSchema(this, database);
        }
        finally {
            this.rwSpinLock.releaseWriteLock();
        }
    }

    @Override
    public void close() {
    }

    @Deprecated
    public int getVersion() {
        return this.version;
    }

    public ORID getIdentity() {
        this.acquireSchemaReadLock();
        try {
            ORID oRID = this.document.getIdentity();
            return oRID;
        }
        finally {
            this.releaseSchemaReadLock();
        }
    }

    public OSchemaShared setDirty() {
        this.rwSpinLock.acquireWriteLock();
        try {
            this.document.setDirty();
            OSchemaShared oSchemaShared = this;
            return oSchemaShared;
        }
        finally {
            this.rwSpinLock.releaseWriteLock();
        }
    }

    public OGlobalProperty getGlobalPropertyById(int id) {
        if (id >= this.properties.size()) {
            return null;
        }
        return this.properties.get(id);
    }

    public OGlobalProperty createGlobalProperty(String name, OType type, Integer id) {
        OGlobalProperty global;
        if (id < this.properties.size() && (global = this.properties.get(id)) != null) {
            if (!global.getName().equals(name) || !global.getType().equals(type)) {
                throw new OSchemaException("A property with id " + id + " already exist ");
            }
            return global;
        }
        global = new OGlobalPropertyImpl(name, type, id);
        this.ensurePropertiesSize(id);
        this.properties.set(id, global);
        this.propertiesByNameType.put(global.getName() + "|" + global.getType().name(), global);
        return global;
    }

    public List<OGlobalProperty> getGlobalProperties() {
        return Collections.unmodifiableList(this.properties);
    }

    protected OGlobalProperty findOrCreateGlobalProperty(String name, OType type) {
        OGlobalProperty global = this.propertiesByNameType.get(name + "|" + type.name());
        if (global == null) {
            int id = this.properties.size();
            global = new OGlobalPropertyImpl(name, type, id);
            this.properties.add(id, global);
            this.propertiesByNameType.put(global.getName() + "|" + global.getType().name(), global);
        }
        return global;
    }

    protected boolean executeThroughDistributedStorage(ODatabaseDocumentInternal database) {
        return database.getStorage() instanceof OAutoshardedStorage && !((OAutoshardedStorage)((Object)database.getStorage())).isLocalEnv();
    }

    private void saveInternal(final ODatabaseDocumentInternal database) {
        if (database.getTransaction().isActive()) {
            this.document = (ODocument)database.reload(this.document, null, true);
            throw new OSchemaException("Cannot change the schema while a transaction is active. Schema changes are not transactional");
        }
        this.setDirty();
        OScenarioThreadLocal.executeAsDistributed((Callable<? extends Object>)new Callable<Object>(){

            @Override
            public Object call() {
                try {
                    OSchemaShared.this.toStream();
                    OSchemaShared.this.document.save("internal");
                }
                catch (OConcurrentModificationException e) {
                    OSchemaShared.this.document = (ODocument)database.reload(OSchemaShared.this.document, null, true);
                    throw e;
                }
                return null;
            }
        });
        this.forceSnapshot(database);
        for (OMetadataUpdateListener listener : database.getSharedContext().browseListeners()) {
            listener.onSchemaUpdate(database.getName(), this);
        }
    }

    protected void addClusterClassMap(OClass cls) {
        for (int clusterId : cls.getClusterIds()) {
            if (clusterId < 0) continue;
            this.clustersToClasses.put(clusterId, cls);
        }
    }

    protected void addClusterViewMap(OView cls) {
        for (int clusterId : cls.getClusterIds()) {
            if (clusterId < 0) continue;
            this.clustersToViews.put(clusterId, cls);
        }
    }

    private void ensurePropertiesSize(int size) {
        while (this.properties.size() <= size) {
            this.properties.add(null);
        }
    }

    public int addBlobCluster(ODatabaseDocumentInternal database, int clusterId) {
        this.acquireSchemaWriteLock(database);
        try {
            this.checkClusterCanBeAdded(clusterId, null);
            this.blobClusters.add(clusterId);
        }
        finally {
            this.releaseSchemaWriteLock(database);
        }
        return clusterId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeBlobCluster(ODatabaseDocumentInternal database, String clusterName) {
        this.acquireSchemaWriteLock(database);
        try {
            int clusterId = this.getClusterId(database, clusterName);
            this.blobClusters.remove(clusterId);
        }
        finally {
            this.releaseSchemaWriteLock(database);
        }
    }

    protected int getClusterId(ODatabaseDocumentInternal database, String stringValue) {
        int clId;
        try {
            clId = Integer.parseInt(stringValue);
        }
        catch (NumberFormatException ignore) {
            clId = database.getClusterIdByName(stringValue);
        }
        return clId;
    }

    protected int createClusterIfNeeded(ODatabaseDocumentInternal database, String nameOrId) {
        String[] parts = nameOrId.split(" ");
        int clId = this.getClusterId(database, parts[0]);
        if (clId == -1) {
            try {
                clId = Integer.parseInt(parts[0]);
                throw new IllegalArgumentException("Cluster id '" + clId + "' cannot be added");
            }
            catch (NumberFormatException ignore) {
                clId = database.addCluster(parts[0], new Object[0]);
            }
        }
        return clId;
    }

    public Set<Integer> getBlobClusters() {
        return Collections.unmodifiableSet(this.blobClusters);
    }

    public ODocument getDocument() {
        return this.document;
    }

    static {
        internalClasses.add("ouser");
        internalClasses.add("orole");
        internalClasses.add("oidentity");
        internalClasses.add("ofunction");
        internalClasses.add("osequence");
        internalClasses.add("otrigger");
        internalClasses.add("oschedule");
        internalClasses.add("orids");
    }

    protected static final class ClusterIdsAreEmptyException
    extends Exception {
        protected ClusterIdsAreEmptyException() {
        }
    }
}

