/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.metadata.schema;

import com.orientechnologies.common.exception.OException;
import com.orientechnologies.common.listener.OProgressListener;
import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.common.util.OArrays;
import com.orientechnologies.common.util.OCommonConst;
import com.orientechnologies.orient.core.command.OCommandResultListener;
import com.orientechnologies.orient.core.db.ODatabaseDocumentInternal;
import com.orientechnologies.orient.core.db.ODatabaseInternal;
import com.orientechnologies.orient.core.db.ODatabaseRecordThreadLocal;
import com.orientechnologies.orient.core.db.document.ODatabaseDocument;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.db.record.ORecordElement;
import com.orientechnologies.orient.core.exception.ODatabaseException;
import com.orientechnologies.orient.core.exception.OSchemaException;
import com.orientechnologies.orient.core.exception.OSecurityAccessException;
import com.orientechnologies.orient.core.exception.OSecurityException;
import com.orientechnologies.orient.core.index.OIndex;
import com.orientechnologies.orient.core.index.OIndexDefinition;
import com.orientechnologies.orient.core.index.OIndexDefinitionFactory;
import com.orientechnologies.orient.core.index.OIndexException;
import com.orientechnologies.orient.core.index.OIndexManager;
import com.orientechnologies.orient.core.metadata.schema.OClass;
import com.orientechnologies.orient.core.metadata.schema.OClassAbstractDelegate;
import com.orientechnologies.orient.core.metadata.schema.OProperty;
import com.orientechnologies.orient.core.metadata.schema.OPropertyImpl;
import com.orientechnologies.orient.core.metadata.schema.OSchema;
import com.orientechnologies.orient.core.metadata.schema.OSchemaShared;
import com.orientechnologies.orient.core.metadata.schema.OType;
import com.orientechnologies.orient.core.metadata.schema.clusterselection.OClusterSelectionStrategy;
import com.orientechnologies.orient.core.metadata.security.ORole;
import com.orientechnologies.orient.core.metadata.security.ORule;
import com.orientechnologies.orient.core.record.ORecord;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.sharding.auto.OAutoShardingClusterSelectionStrategy;
import com.orientechnologies.orient.core.sql.OCommandSQL;
import com.orientechnologies.orient.core.sql.query.OSQLAsynchQuery;
import com.orientechnologies.orient.core.storage.OCluster;
import com.orientechnologies.orient.core.storage.OStorage;
import com.orientechnologies.orient.core.storage.impl.local.OAbstractPaginatedStorage;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;

public abstract class OClassImpl
implements OClass {
    private static final long serialVersionUID = 1L;
    protected static final int NOT_EXISTENT_CLUSTER_ID = -1;
    protected final OSchemaShared owner;
    protected final Map<String, OProperty> properties = new HashMap<String, OProperty>();
    protected int defaultClusterId = -1;
    protected String name;
    protected String description;
    protected int[] clusterIds;
    protected List<OClassImpl> superClasses = new ArrayList<OClassImpl>();
    protected int[] polymorphicClusterIds;
    protected List<OClass> subclasses;
    protected float overSize = 0.0f;
    protected String shortName;
    protected boolean strictMode = false;
    protected boolean abstractClass = false;
    protected Map<String, String> customFields;
    protected volatile OClusterSelectionStrategy clusterSelection;
    protected volatile int hashCode;
    private static Set<String> reserved = new HashSet<String>();
    protected ODocument document;

    protected OClassImpl(OSchemaShared iOwner, String iName) {
        this(iOwner, new ODocument().setTrackingChanges(false), iName);
    }

    protected OClassImpl(OSchemaShared iOwner, String iName, int[] iClusterIds) {
        this(iOwner, iName);
        this.setClusterIds(iClusterIds);
        this.defaultClusterId = iClusterIds[0];
        if (this.defaultClusterId == -1) {
            this.abstractClass = true;
        }
        if (this.abstractClass) {
            this.setPolymorphicClusterIds(OCommonConst.EMPTY_INT_ARRAY);
        } else {
            this.setPolymorphicClusterIds(iClusterIds);
        }
        this.clusterSelection = (OClusterSelectionStrategy)this.owner.getClusterSelectionFactory().newInstanceOfDefaultClass();
    }

    protected OClassImpl(OSchemaShared iOwner, ODocument iDocument, String iName) {
        this.name = iName;
        this.document = iDocument;
        this.owner = iOwner;
    }

    public static int[] readableClusters(ODatabaseDocument db, int[] iClusterIds) {
        ArrayList<Integer> listOfReadableIds = new ArrayList<Integer>();
        boolean all = true;
        for (int clusterId : iClusterIds) {
            try {
                OClass clazz = db.getMetadata().getSchema().getClassByClusterId(clusterId);
                if (clazz != null) {
                    db.checkSecurity(ORule.ResourceGeneric.CLASS, ORole.PERMISSION_READ, (Object)clazz.getName());
                }
                String clusterName = db.getClusterNameById(clusterId);
                db.checkSecurity(ORule.ResourceGeneric.CLUSTER, ORole.PERMISSION_READ, (Object)clusterName);
                listOfReadableIds.add(clusterId);
            }
            catch (OSecurityAccessException ignore) {
                all = false;
            }
        }
        if (all) {
            return iClusterIds;
        }
        int[] readableClusterIds = new int[listOfReadableIds.size()];
        int index = 0;
        Iterator iterator = listOfReadableIds.iterator();
        while (iterator.hasNext()) {
            int clusterId;
            clusterId = (Integer)iterator.next();
            readableClusterIds[index++] = clusterId;
        }
        return readableClusterIds;
    }

    @Override
    public OClusterSelectionStrategy getClusterSelection() {
        this.acquireSchemaReadLock();
        try {
            OClusterSelectionStrategy oClusterSelectionStrategy = this.clusterSelection;
            return oClusterSelectionStrategy;
        }
        finally {
            this.releaseSchemaReadLock();
        }
    }

    @Override
    public OClass setClusterSelection(OClusterSelectionStrategy clusterSelection) {
        return this.setClusterSelection(clusterSelection.getName());
    }

    @Override
    public String getCustom(String iName) {
        this.acquireSchemaReadLock();
        try {
            if (this.customFields == null) {
                String string = null;
                return string;
            }
            String string = this.customFields.get(iName);
            return string;
        }
        finally {
            this.releaseSchemaReadLock();
        }
    }

    public Map<String, String> getCustomInternal() {
        this.acquireSchemaReadLock();
        try {
            if (this.customFields != null) {
                Map<String, String> map = Collections.unmodifiableMap(this.customFields);
                return map;
            }
            Map<String, String> map = null;
            return map;
        }
        finally {
            this.releaseSchemaReadLock();
        }
    }

    @Override
    public void removeCustom(String name) {
        this.setCustom(name, null);
    }

    @Override
    public Set<String> getCustomKeys() {
        this.acquireSchemaReadLock();
        try {
            if (this.customFields != null) {
                Set<String> set = Collections.unmodifiableSet(this.customFields.keySet());
                return set;
            }
            HashSet<String> hashSet = new HashSet<String>();
            return hashSet;
        }
        finally {
            this.releaseSchemaReadLock();
        }
    }

    @Override
    public boolean hasClusterId(int clusterId) {
        return Arrays.binarySearch(this.clusterIds, clusterId) >= 0;
    }

    @Override
    public boolean hasPolymorphicClusterId(int clusterId) {
        return Arrays.binarySearch(this.polymorphicClusterIds, clusterId) >= 0;
    }

    @Override
    @Deprecated
    public OClass getSuperClass() {
        this.acquireSchemaReadLock();
        try {
            OClass oClass = this.superClasses.isEmpty() ? null : (OClass)this.superClasses.get(0);
            return oClass;
        }
        finally {
            this.releaseSchemaReadLock();
        }
    }

    @Override
    @Deprecated
    public OClass setSuperClass(OClass iSuperClass) {
        this.setSuperClasses((List<? extends OClass>)(iSuperClass != null ? Arrays.asList(iSuperClass) : Collections.EMPTY_LIST));
        return this;
    }

    @Override
    public String getName() {
        this.acquireSchemaReadLock();
        try {
            String string = this.name;
            return string;
        }
        finally {
            this.releaseSchemaReadLock();
        }
    }

    @Override
    public List<OClass> getSuperClasses() {
        this.acquireSchemaReadLock();
        try {
            List<OClass> list = Collections.unmodifiableList(this.superClasses);
            return list;
        }
        finally {
            this.releaseSchemaReadLock();
        }
    }

    @Override
    public boolean hasSuperClasses() {
        this.acquireSchemaReadLock();
        try {
            boolean bl = !this.superClasses.isEmpty();
            return bl;
        }
        finally {
            this.releaseSchemaReadLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<String> getSuperClassesNames() {
        this.acquireSchemaReadLock();
        try {
            ArrayList<String> superClassesNames = new ArrayList<String>(this.superClasses.size());
            for (OClassImpl superClass : this.superClasses) {
                superClassesNames.add(superClass.getName());
            }
            ArrayList<String> arrayList = superClassesNames;
            return arrayList;
        }
        finally {
            this.releaseSchemaReadLock();
        }
    }

    public OClass setSuperClassesByNames(List<String> classNames) {
        if (classNames == null) {
            classNames = Collections.EMPTY_LIST;
        }
        ArrayList<OClass> classes = new ArrayList<OClass>(classNames.size());
        OSchema schema = this.getDatabase().getMetadata().getSchema();
        for (String className : classNames) {
            classes.add(schema.getClass(OClassImpl.decodeClassName(className)));
        }
        return this.setSuperClasses(classes);
    }

    protected abstract void setSuperClassesInternal(List<? extends OClass> var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getSize() {
        this.acquireSchemaReadLock();
        try {
            long size = 0L;
            for (int clusterId : this.clusterIds) {
                size += this.getDatabase().getClusterRecordSizeById(clusterId);
            }
            long l = size;
            return l;
        }
        finally {
            this.releaseSchemaReadLock();
        }
    }

    @Override
    public String getShortName() {
        this.acquireSchemaReadLock();
        try {
            String string = this.shortName;
            return string;
        }
        finally {
            this.releaseSchemaReadLock();
        }
    }

    @Override
    public String getDescription() {
        this.acquireSchemaReadLock();
        try {
            String string = this.description;
            return string;
        }
        finally {
            this.releaseSchemaReadLock();
        }
    }

    @Override
    public String getStreamableName() {
        this.acquireSchemaReadLock();
        try {
            String string = this.shortName != null ? this.shortName : this.name;
            return string;
        }
        finally {
            this.releaseSchemaReadLock();
        }
    }

    @Override
    public Collection<OProperty> declaredProperties() {
        this.acquireSchemaReadLock();
        try {
            Collection<OProperty> collection = Collections.unmodifiableCollection(this.properties.values());
            return collection;
        }
        finally {
            this.releaseSchemaReadLock();
        }
    }

    @Override
    public Map<String, OProperty> propertiesMap() {
        this.getDatabase().checkSecurity(ORule.ResourceGeneric.SCHEMA, ORole.PERMISSION_READ, new Object[0]);
        this.acquireSchemaReadLock();
        try {
            HashMap<String, OProperty> props = new HashMap<String, OProperty>(20);
            this.propertiesMap(props);
            HashMap<String, OProperty> hashMap = props;
            return hashMap;
        }
        finally {
            this.releaseSchemaReadLock();
        }
    }

    private void propertiesMap(Map<String, OProperty> propertiesMap) {
        for (OProperty p : this.properties.values()) {
            String propName = p.getName();
            if (propertiesMap.containsKey(propName)) continue;
            propertiesMap.put(propName, p);
        }
        for (OClassImpl superClass : this.superClasses) {
            superClass.propertiesMap(propertiesMap);
        }
    }

    @Override
    public Collection<OProperty> properties() {
        this.getDatabase().checkSecurity(ORule.ResourceGeneric.SCHEMA, ORole.PERMISSION_READ, new Object[0]);
        this.acquireSchemaReadLock();
        try {
            ArrayList<OProperty> props = new ArrayList<OProperty>();
            this.properties(props);
            ArrayList<OProperty> arrayList = props;
            return arrayList;
        }
        finally {
            this.releaseSchemaReadLock();
        }
    }

    private void properties(Collection<OProperty> properties) {
        properties.addAll(this.properties.values());
        for (OClassImpl superClass : this.superClasses) {
            superClass.properties(properties);
        }
    }

    public void getIndexedProperties(Collection<OProperty> indexedProperties) {
        for (OProperty p : this.properties.values()) {
            if (!this.areIndexed(p.getName())) continue;
            indexedProperties.add(p);
        }
        for (OClassImpl superClass : this.superClasses) {
            superClass.getIndexedProperties(indexedProperties);
        }
    }

    @Override
    public Collection<OProperty> getIndexedProperties() {
        this.getDatabase().checkSecurity(ORule.ResourceGeneric.SCHEMA, ORole.PERMISSION_READ, new Object[0]);
        this.acquireSchemaReadLock();
        try {
            HashSet<OProperty> indexedProps = new HashSet<OProperty>();
            this.getIndexedProperties(indexedProps);
            HashSet<OProperty> hashSet = indexedProps;
            return hashSet;
        }
        finally {
            this.releaseSchemaReadLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OProperty getProperty(String propertyName) {
        this.acquireSchemaReadLock();
        try {
            OProperty p = this.properties.get(propertyName);
            if (p != null) {
                OProperty oProperty = p;
                return oProperty;
            }
            for (int i = 0; i < this.superClasses.size() && p == null; ++i) {
                p = this.superClasses.get(i).getProperty(propertyName);
            }
            OProperty oProperty = p;
            return oProperty;
        }
        finally {
            this.releaseSchemaReadLock();
        }
    }

    @Override
    public OProperty createProperty(String iPropertyName, OType iType) {
        return this.addProperty(iPropertyName, iType, null, null, false);
    }

    @Override
    public OProperty createProperty(String iPropertyName, OType iType, OClass iLinkedClass) {
        return this.addProperty(iPropertyName, iType, null, iLinkedClass, false);
    }

    @Override
    public OProperty createProperty(String iPropertyName, OType iType, OClass iLinkedClass, boolean unsafe) {
        return this.addProperty(iPropertyName, iType, null, iLinkedClass, unsafe);
    }

    @Override
    public OProperty createProperty(String iPropertyName, OType iType, OType iLinkedType) {
        return this.addProperty(iPropertyName, iType, iLinkedType, null, false);
    }

    @Override
    public OProperty createProperty(String iPropertyName, OType iType, OType iLinkedType, boolean unsafe) {
        return this.addProperty(iPropertyName, iType, iLinkedType, null, unsafe);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean existsProperty(String propertyName) {
        this.acquireSchemaReadLock();
        try {
            boolean result = this.properties.containsKey(propertyName);
            if (result) {
                boolean bl = true;
                return bl;
            }
            for (OClassImpl superClass : this.superClasses) {
                result = superClass.existsProperty(propertyName);
                if (!result) continue;
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.releaseSchemaReadLock();
        }
    }

    public void fromStream() {
        this.subclasses = null;
        this.superClasses.clear();
        this.name = (String)this.document.field("name");
        this.shortName = this.document.containsField("shortName") ? (String)this.document.field("shortName") : null;
        this.description = this.document.containsField("description") ? (String)this.document.field("description") : null;
        this.defaultClusterId = (Integer)this.document.field("defaultClusterId");
        this.strictMode = this.document.containsField("strictMode") ? (Boolean)this.document.field("strictMode") : false;
        this.abstractClass = this.document.containsField("abstract") ? (Boolean)this.document.field("abstract") : false;
        this.overSize = this.document.field("overSize") != null ? ((Float)this.document.field("overSize")).floatValue() : 0.0f;
        Object cc = this.document.field("clusterIds");
        if (cc instanceof Collection) {
            Collection coll = (Collection)this.document.field("clusterIds");
            this.clusterIds = new int[coll.size()];
            int i = 0;
            for (Integer item : coll) {
                this.clusterIds[i++] = item;
            }
        } else {
            this.clusterIds = (int[])cc;
        }
        Arrays.sort(this.clusterIds);
        if (this.clusterIds.length == 1 && this.clusterIds[0] == -1) {
            this.setPolymorphicClusterIds(OCommonConst.EMPTY_INT_ARRAY);
        } else {
            this.setPolymorphicClusterIds(this.clusterIds);
        }
        HashMap<String, OPropertyImpl> newProperties = new HashMap<String, OPropertyImpl>();
        Collection storedProperties = (Collection)this.document.field("properties");
        if (storedProperties != null) {
            for (OIdentifiable id : storedProperties) {
                OPropertyImpl prop;
                ODocument p = (ODocument)id.getRecord();
                String name = (String)p.field("name");
                if (this.properties.containsKey(name)) {
                    prop = (OPropertyImpl)this.properties.get(name);
                    prop.fromStream(p);
                } else {
                    prop = this.createPropertyInstance(p);
                    prop.fromStream();
                }
                newProperties.put(prop.getName(), prop);
            }
        }
        this.properties.clear();
        this.properties.putAll(newProperties);
        this.customFields = (Map)this.document.field("customFields", OType.EMBEDDEDMAP);
        this.clusterSelection = this.owner.getClusterSelectionFactory().getStrategy((String)this.document.field("clusterSelection"));
    }

    protected abstract OPropertyImpl createPropertyInstance(ODocument var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ODocument toStream() {
        this.document.setInternalStatus(ORecordElement.STATUS.UNMARSHALLING);
        try {
            this.document.field("name", this.name);
            this.document.field("shortName", this.shortName);
            this.document.field("description", this.description);
            this.document.field("defaultClusterId", this.defaultClusterId);
            this.document.field("clusterIds", this.clusterIds);
            this.document.field("clusterSelection", this.clusterSelection.getName());
            this.document.field("overSize", Float.valueOf(this.overSize));
            this.document.field("strictMode", this.strictMode);
            this.document.field("abstract", this.abstractClass);
            LinkedHashSet<ODocument> props = new LinkedHashSet<ODocument>();
            for (OProperty p : this.properties.values()) {
                props.add(((OPropertyImpl)p).toStream());
            }
            this.document.field("properties", props, OType.EMBEDDEDSET);
            if (this.superClasses.isEmpty()) {
                this.document.field("superClass", null, OType.STRING);
                this.document.field("superClasses", null, OType.EMBEDDEDLIST);
            } else {
                this.document.field("superClass", this.superClasses.get(0).getName(), OType.STRING);
                ArrayList<String> superClassesNames = new ArrayList<String>();
                for (OClassImpl superClass : this.superClasses) {
                    superClassesNames.add(superClass.getName());
                }
                this.document.field("superClasses", superClassesNames, OType.EMBEDDEDLIST);
            }
            this.document.field("customFields", this.customFields != null && this.customFields.size() > 0 ? this.customFields : null, OType.EMBEDDEDMAP);
        }
        finally {
            this.document.setInternalStatus(ORecordElement.STATUS.LOADED);
        }
        return this.document;
    }

    @Override
    public int getClusterForNewInstance(ODocument doc) {
        this.acquireSchemaReadLock();
        try {
            int n = this.clusterSelection.getCluster(this, doc);
            return n;
        }
        finally {
            this.releaseSchemaReadLock();
        }
    }

    @Override
    public int getDefaultClusterId() {
        this.acquireSchemaReadLock();
        try {
            int n = this.defaultClusterId;
            return n;
        }
        finally {
            this.releaseSchemaReadLock();
        }
    }

    @Override
    public int[] getClusterIds() {
        this.acquireSchemaReadLock();
        try {
            int[] nArray = this.clusterIds;
            return nArray;
        }
        finally {
            this.releaseSchemaReadLock();
        }
    }

    @Override
    public int[] getPolymorphicClusterIds() {
        this.acquireSchemaReadLock();
        try {
            int[] nArray = Arrays.copyOf(this.polymorphicClusterIds, this.polymorphicClusterIds.length);
            return nArray;
        }
        finally {
            this.releaseSchemaReadLock();
        }
    }

    private void setPolymorphicClusterIds(int[] iClusterIds) {
        TreeSet<Integer> set = new TreeSet<Integer>();
        for (int iClusterId : iClusterIds) {
            set.add(iClusterId);
        }
        this.polymorphicClusterIds = new int[set.size()];
        int i = 0;
        for (Integer clusterId : set) {
            this.polymorphicClusterIds[i] = clusterId;
            ++i;
        }
    }

    public void renameProperty(String iOldName, String iNewName) {
        OProperty p = this.properties.remove(iOldName);
        if (p != null) {
            this.properties.put(iNewName, p);
        }
    }

    public static OClass addClusters(OClass cls, int iClusters) {
        String clusterBase = cls.getName().toLowerCase(Locale.ENGLISH) + "_";
        for (int i = 0; i < iClusters; ++i) {
            cls.addCluster(clusterBase + i);
        }
        return cls;
    }

    protected void truncateClusterInternal(String clusterName, ODatabaseDocumentInternal database) {
        OCluster cluster = database.getStorage().getClusterByName(clusterName);
        if (cluster == null) {
            throw new ODatabaseException("Cluster with name " + clusterName + " does not exist");
        }
        try {
            database.checkForClusterPermissions(clusterName);
            cluster.truncate();
        }
        catch (IOException e) {
            throw OException.wrapException(new ODatabaseException("Error during truncate of cluster " + clusterName), e);
        }
        for (OIndex<?> index : this.getIndexes()) {
            index.rebuild();
        }
    }

    @Override
    public Collection<OClass> getSubclasses() {
        this.acquireSchemaReadLock();
        try {
            if (this.subclasses == null || this.subclasses.size() == 0) {
                List<OClass> list = Collections.emptyList();
                return list;
            }
            Collection<OClass> collection = Collections.unmodifiableCollection(this.subclasses);
            return collection;
        }
        finally {
            this.releaseSchemaReadLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<OClass> getAllSubclasses() {
        this.acquireSchemaReadLock();
        try {
            HashSet<OClass> set = new HashSet<OClass>();
            if (this.subclasses != null) {
                set.addAll(this.subclasses);
                for (OClass c : this.subclasses) {
                    set.addAll(c.getAllSubclasses());
                }
            }
            HashSet<OClass> hashSet = set;
            return hashSet;
        }
        finally {
            this.releaseSchemaReadLock();
        }
    }

    @Override
    @Deprecated
    public Collection<OClass> getBaseClasses() {
        return this.getSubclasses();
    }

    @Override
    @Deprecated
    public Collection<OClass> getAllBaseClasses() {
        return this.getAllSubclasses();
    }

    @Override
    public Collection<OClass> getAllSuperClasses() {
        HashSet<OClass> ret = new HashSet<OClass>();
        this.getAllSuperClasses(ret);
        return ret;
    }

    private void getAllSuperClasses(Set<OClass> set) {
        set.addAll(this.superClasses);
        for (OClassImpl superClass : this.superClasses) {
            superClass.getAllSuperClasses(set);
        }
    }

    protected abstract OClass removeBaseClassInternal(OClass var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public float getOverSize() {
        this.acquireSchemaReadLock();
        try {
            if (this.overSize > 0.0f) {
                float f = this.overSize;
                return f;
            }
            float maxOverSize = 0.0f;
            for (OClassImpl superClass : this.superClasses) {
                float thisOverSize = superClass.getOverSize();
                if (!(thisOverSize > maxOverSize)) continue;
                maxOverSize = thisOverSize;
            }
            float f = maxOverSize;
            return f;
        }
        finally {
            this.releaseSchemaReadLock();
        }
    }

    @Override
    public float getClassOverSize() {
        this.acquireSchemaReadLock();
        try {
            float f = this.overSize;
            return f;
        }
        finally {
            this.releaseSchemaReadLock();
        }
    }

    @Override
    public boolean isAbstract() {
        this.acquireSchemaReadLock();
        try {
            boolean bl = this.abstractClass;
            return bl;
        }
        finally {
            this.releaseSchemaReadLock();
        }
    }

    @Override
    public boolean isStrictMode() {
        this.acquireSchemaReadLock();
        try {
            boolean bl = this.strictMode;
            return bl;
        }
        finally {
            this.releaseSchemaReadLock();
        }
    }

    public String toString() {
        this.acquireSchemaReadLock();
        try {
            String string = this.name;
            return string;
        }
        finally {
            this.releaseSchemaReadLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean equals(Object obj) {
        this.acquireSchemaReadLock();
        try {
            if (this == obj) {
                boolean bl = true;
                return bl;
            }
            if (obj == null) {
                boolean bl = false;
                return bl;
            }
            if (!OClass.class.isAssignableFrom(obj.getClass())) {
                boolean bl = false;
                return bl;
            }
            OClass other = (OClass)obj;
            if (this.name == null) {
                if (other.getName() != null) {
                    boolean bl = false;
                    return bl;
                }
            } else if (!this.name.equals(other.getName())) {
                boolean bl = false;
                return bl;
            }
            boolean bl = true;
            return bl;
        }
        finally {
            this.releaseSchemaReadLock();
        }
    }

    public int hashCode() {
        int sh = this.hashCode;
        if (sh != 0) {
            return sh;
        }
        this.acquireSchemaReadLock();
        try {
            sh = this.hashCode;
            if (sh != 0) {
                int n = sh;
                return n;
            }
            this.calculateHashCode();
            int n = this.hashCode;
            return n;
        }
        finally {
            this.releaseSchemaReadLock();
        }
    }

    @Override
    public int compareTo(OClass o) {
        this.acquireSchemaReadLock();
        try {
            int n = this.name.compareTo(o.getName());
            return n;
        }
        finally {
            this.releaseSchemaReadLock();
        }
    }

    @Override
    public long count() {
        return this.count(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long count(boolean isPolymorphic) {
        this.acquireSchemaReadLock();
        try {
            long l = this.getDatabase().countClass(this.getName(), isPolymorphic);
            return l;
        }
        finally {
            this.releaseSchemaReadLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    public void truncate() throws IOException {
        ODatabaseDocumentInternal db = this.getDatabase();
        db.checkSecurity(ORule.ResourceGeneric.CLASS, ORole.PERMISSION_UPDATE, new Object[0]);
        if (this.isSubClassOf("ORestricted")) {
            throw new OSecurityException("Class '" + this.getName() + "' cannot be truncated because has record level security enabled (extends '" + "ORestricted" + "')");
        }
        OStorage storage = db.getStorage();
        this.acquireSchemaReadLock();
        try {
            void var5_8;
            Object object = this.clusterIds;
            int n = ((int[])object).length;
            boolean bl = false;
            while (var5_8 < n) {
                int id = object[var5_8];
                OCluster cl = storage.getClusterById(id);
                db.checkForClusterPermissions(cl.getName());
                cl.truncate();
                ++var5_8;
            }
            object = this.getClassIndexes().iterator();
            while (object.hasNext()) {
                OIndex index = (OIndex)object.next();
                index.clear();
            }
            HashSet superclassIndexes = new HashSet();
            superclassIndexes.addAll(this.getIndexes());
            superclassIndexes.removeAll(this.getClassIndexes());
            for (OIndex oIndex : superclassIndexes) {
                oIndex.rebuild();
            }
        }
        finally {
            this.releaseSchemaReadLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isSubClassOf(String iClassName) {
        this.acquireSchemaReadLock();
        try {
            if (iClassName == null) {
                boolean bl = false;
                return bl;
            }
            if (iClassName.equalsIgnoreCase(this.getName()) || iClassName.equalsIgnoreCase(this.getShortName())) {
                boolean bl = true;
                return bl;
            }
            for (OClassImpl superClass : this.superClasses) {
                if (!superClass.isSubClassOf(iClassName)) continue;
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.releaseSchemaReadLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isSubClassOf(OClass clazz) {
        this.acquireSchemaReadLock();
        try {
            if (clazz == null) {
                boolean bl = false;
                return bl;
            }
            if (this.equals(clazz)) {
                boolean bl = true;
                return bl;
            }
            for (OClassImpl superClass : this.superClasses) {
                if (!superClass.isSubClassOf(clazz)) continue;
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.releaseSchemaReadLock();
        }
    }

    @Override
    public boolean isSuperClassOf(OClass clazz) {
        return clazz != null && clazz.isSubClassOf(this);
    }

    @Override
    public Object get(OClass.ATTRIBUTES iAttribute) {
        if (iAttribute == null) {
            throw new IllegalArgumentException("attribute is null");
        }
        switch (iAttribute) {
            case NAME: {
                return this.getName();
            }
            case SHORTNAME: {
                return this.getShortName();
            }
            case SUPERCLASS: {
                return this.getSuperClass();
            }
            case SUPERCLASSES: {
                return this.getSuperClasses();
            }
            case OVERSIZE: {
                return Float.valueOf(this.getOverSize());
            }
            case STRICTMODE: {
                return this.isStrictMode();
            }
            case ABSTRACT: {
                return this.isAbstract();
            }
            case CLUSTERSELECTION: {
                return this.getClusterSelection();
            }
            case CUSTOM: {
                return this.getCustomInternal();
            }
            case DESCRIPTION: {
                return this.getDescription();
            }
        }
        throw new IllegalArgumentException("Cannot find attribute '" + (Object)((Object)iAttribute) + "'");
    }

    @Override
    public OClass set(OClass.ATTRIBUTES attribute, Object iValue) {
        if (attribute == null) {
            throw new IllegalArgumentException("attribute is null");
        }
        String stringValue = iValue != null ? iValue.toString() : null;
        boolean isNull = stringValue == null || stringValue.equalsIgnoreCase("NULL");
        switch (attribute) {
            case NAME: {
                this.setName(OClassImpl.decodeClassName(stringValue));
                break;
            }
            case SHORTNAME: {
                this.setShortName(OClassImpl.decodeClassName(stringValue));
                break;
            }
            case SUPERCLASS: {
                if (stringValue == null) {
                    throw new IllegalArgumentException("Superclass is null");
                }
                if (stringValue.startsWith("+")) {
                    this.addSuperClass(this.getDatabase().getMetadata().getSchema().getClass(OClassImpl.decodeClassName(stringValue.substring(1))));
                    break;
                }
                if (stringValue.startsWith("-")) {
                    this.removeSuperClass(this.getDatabase().getMetadata().getSchema().getClass(OClassImpl.decodeClassName(stringValue.substring(1))));
                    break;
                }
                this.setSuperClass(this.getDatabase().getMetadata().getSchema().getClass(OClassImpl.decodeClassName(stringValue)));
                break;
            }
            case SUPERCLASSES: {
                this.setSuperClassesByNames(stringValue != null ? Arrays.asList(stringValue.split(",\\s*")) : null);
                break;
            }
            case OVERSIZE: {
                this.setOverSize(Float.parseFloat(stringValue));
                break;
            }
            case STRICTMODE: {
                this.setStrictMode(Boolean.parseBoolean(stringValue));
                break;
            }
            case ABSTRACT: {
                this.setAbstract(Boolean.parseBoolean(stringValue));
                break;
            }
            case ADDCLUSTER: {
                this.addCluster(stringValue);
                break;
            }
            case REMOVECLUSTER: {
                int clId = this.owner.getClusterId(this.getDatabase(), stringValue);
                if (clId == -1) {
                    throw new IllegalArgumentException("Cluster id '" + stringValue + "' cannot be removed");
                }
                this.removeClusterId(clId);
                break;
            }
            case CLUSTERSELECTION: {
                this.setClusterSelection(stringValue);
                break;
            }
            case CUSTOM: {
                int indx;
                int n = indx = stringValue != null ? stringValue.indexOf(61) : -1;
                if (indx < 0) {
                    if (isNull || "clear".equalsIgnoreCase(stringValue)) {
                        this.clearCustom();
                        break;
                    }
                    throw new IllegalArgumentException("Syntax error: expected <name> = <value> or clear, instead found: " + iValue);
                }
                String customName = stringValue.substring(0, indx).trim();
                String customValue = stringValue.substring(indx + 1).trim();
                if (this.isQuoted(customValue)) {
                    customValue = this.removeQuotes(customValue);
                }
                if (customValue.isEmpty()) {
                    this.removeCustom(customName);
                    break;
                }
                this.setCustom(customName, customValue);
                break;
            }
            case DESCRIPTION: {
                this.setDescription(stringValue);
                break;
            }
            case ENCRYPTION: {
                this.setEncryption(stringValue);
            }
        }
        return this;
    }

    private String removeQuotes(String s) {
        s = s.trim();
        return s.substring(1, s.length() - 1);
    }

    private boolean isQuoted(String s) {
        if ((s = s.trim()).startsWith("\"") && s.endsWith("\"")) {
            return true;
        }
        if (s.startsWith("'") && s.endsWith("'")) {
            return true;
        }
        return s.startsWith("`") && s.endsWith("`");
    }

    public abstract OClassImpl setEncryption(String var1);

    protected void setEncryptionInternal(ODatabaseDocumentInternal database, String iValue) {
        for (int cl : this.getClusterIds()) {
            OCluster c = database.getStorage().getClusterById(cl);
            if (c == null) continue;
            try {
                c.set(OCluster.ATTRIBUTES.ENCRYPTION, iValue);
            }
            catch (IOException e) {
                OLogManager.instance().error(this, "Can not set value of encryption parameter to '%s'", e, iValue);
            }
        }
    }

    @Override
    public OIndex<?> createIndex(String iName, OClass.INDEX_TYPE iType, String ... fields) {
        return this.createIndex(iName, iType.name(), fields);
    }

    @Override
    public OIndex<?> createIndex(String iName, String iType, String ... fields) {
        return this.createIndex(iName, iType, (OProgressListener)null, (ODocument)null, fields);
    }

    @Override
    public OIndex<?> createIndex(String iName, OClass.INDEX_TYPE iType, OProgressListener iProgressListener, String ... fields) {
        return this.createIndex(iName, iType.name(), iProgressListener, null, fields);
    }

    @Override
    public OIndex<?> createIndex(String iName, String iType, OProgressListener iProgressListener, ODocument metadata, String ... fields) {
        return this.createIndex(iName, iType, iProgressListener, metadata, (String)null, fields);
    }

    @Override
    public OIndex<?> createIndex(String name, String type, OProgressListener progressListener, ODocument metadata, String algorithm, String ... fields) {
        if (type == null) {
            throw new IllegalArgumentException("Index type is null");
        }
        type = type.toUpperCase(Locale.ENGLISH);
        if (fields.length == 0) {
            throw new OIndexException("List of fields to index cannot be empty.");
        }
        String localName = this.name;
        int[] localPolymorphicClusterIds = this.polymorphicClusterIds;
        for (String fieldToIndex : fields) {
            String fieldName = OClassImpl.decodeClassName(OIndexDefinitionFactory.extractFieldName(fieldToIndex));
            if (fieldName.equals("@rid") || this.existsProperty(fieldName)) continue;
            throw new OIndexException("Index with name '" + name + "' cannot be created on class '" + localName + "' because the field '" + fieldName + "' is absent in class definition");
        }
        OIndexDefinition indexDefinition = OIndexDefinitionFactory.createIndexDefinition(this, Arrays.asList(fields), this.extractFieldTypes(fields), null, type, algorithm);
        return this.getDatabase().getMetadata().getIndexManager().createIndex(name, type, indexDefinition, localPolymorphicClusterIds, progressListener, metadata, algorithm);
    }

    @Override
    public boolean areIndexed(String ... fields) {
        return this.areIndexed(Arrays.asList(fields));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean areIndexed(Collection<String> fields) {
        OIndexManager indexManager = this.getDatabase().getMetadata().getIndexManager();
        this.acquireSchemaReadLock();
        try {
            boolean currentClassResult = indexManager.areIndexed(this.name, fields);
            if (currentClassResult) {
                boolean bl = true;
                return bl;
            }
            for (OClassImpl superClass : this.superClasses) {
                if (!superClass.areIndexed(fields)) continue;
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.releaseSchemaReadLock();
        }
    }

    @Override
    public Set<OIndex<?>> getInvolvedIndexes(String ... fields) {
        return this.getInvolvedIndexes(Arrays.asList(fields));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<OIndex<?>> getInvolvedIndexes(Collection<String> fields) {
        this.acquireSchemaReadLock();
        try {
            HashSet result = new HashSet(this.getClassInvolvedIndexes(fields));
            for (OClassImpl superClass : this.superClasses) {
                result.addAll(superClass.getInvolvedIndexes(fields));
            }
            HashSet<OIndex<?>> hashSet = result;
            return hashSet;
        }
        finally {
            this.releaseSchemaReadLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<OIndex<?>> getClassInvolvedIndexes(Collection<String> fields) {
        OIndexManager indexManager = this.getDatabase().getMetadata().getIndexManager();
        this.acquireSchemaReadLock();
        try {
            Set<OIndex<?>> set = indexManager.getClassInvolvedIndexes(this.name, fields);
            return set;
        }
        finally {
            this.releaseSchemaReadLock();
        }
    }

    @Override
    public Set<OIndex<?>> getClassInvolvedIndexes(String ... fields) {
        return this.getClassInvolvedIndexes(Arrays.asList(fields));
    }

    @Override
    public OIndex<?> getClassIndex(String name) {
        this.acquireSchemaReadLock();
        try {
            OIndex<?> oIndex = this.getDatabase().getMetadata().getIndexManager().getClassIndex(this.name, name);
            return oIndex;
        }
        finally {
            this.releaseSchemaReadLock();
        }
    }

    @Override
    public Set<OIndex<?>> getClassIndexes() {
        this.acquireSchemaReadLock();
        try {
            OIndexManager idxManager = this.getDatabase().getMetadata().getIndexManager();
            if (idxManager == null) {
                HashSet hashSet = new HashSet();
                return hashSet;
            }
            Set<OIndex<?>> set = idxManager.getClassIndexes(this.name);
            return set;
        }
        finally {
            this.releaseSchemaReadLock();
        }
    }

    @Override
    public void getClassIndexes(Collection<OIndex<?>> indexes) {
        this.acquireSchemaReadLock();
        try {
            OIndexManager idxManager = this.getDatabase().getMetadata().getIndexManager();
            if (idxManager == null) {
                return;
            }
            idxManager.getClassIndexes(this.name, indexes);
        }
        finally {
            this.releaseSchemaReadLock();
        }
    }

    @Override
    public OIndex<?> getAutoShardingIndex() {
        ODatabaseDocumentInternal db = this.getDatabase();
        return db != null ? db.getMetadata().getIndexManager().getClassAutoShardingIndex(this.name) : null;
    }

    @Override
    public boolean isEdgeType() {
        return this.isSubClassOf("E");
    }

    @Override
    public boolean isVertexType() {
        return this.isSubClassOf("V");
    }

    public void onPostIndexManagement() {
        OIndex<?> autoShardingIndex = this.getAutoShardingIndex();
        if (autoShardingIndex != null) {
            if (!this.getDatabase().getStorage().isRemote()) {
                this.acquireSchemaWriteLock();
                try {
                    this.clusterSelection = new OAutoShardingClusterSelectionStrategy(this, autoShardingIndex);
                }
                finally {
                    this.releaseSchemaWriteLock();
                }
            }
        } else if (this.clusterSelection instanceof OAutoShardingClusterSelectionStrategy) {
            this.acquireSchemaWriteLock();
            try {
                this.clusterSelection = (OClusterSelectionStrategy)this.owner.getClusterSelectionFactory().newInstanceOfDefaultClass();
            }
            finally {
                this.releaseSchemaWriteLock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void getIndexes(Collection<OIndex<?>> indexes) {
        this.acquireSchemaReadLock();
        try {
            this.getClassIndexes(indexes);
            for (OClass oClass : this.superClasses) {
                oClass.getIndexes(indexes);
            }
        }
        finally {
            this.releaseSchemaReadLock();
        }
    }

    @Override
    public Set<OIndex<?>> getIndexes() {
        HashSet indexes = new HashSet();
        this.getIndexes(indexes);
        return indexes;
    }

    public void acquireSchemaReadLock() {
        this.owner.acquireSchemaReadLock();
    }

    public void releaseSchemaReadLock() {
        this.owner.releaseSchemaReadLock();
    }

    public void acquireSchemaWriteLock() {
        this.owner.acquireSchemaWriteLock(this.getDatabase());
    }

    public void releaseSchemaWriteLock() {
        this.releaseSchemaWriteLock(true);
    }

    public void releaseSchemaWriteLock(boolean iSave) {
        this.calculateHashCode();
        this.owner.releaseSchemaWriteLock(this.getDatabase(), iSave);
    }

    public void checkEmbedded() {
        this.owner.checkEmbedded();
    }

    public void setClusterSelectionInternal(OClusterSelectionStrategy iClusterSelection) {
        if (this.clusterSelection.getClass().equals(iClusterSelection.getClass())) {
            return;
        }
        this.checkEmbedded();
        this.clusterSelection = iClusterSelection;
    }

    public void fireDatabaseMigration(final ODatabaseDocument database, final String propertyName, final OType type) {
        boolean strictSQL = ((ODatabaseInternal)((Object)database)).getStorage().getConfiguration().isStrictSql();
        database.query(new OSQLAsynchQuery("select from " + this.getEscapedName(this.name, strictSQL) + " where " + this.getEscapedName(propertyName, strictSQL) + ".type() <> \"" + type.name() + "\"", new OCommandResultListener(){

            @Override
            public boolean result(Object iRecord) {
                ODocument record = (ODocument)((OIdentifiable)iRecord).getRecord();
                record.field(propertyName, record.field(propertyName), type);
                database.save(record);
                return true;
            }

            @Override
            public void end() {
            }

            @Override
            public Object getResult() {
                return null;
            }
        }), new Object[0]);
    }

    public void firePropertyNameMigration(final ODatabaseDocument database, final String propertyName, final String newPropertyName, final OType type) {
        boolean strictSQL = ((ODatabaseInternal)((Object)database)).getStorage().getConfiguration().isStrictSql();
        database.query(new OSQLAsynchQuery("select from " + this.getEscapedName(this.name, strictSQL) + " where " + this.getEscapedName(propertyName, strictSQL) + " is not null ", new OCommandResultListener(){

            @Override
            public boolean result(Object iRecord) {
                ODocument record = (ODocument)((OIdentifiable)iRecord).getRecord();
                record.setFieldType(propertyName, type);
                record.field(newPropertyName, record.field(propertyName), type);
                database.save(record);
                return true;
            }

            @Override
            public void end() {
            }

            @Override
            public Object getResult() {
                return null;
            }
        }), new Object[0]);
    }

    public void checkPersistentPropertyType(ODatabaseInternal<ORecord> database, String propertyName, OType type) {
        List res;
        if (OType.ANY.equals(type)) {
            return;
        }
        boolean strictSQL = database.getStorage().getConfiguration().isStrictSql();
        StringBuilder builder = new StringBuilder(256);
        builder.append("select count(*) from ");
        builder.append(this.getEscapedName(this.name, strictSQL));
        builder.append(" where ");
        builder.append(this.getEscapedName(propertyName, strictSQL));
        builder.append(".type() not in [");
        Iterator<OType> cur = type.getCastable().iterator();
        while (cur.hasNext()) {
            builder.append('\"').append(cur.next().name()).append('\"');
            if (!cur.hasNext()) continue;
            builder.append(",");
        }
        builder.append("] and ").append(this.getEscapedName(propertyName, strictSQL)).append(" is not null ");
        if (type.isMultiValue()) {
            builder.append(" and ").append(this.getEscapedName(propertyName, strictSQL)).append(".size() <> 0 limit 1");
        }
        if ((Long)((ODocument)(res = (List)database.command(new OCommandSQL(builder.toString())).execute(new Object[0])).get(0)).field("count") > 0L) {
            throw new OSchemaException("The database contains some schema-less data in the property '" + this.name + "." + propertyName + "' that is not compatible with the type " + type + ". Fix those records and change the schema again");
        }
    }

    protected String getEscapedName(String iName, boolean iStrictSQL) {
        if (iStrictSQL) {
            return "`" + iName + "`";
        }
        return iName;
    }

    public OSchemaShared getOwner() {
        return this.owner;
    }

    private void calculateHashCode() {
        int result = super.hashCode();
        this.hashCode = result = 31 * result + (this.name != null ? this.name.hashCode() : 0);
    }

    protected void renameCluster(String oldName, String newName) {
        oldName = oldName.toLowerCase(Locale.ENGLISH);
        newName = newName.toLowerCase(Locale.ENGLISH);
        ODatabaseDocumentInternal database = this.getDatabase();
        OStorage storage = database.getStorage();
        if (storage.getClusterIdByName(newName) != -1) {
            return;
        }
        int clusterId = storage.getClusterIdByName(oldName);
        if (clusterId == -1) {
            return;
        }
        if (!this.hasClusterId(clusterId)) {
            return;
        }
        database.command("alter cluster `" + oldName + "` NAME \"" + newName + "\"", new Object[0]).close();
    }

    protected void addPolymorphicClusterId(int clusterId) {
        if (Arrays.binarySearch(this.polymorphicClusterIds, clusterId) >= 0) {
            return;
        }
        this.polymorphicClusterIds = OArrays.copyOf(this.polymorphicClusterIds, this.polymorphicClusterIds.length + 1);
        this.polymorphicClusterIds[this.polymorphicClusterIds.length - 1] = clusterId;
        Arrays.sort(this.polymorphicClusterIds);
        this.addClusterIdToIndexes(clusterId);
        for (OClassImpl superClass : this.superClasses) {
            superClass.addPolymorphicClusterId(clusterId);
        }
    }

    protected abstract OProperty addProperty(String var1, OType var2, OType var3, OClass var4, boolean var5);

    protected void validatePropertyName(String propertyName) {
    }

    private int getClusterId(String stringValue) {
        int clId;
        if (!stringValue.isEmpty() && Character.isDigit(stringValue.charAt(0))) {
            try {
                clId = Integer.parseInt(stringValue);
            }
            catch (NumberFormatException ignore) {
                clId = this.getDatabase().getClusterIdByName(stringValue);
            }
        } else {
            clId = this.getDatabase().getClusterIdByName(stringValue);
        }
        return clId;
    }

    private void addClusterIdToIndexes(int iId) {
        ODatabaseDocumentInternal database = ODatabaseRecordThreadLocal.instance().getIfDefined();
        if (database != null && database.getStorage().getUnderlying() instanceof OAbstractPaginatedStorage) {
            String clusterName = this.getDatabase().getClusterNameById(iId);
            ArrayList<String> indexesToAdd = new ArrayList<String>();
            for (OIndex<?> index : this.getIndexes()) {
                indexesToAdd.add(index.getName());
            }
            OIndexManager indexManager = this.getDatabase().getMetadata().getIndexManager();
            for (String indexName : indexesToAdd) {
                indexManager.addClusterToIndex(clusterName, indexName);
            }
        }
    }

    protected OClass addBaseClass(OClassImpl iBaseClass) {
        this.checkRecursion(iBaseClass);
        if (this.subclasses == null) {
            this.subclasses = new ArrayList<OClass>();
        }
        if (this.subclasses.contains(iBaseClass)) {
            return this;
        }
        this.subclasses.add(iBaseClass);
        this.addPolymorphicClusterIdsWithInheritance(iBaseClass);
        return this;
    }

    protected void checkParametersConflict(OClass baseClass) {
        Collection<OProperty> baseClassProperties = baseClass.properties();
        for (OProperty property : baseClassProperties) {
            OProperty thisProperty = this.getProperty(property.getName());
            if (thisProperty == null || thisProperty.getType().equals(property.getType())) continue;
            throw new OSchemaException("Cannot add base class '" + baseClass.getName() + "', because of property conflict: '" + thisProperty + "' vs '" + property + "'");
        }
    }

    public static void checkParametersConflict(List<OClass> classes) {
        HashMap<String, OProperty> comulative = new HashMap<String, OProperty>();
        HashMap<String, OProperty> properties = new HashMap<String, OProperty>();
        for (OClass superClass : classes) {
            if (superClass == null) continue;
            OClassImpl impl = superClass instanceof OClassAbstractDelegate ? (OClassImpl)((OClassAbstractDelegate)superClass).delegate : (OClassImpl)superClass;
            impl.propertiesMap(properties);
            for (Map.Entry entry : properties.entrySet()) {
                String property;
                OProperty existingProperty;
                if (!comulative.containsKey(entry.getKey()) || (existingProperty = (OProperty)comulative.get(property = (String)entry.getKey())).getType().equals(((OProperty)entry.getValue()).getType())) continue;
                throw new OSchemaException("Properties conflict detected: '" + existingProperty + "] vs [" + entry.getValue() + "]");
            }
            comulative.putAll(properties);
            properties.clear();
        }
    }

    private void checkRecursion(OClass baseClass) {
        if (this.isSubClassOf(baseClass)) {
            throw new OSchemaException("Cannot add base class '" + baseClass.getName() + "', because of recursion");
        }
    }

    protected void removePolymorphicClusterIds(OClassImpl iBaseClass) {
        for (int clusterId : iBaseClass.polymorphicClusterIds) {
            this.removePolymorphicClusterId(clusterId);
        }
    }

    protected void removePolymorphicClusterId(int clusterId) {
        int index = Arrays.binarySearch(this.polymorphicClusterIds, clusterId);
        if (index < 0) {
            return;
        }
        if (index < this.polymorphicClusterIds.length - 1) {
            System.arraycopy(this.polymorphicClusterIds, index + 1, this.polymorphicClusterIds, index, this.polymorphicClusterIds.length - (index + 1));
        }
        this.polymorphicClusterIds = Arrays.copyOf(this.polymorphicClusterIds, this.polymorphicClusterIds.length - 1);
        this.removeClusterFromIndexes(clusterId);
        for (OClassImpl superClass : this.superClasses) {
            superClass.removePolymorphicClusterId(clusterId);
        }
    }

    private void removeClusterFromIndexes(int iId) {
        if (this.getDatabase().getStorage().getUnderlying() instanceof OAbstractPaginatedStorage) {
            String clusterName = this.getDatabase().getClusterNameById(iId);
            ArrayList<String> indexesToRemove = new ArrayList<String>();
            for (OIndex<?> index : this.getIndexes()) {
                indexesToRemove.add(index.getName());
            }
            OIndexManager indexManager = this.getDatabase().getMetadata().getIndexManager();
            for (String indexName : indexesToRemove) {
                indexManager.removeClusterFromIndex(clusterName, indexName);
            }
        }
    }

    protected ODatabaseDocumentInternal getDatabase() {
        return ODatabaseRecordThreadLocal.instance().get();
    }

    protected void addPolymorphicClusterIds(OClassImpl iBaseClass) {
        TreeSet<Integer> clusters = new TreeSet<Integer>();
        for (int clusterId : this.polymorphicClusterIds) {
            clusters.add(clusterId);
        }
        for (int clusterId : iBaseClass.polymorphicClusterIds) {
            if (!clusters.add(clusterId)) continue;
            try {
                this.addClusterIdToIndexes(clusterId);
            }
            catch (RuntimeException e) {
                OLogManager.instance().warn((Object)this, "Error adding clusterId '%d' to index of class '%s'", e, clusterId, this.getName());
                clusters.remove(clusterId);
            }
        }
        this.polymorphicClusterIds = new int[clusters.size()];
        int i = 0;
        for (Integer cluster : clusters) {
            this.polymorphicClusterIds[i] = cluster;
            ++i;
        }
    }

    private void addPolymorphicClusterIdsWithInheritance(OClassImpl iBaseClass) {
        this.addPolymorphicClusterIds(iBaseClass);
        for (OClassImpl superClass : this.superClasses) {
            superClass.addPolymorphicClusterIdsWithInheritance(iBaseClass);
        }
    }

    public List<OType> extractFieldTypes(String[] fieldNames) {
        ArrayList<OType> types = new ArrayList<OType>(fieldNames.length);
        for (String fieldName : fieldNames) {
            if (!fieldName.equals("@rid")) {
                types.add(this.getProperty(OClassImpl.decodeClassName(OIndexDefinitionFactory.extractFieldName(fieldName))).getType());
                continue;
            }
            types.add(OType.LINK);
        }
        return types;
    }

    protected OClass setClusterIds(int[] iClusterIds) {
        this.clusterIds = iClusterIds;
        Arrays.sort(this.clusterIds);
        return this;
    }

    public static String decodeClassName(String s) {
        if (s == null) {
            return null;
        }
        if ((s = s.trim()).startsWith("`") && s.endsWith("`")) {
            return s.substring(1, s.length() - 1);
        }
        return s;
    }

    public void fromStream(ODocument document) {
        this.document = document;
        this.fromStream();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ODocument toNetworkStream() {
        ODocument document = new ODocument();
        document.setInternalStatus(ORecordElement.STATUS.UNMARSHALLING);
        try {
            document.field("name", this.name);
            document.field("shortName", this.shortName);
            document.field("description", this.description);
            document.field("defaultClusterId", this.defaultClusterId);
            document.field("clusterIds", this.clusterIds);
            document.field("clusterSelection", this.clusterSelection.getName());
            document.field("overSize", Float.valueOf(this.overSize));
            document.field("strictMode", this.strictMode);
            document.field("abstract", this.abstractClass);
            LinkedHashSet<ODocument> props = new LinkedHashSet<ODocument>();
            for (OProperty p : this.properties.values()) {
                props.add(((OPropertyImpl)p).toNetworkStream());
            }
            document.field("properties", props, OType.EMBEDDEDSET);
            if (this.superClasses.isEmpty()) {
                document.field("superClass", null, OType.STRING);
                document.field("superClasses", null, OType.EMBEDDEDLIST);
            } else {
                document.field("superClass", this.superClasses.get(0).getName(), OType.STRING);
                ArrayList<String> superClassesNames = new ArrayList<String>();
                for (OClassImpl superClass : this.superClasses) {
                    superClassesNames.add(superClass.getName());
                }
                document.field("superClasses", superClassesNames, OType.EMBEDDEDLIST);
            }
            document.field("customFields", this.customFields != null && this.customFields.size() > 0 ? this.customFields : null, OType.EMBEDDEDMAP);
        }
        finally {
            document.setInternalStatus(ORecordElement.STATUS.LOADED);
        }
        return document;
    }

    static {
        reserved.add("traverse");
        reserved.add("insert");
        reserved.add("update");
        reserved.add("delete");
        reserved.add("from");
        reserved.add("where");
        reserved.add("skip");
        reserved.add("limit");
        reserved.add("timeout");
    }
}

