/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.index;

import com.orientechnologies.common.listener.OProgressListener;
import com.orientechnologies.common.serialization.types.OBinarySerializer;
import com.orientechnologies.common.types.OModifiableBoolean;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.exception.OInvalidIndexEngineIdException;
import com.orientechnologies.orient.core.index.OIndexAbstract;
import com.orientechnologies.orient.core.index.OIndexDefinition;
import com.orientechnologies.orient.core.index.OIndexException;
import com.orientechnologies.orient.core.index.OIndexInternal;
import com.orientechnologies.orient.core.index.OIndexKeyUpdater;
import com.orientechnologies.orient.core.index.OIndexMultiValues;
import com.orientechnologies.orient.core.index.OIndexUpdateAction;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.serialization.serializer.OStringSerializerHelper;
import com.orientechnologies.orient.core.storage.impl.local.OAbstractPaginatedStorage;
import com.orientechnologies.orient.core.storage.ridbag.sbtree.OIndexRIDContainer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;

public class OIndexFullText
extends OIndexMultiValues {
    private static final String CONFIG_STOP_WORDS = "stopWords";
    private static final String CONFIG_SEPARATOR_CHARS = "separatorChars";
    private static final String CONFIG_IGNORE_CHARS = "ignoreChars";
    private static final String CONFIG_INDEX_RADIX = "indexRadix";
    private static final String CONFIG_MIN_WORD_LEN = "minWordLength";
    private static final boolean DEF_INDEX_RADIX = true;
    private static final String DEF_SEPARATOR_CHARS = " \r\n\t:;,.|+*/\\=!?[]()";
    private static final String DEF_IGNORE_CHARS = "'\"";
    private static final String DEF_STOP_WORDS = "the in a at as and or for his her him this that what which while up with be was were is";
    private static int DEF_MIN_WORD_LENGTH = 3;
    private boolean indexRadix;
    private String separatorChars;
    private String ignoreChars;
    private int minWordLength;
    private Set<String> stopWords;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OIndexFullText(String name, String typeId, String algorithm, int version, OAbstractPaginatedStorage storage, String valueContainerAlgorithm, ODocument metadata) {
        super(name, typeId, algorithm, version, storage, valueContainerAlgorithm, metadata);
        this.acquireExclusiveLock();
        try {
            this.config();
            this.configWithMetadata(metadata);
        }
        finally {
            this.releaseExclusiveLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OIndexFullText put(Object key, OIdentifiable singleValue) {
        if (key == null) {
            return this;
        }
        key = this.getCollatingValue(key);
        Set<String> words = this.splitIntoWords(key.toString());
        block7: for (String word : words) {
            this.acquireSharedLock();
            try {
                Set refs;
                while (true) {
                    try {
                        refs = (Set)this.storage.getIndexValue(this.indexId, word);
                    }
                    catch (OInvalidIndexEngineIdException ignore) {
                        this.doReloadIndexEngine();
                        continue;
                    }
                    break;
                }
                boolean durable = this.metadata != null && Boolean.TRUE.equals(this.metadata.field("durableInNonTxMode"));
                Set refsc = refs;
                while (true) {
                    try {
                        this.storage.updateIndexEntry(this.indexId, word, (oldValue, bonsayFileId) -> {
                            Set result = null;
                            if (refsc == null) {
                                if (!"SBTREEBONSAISET".equals(this.valueContainerAlgorithm)) throw new IllegalStateException("MBRBTreeContainer is not supported any more");
                                result = new OIndexRIDContainer(this.getName(), durable, bonsayFileId);
                            } else {
                                result = refsc;
                            }
                            result.add(singleValue);
                            return OIndexUpdateAction.changed(result);
                        });
                        continue block7;
                    }
                    catch (OInvalidIndexEngineIdException ignore) {
                        this.doReloadIndexEngine();
                        continue;
                    }
                    break;
                }
            }
            finally {
                this.releaseSharedLock();
            }
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean remove(Object key, OIdentifiable value) {
        if (key == null) {
            return false;
        }
        key = this.getCollatingValue(key);
        Set<String> words = this.splitIntoWords(key.toString());
        OModifiableBoolean removed = new OModifiableBoolean(false);
        block7: for (String word : words) {
            this.acquireSharedLock();
            try {
                Set recs;
                while (true) {
                    try {
                        recs = (Set)this.storage.getIndexValue(this.indexId, word);
                    }
                    catch (OInvalidIndexEngineIdException ignore) {
                        this.doReloadIndexEngine();
                        continue;
                    }
                    break;
                }
                if (recs == null || recs.isEmpty()) continue;
                while (true) {
                    try {
                        this.storage.updateIndexEntry(this.indexId, word, new EntityRemover(value, removed));
                        continue block7;
                    }
                    catch (OInvalidIndexEngineIdException ignore) {
                        this.doReloadIndexEngine();
                        continue;
                    }
                    break;
                }
            }
            finally {
                this.releaseSharedLock();
            }
        }
        return removed.getValue();
    }

    @Override
    public OIndexInternal<?> create(OIndexDefinition indexDefinition, String clusterIndexName, Set<String> clustersToIndex, boolean rebuild, OProgressListener progressListener, OBinarySerializer valueSerializer) {
        if (indexDefinition.getFields().size() > 1) {
            throw new OIndexException(this.type + " indexes cannot be used as composite ones.");
        }
        return super.create(indexDefinition, clusterIndexName, clustersToIndex, rebuild, progressListener, valueSerializer);
    }

    @Override
    public OIndexMultiValues create(String name, OIndexDefinition indexDefinition, String clusterIndexName, Set<String> clustersToIndex, boolean rebuild, OProgressListener progressListener) {
        if (indexDefinition.getFields().size() > 1) {
            throw new OIndexException(this.type + " indexes cannot be used as composite ones.");
        }
        return super.create(name, indexDefinition, clusterIndexName, (Set)clustersToIndex, rebuild, progressListener);
    }

    @Override
    public ODocument updateConfiguration() {
        super.updateConfiguration();
        return ((FullTextIndexConfiguration)this.configuration).updateFullTextIndexConfiguration(this.separatorChars, this.ignoreChars, this.stopWords, this.minWordLength, this.indexRadix);
    }

    @Override
    protected OIndexAbstract.IndexConfiguration indexConfigurationInstance(ODocument document) {
        return new FullTextIndexConfiguration(document);
    }

    @Override
    public boolean canBeUsedInEqualityOperators() {
        return false;
    }

    @Override
    public boolean supportsOrderedIterations() {
        return false;
    }

    protected void configWithMetadata(ODocument metadata) {
        if (metadata != null) {
            if (metadata.containsField(CONFIG_IGNORE_CHARS)) {
                this.ignoreChars = (String)metadata.field(CONFIG_IGNORE_CHARS);
            }
            if (metadata.containsField(CONFIG_INDEX_RADIX)) {
                this.indexRadix = (Boolean)metadata.field(CONFIG_INDEX_RADIX);
            }
            if (metadata.containsField(CONFIG_SEPARATOR_CHARS)) {
                this.separatorChars = (String)metadata.field(CONFIG_SEPARATOR_CHARS);
            }
            if (metadata.containsField(CONFIG_MIN_WORD_LEN)) {
                this.minWordLength = (Integer)metadata.field(CONFIG_MIN_WORD_LEN);
            }
            if (metadata.containsField(CONFIG_STOP_WORDS)) {
                this.stopWords = new HashSet<String>((Collection)metadata.field(CONFIG_STOP_WORDS));
            }
        }
    }

    protected void config() {
        this.ignoreChars = DEF_IGNORE_CHARS;
        this.indexRadix = true;
        this.separatorChars = DEF_SEPARATOR_CHARS;
        this.minWordLength = DEF_MIN_WORD_LENGTH;
        this.stopWords = new HashSet<String>(OStringSerializerHelper.split(DEF_STOP_WORDS, ' ', new char[0]));
    }

    private Set<String> splitIntoWords(String iKey) {
        HashSet<String> result = new HashSet<String>();
        ArrayList<String> words = new ArrayList<String>();
        OStringSerializerHelper.split(words, iKey, 0, -1, this.separatorChars, new char[0]);
        StringBuilder buffer = new StringBuilder(64);
        block0: for (String word : words) {
            buffer.setLength(0);
            for (int i = 0; i < word.length(); ++i) {
                char c = word.charAt(i);
                boolean ignore = false;
                for (int k = 0; k < this.ignoreChars.length(); ++k) {
                    if (c != this.ignoreChars.charAt(k)) continue;
                    ignore = true;
                    break;
                }
                if (ignore) continue;
                buffer.append(c);
            }
            for (int length = buffer.length(); length >= this.minWordLength; --length) {
                buffer.setLength(length);
                word = buffer.toString();
                if (!this.stopWords.contains(word)) {
                    result.add(word);
                }
                if (!this.indexRadix) continue block0;
            }
        }
        return result;
    }

    private final class FullTextIndexConfiguration
    extends OIndexAbstract.IndexConfiguration {
        public FullTextIndexConfiguration(ODocument document) {
            super(document);
        }

        public synchronized ODocument updateFullTextIndexConfiguration(String separatorChars, String ignoreChars, Set<String> stopWords, int minWordLength, boolean indexRadix) {
            this.document.field(OIndexFullText.CONFIG_SEPARATOR_CHARS, separatorChars);
            this.document.field(OIndexFullText.CONFIG_IGNORE_CHARS, ignoreChars);
            this.document.field(OIndexFullText.CONFIG_STOP_WORDS, stopWords);
            this.document.field(OIndexFullText.CONFIG_MIN_WORD_LEN, minWordLength);
            this.document.field(OIndexFullText.CONFIG_INDEX_RADIX, indexRadix);
            return this.document;
        }
    }

    private static class EntityRemover
    implements OIndexKeyUpdater<Object> {
        private final OIdentifiable value;
        private final OModifiableBoolean removed;

        public EntityRemover(OIdentifiable value, OModifiableBoolean removed) {
            this.value = value;
            this.removed = removed;
        }

        @Override
        public OIndexUpdateAction<Object> update(Object old, AtomicLong bonsayFileId) {
            Set recs = (Set)old;
            if (recs.remove(this.value)) {
                this.removed.setValue(true);
                if (recs.isEmpty()) {
                    return OIndexUpdateAction.remove();
                }
                return OIndexUpdateAction.changed(recs);
            }
            return OIndexUpdateAction.changed(recs);
        }
    }
}

