/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.delta;

import com.orientechnologies.common.collection.OMultiValue;
import com.orientechnologies.common.serialization.types.OByteSerializer;
import com.orientechnologies.common.serialization.types.ODecimalSerializer;
import com.orientechnologies.common.serialization.types.OIntegerSerializer;
import com.orientechnologies.common.serialization.types.OLongSerializer;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.db.record.ORecordElement;
import com.orientechnologies.orient.core.db.record.ORecordLazyList;
import com.orientechnologies.orient.core.db.record.ORecordLazySet;
import com.orientechnologies.orient.core.db.record.OTrackedList;
import com.orientechnologies.orient.core.db.record.OTrackedSet;
import com.orientechnologies.orient.core.db.record.ridbag.ORidBag;
import com.orientechnologies.orient.core.delta.ODeltaDocumentFieldType;
import com.orientechnologies.orient.core.delta.ODocumentDelta;
import com.orientechnologies.orient.core.delta.ODocumentDeltaSerializer;
import com.orientechnologies.orient.core.delta.ValueType;
import com.orientechnologies.orient.core.exception.OSerializationException;
import com.orientechnologies.orient.core.exception.OValidationException;
import com.orientechnologies.orient.core.metadata.schema.OClass;
import com.orientechnologies.orient.core.metadata.schema.OGlobalProperty;
import com.orientechnologies.orient.core.metadata.schema.OImmutableClass;
import com.orientechnologies.orient.core.metadata.schema.OProperty;
import com.orientechnologies.orient.core.metadata.schema.OType;
import com.orientechnologies.orient.core.metadata.schema.OTypeInterface;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.record.impl.ODocumentEntry;
import com.orientechnologies.orient.core.record.impl.ODocumentInternal;
import com.orientechnologies.orient.core.serialization.ODocumentSerializable;
import com.orientechnologies.orient.core.serialization.OSerializableStream;
import com.orientechnologies.orient.core.serialization.serializer.record.binary.BytesContainer;
import com.orientechnologies.orient.core.serialization.serializer.record.binary.HelperClasses;
import com.orientechnologies.orient.core.serialization.serializer.record.binary.OSerializableWrapper;
import com.orientechnologies.orient.core.serialization.serializer.record.binary.OVarIntSerializer;
import com.orientechnologies.orient.core.util.ODateHelper;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.AbstractCollection;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;

public class ODocumentDeltaSerializerV1
extends ODocumentDeltaSerializer {
    protected ODocumentDeltaSerializerV1() {
    }

    @Override
    public byte[] toStream(ODocumentDelta delta) {
        BytesContainer bytes = new BytesContainer();
        this.serialize(delta, bytes);
        return bytes.fitBytes();
    }

    private void serialize(ODocumentDelta deltaDoc, BytesContainer bytes) {
        for (Map.Entry<String, ValueType> entry : deltaDoc.fields.entrySet()) {
            OTypeInterface type;
            String fieldName = entry.getKey();
            ValueType fieldValueType = entry.getValue();
            Object fieldValue = fieldValueType.getValue();
            this.serializeValue(bytes, fieldName, OType.STRING);
            OTypeInterface oTypeInterface = type = fieldValue != null ? fieldValueType.getType() : null;
            if (type == null) {
                HelperClasses.writeByte(bytes, (byte)-1);
                continue;
            }
            if (type == OType.LINK && fieldValue instanceof ODocument) {
                type = OType.EMBEDDED;
            }
            HelperClasses.writeType(bytes, type);
            this.serializeValue(bytes, fieldValue, type);
        }
        this.serializeValue(bytes, -1, OType.INTEGER);
    }

    private void deserialize(ODocumentDelta delta, BytesContainer bytes) {
        boolean endReached = false;
        while (!endReached) {
            int fieldNameLength = OVarIntSerializer.readAsInteger(bytes);
            if (fieldNameLength > -1) {
                if (fieldNameLength <= 0) continue;
                String fieldName = HelperClasses.stringFromBytes(bytes.bytes, bytes.offset, fieldNameLength);
                bytes.offset += fieldNameLength;
                OTypeInterface type = HelperClasses.readDeltaDocumentType(bytes);
                if (type == null) {
                    delta.field(fieldName, new ValueType(null, null));
                    continue;
                }
                Object value = this.deserializeValue(bytes, type, null);
                delta.field(fieldName, new ValueType(value, type));
                continue;
            }
            endReached = true;
        }
    }

    private ODocumentDelta deserialize(BytesContainer bytes) {
        ODocumentDelta ret = new ODocumentDelta();
        this.deserialize(ret, bytes);
        return ret;
    }

    protected int writeEmptyString(BytesContainer bytes) {
        return OVarIntSerializer.write(bytes, 0L);
    }

    private int serializeEmbeddedCollection(BytesContainer bytes, Collection<?> value, OTypeInterface linkedType) {
        int pos = OVarIntSerializer.write(bytes, value.size());
        for (Object itemValue : value) {
            OTypeInterface type;
            if (itemValue == null) {
                HelperClasses.writeType(bytes, OType.ANY);
                continue;
            }
            if (linkedType == null || linkedType == OType.ANY) {
                type = HelperClasses.getDeltaTypeFromValueEmbedded(itemValue);
                if (type == OType.LINK && itemValue instanceof ODocument) {
                    type = OType.EMBEDDED;
                }
            } else {
                type = linkedType;
            }
            if (type != null) {
                HelperClasses.writeType(bytes, type);
                this.serializeValue(bytes, itemValue, type);
                continue;
            }
            throw new OSerializationException("Impossible serialize value of type " + value.getClass() + " with the ODocument binary serializer");
        }
        return pos;
    }

    private Collection<?> deserializeEmbeddedCollection(BytesContainer bytes, ODocument ownerDocument, boolean isList) {
        AbstractCollection found = isList ? this.deserializeEmbeddedList(bytes, ownerDocument) : this.deserializeEmbeddedSet(bytes, ownerDocument);
        return found;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected OTrackedSet deserializeEmbeddedSet(BytesContainer bytes, ODocument ownerDocument) {
        int items = OVarIntSerializer.readAsInteger(bytes);
        OTrackedSet found = new OTrackedSet(ownerDocument);
        found.setInternalStatus(ORecordElement.STATUS.UNMARSHALLING);
        try {
            for (int i = 0; i < items; ++i) {
                OTypeInterface itemType = HelperClasses.readDeltaDocumentType(bytes);
                if (itemType == OType.ANY) {
                    found.add((Object)null);
                    continue;
                }
                found.add(this.deserializeValue(bytes, itemType, ownerDocument));
            }
            OTrackedSet oTrackedSet = found;
            return oTrackedSet;
        }
        finally {
            found.setInternalStatus(ORecordElement.STATUS.LOADED);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private OTrackedList deserializeEmbeddedList(BytesContainer bytes, ODocument ownerDocument) {
        int items = OVarIntSerializer.readAsInteger(bytes);
        OTrackedList found = new OTrackedList(ownerDocument);
        found.setInternalStatus(ORecordElement.STATUS.UNMARSHALLING);
        try {
            for (int i = 0; i < items; ++i) {
                OTypeInterface itemType = HelperClasses.readDeltaDocumentType(bytes);
                if (itemType == OType.ANY) {
                    found.add((Object)null);
                    continue;
                }
                found.add(this.deserializeValue(bytes, itemType, ownerDocument));
            }
            OTrackedList oTrackedList = found;
            return oTrackedList;
        }
        finally {
            found.setInternalStatus(ORecordElement.STATUS.LOADED);
        }
    }

    private void serializeValue(BytesContainer bytes, Object value, OTypeInterface type) {
        if (type == OType.INTEGER || type == OType.LONG || type == OType.SHORT) {
            OVarIntSerializer.write(bytes, ((Number)value).longValue());
        } else if (type == OType.STRING) {
            HelperClasses.writeString(bytes, value.toString());
        } else if (type == OType.DOUBLE) {
            long dg = Double.doubleToLongBits(((Number)value).doubleValue());
            int pointer = bytes.alloc(8);
            OLongSerializer.INSTANCE.serializeLiteral(dg, bytes.bytes, pointer);
        } else if (type == OType.FLOAT) {
            int fg = Float.floatToIntBits(((Number)value).floatValue());
            int pointer = bytes.alloc(4);
            OIntegerSerializer.INSTANCE.serializeLiteral(fg, bytes.bytes, pointer);
        } else if (type == OType.BYTE) {
            HelperClasses.writeByte(bytes, ((Number)value).byteValue());
        } else if (type == OType.BOOLEAN) {
            byte val = (Boolean)value != false ? (byte)1 : 0;
            HelperClasses.writeByte(bytes, val);
        } else if (type == OType.DATETIME) {
            if (value instanceof Number) {
                OVarIntSerializer.write(bytes, ((Number)value).longValue());
            } else {
                OVarIntSerializer.write(bytes, ((Date)value).getTime());
            }
        } else if (type == OType.DATE) {
            long dateValue = value instanceof Number ? ((Number)value).longValue() : ((Date)value).getTime();
            dateValue = HelperClasses.convertDayToTimezone(ODateHelper.getDatabaseTimeZone(), TimeZone.getTimeZone("GMT"), dateValue);
            OVarIntSerializer.write(bytes, dateValue / 86400000L);
        } else if (type == OType.EMBEDDED) {
            if (value instanceof ODocumentSerializable) {
                ODocument cur = ((ODocumentSerializable)value).toDocument();
                cur.field("__orientdb_serilized_class__ ", value.getClass().getName());
                this.serializeDoc(cur, bytes);
            } else {
                this.serializeDoc((ODocument)value, bytes);
            }
        } else if (type == OType.EMBEDDEDSET || type == OType.EMBEDDEDLIST) {
            if (value.getClass().isArray()) {
                this.serializeEmbeddedCollection(bytes, Arrays.asList(OMultiValue.array(value)), null);
            } else {
                this.serializeEmbeddedCollection(bytes, (Collection)value, null);
            }
        } else if (type == OType.DECIMAL) {
            BigDecimal decimalValue = (BigDecimal)value;
            int pointer = bytes.alloc(ODecimalSerializer.INSTANCE.getObjectSize(decimalValue, new Object[0]));
            ODecimalSerializer.INSTANCE.serialize(decimalValue, bytes.bytes, pointer, new Object[0]);
        } else if (type == OType.BINARY) {
            HelperClasses.writeBinary(bytes, (byte[])value);
        } else if (type == OType.LINKSET || type == OType.LINKLIST) {
            Collection ridCollection = (Collection)value;
            HelperClasses.writeLinkCollection(bytes, ridCollection);
        } else if (type == OType.LINK) {
            if (!(value instanceof OIdentifiable)) {
                throw new OValidationException("Value '" + value + "' is not a OIdentifiable");
            }
            HelperClasses.writeOptimizedLink(bytes, (OIdentifiable)value);
        } else if (type == OType.LINKMAP) {
            HelperClasses.writeLinkMap(bytes, (Map)value);
        } else if (type == OType.EMBEDDEDMAP) {
            this.writeEmbeddedMap(bytes, (Map)value);
        } else if (type == OType.LINKBAG) {
            HelperClasses.writeRidBag(bytes, (ORidBag)value);
        } else if (type == OType.CUSTOM) {
            if (!(value instanceof OSerializableStream)) {
                value = new OSerializableWrapper((Serializable)value);
            }
            HelperClasses.writeString(bytes, value.getClass().getName());
            HelperClasses.writeBinary(bytes, ((OSerializableStream)value).toStream());
        } else if (type == ODeltaDocumentFieldType.DELTA_RECORD) {
            ODocumentDelta deltaVal = (ODocumentDelta)value;
            this.serialize(deltaVal, bytes);
        }
    }

    protected OClass serializeClassName(ODocument document, BytesContainer bytes) {
        OImmutableClass clazz = ODocumentInternal.getImmutableSchemaClass(document);
        if (clazz != null) {
            HelperClasses.writeString(bytes, clazz.getName());
        } else {
            this.writeEmptyString(bytes);
        }
        return clazz;
    }

    private String deserializeClassName(BytesContainer bytes) {
        String className = HelperClasses.readString(bytes);
        return className;
    }

    private void serializeDoc(ODocument document, BytesContainer bytes) {
        OClass clazz = this.serializeClassName(document, bytes);
        Map<String, OProperty> props = clazz != null ? clazz.propertiesMap() : null;
        Set<Map.Entry<String, ODocumentEntry>> fields = ODocumentInternal.rawEntries(document);
        for (Map.Entry<String, ODocumentEntry> entry : fields) {
            OProperty prop;
            ODocumentEntry docEntry = entry.getValue();
            if (!docEntry.exist()) continue;
            if (docEntry.property == null && props != null && (prop = props.get(entry.getKey())) != null && docEntry.type == prop.getType()) {
                docEntry.property = prop;
            }
            OTypeInterface valueType = this.getDocumentFieldType(docEntry);
            if (docEntry.property != null) {
                this.serializeValue(bytes, (docEntry.property.getId() + 1) * -1, OType.INTEGER);
                if (valueType == OType.ANY) {
                    HelperClasses.writeType(bytes, valueType);
                }
            } else {
                if (valueType == OType.LINK && docEntry.value instanceof ODocument) {
                    valueType = OType.EMBEDDED;
                }
                this.serializeValue(bytes, entry.getKey(), OType.STRING);
                HelperClasses.writeType(bytes, valueType);
            }
            this.serializeValue(bytes, docEntry.value, valueType);
        }
        this.serializeValue(bytes, 0, OType.INTEGER);
    }

    private ODocument deserializeDoc(BytesContainer bytes, ODocument owner) {
        String className = this.deserializeClassName(bytes);
        ODocument ret = className == null || className.equals("") ? new ODocument() : new ODocument(className);
        boolean endSignal = false;
        while (!endSignal) {
            OTypeInterface fieldType;
            String fieldName;
            int len = (Integer)this.deserializeValue(bytes, OType.INTEGER, null);
            if (len == 0) {
                endSignal = true;
                continue;
            }
            if (len < 0) {
                OGlobalProperty prop = HelperClasses.getGlobalProperty(ret, len);
                fieldName = prop.getName();
                fieldType = prop.getType();
                if (fieldType == OType.ANY) {
                    fieldType = HelperClasses.readDeltaDocumentType(bytes);
                }
            } else {
                fieldName = HelperClasses.stringFromBytes(bytes.bytes, bytes.offset, len);
                bytes.offset += len;
                fieldType = HelperClasses.readDeltaDocumentType(bytes);
            }
            Object fieldValue = this.deserializeValue(bytes, fieldType, ret);
            ret.field(fieldName, fieldValue);
        }
        if (!ret.containsField("__orientdb_serilized_class__ ")) {
            ODocumentInternal.addOwner(ret, owner);
        }
        return ret;
    }

    protected OTypeInterface getDocumentFieldType(ODocumentEntry entry) {
        OProperty prop;
        OTypeInterface type = entry.type;
        if (type == null && (prop = entry.property) != null) {
            type = prop.getType();
        }
        if (type == null || OType.ANY == type) {
            type = ODeltaDocumentFieldType.getTypeByValue(entry.value);
        }
        return type;
    }

    protected <T> T deserializeValue(BytesContainer bytes, OTypeInterface type, ODocument ownerDocument) {
        Object value = null;
        if (type == OType.INTEGER) {
            value = OVarIntSerializer.readAsInteger(bytes);
        } else if (type == OType.LONG) {
            value = OVarIntSerializer.readAsLong(bytes);
        } else if (type == OType.SHORT) {
            value = OVarIntSerializer.readAsShort(bytes);
        } else if (type == OType.STRING) {
            value = HelperClasses.readString(bytes);
        } else if (type == OType.DOUBLE) {
            value = Double.longBitsToDouble(HelperClasses.readLong(bytes));
        } else if (type == OType.FLOAT) {
            value = Float.valueOf(Float.intBitsToFloat(HelperClasses.readInteger(bytes)));
        } else if (type == OType.BYTE) {
            value = HelperClasses.readByte(bytes);
        } else if (type == OType.BOOLEAN) {
            value = HelperClasses.readByte(bytes) == 1;
        } else if (type == OType.DATETIME) {
            value = new Date(OVarIntSerializer.readAsLong(bytes));
        } else if (type == OType.DATE) {
            long savedTime = OVarIntSerializer.readAsLong(bytes) * 86400000L;
            savedTime = HelperClasses.convertDayToTimezone(TimeZone.getTimeZone("GMT"), ODateHelper.getDatabaseTimeZone(), savedTime);
            value = new Date(savedTime);
        } else if (type == OType.EMBEDDED) {
            value = this.deserializeDoc(bytes, ownerDocument);
        } else if (type == OType.EMBEDDEDSET) {
            value = this.deserializeEmbeddedCollection(bytes, ownerDocument, false);
        } else if (type == OType.EMBEDDEDLIST) {
            value = this.deserializeEmbeddedCollection(bytes, ownerDocument, true);
        } else if (type == OType.LINKSET) {
            ORecordLazySet collectionSet = null;
            collectionSet = new ORecordLazySet(ownerDocument);
            value = HelperClasses.readLinkCollection(bytes, collectionSet, false);
        } else if (type == OType.LINKLIST) {
            ORecordLazyList collectionList = null;
            collectionList = new ORecordLazyList(ownerDocument);
            value = HelperClasses.readLinkCollection(bytes, collectionList, false);
        } else if (type == OType.BINARY) {
            value = HelperClasses.readBinary(bytes);
        } else if (type == OType.LINK) {
            value = HelperClasses.readOptimizedLink(bytes, false);
        } else if (type == OType.LINKMAP) {
            value = HelperClasses.readLinkMap(bytes, ownerDocument, false);
        } else if (type == OType.EMBEDDEDMAP) {
            value = this.readEmbeddedMap(bytes, ownerDocument);
        } else if (type == OType.DECIMAL) {
            value = ODecimalSerializer.INSTANCE.deserialize(bytes.bytes, bytes.offset);
            bytes.skip(ODecimalSerializer.INSTANCE.getObjectSize(bytes.bytes, bytes.offset));
        } else if (type == OType.LINKBAG) {
            ORidBag bag = HelperClasses.readRidbag(bytes);
            bag.setOwner(ownerDocument);
            value = bag;
        } else if (type == ODeltaDocumentFieldType.DELTA_RECORD) {
            ODocumentDelta delta = this.deserialize(bytes);
            value = delta;
        } else if (type == OType.CUSTOM) {
            try {
                String className = HelperClasses.readString(bytes);
                Class<?> clazz = Class.forName(className);
                OSerializableStream stream = (OSerializableStream)clazz.newInstance();
                byte[] bytesRepresentation = HelperClasses.readBinary(bytes);
                stream.fromStream(bytesRepresentation);
                value = stream instanceof OSerializableWrapper ? ((OSerializableWrapper)stream).getSerializable() : stream;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return (T)value;
    }

    @Override
    public void fromStream(ODocumentDelta delta, BytesContainer bytes) {
        this.deserialize(delta, bytes);
    }

    @Override
    public ODocumentDelta fromStream(BytesContainer bytes) {
        return this.deserialize(bytes);
    }

    private int writeEmbeddedMap(BytesContainer bytes, Map<Object, Object> map) {
        int fullPos = OVarIntSerializer.write(bytes, map.size());
        for (Map.Entry<Object, Object> entry : map.entrySet()) {
            OTypeInterface type = OType.STRING;
            HelperClasses.writeType(bytes, type);
            HelperClasses.writeString(bytes, entry.getKey().toString());
            Object value = entry.getValue();
            if (value != null) {
                type = HelperClasses.getDeltaTypeFromValueEmbedded(value);
                if (type == OType.LINK && value instanceof ODocument) {
                    type = OType.EMBEDDED;
                }
                if (type == null) {
                    throw new OSerializationException("Impossible serialize value of type " + value.getClass() + " with the ODocument binary serializer");
                }
                HelperClasses.writeType(bytes, type);
                this.serializeValue(bytes, value, type);
                continue;
            }
            OByteSerializer.INSTANCE.serialize((byte)-1, bytes.bytes, bytes.alloc(1), new Object[0]);
        }
        return fullPos;
    }

    protected Map readEmbeddedMap(BytesContainer bytes, ODocument document) {
        int size = OVarIntSerializer.readAsInteger(bytes);
        HashMap result = new HashMap();
        for (int i = 0; i < size; ++i) {
            OTypeInterface keyType = HelperClasses.readDeltaDocumentType(bytes);
            Object key = this.deserializeValue(bytes, keyType, document);
            byte typeId = HelperClasses.readByte(bytes);
            if (typeId != -1) {
                OTypeInterface type = ODeltaDocumentFieldType.getFromId(typeId);
                Object value = this.deserializeValue(bytes, type, document);
                result.put(key, value);
                continue;
            }
            result.put(key, null);
        }
        return result;
    }
}

