/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.delta;

import com.orientechnologies.common.collection.OMultiValue;
import com.orientechnologies.orient.core.db.ODatabaseDocumentInternal;
import com.orientechnologies.orient.core.db.ODatabaseRecordThreadLocal;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.delta.ODeltaDocumentFieldType;
import com.orientechnologies.orient.core.delta.ODocumentDeltaSerializer;
import com.orientechnologies.orient.core.delta.ODocumentDeltaSerializerI;
import com.orientechnologies.orient.core.delta.ValueType;
import com.orientechnologies.orient.core.id.ORID;
import com.orientechnologies.orient.core.metadata.schema.OType;
import com.orientechnologies.orient.core.metadata.schema.OTypeInterface;
import com.orientechnologies.orient.core.record.ORecord;
import com.orientechnologies.orient.core.record.ORecordAbstract;
import com.orientechnologies.orient.core.record.ORecordInternal;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.serialization.ODocumentSerializable;
import com.orientechnologies.orient.core.serialization.OSerializableStream;
import com.orientechnologies.orient.core.serialization.serializer.record.binary.BytesContainer;
import com.orientechnologies.orient.core.serialization.serializer.record.binary.OSerializableWrapper;
import com.orientechnologies.orient.core.storage.OStorage;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public class ODocumentDelta
implements OIdentifiable {
    protected Map<String, ValueType> fields = new HashMap<String, ValueType>();
    private final ODocumentDeltaSerializerI serializer = ODocumentDeltaSerializer.getActiveSerializer();

    public ValueType field(String name) {
        return this.fields.get(name);
    }

    public void field(String name, ValueType value) {
        this.fields.put(name, value);
    }

    @Override
    public ORID getIdentity() {
        return (ORID)this.field("i").getValue();
    }

    public void setIdentity(ORID identity) {
        ValueType vt = new ValueType(identity, OType.LINK);
        this.field("i", vt);
    }

    public byte[] serialize() {
        return this.serializer.toStream(this);
    }

    public void setVersion(int version) {
        ValueType vt = new ValueType(version, OType.INTEGER);
        this.field("r", vt);
    }

    private Integer getVersion() {
        return (Integer)this.field("r").getValue();
    }

    public void deserialize(BytesContainer bytes) {
        this.serializer.fromStream(this, bytes);
    }

    public boolean isLeaf() {
        return this.fields.isEmpty();
    }

    public Set<Map.Entry<String, ValueType>> fields() {
        return this.fields.entrySet();
    }

    private static boolean equalDocsInThisContext(ODocument doc1, ODocument doc2) {
        String[] fieldNames;
        for (String fieldName : fieldNames = doc1.fieldNames()) {
            Object otherFieldVal;
            if (!doc2.containsField(fieldName)) {
                return false;
            }
            Object fieldVal = doc1.field(fieldName);
            if (ODocumentDelta.equalVals(fieldVal, otherFieldVal = doc2.field(fieldName))) continue;
            return false;
        }
        return true;
    }

    private static boolean equalEmbeddedCollections(Collection<Object> col1, Collection<Object> col2) {
        if (col1.size() != col2.size()) {
            return false;
        }
        if (col1 instanceof List) {
            List l1 = (List)col1;
            List l2 = (List)col2;
            for (int i = 0; i < l1.size(); ++i) {
                Object o2;
                Object o1 = l1.get(i);
                if (ODocumentDelta.equalVals(o1, o2 = l2.get(i))) continue;
                return false;
            }
        } else {
            Set s1 = (Set)col1;
            HashSet<Object> s2 = new HashSet<Object>(col2);
            for (Object o1 : s1) {
                boolean foundInOther = false;
                Iterator iter2 = s2.iterator();
                while (iter2.hasNext()) {
                    Object o2 = iter2.next();
                    if (!ODocumentDelta.equalVals(o1, o2)) continue;
                    foundInOther = true;
                    iter2.remove();
                }
                if (foundInOther) continue;
                return false;
            }
        }
        return true;
    }

    private static boolean equalEmbeddedMaps(Map<String, Object> m1, Map<String, Object> m2) {
        if (m1.size() != m2.size()) {
            return false;
        }
        for (Map.Entry<String, Object> entry : m1.entrySet()) {
            Object otherFieldVal;
            String fieldName = entry.getKey();
            if (!m2.containsKey(fieldName)) {
                return false;
            }
            Object fieldVal = entry.getValue();
            if (ODocumentDelta.equalVals(fieldVal, otherFieldVal = m2.get(fieldName))) continue;
            return false;
        }
        return true;
    }

    private static boolean equalVals(Object val1, Object val2) {
        byte[] v2;
        byte[] v1;
        Map m2;
        Map m1;
        List<Object> col2;
        List<Object> col1;
        ODocument otherFieldDoc;
        ODocument fieldDoc;
        OTypeInterface otherFieldType;
        if (val1 == val2) {
            return true;
        }
        if (val1 == null && val2 != null || val1 != null && val2 == null) {
            return false;
        }
        if (val1 == null && val2 == null) {
            return true;
        }
        OTypeInterface fieldType = ODeltaDocumentFieldType.getFromClass(val1.getClass());
        if (fieldType == OType.LINK && val1 instanceof ODocument) {
            fieldType = OType.EMBEDDED;
        }
        if ((otherFieldType = ODeltaDocumentFieldType.getFromClass(val2.getClass())) == OType.LINK && val2 instanceof ODocument) {
            otherFieldType = OType.EMBEDDED;
        }
        if (fieldType != otherFieldType) {
            return false;
        }
        return !(fieldType == OType.INTEGER || fieldType == OType.LONG || fieldType == OType.SHORT || fieldType == OType.STRING || fieldType == OType.DOUBLE || fieldType == OType.FLOAT || fieldType == OType.BYTE || fieldType == OType.BOOLEAN || fieldType == OType.DATETIME || fieldType == OType.DATE || fieldType == OType.LINKBAG || fieldType == OType.BINARY || fieldType == OType.DECIMAL || fieldType == OType.LINKSET || fieldType == OType.LINKLIST || fieldType == ODeltaDocumentFieldType.DELTA_RECORD || fieldType == OType.LINK || fieldType == OType.LINKMAP || fieldType == OType.TRANSIENT || fieldType == OType.ANY ? !Objects.equals(val1, val2) : (fieldType == OType.EMBEDDED ? !ODocumentDelta.equalDocsInThisContext(fieldDoc = val1 instanceof ODocumentSerializable ? ((ODocumentSerializable)val1).toDocument() : (ODocument)val1, otherFieldDoc = val2 instanceof ODocumentSerializable ? ((ODocumentSerializable)val2).toDocument() : (ODocument)val2) : (fieldType == OType.EMBEDDEDSET || fieldType == OType.EMBEDDEDLIST ? !ODocumentDelta.equalEmbeddedCollections(col1 = val1.getClass().isArray() ? Arrays.asList(OMultiValue.array(val1)) : (List<Object>)val1, col2 = val2.getClass().isArray() ? Arrays.asList(OMultiValue.array(val2)) : (List<Object>)val2) : (fieldType == OType.EMBEDDEDMAP ? !ODocumentDelta.equalEmbeddedMaps(m1 = (Map)val1, m2 = (Map)val2) : fieldType == OType.CUSTOM && !Objects.equals(v1 = !(val1 instanceof OSerializableStream) ? new OSerializableWrapper((Serializable)val1).toStream() : ((OSerializableStream)val1).toStream(), v2 = !(val2 instanceof OSerializableStream) ? new OSerializableWrapper((Serializable)val2).toStream() : ((OSerializableStream)val2).toStream())))));
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ODocumentDelta other = (ODocumentDelta)obj;
        if (this.fields.size() != other.fields.size()) {
            return false;
        }
        for (Map.Entry<String, ValueType> field : this.fields.entrySet()) {
            Object otherFieldVal;
            String fieldName = field.getKey();
            if (!other.fields.containsKey(fieldName)) {
                return false;
            }
            Object fieldVal = field.getValue().getValue();
            if (ODocumentDelta.equalVals(fieldVal, otherFieldVal = other.fields.get(fieldName).getValue())) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int hash = 7;
        hash = 67 * hash + Objects.hashCode(this.fields);
        return hash;
    }

    @Override
    public int compareTo(OIdentifiable iOther) {
        int otherClusterId;
        if (iOther == this) {
            return 0;
        }
        if (iOther == null) {
            return 1;
        }
        int clusterId = this.getIdentity().getClusterId();
        if (clusterId == (otherClusterId = iOther.getIdentity().getClusterId())) {
            long otherClusterPos;
            long clusterPosition = this.getIdentity().getClusterPosition();
            return clusterPosition < (otherClusterPos = iOther.getIdentity().getClusterPosition()) ? -1 : (clusterPosition == otherClusterPos ? 0 : 1);
        }
        if (clusterId > otherClusterId) {
            return 1;
        }
        return -1;
    }

    @Override
    public int compare(OIdentifiable o1, OIdentifiable o2) {
        return o1.compareTo(o2);
    }

    @Override
    public <T extends ORecord> T getRecord() {
        ODatabaseDocumentInternal database = ODatabaseRecordThreadLocal.instance().get();
        Object rec = database.getRecord(this.getIdentity());
        if (rec instanceof ORecordAbstract) {
            rec = rec.copy();
            ORecordInternal.setVersion(rec, this.getVersion());
        }
        return (T)rec;
    }

    @Override
    public void lock(boolean iExclusive) {
    }

    @Override
    public boolean isLocked() {
        return false;
    }

    @Override
    public OStorage.LOCKING_STRATEGY lockingStrategy() {
        return OStorage.LOCKING_STRATEGY.NONE;
    }

    @Override
    public void unlock() {
    }
}

