/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.db;

import com.orientechnologies.common.exception.OException;
import com.orientechnologies.common.io.OIOUtils;
import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.orient.core.Orient;
import com.orientechnologies.orient.core.command.OCommandOutputListener;
import com.orientechnologies.orient.core.db.ODatabaseDocumentEmbeddedPooled;
import com.orientechnologies.orient.core.db.ODatabaseDocumentInternal;
import com.orientechnologies.orient.core.db.ODatabaseLifecycleListener;
import com.orientechnologies.orient.core.db.ODatabasePoolImpl;
import com.orientechnologies.orient.core.db.ODatabasePoolInternal;
import com.orientechnologies.orient.core.db.ODatabaseRecordThreadLocal;
import com.orientechnologies.orient.core.db.ODatabaseTask;
import com.orientechnologies.orient.core.db.ODatabaseType;
import com.orientechnologies.orient.core.db.OSharedContext;
import com.orientechnologies.orient.core.db.OSharedContextEmbedded;
import com.orientechnologies.orient.core.db.OrientDBConfig;
import com.orientechnologies.orient.core.db.OrientDBInternal;
import com.orientechnologies.orient.core.db.document.ODatabaseDocumentEmbedded;
import com.orientechnologies.orient.core.engine.OEngine;
import com.orientechnologies.orient.core.engine.OMemoryAndLocalPaginatedEnginesInitializer;
import com.orientechnologies.orient.core.exception.ODatabaseException;
import com.orientechnologies.orient.core.serialization.serializer.record.ORecordSerializer;
import com.orientechnologies.orient.core.serialization.serializer.record.ORecordSerializerFactory;
import com.orientechnologies.orient.core.storage.OStorage;
import com.orientechnologies.orient.core.storage.impl.local.OAbstractPaginatedStorage;
import com.orientechnologies.orient.core.storage.impl.local.paginated.OLocalPaginatedStorage;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;

public class OrientDBEmbedded
implements OrientDBInternal {
    protected final Map<String, OAbstractPaginatedStorage> storages = new HashMap<String, OAbstractPaginatedStorage>();
    protected final Map<String, OSharedContext> sharedContexts = new HashMap<String, OSharedContext>();
    protected final Set<ODatabasePoolInternal> pools = new HashSet<ODatabasePoolInternal>();
    protected final OrientDBConfig configurations;
    protected final String basePath;
    protected final OEngine memory;
    protected final OEngine disk;
    protected final Orient orient;
    private volatile boolean open = true;
    private ExecutorService executor;
    private Timer timer;

    public OrientDBEmbedded(String directoryPath, OrientDBConfig configurations, Orient orient) {
        this.orient = orient;
        orient.onEmbeddedFactoryInit(this);
        this.memory = orient.getEngine("memory");
        this.disk = orient.getEngine("plocal");
        directoryPath = directoryPath.trim();
        this.basePath = directoryPath.length() != 0 ? new File(directoryPath).getAbsolutePath() : null;
        this.configurations = configurations != null ? configurations : OrientDBConfig.defaultConfig();
        OMemoryAndLocalPaginatedEnginesInitializer.INSTANCE.initialize();
        orient.addOrientDB(this);
        this.executor = new ThreadPoolExecutor(1, Runtime.getRuntime().availableProcessors(), 30L, TimeUnit.MINUTES, new LinkedBlockingQueue<Runnable>());
        this.timer = new Timer();
    }

    @Override
    public ODatabaseDocumentInternal open(String name, String user, String password) {
        return this.open(name, user, password, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ODatabaseDocumentEmbedded openNoAuthenticate(String name, String user) {
        try {
            ODatabaseDocumentEmbedded embedded;
            OrientDBConfig config = this.solveConfig(null);
            OrientDBEmbedded orientDBEmbedded = this;
            synchronized (orientDBEmbedded) {
                this.checkOpen();
                OAbstractPaginatedStorage storage = this.getOrInitStorage(name);
                storage.open(config.getConfigurations());
                embedded = this.newSessionInstance(storage);
                embedded.init(config, this.getOrCreateSharedContext(storage));
            }
            embedded.rebuildIndexes();
            embedded.internalOpen(user, "nopwd", false);
            embedded.callOnOpenListeners();
            return embedded;
        }
        catch (Exception e) {
            throw OException.wrapException(new ODatabaseException("Cannot open database '" + name + "'"), e);
        }
    }

    protected ODatabaseDocumentEmbedded newSessionInstance(OAbstractPaginatedStorage storage) {
        return new ODatabaseDocumentEmbedded(storage);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ODatabaseDocumentEmbedded openNoAuthorization(String name) {
        try {
            ODatabaseDocumentEmbedded embedded;
            OrientDBConfig config = this.solveConfig(null);
            OrientDBEmbedded orientDBEmbedded = this;
            synchronized (orientDBEmbedded) {
                this.checkOpen();
                OAbstractPaginatedStorage storage = this.getOrInitStorage(name);
                storage.open(config.getConfigurations());
                embedded = this.newSessionInstance(storage);
                embedded.init(config, this.getOrCreateSharedContext(storage));
            }
            embedded.rebuildIndexes();
            embedded.callOnOpenListeners();
            return embedded;
        }
        catch (Exception e) {
            throw OException.wrapException(new ODatabaseException("Cannot open database '" + name + "'"), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ODatabaseDocumentInternal open(String name, String user, String password, OrientDBConfig config) {
        try {
            ODatabaseDocumentEmbedded embedded;
            OrientDBEmbedded orientDBEmbedded = this;
            synchronized (orientDBEmbedded) {
                this.checkOpen();
                config = this.solveConfig(config);
                OAbstractPaginatedStorage storage = this.getOrInitStorage(name);
                storage.open(config.getConfigurations());
                embedded = this.newSessionInstance(storage);
                embedded.init(config, this.getOrCreateSharedContext(storage));
            }
            embedded.rebuildIndexes();
            embedded.internalOpen(user, password);
            embedded.callOnOpenListeners();
            return embedded;
        }
        catch (Exception e) {
            throw OException.wrapException(new ODatabaseException("Cannot open database '" + name + "'"), e);
        }
    }

    protected OrientDBConfig solveConfig(OrientDBConfig config) {
        if (config != null) {
            config.setParent(this.configurations);
            return config;
        }
        OrientDBConfig cfg = OrientDBConfig.defaultConfig();
        cfg.setParent(this.configurations);
        return cfg;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ODatabaseDocumentInternal poolOpen(String name, String user, String password, ODatabasePoolInternal pool) {
        ODatabaseDocumentEmbedded embedded;
        OrientDBEmbedded orientDBEmbedded = this;
        synchronized (orientDBEmbedded) {
            this.checkOpen();
            OAbstractPaginatedStorage storage = this.getOrInitStorage(name);
            storage.open(pool.getConfig().getConfigurations());
            embedded = this.newPooledSessionInstance(pool, storage);
            embedded.init(pool.getConfig(), this.getOrCreateSharedContext(storage));
        }
        embedded.rebuildIndexes();
        embedded.internalOpen(user, password);
        embedded.callOnOpenListeners();
        return embedded;
    }

    protected ODatabaseDocumentEmbedded newPooledSessionInstance(ODatabasePoolInternal pool, OAbstractPaginatedStorage storage) {
        return new ODatabaseDocumentEmbeddedPooled(pool, storage);
    }

    protected OAbstractPaginatedStorage getOrInitStorage(String name) {
        OAbstractPaginatedStorage storage = this.storages.get(name);
        if (storage == null && (storage = (OAbstractPaginatedStorage)this.disk.createStorage(this.buildName(name), new HashMap<String, String>())).exists()) {
            this.storages.put(name, storage);
        }
        return storage;
    }

    public synchronized OAbstractPaginatedStorage getStorage(String name) {
        return this.storages.get(name);
    }

    protected String buildName(String name) {
        if (this.basePath == null) {
            throw new ODatabaseException("OrientDB instanced created without physical path, only memory databases are allowed");
        }
        return this.basePath + "/" + name;
    }

    @Override
    public void create(String name, String user, String password, ODatabaseType type) {
        this.create(name, user, password, type, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void create(String name, String user, String password, ODatabaseType type, OrientDBConfig config) {
        ODatabaseDocumentEmbedded embedded;
        OrientDBEmbedded orientDBEmbedded = this;
        synchronized (orientDBEmbedded) {
            if (!this.exists(name, user, password)) {
                try {
                    config = this.solveConfig(config);
                    OAbstractPaginatedStorage storage = type == ODatabaseType.MEMORY ? (OAbstractPaginatedStorage)this.memory.createStorage(name, new HashMap<String, String>()) : (OAbstractPaginatedStorage)this.disk.createStorage(this.buildName(name), new HashMap<String, String>());
                    this.storages.put(name, storage);
                    embedded = this.internalCreate(config, storage);
                }
                catch (Exception e) {
                    throw OException.wrapException(new ODatabaseException("Cannot create database '" + name + "'"), e);
                }
            } else {
                throw new ODatabaseException("Cannot create new database '" + name + "' because it already exists");
            }
        }
        embedded.callOnCreateListeners();
        ODatabaseRecordThreadLocal.instance().remove();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void restore(String name, String user, String password, ODatabaseType type, String path, OrientDBConfig config) {
        ODatabaseDocumentEmbedded embedded;
        OAbstractPaginatedStorage storage;
        OrientDBEmbedded orientDBEmbedded = this;
        synchronized (orientDBEmbedded) {
            if (!this.exists(name, null, null)) {
                try {
                    storage = (OAbstractPaginatedStorage)this.disk.createStorage(this.buildName(name), new HashMap<String, String>());
                    embedded = this.internalCreate(config, storage);
                    this.storages.put(name, storage);
                }
                catch (Exception e) {
                    throw OException.wrapException(new ODatabaseException("Cannot restore database '" + name + "'"), e);
                }
            } else {
                throw new ODatabaseException("Cannot create new storage '" + name + "' because it already exists");
            }
        }
        storage.restoreFromIncrementalBackup(path);
        embedded.callOnCreateListeners();
        ODatabaseRecordThreadLocal.instance().remove();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void restore(String name, InputStream in, Map<String, Object> options, Callable<Object> callable, OCommandOutputListener iListener) {
        try {
            OAbstractPaginatedStorage storage;
            OrientDBEmbedded orientDBEmbedded = this;
            synchronized (orientDBEmbedded) {
                OSharedContext context = this.sharedContexts.remove(name);
                if (context != null) {
                    context.close();
                }
                storage = this.getOrInitStorage(name);
                this.storages.put(name, storage);
            }
            storage.restore(in, options, callable, iListener);
        }
        catch (Exception e) {
            throw OException.wrapException(new ODatabaseException("Cannot create database '" + name + "'"), e);
        }
    }

    protected ODatabaseDocumentEmbedded internalCreate(OrientDBConfig config, OAbstractPaginatedStorage storage) {
        try {
            storage.create(config.getConfigurations());
        }
        catch (IOException e) {
            throw OException.wrapException(new ODatabaseException("Error on database creation"), e);
        }
        ORecordSerializer serializer = ORecordSerializerFactory.instance().getDefaultRecordSerializer();
        if (serializer.toString().equals("ORecordDocument2csv")) {
            throw new ODatabaseException("Impossible to create the database with ORecordDocument2csv serializer");
        }
        storage.setRecordSerializer(serializer.toString(), serializer.getCurrentVersion());
        storage.setProperty("strictSql", "true");
        ODatabaseDocumentEmbedded embedded = this.newSessionInstance(storage);
        embedded.setSerializer(serializer);
        embedded.internalCreate(config, this.getOrCreateSharedContext(storage));
        return embedded;
    }

    protected synchronized OSharedContext getOrCreateSharedContext(OAbstractPaginatedStorage storage) {
        OSharedContext result = this.sharedContexts.get(storage.getName());
        if (result == null) {
            result = this.createSharedContext(storage);
            this.sharedContexts.put(storage.getName(), result);
        }
        return result;
    }

    protected OSharedContext createSharedContext(OAbstractPaginatedStorage storage) {
        return new OSharedContextEmbedded(storage, this);
    }

    @Override
    public synchronized boolean exists(String name, String user, String password) {
        this.checkOpen();
        OStorage storage = this.storages.get(name);
        if (storage == null) {
            if (this.basePath != null) {
                return OLocalPaginatedStorage.exists(Paths.get(this.buildName(name), new String[0]));
            }
            return false;
        }
        return storage.exists();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void drop(String name, String user, String password) {
        OrientDBEmbedded orientDBEmbedded = this;
        synchronized (orientDBEmbedded) {
            this.checkOpen();
        }
        ODatabaseDocumentEmbedded db = this.openNoAuthenticate(name, user);
        Iterator<ODatabaseLifecycleListener> it = this.orient.getDbLifecycleListeners();
        while (it.hasNext()) {
            it.next().onDrop(db);
        }
        db.close();
        OrientDBEmbedded orientDBEmbedded2 = this;
        synchronized (orientDBEmbedded2) {
            if (this.exists(name, user, password)) {
                OAbstractPaginatedStorage storage = this.getOrInitStorage(name);
                OSharedContext sharedContext = this.sharedContexts.get(name);
                if (sharedContext != null) {
                    sharedContext.close();
                }
                storage.delete();
                this.storages.remove(name);
                this.sharedContexts.remove(name);
            }
        }
    }

    @Override
    public synchronized Set<String> listDatabases(String user, String password) {
        this.checkOpen();
        HashSet<String> databases = new HashSet<String>();
        if (this.basePath != null) {
            this.scanDatabaseDirectory(new File(this.basePath), name -> databases.add(name));
        }
        databases.addAll(this.storages.keySet());
        return databases;
    }

    @Override
    public synchronized void loadAllDatabases() {
        if (this.basePath != null) {
            this.scanDatabaseDirectory(new File(this.basePath), name -> {
                if (!this.storages.containsKey(name)) {
                    OAbstractPaginatedStorage storage = this.getOrInitStorage(name);
                    storage.open(this.getConfigurations().getConfigurations());
                }
            });
        }
    }

    @Override
    public ODatabasePoolInternal openPool(String name, String user, String password) {
        return this.openPool(name, user, password, null);
    }

    @Override
    public ODatabasePoolInternal openPool(String name, String user, String password, OrientDBConfig config) {
        this.checkOpen();
        ODatabasePoolImpl pool = new ODatabasePoolImpl(this, name, user, password, this.solveConfig(config));
        this.pools.add(pool);
        return pool;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        if (!this.open) {
            return;
        }
        this.timer.cancel();
        this.executor.shutdown();
        try {
            while (!this.executor.awaitTermination(1L, TimeUnit.MINUTES)) {
                OLogManager.instance().warn((Object)this, "Failed waiting background operations termination", new Object[0]);
                this.executor.shutdownNow();
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        OrientDBEmbedded orientDBEmbedded = this;
        synchronized (orientDBEmbedded) {
            this.removeShutdownHook();
            this.internalClose();
        }
    }

    @Override
    public synchronized void internalClose() {
        if (!this.open) {
            return;
        }
        this.open = false;
        this.sharedContexts.values().forEach(x -> x.close());
        ArrayList<OAbstractPaginatedStorage> storagesCopy = new ArrayList<OAbstractPaginatedStorage>(this.storages.values());
        for (OAbstractPaginatedStorage stg : storagesCopy) {
            try {
                OLogManager.instance().info((Object)this, "- shutdown storage: " + stg.getName() + "...", new Object[0]);
                stg.shutdown();
            }
            catch (Exception e) {
                OLogManager.instance().warn((Object)this, "-- error on shutdown storage", e, new Object[0]);
            }
            catch (Error e) {
                OLogManager.instance().warn((Object)this, "-- error on shutdown storage", e, new Object[0]);
                throw e;
            }
        }
        this.sharedContexts.clear();
        this.storages.clear();
        this.orient.onEmbeddedFactoryClose(this);
    }

    public OrientDBConfig getConfigurations() {
        return this.configurations;
    }

    @Override
    public void removePool(ODatabasePoolInternal pool) {
        this.pools.remove(pool);
    }

    protected void scanDatabaseDirectory(File directory, DatabaseFound found) {
        File[] files;
        if (directory.exists() && directory.isDirectory() && (files = directory.listFiles()) != null) {
            for (File db : files) {
                if (!db.isDirectory()) continue;
                File plocalFile = new File(db.getAbsolutePath() + "/database.ocf");
                String dbPath = db.getPath().replace('\\', '/');
                int lastBS = dbPath.lastIndexOf(47, dbPath.length() - 1) + 1;
                if (!plocalFile.exists()) continue;
                found.found(OIOUtils.getDatabaseNameFromPath(dbPath.substring(lastBS)));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void initCustomStorage(String name, String path, String userName, String userPassword) {
        ODatabaseDocumentEmbedded embedded = null;
        OrientDBEmbedded orientDBEmbedded = this;
        synchronized (orientDBEmbedded) {
            boolean exists = OLocalPaginatedStorage.exists(Paths.get(path, new String[0]));
            OAbstractPaginatedStorage storage = (OAbstractPaginatedStorage)this.disk.createStorage(path, new HashMap<String, String>());
            if (!exists) {
                embedded = this.internalCreate(this.getConfigurations(), storage);
            }
            this.storages.put(name, storage);
        }
        if (embedded != null) {
            embedded.callOnCreateListeners();
            ODatabaseRecordThreadLocal.instance().remove();
        }
    }

    @Override
    public synchronized void removeShutdownHook() {
        this.orient.removeOrientDB(this);
    }

    @Override
    public synchronized Collection<OStorage> getStorages() {
        return this.storages.values().stream().map(x -> x).collect(Collectors.toSet());
    }

    @Override
    public synchronized void forceDatabaseClose(String iDatabaseName) {
        OAbstractPaginatedStorage storage = this.storages.remove(iDatabaseName);
        if (storage != null) {
            OSharedContext ctx = this.sharedContexts.remove(iDatabaseName);
            if (ctx != null) {
                ctx.close();
            }
            storage.shutdown();
        }
    }

    public String getDatabasePath(String iDatabaseName) {
        OAbstractPaginatedStorage storage = this.storages.get(iDatabaseName);
        if (storage != null && storage instanceof OLocalPaginatedStorage) {
            return ((OLocalPaginatedStorage)storage).getStoragePath().toString();
        }
        return null;
    }

    protected void checkOpen() {
        if (!this.open) {
            throw new ODatabaseException("OrientDB Instance is closed");
        }
    }

    @Override
    public boolean isOpen() {
        return this.open;
    }

    @Override
    public boolean isEmbedded() {
        return true;
    }

    @Override
    public void schedule(TimerTask task, long delay, long period) {
        this.timer.schedule(task, delay, period);
    }

    @Override
    public void scheduleOnce(TimerTask task, long delay) {
        this.timer.schedule(task, delay);
    }

    @Override
    public <X> Future<X> execute(String database, String user, ODatabaseTask<X> task) {
        return this.executor.submit(() -> {
            try (ODatabaseDocumentEmbedded session = this.openNoAuthenticate(database, user);){
                Object x = task.call(session);
                return x;
            }
        });
    }

    @Override
    public <X> Future<X> executeNoAuthorization(String database, ODatabaseTask<X> task) {
        return this.executor.submit(() -> {
            try (ODatabaseDocumentEmbedded session = this.openNoAuthorization(database);){
                Object x = task.call(session);
                return x;
            }
        });
    }

    public static interface InstanceFactory<T> {
        public T create(OAbstractPaginatedStorage var1);
    }

    protected static interface DatabaseFound {
        public void found(String var1);
    }
}

