/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.db;

import com.orientechnologies.orient.core.config.OContextConfiguration;
import com.orientechnologies.orient.core.db.ODatabase;
import com.orientechnologies.orient.core.db.ODatabaseListener;
import com.orientechnologies.orient.core.db.OrientDBConfigBuilder;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class OrientDBConfig {
    public static final String LOCK_TYPE_MODIFICATION = "modification";
    public static final String LOCK_TYPE_READWRITE = "readwrite";
    private OrientDBConfig parent;
    private OContextConfiguration configurations;
    private Map<ODatabase.ATTRIBUTES, Object> attributes;
    private Set<ODatabaseListener> listeners;
    private ClassLoader classLoader;

    protected OrientDBConfig() {
        this.configurations = new OContextConfiguration();
        this.attributes = new HashMap<ODatabase.ATTRIBUTES, Object>();
        this.parent = null;
        this.listeners = new HashSet<ODatabaseListener>();
        this.classLoader = this.getClass().getClassLoader();
    }

    protected OrientDBConfig(OContextConfiguration configurations, Map<ODatabase.ATTRIBUTES, Object> attributes, Set<ODatabaseListener> listeners, ClassLoader classLoader) {
        this.configurations = configurations;
        this.attributes = attributes;
        this.parent = null;
        this.listeners = listeners != null ? listeners : Collections.emptySet();
        this.classLoader = classLoader != null ? classLoader : this.getClass().getClassLoader();
    }

    public static OrientDBConfig defaultConfig() {
        return new OrientDBConfig();
    }

    public static OrientDBConfigBuilder builder() {
        return new OrientDBConfigBuilder();
    }

    public Set<ODatabaseListener> getListeners() {
        return this.listeners;
    }

    public OContextConfiguration getConfigurations() {
        return this.configurations;
    }

    public Map<ODatabase.ATTRIBUTES, Object> getAttributes() {
        return this.attributes;
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    protected void setParent(OrientDBConfig parent) {
        this.parent = parent;
        if (parent != null) {
            if (parent.attributes != null) {
                HashMap<ODatabase.ATTRIBUTES, Object> attrs = new HashMap<ODatabase.ATTRIBUTES, Object>();
                attrs.putAll(parent.attributes);
                if (this.attributes != null) {
                    attrs.putAll(this.attributes);
                }
                this.attributes = attrs;
            }
            if (parent.configurations != null) {
                OContextConfiguration confis = new OContextConfiguration();
                confis.merge(parent.configurations);
                if (this.configurations != null) {
                    confis.merge(this.configurations);
                }
                this.configurations = confis;
            }
            if (this.classLoader == null) {
                this.classLoader = parent.classLoader;
            }
            if (parent.listeners != null) {
                HashSet<ODatabaseListener> lis = new HashSet<ODatabaseListener>();
                lis.addAll(parent.listeners);
                if (this.listeners != null) {
                    lis.addAll(this.listeners);
                }
                this.listeners = lis;
            }
        }
    }
}

