/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.db;

import com.orientechnologies.orient.core.db.ODatabasePoolInternal;
import com.orientechnologies.orient.core.db.ODatabaseSession;
import com.orientechnologies.orient.core.db.ODatabaseType;
import com.orientechnologies.orient.core.db.OrientDBConfig;
import com.orientechnologies.orient.core.db.OrientDBInternal;
import java.util.ArrayList;
import java.util.List;

public class OrientDB
implements AutoCloseable {
    protected OrientDBInternal internal;
    private String serverUser;
    private String serverPassword;

    public OrientDB(String url, OrientDBConfig configuration) {
        this(url, null, null, configuration);
    }

    public OrientDB(String url, String serverUser, String serverPassword, OrientDBConfig configuration) {
        int pos = url.indexOf(58);
        String what = pos > 0 ? url.substring(0, pos) : url;
        if ("embedded".equals(what) || "memory".equals(what) || "plocal".equals(what)) {
            this.internal = OrientDBInternal.embedded(url.substring(url.indexOf(58) + 1), configuration);
        } else if ("remote".equals(what)) {
            this.internal = OrientDBInternal.remote(url.substring(url.indexOf(58) + 1).split(","), configuration);
        } else {
            throw new IllegalArgumentException("Wrong url:`" + url + "`");
        }
        this.serverUser = serverUser;
        this.serverPassword = serverPassword;
    }

    OrientDB(OrientDBInternal internal) {
        this.internal = internal;
        this.serverUser = null;
        this.serverPassword = null;
    }

    public ODatabaseSession open(String database, String user, String password) {
        return this.open(database, user, password, OrientDBConfig.defaultConfig());
    }

    public ODatabaseSession open(String database, String user, String password, OrientDBConfig config) {
        return this.internal.open(database, user, password, config);
    }

    public void create(String database, ODatabaseType type) {
        this.create(database, type, OrientDBConfig.defaultConfig());
    }

    public void create(String database, ODatabaseType type, OrientDBConfig config) {
        this.internal.create(database, this.serverUser, this.serverPassword, type, config);
    }

    public boolean createIfNotExists(String database, ODatabaseType type) {
        return this.createIfNotExists(database, type, OrientDBConfig.defaultConfig());
    }

    public boolean createIfNotExists(String database, ODatabaseType type, OrientDBConfig config) {
        if (!this.internal.exists(database, this.serverUser, this.serverPassword)) {
            this.internal.create(database, this.serverUser, this.serverPassword, type, config);
            return true;
        }
        return false;
    }

    public void drop(String database) {
        this.internal.drop(database, this.serverUser, this.serverPassword);
    }

    public boolean exists(String database) {
        return this.internal.exists(database, this.serverUser, this.serverPassword);
    }

    public List<String> list() {
        return new ArrayList<String>(this.internal.listDatabases(this.serverUser, this.serverPassword));
    }

    @Override
    public void close() {
        this.internal.close();
    }

    public boolean isOpen() {
        return this.internal.isOpen();
    }

    ODatabasePoolInternal openPool(String database, String user, String password, OrientDBConfig config) {
        return this.internal.openPool(database, user, password, config);
    }

    OrientDBInternal getInternal() {
        return this.internal;
    }
}

