/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.db;

import com.orientechnologies.orient.core.db.ODatabasePoolInternal;
import com.orientechnologies.orient.core.db.ODatabaseSession;
import com.orientechnologies.orient.core.db.OrientDB;
import com.orientechnologies.orient.core.db.OrientDBConfig;
import com.orientechnologies.orient.core.exception.OAcquireTimeoutException;
import com.orientechnologies.orient.core.util.OURLConnection;
import com.orientechnologies.orient.core.util.OURLHelper;

public class ODatabasePool
implements AutoCloseable {
    private final OrientDB orientDb;
    private ODatabasePoolInternal internal;
    private final boolean autoclose;

    public ODatabasePool(OrientDB environment, String database, String user, String password) {
        this(environment, database, user, password, OrientDBConfig.defaultConfig());
    }

    public ODatabasePool(OrientDB environment, String database, String user, String password, OrientDBConfig configuration) {
        this.orientDb = environment;
        this.autoclose = false;
        this.internal = this.orientDb.openPool(database, user, password, configuration);
    }

    public ODatabasePool(String url, String user, String password) {
        this(url, user, password, OrientDBConfig.defaultConfig());
    }

    public ODatabasePool(String url, String user, String password, OrientDBConfig configuration) {
        OURLConnection val = OURLHelper.parseNew(url);
        this.orientDb = new OrientDB(val.getType() + ":" + val.getPath(), configuration);
        this.autoclose = true;
        this.internal = this.orientDb.openPool(val.getDbName(), user, password, configuration);
    }

    public ODatabasePool(String environment, String database, String user, String password) {
        this(environment, database, user, password, OrientDBConfig.defaultConfig());
    }

    public ODatabasePool(String environment, String database, String user, String password, OrientDBConfig configuration) {
        this.orientDb = new OrientDB(environment, configuration);
        this.autoclose = true;
        this.internal = this.orientDb.openPool(database, user, password, configuration);
    }

    public ODatabaseSession acquire() throws OAcquireTimeoutException {
        return this.internal.acquire();
    }

    @Override
    public void close() {
        this.internal.close();
        if (this.autoclose) {
            this.orientDb.close();
        }
    }
}

