/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.common.concur.lock;

import com.orientechnologies.common.types.OModifiableInteger;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.atomic.LongAdder;
import java.util.concurrent.locks.AbstractOwnableSynchronizer;
import java.util.concurrent.locks.LockSupport;

@SuppressFBWarnings(value={"SE_TRANSIENT_FIELD_NOT_RESTORED"})
public class OReadersWriterSpinLock
extends AbstractOwnableSynchronizer {
    private static final long serialVersionUID = 7975120282194559960L;
    private final transient LongAdder distributedCounter;
    private final transient AtomicReference<WNode> tail = new AtomicReference();
    private final transient ThreadLocal<OModifiableInteger> lockHolds = new InitOModifiableInteger();
    private final transient ThreadLocal<WNode> myNode = new InitWNode();

    public OReadersWriterSpinLock() {
        WNode wNode = new WNode();
        wNode.locked = false;
        this.tail.set(wNode);
        this.distributedCounter = new LongAdder();
    }

    public boolean tryAcquireReadLock(long timeout) {
        OModifiableInteger lHolds = this.lockHolds.get();
        int holds = lHolds.intValue();
        if (holds > 0) {
            lHolds.increment();
            return true;
        }
        if (holds < 0) {
            return true;
        }
        this.distributedCounter.increment();
        WNode wNode = this.tail.get();
        long start = System.nanoTime();
        while (wNode.locked) {
            this.distributedCounter.decrement();
            while (wNode.locked && wNode == this.tail.get()) {
                wNode.waitingReaders.put(Thread.currentThread(), Boolean.TRUE);
                if (wNode.locked && wNode == this.tail.get()) {
                    long parkTimeout = timeout - (System.nanoTime() - start);
                    if (parkTimeout > 0L) {
                        LockSupport.parkNanos(this, parkTimeout);
                    } else {
                        return false;
                    }
                }
                wNode = this.tail.get();
                if (System.nanoTime() - start <= timeout) continue;
                return false;
            }
            this.distributedCounter.increment();
            wNode = this.tail.get();
            if (System.nanoTime() - start <= timeout) continue;
            this.distributedCounter.decrement();
            return false;
        }
        lHolds.increment();
        assert (lHolds.intValue() == 1);
        return true;
    }

    public void acquireReadLock() {
        OModifiableInteger lHolds = this.lockHolds.get();
        int holds = lHolds.intValue();
        if (holds > 0) {
            lHolds.increment();
            return;
        }
        if (holds < 0) {
            return;
        }
        this.distributedCounter.increment();
        WNode wNode = this.tail.get();
        while (wNode.locked) {
            this.distributedCounter.decrement();
            while (wNode.locked && wNode == this.tail.get()) {
                wNode.waitingReaders.put(Thread.currentThread(), Boolean.TRUE);
                if (wNode.locked && wNode == this.tail.get()) {
                    LockSupport.park(this);
                }
                wNode = this.tail.get();
            }
            this.distributedCounter.increment();
            wNode = this.tail.get();
        }
        lHolds.increment();
        assert (lHolds.intValue() == 1);
    }

    public void releaseReadLock() {
        OModifiableInteger lHolds = this.lockHolds.get();
        int holds = lHolds.intValue();
        if (holds > 1) {
            lHolds.decrement();
            return;
        }
        if (holds < 0) {
            return;
        }
        this.distributedCounter.decrement();
        lHolds.decrement();
        assert (lHolds.intValue() == 0);
    }

    public void acquireWriteLock() {
        OModifiableInteger lHolds = this.lockHolds.get();
        if (lHolds.intValue() < 0) {
            lHolds.decrement();
            return;
        }
        WNode node = this.myNode.get();
        node.locked = true;
        WNode pNode = this.tail.getAndSet(this.myNode.get());
        while (pNode.locked) {
            pNode.waitingWriter = Thread.currentThread();
            if (!pNode.locked) continue;
            LockSupport.park(this);
        }
        pNode.waitingWriter = null;
        while (this.distributedCounter.sum() != 0L) {
            Thread.yield();
        }
        this.setExclusiveOwnerThread(Thread.currentThread());
        lHolds.decrement();
        assert (lHolds.intValue() == -1);
    }

    public void releaseWriteLock() {
        OModifiableInteger lHolds = this.lockHolds.get();
        if (lHolds.intValue() < -1) {
            lHolds.increment();
            return;
        }
        this.setExclusiveOwnerThread(null);
        WNode node = this.myNode.get();
        this.myNode.set(new WNode());
        node.locked = false;
        Thread waitingWriter = node.waitingWriter;
        if (waitingWriter != null) {
            LockSupport.unpark(waitingWriter);
        }
        while (!node.waitingReaders.isEmpty()) {
            Set readers = node.waitingReaders.keySet();
            Iterator threadIterator = readers.iterator();
            while (threadIterator.hasNext()) {
                Thread reader = (Thread)threadIterator.next();
                threadIterator.remove();
                LockSupport.unpark(reader);
            }
        }
        lHolds.increment();
        assert (lHolds.intValue() == 0);
    }

    private static final class WNode {
        private final ConcurrentHashMap<Thread, Boolean> waitingReaders = new ConcurrentHashMap();
        private volatile boolean locked = true;
        private volatile Thread waitingWriter;

        private WNode() {
        }
    }

    private static final class InitOModifiableInteger
    extends ThreadLocal<OModifiableInteger> {
        private InitOModifiableInteger() {
        }

        @Override
        protected OModifiableInteger initialValue() {
            return new OModifiableInteger();
        }
    }

    private static final class InitWNode
    extends ThreadLocal<WNode> {
        private InitWNode() {
        }

        @Override
        protected WNode initialValue() {
            return new WNode();
        }
    }
}

