/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.etl.util;

import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.etl.context.OETLContext;
import com.orientechnologies.orient.etl.context.OETLContextWrapper;
import com.orientechnologies.orient.etl.util.OFileManager;
import java.io.File;
import java.io.IOException;

public class OMigrationConfigManager {
    private static final String configurationDirectoryName = "etl-config/";
    private static final String configFileDefaultName = "migration-config.json";

    public static String writeConfigurationInTargetDB(ODocument migrationConfig, String outOrientGraphUri, String configName) {
        String outDBConfigPath = OMigrationConfigManager.prepareConfigDirectoryForWriting(outOrientGraphUri, configName);
        String jsonSourcesInfo = migrationConfig.toJSON("prettyPrint");
        try {
            OFileManager.writeFileFromText(jsonSourcesInfo, outDBConfigPath, false);
        }
        catch (IOException e) {
            String mess = "";
            ((OETLContext)OETLContextWrapper.getInstance().getContext()).printExceptionMessage(e, mess, "error");
            ((OETLContext)OETLContextWrapper.getInstance().getContext()).printExceptionStackTrace(e, "error");
        }
        return outDBConfigPath;
    }

    public static String writeConfigurationInTargetDB(String migrationConfig, String outOrientGraphUri, String configName) throws IOException {
        String outDBConfigPath = OMigrationConfigManager.prepareConfigDirectoryForWriting(outOrientGraphUri, configName);
        OFileManager.writeFileFromText(migrationConfig, outDBConfigPath, false);
        return outDBConfigPath;
    }

    private static String prepareConfigDirectoryForWriting(String outOrientGraphUri, String configName) {
        String outDBConfigPath;
        if (configName == null) {
            outDBConfigPath = OMigrationConfigManager.buildConfigurationFilePath(outOrientGraphUri, configFileDefaultName);
        } else {
            if (!configName.endsWith(".json")) {
                configName = configName + ".json";
            }
            outDBConfigPath = OMigrationConfigManager.buildConfigurationFilePath(outOrientGraphUri, configName);
        }
        File confFileInOrientDB = new File(outDBConfigPath);
        if (confFileInOrientDB.exists()) {
            confFileInOrientDB.delete();
        }
        return outDBConfigPath;
    }

    public static String buildConfigurationFilePath(String outOrientGraphUri, String configFileName) {
        if (outOrientGraphUri.contains("\\")) {
            outOrientGraphUri = outOrientGraphUri.replace("\\", "/");
        }
        if (!configFileName.endsWith(".json")) {
            configFileName = configFileName + ".json";
        }
        if (outOrientGraphUri.charAt(outOrientGraphUri.length() - 1) != '/') {
            outOrientGraphUri = outOrientGraphUri + "/";
        }
        String outDBConfigPath = outOrientGraphUri + configurationDirectoryName + configFileName;
        outDBConfigPath = outDBConfigPath.replace("plocal:", "");
        return outDBConfigPath;
    }
}

