/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.etl.transformer;

import com.orientechnologies.common.collection.OMultiValue;
import com.orientechnologies.orient.core.command.OCommandContext;
import com.orientechnologies.orient.core.db.document.ODatabaseDocument;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.exception.OConfigurationException;
import com.orientechnologies.orient.core.metadata.schema.OClass;
import com.orientechnologies.orient.core.record.OEdge;
import com.orientechnologies.orient.core.record.ORecord;
import com.orientechnologies.orient.core.record.OVertex;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.record.impl.OVertexDelegate;
import com.orientechnologies.orient.core.storage.ORecordDuplicatedException;
import com.orientechnologies.orient.etl.OETLProcessHaltedException;
import com.orientechnologies.orient.etl.transformer.OETLAbstractLookupTransformer;
import com.orientechnologies.orient.etl.transformer.OETLTransformException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;

public class OETLEdgeTransformer
extends OETLAbstractLookupTransformer {
    private String edgeClass = "E";
    private boolean directionOut = true;
    private ODocument targetVertexFields;
    private ODocument edgeFields;
    private boolean skipDuplicates = false;

    @Override
    public ODocument getConfiguration() {
        return new ODocument().fromJSON("{parameters:[" + this.getCommonConfigurationParameters() + ",{joinValue:{optional:true,description:'value to use for join'}},{joinFieldName:{optional:true,description:'field name containing the value to join'}},{lookup:{optional:false,description:'<Class>.<property> or Query to execute'}},{direction:{optional:true,description:'Direction between 'in' and 'out'. Default is 'out''}},{class:{optional:true,description:'Edge class name. Default is 'E''}},{targetVertexFields:{optional:true,description:'Map of fields to set in target vertex. Use ${$input.<field>} to get input field values'}},{edgeFields:{optional:true,description:'Map of fields to set in edge. Use ${$input.<field>} to get input field values'}},{skipDuplicates:{optional:true,description:'Duplicated edges (with a composite index built on both out and in properties) are skipped', default:false}},{unresolvedLinkAction:{optional:true,description:'action when the target vertex is not found',values:" + this.stringArray2Json((Object[])OETLAbstractLookupTransformer.ACTION.values()) + "}}],input:['ODocument','OVertex'],output:'OVertex'}");
    }

    @Override
    public void configure(ODocument iConfiguration, OCommandContext iContext) {
        super.configure(iConfiguration, iContext);
        this.edgeClass = (String)iConfiguration.field("class");
        if (iConfiguration.containsField("direction")) {
            String direction = (String)iConfiguration.field("direction");
            if ("out".equalsIgnoreCase(direction)) {
                this.directionOut = true;
            } else if ("in".equalsIgnoreCase(direction)) {
                this.directionOut = false;
            } else {
                throw new OConfigurationException("Direction can be 'in' or 'out', but found: " + direction);
            }
        }
        if (iConfiguration.containsField("targetVertexFields")) {
            this.targetVertexFields = (ODocument)iConfiguration.field("targetVertexFields");
        }
        if (iConfiguration.containsField("edgeFields")) {
            this.edgeFields = (ODocument)iConfiguration.field("edgeFields");
        }
        if (iConfiguration.containsField("skipDuplicates")) {
            this.skipDuplicates = (Boolean)this.resolve(iConfiguration.field("skipDuplicates"));
        }
    }

    @Override
    public String getName() {
        return "edge";
    }

    @Override
    public void begin(ODatabaseDocument db) {
        super.begin(db);
        OClass cls = db.getClass(this.edgeClass);
        if (cls == null) {
            db.createEdgeClass(this.edgeClass);
        }
        super.begin(db);
    }

    @Override
    public Object executeTransform(ODatabaseDocument db, Object input) {
        for (Object o : OMultiValue.getMultiValueIterable((Object)input)) {
            OVertex vertex;
            if (o instanceof OVertex) {
                vertex = (OVertex)o;
            } else if (o instanceof OIdentifiable) {
                vertex = (OVertex)db.getRecord((OIdentifiable)o);
            } else {
                throw new OETLTransformException(this.getName() + ": input type '" + o + "' is not supported");
            }
            Object joinCurrentValue = this.joinValue;
            if (joinCurrentValue == null) {
                joinCurrentValue = this.joinFieldName.startsWith("$") ? this.resolve(this.joinFieldName) : vertex.getProperty(this.joinFieldName);
            }
            if (OMultiValue.isMultiValue((Object)joinCurrentValue)) {
                for (Object ob : OMultiValue.getMultiValueIterable((Object)joinCurrentValue)) {
                    Object r;
                    if (this.createEdge(db, vertex, ob, r = this.lookup(db, ob, true)) != null || this.unresolvedLinkAction != OETLAbstractLookupTransformer.ACTION.SKIP) continue;
                    return null;
                }
                continue;
            }
            Object result = this.lookup(db, joinCurrentValue, true);
            if (this.createEdge(db, vertex, joinCurrentValue, result) != null || this.unresolvedLinkAction != OETLAbstractLookupTransformer.ACTION.SKIP) continue;
            return null;
        }
        return input;
    }

    private List<OEdge> createEdge(ODatabaseDocument db, OVertex vertex, Object joinCurrentValue, Object result) {
        this.log(Level.FINE, "joinCurrentValue=%s, lookupResult=%s", joinCurrentValue, result);
        if (result == null) {
            switch (this.unresolvedLinkAction) {
                case CREATE: {
                    if (joinCurrentValue == null) break;
                    if (this.lookup != null) {
                        String[] lookupParts = this.lookup.split("\\.");
                        OVertex linkedV = db.newVertex(lookupParts[0]);
                        linkedV.setProperty(lookupParts[1], joinCurrentValue);
                        if (this.targetVertexFields != null) {
                            for (String f : this.targetVertexFields.fieldNames()) {
                                linkedV.setProperty(f, this.resolve(this.targetVertexFields.field(f)));
                            }
                        }
                        linkedV.save();
                        this.log(Level.FINE, "created new vertex=" + linkedV.getRecord(), new Object[0]);
                        result = linkedV.getIdentity();
                        break;
                    }
                    throw new OConfigurationException("Cannot create linked document because target class is unknown. Use 'lookup' field");
                }
                case ERROR: {
                    this.processor.getStats().incrementErrors();
                    this.log(Level.SEVERE, "%s: ERROR Cannot resolve join for value '%s'", this.getName(), joinCurrentValue);
                    break;
                }
                case WARNING: {
                    this.processor.getStats().incrementWarnings();
                    this.log(Level.INFO, "%s: WARN Cannot resolve join for value '%s'", this.getName(), joinCurrentValue);
                    break;
                }
                case SKIP: {
                    return null;
                }
                case HALT: {
                    throw new OETLProcessHaltedException("Cannot resolve join for value '" + joinCurrentValue + "'");
                }
                default: {
                    return null;
                }
            }
        }
        if (result != null) {
            ArrayList<OEdge> edges;
            if (OMultiValue.isMultiValue((Object)result)) {
                int size = OMultiValue.getSize((Object)result);
                if (size == 0) {
                    return null;
                }
                edges = new ArrayList(size);
            } else {
                edges = new ArrayList<OEdge>(1);
            }
            for (Object o : OMultiValue.getMultiValueIterable((Object)result)) {
                OIdentifiable oid = (OIdentifiable)o;
                OVertexDelegate targetVertex = new OVertexDelegate((ODocument)db.getRecord(oid));
                try {
                    OEdge edge = this.directionOut ? vertex.addEdge((OVertex)targetVertex, this.edgeClass) : targetVertex.addEdge(vertex, this.edgeClass);
                    if (this.edgeFields != null) {
                        for (String f : this.edgeFields.fieldNames()) {
                            edge.setProperty(f, this.resolve(this.edgeFields.field(f)));
                        }
                    }
                    edges.add(edge);
                    this.log(Level.FINE, "created new edge=%s", edge);
                }
                catch (ORecordDuplicatedException e2) {
                    if (this.skipDuplicates) {
                        this.log(Level.FINE, "skipped creation of new edge because already exists", new Object[0]);
                        continue;
                    }
                    this.log(Level.SEVERE, "error on creation of new edge because it already exists (skipDuplicates=false)", new Object[0]);
                    throw e2;
                }
            }
            edges.stream().forEach(e -> {
                ORecord cfr_ignored_0 = (ORecord)db.save(e);
            });
            return edges;
        }
        return null;
    }
}

