/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.etl.extractor;

import com.orientechnologies.apache.commons.csv.CSVFormat;
import com.orientechnologies.apache.commons.csv.CSVParser;
import com.orientechnologies.apache.commons.csv.CSVRecord;
import com.orientechnologies.orient.core.command.OCommandContext;
import com.orientechnologies.orient.core.metadata.schema.OType;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.etl.OETLExtractedItem;
import com.orientechnologies.orient.etl.extractor.OETLAbstractSourceExtractor;
import com.orientechnologies.orient.etl.extractor.OETLExtractorException;
import java.io.IOException;
import java.io.Reader;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.logging.Level;

public class OETLCSVExtractor
extends OETLAbstractSourceExtractor {
    private static String NULL_STRING = "NULL";
    protected OETLExtractedItem next;
    private Map<String, OType> columnTypes = new HashMap<String, OType>();
    private long skipFrom = -1L;
    private long skipTo = -1L;
    private Character stringCharacter = Character.valueOf('\"');
    private boolean unicode = true;
    private Iterator<CSVRecord> recordIterator;
    private CSVFormat csvFormat;
    private String nullValue = NULL_STRING;
    private String dateFormat = "yyyy-MM-dd";
    private String dateTimeFormat = "yyyy-MM-dd hh:mm";

    @Override
    public ODocument getConfiguration() {
        return new ODocument().fromJSON("{parameters:[" + this.getCommonConfigurationParameters() + ",{separator:{optional:true,description:'Column separator'}},{columnsOnFirstLine:{optional:true,description:'Columns are described in the first line'}},{columns:{optional:true,description:'Columns array containing names, and optionally type after : (e.g.: name:String, age:int'}},{nullValue:{optional:true,description:'Value to consider as NULL_STRING. Default is NULL'}},{dateFormat:{optional:true,description:'Date format used to parde dates. Default is yyyy-MM-dd'}},{dateTimeFormat:{optional:true,description:'DateTime format used to parde dates. Default is yyyy-mm-dd HH:MM'}},{quote:{optional:true,description:'String character delimiter. Use \"\" to do not use any delimitator'}},{ignoreEmptyLines:{optional:true,description:'Ignore empty lines',type:'boolean'}},{ignoreMissingColumns:{optional:true,description:'Ignore empty columns',type:'boolean'}},{skipFrom:{optional:true,description:'Line number where start to skip',type:'int'}},{skipTo:{optional:true,description:'Line number where skip ends',type:'int'}},{predefinedFormat:{optional:true,description:'Name of standard csv format (from Apache commons-csv): Default, Excel, MySQL, RFC4180, TDF',type:'String'}}],input:['String'],output:'ODocument'}");
    }

    @Override
    public String getName() {
        return "csv";
    }

    @Override
    public String getUnit() {
        return "rows";
    }

    @Override
    public void configure(ODocument iConfiguration, OCommandContext iContext) {
        String value;
        super.configure(iConfiguration, iContext);
        this.csvFormat = CSVFormat.newFormat(',').withNullString(NULL_STRING).withEscape('\\').withQuote('\"').withCommentMarker('#');
        if (iConfiguration.containsField("predefinedFormat")) {
            this.csvFormat = CSVFormat.valueOf((String)iConfiguration.field("predefinedFormat"));
        }
        if (iConfiguration.containsField("separator")) {
            this.csvFormat = this.csvFormat.withDelimiter(iConfiguration.field("separator").toString().charAt(0));
        }
        if (iConfiguration.containsField("dateFormat")) {
            this.dateFormat = (String)iConfiguration.field("dateFormat");
        }
        if (iConfiguration.containsField("dateTimeFormat")) {
            this.dateTimeFormat = (String)iConfiguration.field("dateTimeFormat");
        }
        if (iConfiguration.containsField("ignoreEmptyLines")) {
            boolean ignoreEmptyLines = (Boolean)iConfiguration.field("ignoreEmptyLines");
            this.csvFormat = this.csvFormat.withIgnoreEmptyLines(ignoreEmptyLines);
        }
        if (iConfiguration.containsField("ignoreMissingColumns")) {
            boolean ignoreMissingColumns = (Boolean)iConfiguration.field("ignoreMissingColumns");
            this.csvFormat = this.csvFormat.withAllowMissingColumnNames(ignoreMissingColumns);
        }
        if (iConfiguration.containsField("columnsOnFirstLine")) {
            Boolean columnsOnFirstLine = (Boolean)iConfiguration.field("columnsOnFirstLine");
            if (columnsOnFirstLine.equals(Boolean.TRUE)) {
                this.csvFormat = this.csvFormat.withHeader(new String[0]);
            }
        } else {
            this.csvFormat = this.csvFormat.withHeader(new String[0]);
        }
        if (iConfiguration.containsField("columns")) {
            List columns = (List)iConfiguration.field("columns");
            ArrayList<String> columnNames = new ArrayList<String>(columns.size());
            this.columnTypes = new HashMap<String, OType>(columns.size());
            for (String col : columns) {
                String[] col2Type = col.split(":");
                columnNames.add(col2Type[0]);
                if (col2Type.length > 1) {
                    this.columnTypes.put(col2Type[0], OType.valueOf((String)col2Type[1].toUpperCase(Locale.ENGLISH)));
                    continue;
                }
                this.columnTypes.put(col2Type[0], OType.ANY);
            }
            this.log(Level.INFO, "column types: %s", this.columnTypes);
            this.csvFormat = this.csvFormat.withHeader(columnNames.toArray(new String[0])).withSkipHeaderRecord();
        }
        if (iConfiguration.containsField("skipFrom")) {
            this.skipFrom = ((Number)iConfiguration.field("skipFrom")).longValue();
        }
        if (iConfiguration.containsField("skipTo")) {
            this.skipTo = ((Number)iConfiguration.field("skipTo")).longValue();
        }
        if (iConfiguration.containsField("nullValue")) {
            this.nullValue = (String)iConfiguration.field("nullValue");
            this.csvFormat = this.csvFormat.withNullString(this.nullValue);
        }
        if (iConfiguration.containsField("quote") && !(value = iConfiguration.field("quote").toString()).isEmpty()) {
            this.csvFormat = this.csvFormat.withQuote(value.charAt(0));
        }
    }

    @Override
    public void extract(Reader iReader) {
        super.extract(iReader);
        try {
            CSVParser parser = new CSVParser(iReader, this.csvFormat);
            this.recordIterator = parser.iterator();
        }
        catch (IOException e) {
            throw new OETLExtractorException(e);
        }
    }

    @Override
    public boolean hasNext() {
        if (this.recordIterator.hasNext()) {
            CSVRecord csvRecord = this.recordIterator.next();
            while (this.shouldSkipRecord(csvRecord) && this.recordIterator.hasNext()) {
                csvRecord = this.recordIterator.next();
            }
            this.next = this.fetchNext(csvRecord);
            return true;
        }
        return false;
    }

    private boolean shouldSkipRecord(CSVRecord csvRecord) {
        return csvRecord.getRecordNumber() <= this.skipTo && csvRecord.getRecordNumber() >= this.skipFrom;
    }

    private OETLExtractedItem fetchNext(CSVRecord csvRecord) {
        ODocument doc = new ODocument();
        Map<String, String> recordAsMap = csvRecord.toMap();
        if (this.columnTypes.isEmpty()) {
            for (Map.Entry<String, String> en : recordAsMap.entrySet()) {
                String value = en.getValue();
                if (this.csvFormat.getAllowMissingColumnNames() && en.getKey().isEmpty()) continue;
                if (value == null || this.nullValue.equals(value) || value.isEmpty()) {
                    doc.field(en.getKey(), null, new OType[]{OType.ANY});
                    continue;
                }
                doc.field(en.getKey(), this.determineTheType(value));
            }
        } else {
            for (Map.Entry<String, OType> typeEntry : this.columnTypes.entrySet()) {
                String fieldName = typeEntry.getKey();
                OType fieldType = typeEntry.getValue();
                String fieldValueAsString = recordAsMap.get(fieldName);
                try {
                    if (fieldType != null && fieldType.getDefaultJavaType() != null && fieldType.getDefaultJavaType().equals(Date.class)) {
                        if (fieldType.equals((Object)OType.DATE)) {
                            doc.field(fieldName, this.transformToDate(fieldValueAsString));
                            continue;
                        }
                        doc.field(fieldName, this.transformToDateTime(fieldValueAsString));
                        continue;
                    }
                    Object fieldValue = OType.convert((Object)fieldValueAsString, (Class)fieldType.getDefaultJavaType());
                    doc.field(fieldName, fieldValue);
                }
                catch (Exception e) {
                    this.processor.getStats().incrementErrors();
                    this.log(Level.SEVERE, "Error on converting row %d field '%s' (%d), value '%s' (class:%s) to type: %s", csvRecord.getRecordNumber(), fieldName, fieldValueAsString, fieldValueAsString.getClass().getName(), fieldType);
                }
            }
        }
        this.log(Level.FINE, "document=%s", doc);
        ++this.current;
        return new OETLExtractedItem(this.current, doc);
    }

    private Object determineTheType(String fieldStringValue) {
        Object fieldValue = this.transformToDate(fieldStringValue);
        if (fieldValue == null && (fieldValue = this.transformToNumeric(fieldStringValue)) == null && (fieldValue = this.transformToBoolean(fieldStringValue)) == null) {
            fieldValue = fieldStringValue;
        }
        return fieldValue;
    }

    private Object transformToDate(String fieldStringValue) {
        Date fieldValue;
        SimpleDateFormat df = new SimpleDateFormat(this.dateFormat);
        df.setLenient(true);
        try {
            fieldValue = df.parse(fieldStringValue);
        }
        catch (ParseException pe) {
            fieldValue = null;
        }
        return fieldValue;
    }

    private Object transformToDateTime(String fieldStringValue) {
        Date fieldValue;
        SimpleDateFormat df = new SimpleDateFormat(this.dateTimeFormat);
        df.setLenient(true);
        try {
            fieldValue = df.parse(fieldStringValue);
        }
        catch (ParseException pe) {
            fieldValue = null;
        }
        return fieldValue;
    }

    private Object transformToNumeric(String fieldStringValue) {
        Number fieldValue;
        if (fieldStringValue.isEmpty()) {
            return null;
        }
        char c = fieldStringValue.charAt(0);
        if (c != '-' && !Character.isDigit(c)) {
            return null;
        }
        try {
            if (fieldStringValue.contains(".") || fieldStringValue.contains(",")) {
                String numberAsString = fieldStringValue.replaceAll(",", ".");
                fieldValue = new Float(numberAsString);
                if (!this.isFinite((Float)fieldValue)) {
                    fieldValue = new Double(numberAsString);
                }
            } else {
                try {
                    fieldValue = new Integer(fieldStringValue);
                }
                catch (Exception e) {
                    fieldValue = new Long(fieldStringValue);
                }
            }
        }
        catch (NumberFormatException nf) {
            fieldValue = null;
        }
        return fieldValue;
    }

    private Object transformToBoolean(String fieldStringValue) {
        if (fieldStringValue.equalsIgnoreCase(Boolean.FALSE.toString()) || fieldStringValue.equalsIgnoreCase(Boolean.TRUE.toString())) {
            return Boolean.parseBoolean(fieldStringValue);
        }
        return null;
    }

    protected boolean isFinite(Float f) {
        return Math.abs(f.floatValue()) <= Float.MAX_VALUE;
    }

    @Override
    public OETLExtractedItem next() {
        return this.next;
    }
}

