/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.etl;

import com.orientechnologies.common.exception.OException;
import com.orientechnologies.common.io.OIOUtils;
import com.orientechnologies.orient.core.command.OCommandContext;
import com.orientechnologies.orient.core.exception.OConfigurationException;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.etl.OETLComponent;
import com.orientechnologies.orient.etl.OETLComponentFactory;
import com.orientechnologies.orient.etl.OETLProcessor;
import com.orientechnologies.orient.etl.block.OETLBlock;
import com.orientechnologies.orient.etl.context.OETLContext;
import com.orientechnologies.orient.etl.extractor.OETLExtractor;
import com.orientechnologies.orient.etl.loader.OETLLoader;
import com.orientechnologies.orient.etl.source.OETLSource;
import com.orientechnologies.orient.etl.transformer.OETLTransformer;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;

public class OETLProcessorConfigurator {
    private final OETLComponentFactory factory;

    public OETLProcessorConfigurator() {
        this(new OETLComponentFactory());
    }

    public OETLProcessorConfigurator(OETLComponentFactory factory) {
        this.factory = factory;
    }

    protected OCommandContext createDefaultContext() {
        OETLContext context = new OETLContext();
        context.setVariable("dumpEveryMs", 1000);
        return context;
    }

    public OETLProcessor parseConfigAndParameters(String[] args) {
        OCommandContext context = this.createDefaultContext();
        ODocument configuration = new ODocument().fromJSON("{}");
        for (String arg : args) {
            if (arg.startsWith("-")) continue;
            try {
                String config = OIOUtils.readFileAsString((File)new File(arg));
                configuration.merge(new ODocument().fromJSON(config, "noMap"), true, true);
            }
            catch (IOException e) {
                throw OException.wrapException((OException)new OConfigurationException("Error on loading config file: " + arg), (Throwable)e);
            }
        }
        for (String arg : args) {
            if (!arg.startsWith("-")) continue;
            String[] parts = arg.substring(1).split("=");
            context.setVariable(parts[0], (Object)parts[1]);
        }
        return this.parse(configuration, context);
    }

    public OETLProcessor parse(ODocument cfg, OCommandContext context) {
        ODocument cfgGlobal = (ODocument)cfg.field("config");
        if (cfgGlobal != null) {
            for (String f : cfgGlobal.fieldNames()) {
                if (context.getVariable(f) != null) continue;
                context.setVariable(f, cfgGlobal.field(f));
            }
        }
        if (cfg.field("extractor") == null) {
            throw new IllegalArgumentException("No Extractor configured");
        }
        try {
            final List<OETLBlock> beginBlocks = this.configureBeginBlocks(cfg, context);
            final OETLSource source = this.configureSource(cfg, context);
            final OETLExtractor extractor = this.configureExtractor(cfg, context);
            Optional.ofNullable(cfg.field("transformers")).map(c -> c.stream().filter(d -> d.containsField("vertex")).map(d -> (ODocument)d.field("vertex")).filter(d -> d.containsField("skipDuplicates")).map(d -> d.field("skipDuplicates")).map(skip -> ((ODocument)((ODocument)cfg.field("loader")).field(((ODocument)cfg.field("loader")).fieldNames()[0])).field("skipDuplicates", skip)).count());
            final OETLLoader loader = this.configureLoader(cfg, context);
            final List<OETLTransformer> transformers = this.configureTransformers(cfg, context);
            final List<OETLBlock> endBlocks = this.configureEndBlocks(cfg, context);
            OETLProcessor processor = new OETLProcessor(beginBlocks, source, extractor, transformers, loader, endBlocks, context);
            ArrayList<OETLComponent> components = new ArrayList<OETLComponent>(){
                {
                    this.add(source);
                    this.addAll(transformers);
                    this.addAll(beginBlocks);
                    this.addAll(endBlocks);
                    this.add(loader);
                    this.add(extractor);
                }
            };
            components.stream().forEach(c -> c.setProcessor(processor));
            return processor;
        }
        catch (Exception e) {
            throw OException.wrapException((OException)new OConfigurationException("Error on creating ETL processor"), (Throwable)e);
        }
    }

    protected void configureComponent(OETLComponent iComponent, ODocument iCfg, OCommandContext iContext) {
        iComponent.configure(iCfg, iContext);
    }

    private List<OETLBlock> configureEndBlocks(ODocument cfg, OCommandContext iContext) throws IllegalAccessException, InstantiationException {
        ArrayList<OETLBlock> endBlocks = new ArrayList<OETLBlock>();
        Collection endBlocksConf = (Collection)cfg.field("end");
        if (endBlocksConf != null) {
            for (ODocument blockConf : endBlocksConf) {
                String name = blockConf.fieldNames()[0];
                OETLBlock block = this.factory.getBlock(name);
                endBlocks.add(block);
                this.configureComponent(block, (ODocument)blockConf.field(name), iContext);
            }
        }
        return endBlocks;
    }

    private List<OETLTransformer> configureTransformers(ODocument cfg, OCommandContext iContext) throws IllegalAccessException, InstantiationException {
        Collection transformersConf = (Collection)cfg.field("transformers");
        ArrayList<OETLTransformer> transformers = new ArrayList<OETLTransformer>();
        if (transformersConf != null) {
            for (ODocument t : transformersConf) {
                String name = t.fieldNames()[0];
                OETLTransformer tr = this.factory.getTransformer(name);
                transformers.add(tr);
                this.configureComponent(tr, (ODocument)t.field(name), iContext);
            }
        }
        return transformers;
    }

    private OETLLoader configureLoader(ODocument cfg, OCommandContext iContext) throws IllegalAccessException, InstantiationException {
        ODocument loadersConf = (ODocument)cfg.field("loader");
        if (loadersConf != null) {
            String name = loadersConf.fieldNames()[0];
            OETLLoader loader = this.factory.getLoader(name);
            this.configureComponent(loader, (ODocument)loadersConf.field(name), iContext);
            return loader;
        }
        OETLLoader loader = this.factory.getLoader("output");
        this.configureComponent(loader, new ODocument(), iContext);
        return loader;
    }

    private OETLExtractor configureExtractor(ODocument cfg, OCommandContext iContext) throws IllegalAccessException, InstantiationException {
        ODocument extractorConf = (ODocument)cfg.field("extractor");
        String name = extractorConf.fieldNames()[0];
        OETLExtractor extractor = this.factory.getExtractor(name);
        this.configureComponent(extractor, (ODocument)extractorConf.field(name), iContext);
        return extractor;
    }

    private OETLSource configureSource(ODocument cfg, OCommandContext iContext) throws IllegalAccessException, InstantiationException {
        ODocument sourceConf = (ODocument)cfg.field("source");
        if (sourceConf != null) {
            String name = sourceConf.fieldNames()[0];
            OETLSource source = this.factory.getSource(name);
            this.configureComponent(source, (ODocument)sourceConf.field(name), iContext);
            return source;
        }
        OETLSource source = this.factory.getSource("input");
        this.configureComponent(source, new ODocument(), iContext);
        return source;
    }

    private List<OETLBlock> configureBeginBlocks(ODocument cfg, OCommandContext iContext) throws IllegalAccessException, InstantiationException {
        Collection iBeginBlocks = (Collection)cfg.field("begin");
        ArrayList<OETLBlock> blocks = new ArrayList<OETLBlock>();
        if (iBeginBlocks != null) {
            for (ODocument block : iBeginBlocks) {
                String name = block.fieldNames()[0];
                OETLBlock b = this.factory.getBlock(name);
                blocks.add(b);
                this.configureComponent(b, (ODocument)block.field(name), iContext);
                b.execute();
            }
        }
        return blocks;
    }
}

