/*
 * Decompiled with CFR 0.152.
 */
package groovyx.gprof;

import groovyx.gprof.CallInfo;
import groovyx.gprof.ThreadRunInfo;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class CallTree {
    private Node root;

    public CallTree(Thread thread) {
        this.root = new Node(new ThreadRunInfo(thread));
    }

    public void visit(NodeVisitor visitor) {
        visitor.visit(this.root);
        this.root.visit(visitor);
        visitor.exit(this.root);
    }

    public Node getRoot() {
        return this.root;
    }

    public String toString() {
        return this.root.toString();
    }

    public static abstract class NodeVisitor {
        public abstract void visit(Node var1);

        public void exit(Node node) {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Node {
        private CallInfo data;
        private Node parent;
        private List<Node> children = new ArrayList<Node>();

        public Node(CallInfo data) {
            this.data = data;
        }

        public void setParent(Node parent) {
            this.parent = parent;
        }

        public Node getParent() {
            return this.parent;
        }

        public boolean hasParent() {
            return this.parent != null;
        }

        public void addChild(Node child) {
            this.children.add(child);
            child.setParent(this);
        }

        public void removeChild(Node child) {
            this.children.remove(child);
            child.setParent(null);
        }

        public List<Node> getChildren() {
            return Collections.unmodifiableList(this.children);
        }

        public boolean hasChildren() {
            return this.children != null;
        }

        public CallInfo getData() {
            return this.data;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder(String.format("%s", this.data));
            for (Node child : this.getChildren()) {
                sb.append("\n");
                sb.append(String.format("    %s", child));
            }
            return sb.toString();
        }

        public void visit(NodeVisitor visitor) {
            for (Node child : new ArrayList<Node>(this.getChildren())) {
                visitor.visit(child);
                child.visit(visitor);
                visitor.exit(child);
            }
        }
    }
}

