/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.orientdb.traversal.strategy.optimization;

import org.apache.tinkerpop.gremlin.orientdb.traversal.step.sideEffect.OrientGraphStep;
import org.apache.tinkerpop.gremlin.process.traversal.Step;
import org.apache.tinkerpop.gremlin.process.traversal.Traversal;
import org.apache.tinkerpop.gremlin.process.traversal.TraversalStrategy;
import org.apache.tinkerpop.gremlin.process.traversal.step.HasContainerHolder;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.GraphStep;
import org.apache.tinkerpop.gremlin.process.traversal.strategy.AbstractTraversalStrategy;
import org.apache.tinkerpop.gremlin.process.traversal.util.TraversalHelper;

public final class OrientGraphStepStrategy
extends AbstractTraversalStrategy<TraversalStrategy.ProviderOptimizationStrategy>
implements TraversalStrategy.ProviderOptimizationStrategy {
    private static final OrientGraphStepStrategy INSTANCE = new OrientGraphStepStrategy();

    private OrientGraphStepStrategy() {
    }

    public void apply(Traversal.Admin<?, ?> traversal) {
        Step startStep = traversal.getStartStep();
        if (startStep instanceof GraphStep && !(startStep instanceof OrientGraphStep)) {
            GraphStep originalGraphStep = (GraphStep)startStep;
            OrientGraphStep orientGraphStep = new OrientGraphStep(originalGraphStep);
            TraversalHelper.replaceStep((Step)startStep, orientGraphStep, traversal);
            Step currentStep = orientGraphStep.getNextStep();
            while (currentStep instanceof HasContainerHolder) {
                ((HasContainerHolder)currentStep).getHasContainers().forEach(orientGraphStep::addHasContainer);
                currentStep.getLabels().forEach(arg_0 -> orientGraphStep.addLabel(arg_0));
                traversal.removeStep(currentStep);
                currentStep = currentStep.getNextStep();
            }
        }
    }

    public static OrientGraphStepStrategy instance() {
        return INSTANCE;
    }
}

