/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.orientdb.traversal.strategy.optimization;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.function.BiPredicate;
import java.util.stream.Collectors;
import org.apache.tinkerpop.gremlin.orientdb.traversal.step.map.OrientClassCountStep;
import org.apache.tinkerpop.gremlin.orientdb.traversal.step.sideEffect.OrientGraphStep;
import org.apache.tinkerpop.gremlin.orientdb.traversal.strategy.optimization.OrientGraphStepStrategy;
import org.apache.tinkerpop.gremlin.process.traversal.Compare;
import org.apache.tinkerpop.gremlin.process.traversal.Contains;
import org.apache.tinkerpop.gremlin.process.traversal.Step;
import org.apache.tinkerpop.gremlin.process.traversal.Traversal;
import org.apache.tinkerpop.gremlin.process.traversal.TraversalStrategy;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.CountGlobalStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.util.EmptyStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.util.HasContainer;
import org.apache.tinkerpop.gremlin.process.traversal.strategy.AbstractTraversalStrategy;
import org.apache.tinkerpop.gremlin.process.traversal.util.TraversalHelper;

public class OrientGraphCountStrategy
extends AbstractTraversalStrategy<TraversalStrategy.ProviderOptimizationStrategy>
implements TraversalStrategy.ProviderOptimizationStrategy {
    private static final OrientGraphCountStrategy INSTANCE = new OrientGraphCountStrategy();

    private OrientGraphCountStrategy() {
    }

    public void apply(Traversal.Admin<?, ?> traversal) {
        if (!(traversal.getParent() instanceof EmptyStep) || TraversalHelper.onGraphComputer(traversal)) {
            return;
        }
        List steps = traversal.getSteps();
        if (steps.size() < 2) {
            return;
        }
        Step startStep = traversal.getStartStep();
        Step endStep = traversal.getEndStep();
        if (steps.size() == 2 && startStep instanceof OrientGraphStep && endStep instanceof CountGlobalStep) {
            OrientGraphStep step = (OrientGraphStep)startStep;
            if (step.getHasContainers().size() == 1) {
                List<HasContainer> hasContainers = step.getHasContainers();
                List<String> classes = hasContainers.stream().filter(this::isLabelFilter).map(this::extractLabels).flatMap(s -> s.stream()).collect(Collectors.toList());
                if (classes.size() > 0) {
                    TraversalHelper.removeAllSteps(traversal);
                    traversal.addStep(new OrientClassCountStep(traversal, classes, step.isVertexStep()));
                }
            } else if (step.getHasContainers().size() == 0) {
                TraversalHelper.removeAllSteps(traversal);
                String baseClass = step.isVertexStep() ? "V" : "E";
                traversal.addStep(new OrientClassCountStep(traversal, Collections.singletonList(baseClass), step.isVertexStep()));
            }
        }
    }

    protected boolean isLabelFilter(HasContainer f) {
        boolean labelFilter = f.getKey().equals("~label");
        BiPredicate predicate = f.getBiPredicate();
        if (predicate instanceof Compare) {
            return labelFilter && Compare.eq.equals((Object)predicate);
        }
        if (predicate instanceof Contains) {
            return labelFilter && Contains.within.equals((Object)predicate);
        }
        return false;
    }

    protected List<String> extractLabels(HasContainer f) {
        Object value = f.getValue();
        ArrayList<String> classLabels = new ArrayList<String>();
        if (value instanceof List) {
            ((List)value).forEach(label -> classLabels.add((String)label));
        } else {
            classLabels.add((String)value);
        }
        return classLabels;
    }

    public Set<Class<? extends TraversalStrategy.ProviderOptimizationStrategy>> applyPrior() {
        return Collections.singleton(OrientGraphStepStrategy.class);
    }

    public static OrientGraphCountStrategy instance() {
        return INSTANCE;
    }
}

