/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.orientdb.executor;

import com.orientechnologies.common.exception.OException;
import com.orientechnologies.orient.core.command.script.transformer.OScriptTransformer;
import com.orientechnologies.orient.core.exception.OCommandExecutionException;
import com.orientechnologies.orient.core.sql.executor.OExecutionPlan;
import com.orientechnologies.orient.core.sql.executor.OResult;
import com.orientechnologies.orient.core.sql.executor.OResultSet;
import java.util.Map;
import java.util.Optional;
import org.apache.tinkerpop.gremlin.orientdb.OrientGraph;
import org.apache.tinkerpop.gremlin.process.traversal.Traversal;

public class OGremlinScriptResultSet
implements OResultSet {
    protected Traversal traversal;
    private OScriptTransformer transformer;
    private boolean closeGraph;
    private boolean closing = false;

    public OGremlinScriptResultSet(Traversal traversal, OScriptTransformer transformer) {
        this(traversal, transformer, false);
    }

    public OGremlinScriptResultSet(Traversal traversal, OScriptTransformer transformer, boolean closeGraph) {
        this.traversal = traversal;
        this.transformer = transformer;
        this.closeGraph = closeGraph;
    }

    public boolean hasNext() {
        return this.traversal.hasNext();
    }

    public OResult next() {
        Object next = this.traversal.next();
        return this.transformer.toResult(next);
    }

    public void close() {
        try {
            this.traversal.close();
            if (this.closeGraph) {
                this.traversal.asAdmin().getGraph().ifPresent(graph -> {
                    try {
                        OrientGraph g = (OrientGraph)graph;
                        if (!this.closing) {
                            this.closing = true;
                            g.close();
                        }
                    }
                    catch (Exception e) {
                        throw OException.wrapException((OException)new OCommandExecutionException("Error closing the Graph "), (Throwable)e);
                    }
                });
            }
        }
        catch (Exception e) {
            throw OException.wrapException((OException)new OCommandExecutionException("Error closing the gremlin Result Set"), (Throwable)e);
        }
    }

    public Optional<OExecutionPlan> getExecutionPlan() {
        return Optional.empty();
    }

    public Map<String, Long> getQueryStats() {
        return null;
    }
}

