/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.orientdb;

import com.orientechnologies.orient.core.db.ODatabase;
import com.orientechnologies.orient.core.db.document.ODatabaseDocumentEmbedded;
import java.util.function.Consumer;
import org.apache.tinkerpop.gremlin.orientdb.OrientStandardGraph;
import org.apache.tinkerpop.gremlin.orientdb.OrientTransaction;
import org.apache.tinkerpop.gremlin.structure.Graph;
import org.apache.tinkerpop.gremlin.structure.Transaction;
import org.apache.tinkerpop.gremlin.structure.util.AbstractTransaction;
import org.apache.tinkerpop.gremlin.structure.util.TransactionException;

public class OrientStandardTransaction
extends AbstractTransaction {
    private OrientStandardGraph g;

    public OrientStandardTransaction(OrientStandardGraph graph) {
        super((Graph)graph);
        this.g = graph;
    }

    protected void doOpen() {
        this.tx().doOpen();
    }

    protected void doCommit() throws TransactionException {
        this.tx().doCommit();
        ODatabaseDocumentEmbedded db = (ODatabaseDocumentEmbedded)this.g.graph().getRawDatabase();
        db.internalClose(true);
        db.activateOnCurrentThread();
        db.setStatus(ODatabase.STATUS.OPEN);
    }

    protected void doRollback() throws TransactionException {
        this.tx().doRollback();
        ODatabaseDocumentEmbedded db = (ODatabaseDocumentEmbedded)this.g.graph().getRawDatabase();
        db.internalClose(true);
        db.activateOnCurrentThread();
        db.setStatus(ODatabase.STATUS.OPEN);
    }

    protected void fireOnCommit() {
        this.tx().fireOnCommit();
    }

    protected void fireOnRollback() {
        this.tx().fireOnRollback();
    }

    protected void doReadWrite() {
        this.tx().doReadWrite();
    }

    protected void doClose() {
        this.tx().doClose();
    }

    public Transaction onReadWrite(Consumer<Transaction> consumer) {
        return this.tx().onReadWrite(consumer);
    }

    public Transaction onClose(Consumer<Transaction> consumer) {
        return this.tx().onClose(consumer);
    }

    public void addTransactionListener(Consumer<Transaction.Status> listener) {
        this.tx().addTransactionListener(listener);
    }

    public void removeTransactionListener(Consumer<Transaction.Status> listener) {
        this.tx().removeTransactionListener(listener);
    }

    public void clearTransactionListeners() {
        this.tx().clearTransactionListeners();
    }

    public boolean isOpen() {
        return this.tx().isOpen();
    }

    private OrientTransaction tx() {
        return this.g.graph().tx();
    }
}

