/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.orientdb;

import com.orientechnologies.common.log.OLogManager;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import org.apache.tinkerpop.gremlin.orientdb.OGraph;
import org.apache.tinkerpop.gremlin.orientdb.OrientGraphBaseQuery;
import org.apache.tinkerpop.gremlin.orientdb.OrientGraphEmptyQuery;
import org.apache.tinkerpop.gremlin.orientdb.OrientGraphQuery;
import org.apache.tinkerpop.gremlin.process.traversal.Compare;
import org.apache.tinkerpop.gremlin.process.traversal.Contains;
import org.apache.tinkerpop.gremlin.process.traversal.P;
import org.apache.tinkerpop.gremlin.process.traversal.step.util.HasContainer;
import org.apache.tinkerpop.gremlin.structure.T;

public class OrientGraphQueryBuilder {
    private final boolean vertexStep;
    private List<String> classes = new ArrayList<String>();
    private Map<String, P<?>> params = new LinkedHashMap();

    public OrientGraphQueryBuilder(boolean vertexStep) {
        this.vertexStep = vertexStep;
    }

    public OrientGraphQueryBuilder addCondition(HasContainer condition) {
        if (this.isLabelKey(condition.getKey())) {
            Object value = condition.getValue();
            if (value instanceof List) {
                ((List)value).forEach(label -> this.classes.add((String)label));
            } else {
                this.classes.add((String)value);
            }
        } else {
            this.params.put(condition.getKey(), condition.getPredicate());
        }
        return this;
    }

    public Optional<OrientGraphBaseQuery> build(OGraph graph) {
        if (this.classes.size() == 0) {
            this.classes.add(this.vertexStep ? "V" : "E");
        } else {
            this.classes = this.classes.stream().filter(graph::existClass).collect(Collectors.toList());
            if (this.classes.size() == 0) {
                return Optional.of(new OrientGraphEmptyQuery());
            }
        }
        try {
            StringBuilder builder = new StringBuilder();
            HashMap<String, Object> parameters = new HashMap<String, Object>();
            String whereCondition = this.fillParameters(parameters);
            if (this.classes.size() > 1) {
                builder.append("SELECT expand($union) ");
                String lets = this.classes.stream().map(s -> this.buildLetStatement(this.buildSingleQuery((String)s, whereCondition), this.classes.indexOf(s))).reduce("", (a, b) -> a.isEmpty() ? b : a + " , " + b);
                builder.append(String.format("%s , $union = UNIONALL(%s)", lets, this.buildVariables(this.classes.size())));
            } else {
                builder.append(this.buildSingleQuery(this.classes.get(0), whereCondition));
            }
            return Optional.of(new OrientGraphQuery(builder.toString(), parameters, this.classes.size()));
        }
        catch (UnsupportedOperationException e) {
            OLogManager.instance().debug((Object)this, "Cannot generate a query from the traversal", (Throwable)e, new Object[0]);
            return Optional.empty();
        }
    }

    private String fillParameters(Map<String, Object> parameters) {
        StringBuilder whereBuilder = new StringBuilder();
        if (this.params.size() > 0) {
            whereBuilder.append(" WHERE ");
            boolean[] first = new boolean[]{true};
            AtomicInteger paramNum = new AtomicInteger();
            this.params.entrySet().forEach(e -> {
                String param = "param" + paramNum.getAndIncrement();
                String cond = this.formatCondition((String)e.getKey(), param, (P)e.getValue());
                if (first[0]) {
                    whereBuilder.append(" " + cond);
                    first[0] = false;
                } else {
                    whereBuilder.append(" AND " + cond);
                }
                parameters.put(param, ((P)e.getValue()).getValue());
            });
        }
        return whereBuilder.toString();
    }

    private String buildVariables(int size) {
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < this.classes.size(); ++i) {
            builder.append(String.format("$q%d", i));
            if (i >= this.classes.size() - 1) continue;
            builder.append(String.format(",", i));
        }
        return builder.toString();
    }

    protected String buildLetStatement(String query, int idx) {
        StringBuilder builder = new StringBuilder();
        if (idx == 0) {
            builder.append("LET ");
        }
        builder.append(String.format("$q%d = (%s)", idx, query));
        return builder.toString();
    }

    protected String buildSingleQuery(String clazz, String whereCondition) {
        return String.format("SELECT FROM `%s` %s", clazz, whereCondition);
    }

    private String formatCondition(String field, String param, P<?> predicate) {
        if (T.id.getAccessor().equalsIgnoreCase(field)) {
            return String.format(" %s %s :%s", "@rid", this.formatPredicate(predicate), param);
        }
        return String.format(" `%s` %s :%s", field, this.formatPredicate(predicate), param);
    }

    private String formatPredicate(P<?> cond) {
        if (cond.getBiPredicate() instanceof Compare) {
            Compare compare = (Compare)cond.getBiPredicate();
            String condition = null;
            switch (compare) {
                case eq: {
                    condition = "=";
                    break;
                }
                case gt: {
                    condition = ">";
                    break;
                }
                case gte: {
                    condition = ">=";
                    break;
                }
                case lt: {
                    condition = "<";
                    break;
                }
                case lte: {
                    condition = "<=";
                    break;
                }
                case neq: {
                    condition = "<>";
                }
            }
            return condition;
        }
        if (cond.getBiPredicate() instanceof Contains) {
            Contains contains = (Contains)cond.getBiPredicate();
            String condition = null;
            switch (contains) {
                case within: {
                    condition = "IN";
                    break;
                }
                case without: {
                    condition = "NOT IN";
                }
            }
            return condition;
        }
        throw new UnsupportedOperationException(String.format("Predicate %s not supported!", cond.toString()));
    }

    private boolean isLabelKey(String key) {
        try {
            return T.fromString((String)key) == T.label;
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }
}

