/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.algorithm.generator;

import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.configuration.Configuration;
import org.apache.tinkerpop.gremlin.AbstractGremlinTest;
import org.apache.tinkerpop.gremlin.FeatureRequirement;
import org.apache.tinkerpop.gremlin.FeatureRequirementSet;
import org.apache.tinkerpop.gremlin.algorithm.generator.AbstractGeneratorTest;
import org.apache.tinkerpop.gremlin.algorithm.generator.Distribution;
import org.apache.tinkerpop.gremlin.algorithm.generator.DistributionGenerator;
import org.apache.tinkerpop.gremlin.algorithm.generator.NormalDistribution;
import org.apache.tinkerpop.gremlin.algorithm.generator.PowerLawDistribution;
import org.apache.tinkerpop.gremlin.structure.Graph;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.apache.tinkerpop.gremlin.util.iterator.IteratorUtils;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.runners.Enclosed;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Enclosed.class)
public class DistributionGeneratorTest {

    public static class ProcessorTest
    extends AbstractGremlinTest {
        private static final int numberOfVertices = 100;

        @Test
        @FeatureRequirementSet(value=FeatureRequirementSet.Package.SIMPLE)
        @FeatureRequirement(featureClass=Graph.Features.VertexPropertyFeatures.class, feature="IntegerValues")
        public void shouldProcessEdges() {
            NormalDistribution dist = new NormalDistribution(2.0);
            DistributionGenerator generator = ((DistributionGenerator.Builder)((DistributionGenerator.Builder)DistributionGenerator.build(this.graph).label("knows")).edgeProcessor(e -> e.property("data", (Object)"test"))).outDistribution(dist).inDistribution(dist).expectedNumEdges(100).create();
            int edgesGenerated = generator.generate();
            Assert.assertTrue((edgesGenerated > 0 ? 1 : 0) != 0);
            this.tryCommit(this.graph, g -> {
                Assert.assertEquals((Object)new Long(edgesGenerated), (Object)new Long(IteratorUtils.count((Iterator)g.edges(new Object[0]))));
                Assert.assertTrue((IteratorUtils.count((Iterator)g.vertices(new Object[0])) > 0L ? 1 : 0) != 0);
                Assert.assertTrue((boolean)IteratorUtils.stream((Iterator)g.edges(new Object[0])).allMatch(e -> e.value("data").equals("test")));
            });
        }

        @Override
        protected void afterLoadGraphWith(Graph graph) throws Exception {
            int numNodes = 100;
            for (int i = 0; i < 100; ++i) {
                graph.addVertex(new Object[]{"oid", i});
            }
            this.tryCommit(graph);
        }
    }

    @RunWith(value=Parameterized.class)
    public static class DifferentDistributionsTest
    extends AbstractGeneratorTest {
        @Parameterized.Parameter(value=0)
        public Distribution inDistribution;
        @Parameterized.Parameter(value=1)
        public Distribution outDistribution;
        private static final int numberOfVertices = 100;

        @Parameterized.Parameters(name="test({0},{1})")
        public static Iterable<Object[]> data() {
            return Arrays.asList({new NormalDistribution(2.0), new NormalDistribution(2.0)}, {new NormalDistribution(2.0), new NormalDistribution(5.0)}, {new PowerLawDistribution(2.1), new PowerLawDistribution(2.1)}, {new PowerLawDistribution(2.9), new PowerLawDistribution(2.9)}, {new PowerLawDistribution(3.9), new PowerLawDistribution(3.9)}, {new PowerLawDistribution(2.3), new PowerLawDistribution(2.8)});
        }

        @Test
        @FeatureRequirementSet(value=FeatureRequirementSet.Package.SIMPLE)
        @FeatureRequirement(featureClass=Graph.Features.VertexPropertyFeatures.class, feature="IntegerValues")
        public void shouldGenerateDifferentGraph() throws Exception {
            int executions = 0;
            boolean same = true;
            do {
                Configuration configuration1 = this.graphProvider.newGraphConfiguration("g1", this.getClass(), this.name.getMethodName(), null);
                Graph g1 = this.graphProvider.openTestGraph(configuration1);
                Configuration configuration2 = this.graphProvider.newGraphConfiguration("g2", this.getClass(), this.name.getMethodName(), null);
                Graph g2 = this.graphProvider.openTestGraph(configuration2);
                try {
                    this.afterLoadGraphWith(g1);
                    DistributionGenerator generator = ((DistributionGenerator.Builder)this.makeGenerator(g1).seedGenerator(() -> 123456789L)).create();
                    this.distributionGeneratorTest(g1, generator);
                    this.afterLoadGraphWith(g2);
                    DistributionGenerator generator1 = ((DistributionGenerator.Builder)this.makeGenerator(g2).seedGenerator(() -> 987654321L)).create();
                    this.distributionGeneratorTest(g2, generator1);
                    same = this.same(g1, g2);
                }
                catch (Exception ex) {
                    throw ex;
                }
                finally {
                    this.graphProvider.clear(g1, configuration1);
                    this.graphProvider.clear(g2, configuration2);
                    ++executions;
                }
            } while (same || executions < 5);
        }

        private DistributionGenerator.Builder makeGenerator(Graph g) {
            return ((DistributionGenerator.Builder)DistributionGenerator.build(g).label("knows")).outDistribution(this.outDistribution).inDistribution(this.inDistribution).expectedNumEdges(1000);
        }

        @Test
        @FeatureRequirementSet(value=FeatureRequirementSet.Package.SIMPLE)
        @FeatureRequirement(featureClass=Graph.Features.VertexPropertyFeatures.class, feature="IntegerValues")
        public void shouldGenerateSameGraph() throws Exception {
            Configuration configuration = this.graphProvider.newGraphConfiguration("g1", this.getClass(), this.name.getMethodName(), null);
            Graph g1 = this.graphProvider.openTestGraph(configuration);
            try {
                Iterable<Vertex> vordered = this.verticesByOid(this.graph);
                DistributionGenerator generator = ((DistributionGenerator.Builder)this.makeGenerator(this.graph).seedGenerator(() -> 123456789L)).inVertices(vordered).outVertices(vordered).create();
                this.distributionGeneratorTest(this.graph, generator);
                this.afterLoadGraphWith(g1);
                Iterable<Vertex> vordered1 = this.verticesByOid(g1);
                DistributionGenerator generator1 = ((DistributionGenerator.Builder)this.makeGenerator(g1).seedGenerator(() -> 123456789L)).inVertices(vordered1).outVertices(vordered1).create();
                this.distributionGeneratorTest(g1, generator1);
                Assert.assertTrue((boolean)this.same(this.graph, g1));
            }
            catch (Exception ex) {
                throw ex;
            }
            finally {
                this.graphProvider.clear(g1, configuration);
            }
        }

        @Override
        protected void afterLoadGraphWith(Graph graph) throws Exception {
            int numNodes = 100;
            for (int i = 0; i < 100; ++i) {
                graph.addVertex(new Object[]{"oid", i});
            }
            this.tryCommit(graph);
        }

        protected Iterable<Vertex> verticesByOid(Graph graph) {
            List vertices = IteratorUtils.list((Iterator)graph.vertices(new Object[0]));
            Collections.sort(vertices, (v1, v2) -> ((Integer)v1.value("oid")).compareTo((Integer)v2.value("oid")));
            return vertices;
        }

        private void distributionGeneratorTest(Graph graph, DistributionGenerator generator) {
            int numEdges = generator.generate();
            Assert.assertTrue((numEdges > 0 ? 1 : 0) != 0);
            this.tryCommit(graph, g -> Assert.assertEquals((long)numEdges, (long)IteratorUtils.count((Iterator)g.edges(new Object[0]))));
        }
    }
}

