/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.structure.io.graphson;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.tinkerpop.gremlin.structure.io.graphson.TypeInfo;
import org.apache.tinkerpop.shaded.jackson.annotation.JsonTypeInfo;
import org.apache.tinkerpop.shaded.jackson.core.JsonGenerator;
import org.apache.tinkerpop.shaded.jackson.databind.BeanProperty;
import org.apache.tinkerpop.shaded.jackson.databind.jsontype.TypeIdResolver;
import org.apache.tinkerpop.shaded.jackson.databind.jsontype.TypeSerializer;

public abstract class AbstractGraphSONTypeSerializer
extends TypeSerializer {
    protected final TypeIdResolver idRes;
    protected final String propertyName;
    protected final TypeInfo typeInfo;
    protected final String valuePropertyName;
    protected final Map<Class, Class> classMap = new HashMap<Class, Class>();

    AbstractGraphSONTypeSerializer(TypeIdResolver idRes, String propertyName, TypeInfo typeInfo, String valuePropertyName) {
        this.idRes = idRes;
        this.propertyName = propertyName;
        this.typeInfo = typeInfo;
        this.valuePropertyName = valuePropertyName;
    }

    public TypeSerializer forProperty(BeanProperty beanProperty) {
        return this;
    }

    public JsonTypeInfo.As getTypeInclusion() {
        return null;
    }

    public String getPropertyName() {
        return this.propertyName;
    }

    public TypeIdResolver getTypeIdResolver() {
        return this.idRes;
    }

    public void writeTypePrefixForScalar(Object o, JsonGenerator jsonGenerator) throws IOException {
        if (this.canWriteTypeId()) {
            this.writeTypePrefix(jsonGenerator, this.getTypeIdResolver().idFromValueAndType(o, this.getClassFromObject(o)));
        }
    }

    public void writeTypePrefixForObject(Object o, JsonGenerator jsonGenerator) throws IOException {
        jsonGenerator.writeStartObject();
    }

    public void writeTypePrefixForArray(Object o, JsonGenerator jsonGenerator) throws IOException {
        jsonGenerator.writeStartArray();
    }

    public void writeTypeSuffixForScalar(Object o, JsonGenerator jsonGenerator) throws IOException {
        if (this.canWriteTypeId()) {
            this.writeTypeSuffix(jsonGenerator);
        }
    }

    public void writeTypeSuffixForObject(Object o, JsonGenerator jsonGenerator) throws IOException {
        jsonGenerator.writeEndObject();
    }

    public void writeTypeSuffixForArray(Object o, JsonGenerator jsonGenerator) throws IOException {
        jsonGenerator.writeEndArray();
    }

    public void writeCustomTypePrefixForScalar(Object o, JsonGenerator jsonGenerator, String s) throws IOException {
        if (this.canWriteTypeId()) {
            this.writeTypePrefix(jsonGenerator, s);
        }
    }

    public void writeCustomTypePrefixForObject(Object o, JsonGenerator jsonGenerator, String s) throws IOException {
        jsonGenerator.writeStartObject();
    }

    public void writeCustomTypePrefixForArray(Object o, JsonGenerator jsonGenerator, String s) throws IOException {
        jsonGenerator.writeStartArray();
    }

    public void writeCustomTypeSuffixForScalar(Object o, JsonGenerator jsonGenerator, String s) throws IOException {
        if (this.canWriteTypeId()) {
            this.writeTypeSuffix(jsonGenerator);
        }
    }

    public void writeCustomTypeSuffixForObject(Object o, JsonGenerator jsonGenerator, String s) throws IOException {
        jsonGenerator.writeEndObject();
    }

    public void writeCustomTypeSuffixForArray(Object o, JsonGenerator jsonGenerator, String s) throws IOException {
        jsonGenerator.writeEndArray();
    }

    protected boolean canWriteTypeId() {
        return this.typeInfo != null && this.typeInfo == TypeInfo.PARTIAL_TYPES;
    }

    protected void writeTypePrefix(JsonGenerator jsonGenerator, String s) throws IOException {
        jsonGenerator.writeStartObject();
        jsonGenerator.writeStringField(this.getPropertyName(), s);
        jsonGenerator.writeFieldName(this.valuePropertyName);
    }

    protected void writeTypeSuffix(JsonGenerator jsonGenerator) throws IOException {
        jsonGenerator.writeEndObject();
    }

    protected abstract Class getClassFromObject(Object var1);
}

