/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.structure.io;

import org.apache.tinkerpop.gremlin.structure.io.Io;
import org.apache.tinkerpop.gremlin.structure.io.graphml.GraphMLIo;
import org.apache.tinkerpop.gremlin.structure.io.graphson.GraphSONIo;
import org.apache.tinkerpop.gremlin.structure.io.gryo.GryoIo;

public final class IoCore {
    private IoCore() {
    }

    public static Io.Builder<GraphMLIo> graphml() {
        return GraphMLIo.build();
    }

    public static Io.Builder<GraphSONIo> graphson() {
        return GraphSONIo.build();
    }

    public static Io.Builder<GryoIo> gryo() {
        return GryoIo.build();
    }

    public static Io.Builder createIoBuilder(String graphFormat) throws ClassNotFoundException, IllegalAccessException, InstantiationException {
        Class<?> ioBuilderClass = Class.forName(graphFormat);
        Io.Builder ioBuilder = (Io.Builder)ioBuilderClass.newInstance();
        return ioBuilder;
    }
}

