/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.structure.io;

import java.io.IOException;
import java.util.function.Consumer;
import org.apache.tinkerpop.gremlin.structure.Graph;
import org.apache.tinkerpop.gremlin.structure.io.GraphReader;
import org.apache.tinkerpop.gremlin.structure.io.GraphWriter;
import org.apache.tinkerpop.gremlin.structure.io.Mapper;

public interface Io<R extends GraphReader.ReaderBuilder, W extends GraphWriter.WriterBuilder, M extends Mapper.Builder> {
    public R reader();

    public W writer();

    public M mapper();

    public void writeGraph(String var1) throws IOException;

    public void readGraph(String var1) throws IOException;

    public static interface Builder<I extends Io> {
        public Builder<? extends Io> onMapper(Consumer<Mapper.Builder> var1);

        public Builder<? extends Io> graph(Graph var1);

        public I create();
    }

    public static class Exceptions {
        public static UnsupportedOperationException readerFormatIsForFullGraphSerializationOnly(Class<? extends GraphReader> clazz) {
            return new UnsupportedOperationException(String.format("%s only reads an entire Graph", clazz));
        }

        public static UnsupportedOperationException writerFormatIsForFullGraphSerializationOnly(Class<? extends GraphWriter> clazz) {
            return new UnsupportedOperationException(String.format("%s only writes an entire Graph", clazz));
        }
    }
}

