/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.process.traversal.strategy.optimization;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.tinkerpop.gremlin.process.computer.traversal.step.map.VertexProgramStep;
import org.apache.tinkerpop.gremlin.process.traversal.Step;
import org.apache.tinkerpop.gremlin.process.traversal.Traversal;
import org.apache.tinkerpop.gremlin.process.traversal.TraversalStrategy;
import org.apache.tinkerpop.gremlin.process.traversal.step.Barrier;
import org.apache.tinkerpop.gremlin.process.traversal.step.LambdaHolder;
import org.apache.tinkerpop.gremlin.process.traversal.step.PathProcessor;
import org.apache.tinkerpop.gremlin.process.traversal.step.TraversalParent;
import org.apache.tinkerpop.gremlin.process.traversal.step.branch.RepeatStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.filter.DedupGlobalStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.filter.FilterStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.MatchStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.NoOpBarrierStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.SelectOneStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.util.EmptyStep;
import org.apache.tinkerpop.gremlin.process.traversal.strategy.AbstractTraversalStrategy;
import org.apache.tinkerpop.gremlin.process.traversal.strategy.optimization.MatchPredicateStrategy;
import org.apache.tinkerpop.gremlin.process.traversal.strategy.optimization.PathProcessorStrategy;
import org.apache.tinkerpop.gremlin.process.traversal.strategy.optimization.RepeatUnrollStrategy;
import org.apache.tinkerpop.gremlin.process.traversal.traverser.TraverserRequirement;
import org.apache.tinkerpop.gremlin.process.traversal.util.PathUtil;
import org.apache.tinkerpop.gremlin.process.traversal.util.TraversalHelper;
import org.apache.tinkerpop.gremlin.structure.Graph;
import org.javatuples.Pair;

public final class PathRetractionStrategy
extends AbstractTraversalStrategy<TraversalStrategy.OptimizationStrategy>
implements TraversalStrategy.OptimizationStrategy {
    public static Integer MAX_BARRIER_SIZE = 2500;
    private static final PathRetractionStrategy INSTANCE = new PathRetractionStrategy(MAX_BARRIER_SIZE);
    private static final Set<Class<? extends TraversalStrategy.OptimizationStrategy>> PRIORS = new HashSet<Class>(Arrays.asList(RepeatUnrollStrategy.class, MatchPredicateStrategy.class, PathProcessorStrategy.class));
    private static final String MARKER = Graph.Hidden.hide("gremlin.pathRetraction");
    private final int standardBarrierSize;

    private PathRetractionStrategy(int standardBarrierSize) {
        this.standardBarrierSize = standardBarrierSize;
    }

    public static PathRetractionStrategy instance() {
        return INSTANCE;
    }

    @Override
    public void apply(Traversal.Admin<?, ?> traversal) {
        if (traversal.getParent() instanceof EmptyStep && TraversalHelper.anyStepRecursively(step -> step instanceof LambdaHolder || step.getRequirements().contains((Object)TraverserRequirement.PATH) || step instanceof VertexProgramStep && step.getRequirements().contains((Object)TraverserRequirement.LABELED_PATH), traversal)) {
            TraversalHelper.applyTraversalRecursively(t -> t.getEndStep().addLabel(MARKER), traversal);
        }
        if (traversal.getEndStep().getLabels().contains(MARKER)) {
            traversal.getEndStep().removeLabel(MARKER);
            return;
        }
        boolean onGraphComputer = TraversalHelper.onGraphComputer(traversal);
        HashSet<String> foundLabels = new HashSet<String>();
        HashSet<String> keepLabels = new HashSet<String>();
        List<Step> steps = traversal.getSteps();
        for (int i = steps.size() - 1; i >= 0; --i) {
            Step currentStep = steps.get(i);
            keepLabels.addAll(foundLabels);
            Set<String> labels = PathUtil.getReferencedLabels(currentStep);
            for (String label : labels) {
                if (foundLabels.contains(label)) {
                    keepLabels.add(label);
                    continue;
                }
                foundLabels.add(label);
            }
            if (!(currentStep instanceof PathProcessor)) continue;
            PathProcessor pathProcessor = (PathProcessor)((Object)currentStep);
            if (currentStep instanceof MatchStep && (currentStep.getNextStep().equals(EmptyStep.instance()) || currentStep.getNextStep() instanceof DedupGlobalStep || currentStep.getNextStep() instanceof SelectOneStep && currentStep.getNextStep().getNextStep() instanceof FilterStep)) {
                pathProcessor.setKeepLabels(((MatchStep)currentStep).getMatchStartLabels());
                pathProcessor.getKeepLabels().addAll(((MatchStep)currentStep).getMatchEndLabels());
            } else if (pathProcessor.getKeepLabels() == null) {
                pathProcessor.setKeepLabels(new HashSet<String>(keepLabels));
            } else {
                pathProcessor.getKeepLabels().addAll(new HashSet(keepLabels));
            }
            if (currentStep.getTraversal().getParent() instanceof MatchStep) {
                pathProcessor.setKeepLabels(((MatchStep)currentStep.getTraversal().getParent().asStep()).getMatchStartLabels());
                pathProcessor.getKeepLabels().addAll(((MatchStep)currentStep.getTraversal().getParent().asStep()).getMatchEndLabels());
            }
            if (onGraphComputer || currentStep instanceof MatchStep || currentStep instanceof Barrier || currentStep.getNextStep() instanceof Barrier || currentStep.getTraversal().getParent() instanceof MatchStep || currentStep.getNextStep() instanceof EmptyStep) continue;
            TraversalHelper.insertAfterStep(new NoOpBarrierStep(traversal, this.standardBarrierSize), currentStep, traversal);
        }
        keepLabels.addAll(foundLabels);
        Step<?, ?> parent = traversal.getParent().asStep();
        ArrayList<Pair> parentKeeperPairs = new ArrayList<Pair>();
        while (!parent.equals(EmptyStep.instance())) {
            HashSet<String> parentKeepLabels = new HashSet<String>(PathUtil.getReferencedLabels(parent));
            parentKeepLabels.addAll(PathUtil.getReferencedLabelsAfterStep(parent));
            parentKeeperPairs.add(new Pair(parent, parentKeepLabels));
            parent = parent.getTraversal().getParent().asStep();
        }
        Collections.reverse(parentKeeperPairs);
        boolean hasRepeat = false;
        HashSet keeperTrail = new HashSet();
        for (Pair pair : parentKeeperPairs) {
            ArrayList<Traversal.Admin<Object, Object>> children;
            Step<Object, Object> step2 = (Step)pair.getValue0();
            Set levelLabels = (Set)pair.getValue1();
            if (step2 instanceof RepeatStep) {
                hasRepeat = true;
            }
            if (step2 instanceof TraversalParent) {
                children = new ArrayList<Traversal.Admin<Object, Object>>();
                children.addAll(((TraversalParent)((Object)step2)).getGlobalChildren());
                children.addAll(((TraversalParent)((Object)step2)).getLocalChildren());
                if (children.size() > 1) {
                    this.applyToChildren(keepLabels, children);
                }
            }
            step2 = step2.getPreviousStep();
            while (!step2.equals(EmptyStep.instance())) {
                if (step2 instanceof PathProcessor) {
                    this.addLabels((PathProcessor)((Object)step2), keepLabels);
                }
                if (step2 instanceof TraversalParent) {
                    children = new ArrayList();
                    children.addAll(((TraversalParent)((Object)step2)).getGlobalChildren());
                    children.addAll(((TraversalParent)((Object)step2)).getLocalChildren());
                    this.applyToChildren(keepLabels, children);
                }
                step2 = step2.getPreviousStep();
            }
            while (!step2.equals(EmptyStep.instance())) {
                if (step2 instanceof PathProcessor) {
                    Set<String> referencedLabels = PathUtil.getReferencedLabelsAfterStep(step2);
                    for (String ref : referencedLabels) {
                        if (!levelLabels.contains(ref)) continue;
                        if (((PathProcessor)((Object)step2)).getKeepLabels() == null) {
                            HashSet<String> newKeepLabels = new HashSet<String>();
                            newKeepLabels.add(ref);
                            ((PathProcessor)((Object)step2)).setKeepLabels(newKeepLabels);
                            continue;
                        }
                        ((PathProcessor)((Object)step2)).getKeepLabels().addAll(Collections.singleton(ref));
                    }
                }
                step2 = step2.getNextStep();
            }
            keeperTrail.addAll(levelLabels);
        }
        for (Step currentStep : traversal.getSteps()) {
            if (!(currentStep instanceof PathProcessor)) continue;
            ((PathProcessor)((Object)currentStep)).getKeepLabels().addAll(keeperTrail);
            if (!hasRepeat) continue;
            ((PathProcessor)((Object)currentStep)).getKeepLabels().addAll(keepLabels);
        }
    }

    private void applyToChildren(Set<String> keepLabels, List<Traversal.Admin<Object, Object>> children) {
        for (Traversal.Admin<Object, Object> child : children) {
            TraversalHelper.applyTraversalRecursively(trav -> this.addLabels((Traversal.Admin)trav, keepLabels), child);
        }
    }

    private void addLabels(Traversal.Admin traversal, Set<String> keepLabels) {
        for (Step s : traversal.getSteps()) {
            if (!(s instanceof PathProcessor)) continue;
            this.addLabels((PathProcessor)((Object)s), keepLabels);
        }
    }

    private void addLabels(PathProcessor s, Set<String> keepLabels) {
        if (null == s.getKeepLabels()) {
            s.setKeepLabels(new HashSet<String>(keepLabels));
        } else {
            s.getKeepLabels().addAll(new HashSet<String>(keepLabels));
        }
    }

    @Override
    public Set<Class<? extends TraversalStrategy.OptimizationStrategy>> applyPrior() {
        return PRIORS;
    }
}

