/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.process.traversal.strategy.optimization;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.apache.tinkerpop.gremlin.process.computer.traversal.step.map.VertexProgramStep;
import org.apache.tinkerpop.gremlin.process.traversal.Step;
import org.apache.tinkerpop.gremlin.process.traversal.Traversal;
import org.apache.tinkerpop.gremlin.process.traversal.TraversalStrategy;
import org.apache.tinkerpop.gremlin.process.traversal.step.LambdaHolder;
import org.apache.tinkerpop.gremlin.process.traversal.step.filter.PathFilterStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.EdgeOtherVertexStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.EdgeVertexStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.PathStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.TreeStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.VertexStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.sideEffect.TreeSideEffectStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.util.EmptyStep;
import org.apache.tinkerpop.gremlin.process.traversal.strategy.AbstractTraversalStrategy;
import org.apache.tinkerpop.gremlin.process.traversal.strategy.optimization.IdentityRemovalStrategy;
import org.apache.tinkerpop.gremlin.process.traversal.util.TraversalHelper;
import org.apache.tinkerpop.gremlin.structure.Direction;
import org.apache.tinkerpop.gremlin.structure.Graph;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.javatuples.Pair;

public final class IncidentToAdjacentStrategy
extends AbstractTraversalStrategy<TraversalStrategy.OptimizationStrategy>
implements TraversalStrategy.OptimizationStrategy {
    private static final IncidentToAdjacentStrategy INSTANCE = new IncidentToAdjacentStrategy();
    private static final String MARKER = Graph.Hidden.hide("gremlin.incidentToAdjacent");
    private static final Set<Class> INVALIDATING_STEP_CLASSES = new HashSet<Class>(Arrays.asList(PathStep.class, PathFilterStep.class, TreeStep.class, TreeSideEffectStep.class, LambdaHolder.class));

    private IncidentToAdjacentStrategy() {
    }

    private static boolean isOptimizable(Step step1, Step step2) {
        if (step1 instanceof VertexStep && ((VertexStep)step1).returnsEdge() && step1.getLabels().isEmpty()) {
            Direction step1Dir = ((VertexStep)step1).getDirection();
            if (step1Dir.equals((Object)Direction.BOTH)) {
                return step2 instanceof EdgeOtherVertexStep;
            }
            return step2 instanceof EdgeOtherVertexStep || step2 instanceof EdgeVertexStep && ((EdgeVertexStep)step2).getDirection().equals((Object)step1Dir.opposite());
        }
        return false;
    }

    private static void optimizeSteps(Traversal.Admin traversal, VertexStep step1, Step step2) {
        VertexStep<Vertex> newStep = new VertexStep<Vertex>(traversal, Vertex.class, step1.getDirection(), step1.getEdgeLabels());
        for (String label : step2.getLabels()) {
            newStep.addLabel(label);
        }
        TraversalHelper.replaceStep(step1, newStep, traversal);
        traversal.removeStep(step2);
    }

    public static IncidentToAdjacentStrategy instance() {
        return INSTANCE;
    }

    @Override
    public void apply(Traversal.Admin<?, ?> traversal) {
        if ((traversal.getParent() instanceof EmptyStep || traversal.getParent() instanceof VertexProgramStep) && TraversalHelper.hasStepOfAssignableClassRecursively(INVALIDATING_STEP_CLASSES, traversal)) {
            TraversalHelper.applyTraversalRecursively(t -> t.getStartStep().addLabel(MARKER), traversal);
        }
        if (traversal.getStartStep().getLabels().contains(MARKER)) {
            traversal.getStartStep().removeLabel(MARKER);
            return;
        }
        ArrayList<Pair> stepsToReplace = new ArrayList<Pair>();
        Step prev = null;
        for (Step curr : traversal.getSteps()) {
            if (IncidentToAdjacentStrategy.isOptimizable(prev, curr)) {
                stepsToReplace.add(Pair.with((Object)((VertexStep)prev), (Object)curr));
            }
            prev = curr;
        }
        if (!stepsToReplace.isEmpty()) {
            for (Pair pair : stepsToReplace) {
                IncidentToAdjacentStrategy.optimizeSteps(traversal, (VertexStep)pair.getValue0(), (Step)pair.getValue1());
            }
        }
    }

    @Override
    public Set<Class<? extends TraversalStrategy.OptimizationStrategy>> applyPrior() {
        return Collections.singleton(IdentityRemovalStrategy.class);
    }
}

