/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.process.traversal.strategy.decoration;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.MapConfiguration;
import org.apache.tinkerpop.gremlin.process.traversal.Step;
import org.apache.tinkerpop.gremlin.process.traversal.Traversal;
import org.apache.tinkerpop.gremlin.process.traversal.TraversalStrategy;
import org.apache.tinkerpop.gremlin.process.traversal.dsl.graph.__;
import org.apache.tinkerpop.gremlin.process.traversal.lambda.ElementValueTraversal;
import org.apache.tinkerpop.gremlin.process.traversal.step.TraversalParent;
import org.apache.tinkerpop.gremlin.process.traversal.step.filter.ClassFilterStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.filter.FilterStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.filter.OrStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.filter.TraversalFilterStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.AddEdgeStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.AddVertexStartStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.AddVertexStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.EdgeOtherVertexStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.EdgeVertexStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.GraphStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.PropertiesStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.PropertyMapStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.PropertyValueStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.VertexStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.sideEffect.SideEffectStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.util.AbstractStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.util.EmptyStep;
import org.apache.tinkerpop.gremlin.process.traversal.strategy.AbstractTraversalStrategy;
import org.apache.tinkerpop.gremlin.process.traversal.strategy.decoration.ConnectiveStrategy;
import org.apache.tinkerpop.gremlin.process.traversal.util.DefaultTraversal;
import org.apache.tinkerpop.gremlin.process.traversal.util.TraversalHelper;
import org.apache.tinkerpop.gremlin.structure.Direction;
import org.apache.tinkerpop.gremlin.structure.Edge;
import org.apache.tinkerpop.gremlin.structure.Element;
import org.apache.tinkerpop.gremlin.structure.Graph;
import org.apache.tinkerpop.gremlin.structure.Property;
import org.apache.tinkerpop.gremlin.structure.PropertyType;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.apache.tinkerpop.gremlin.structure.VertexProperty;

public final class SubgraphStrategy
extends AbstractTraversalStrategy<TraversalStrategy.DecorationStrategy>
implements TraversalStrategy.DecorationStrategy {
    private final Traversal.Admin<Vertex, ?> vertexCriterion;
    private final Traversal.Admin<Edge, ?> edgeCriterion;
    private final Traversal.Admin<VertexProperty, ?> vertexPropertyCriterion;
    private static final Set<Class<? extends TraversalStrategy.DecorationStrategy>> POSTS = Collections.singleton(ConnectiveStrategy.class);
    private final String MARKER = Graph.Hidden.hide("gremlin.subgraphStrategy");
    public static final String VERTICES = "vertices";
    public static final String EDGES = "edges";
    public static final String VERTEX_PROPERTIES = "vertexProperties";

    private SubgraphStrategy(Traversal<Vertex, ?> vertexCriterion, Traversal<Edge, ?> edgeCriterion, Traversal<VertexProperty, ?> vertexPropertyCriterion) {
        Traversal.Admin<Vertex, ?> admin = this.vertexCriterion = null == vertexCriterion ? null : vertexCriterion.asAdmin().clone();
        if (null == this.vertexCriterion) {
            this.edgeCriterion = null == edgeCriterion ? null : edgeCriterion.asAdmin().clone();
        } else {
            Traversal.Admin vertexPredicate = __.and(__.inV().filter(this.vertexCriterion), __.outV().filter(this.vertexCriterion)).asAdmin();
            this.edgeCriterion = null == edgeCriterion ? vertexPredicate : edgeCriterion.asAdmin().clone().addStep(new TraversalFilterStep(edgeCriterion.asAdmin(), vertexPredicate));
        }
        Traversal.Admin<VertexProperty, ?> admin2 = this.vertexPropertyCriterion = null == vertexPropertyCriterion ? null : vertexPropertyCriterion.asAdmin().clone();
        if (null != this.vertexCriterion) {
            TraversalHelper.applyTraversalRecursively(t -> t.getStartStep().addLabel(this.MARKER), this.vertexCriterion);
        }
        if (null != this.edgeCriterion) {
            TraversalHelper.applyTraversalRecursively(t -> t.getStartStep().addLabel(this.MARKER), this.edgeCriterion);
        }
        if (null != this.vertexPropertyCriterion) {
            TraversalHelper.applyTraversalRecursively(t -> t.getStartStep().addLabel(this.MARKER), this.vertexPropertyCriterion);
        }
    }

    private static void applyCriterion(List<Step> stepsToApplyCriterionAfter, Traversal.Admin traversal, Traversal.Admin<? extends Element, ?> criterion) {
        for (Step step : stepsToApplyCriterionAfter) {
            TraversalFilterStep<? extends Element> filter = new TraversalFilterStep<Element>(traversal, criterion.clone());
            TraversalHelper.insertAfterStep(filter, step, traversal);
            TraversalHelper.copyLabels(step, filter, true);
        }
    }

    private static final char processesPropertyType(Step step) {
        while (!(step instanceof EmptyStep)) {
            if (step instanceof FilterStep || step instanceof SideEffectStep) {
                step = step.getPreviousStep();
                continue;
            }
            if (step instanceof GraphStep && ((GraphStep)step).returnsVertex()) {
                return 'v';
            }
            if (step instanceof EdgeVertexStep) {
                return 'v';
            }
            if (step instanceof VertexStep) {
                return ((VertexStep)step).returnsVertex() ? (char)'v' : 'p';
            }
            if (step instanceof PropertyMapStep || step instanceof PropertiesStep) {
                return 'p';
            }
            return 'x';
        }
        return 'x';
    }

    @Override
    public void apply(Traversal.Admin<?, ?> traversal) {
        if (traversal.getStartStep().getLabels().contains(this.MARKER)) {
            traversal.getStartStep().removeLabel(this.MARKER);
            return;
        }
        List<GraphStep> graphSteps = TraversalHelper.getStepsOfAssignableClass(GraphStep.class, traversal);
        List<VertexStep> vertexSteps = TraversalHelper.getStepsOfAssignableClass(VertexStep.class, traversal);
        if (null != this.vertexCriterion) {
            ArrayList<Step> vertexStepsToInsertFilterAfter = new ArrayList<Step>();
            vertexStepsToInsertFilterAfter.addAll(TraversalHelper.getStepsOfAssignableClass(EdgeOtherVertexStep.class, traversal));
            vertexStepsToInsertFilterAfter.addAll(TraversalHelper.getStepsOfAssignableClass(EdgeVertexStep.class, traversal));
            vertexStepsToInsertFilterAfter.addAll(TraversalHelper.getStepsOfAssignableClass(AddVertexStep.class, traversal));
            vertexStepsToInsertFilterAfter.addAll(TraversalHelper.getStepsOfAssignableClass(AddVertexStartStep.class, traversal));
            vertexStepsToInsertFilterAfter.addAll(graphSteps.stream().filter(GraphStep::returnsVertex).collect(Collectors.toList()));
            SubgraphStrategy.applyCriterion(vertexStepsToInsertFilterAfter, traversal, this.vertexCriterion);
        }
        if (null != this.edgeCriterion) {
            ArrayList edgeStepsToInsertFilterAfter = new ArrayList();
            edgeStepsToInsertFilterAfter.addAll(TraversalHelper.getStepsOfAssignableClass(AddEdgeStep.class, traversal));
            edgeStepsToInsertFilterAfter.addAll(graphSteps.stream().filter(GraphStep::returnsEdge).collect(Collectors.toList()));
            edgeStepsToInsertFilterAfter.addAll(vertexSteps.stream().filter(VertexStep::returnsEdge).collect(Collectors.toList()));
            SubgraphStrategy.applyCriterion(edgeStepsToInsertFilterAfter, traversal, this.edgeCriterion);
        }
        for (VertexStep step : vertexSteps) {
            if (step.returnsEdge()) continue;
            if (null != this.vertexCriterion && null == this.edgeCriterion) {
                TraversalHelper.insertAfterStep(new TraversalFilterStep<Vertex>(traversal, this.vertexCriterion.clone()), step, traversal);
                continue;
            }
            VertexStep<Edge> someEStep = new VertexStep<Edge>(traversal, Edge.class, step.getDirection(), step.getEdgeLabels());
            AbstractStep abstractStep = step.getDirection() == Direction.BOTH ? new EdgeOtherVertexStep(traversal) : new EdgeVertexStep(traversal, step.getDirection().opposite());
            TraversalHelper.replaceStep(step, someEStep, traversal);
            TraversalHelper.insertAfterStep(abstractStep, someEStep, traversal);
            TraversalHelper.copyLabels(step, abstractStep, true);
            if (null != this.edgeCriterion) {
                TraversalHelper.insertAfterStep(new TraversalFilterStep<Edge>(traversal, this.edgeCriterion.clone()), someEStep, traversal);
            }
            if (null == this.vertexCriterion) continue;
            TraversalHelper.insertAfterStep(new TraversalFilterStep<Vertex>(traversal, this.vertexCriterion.clone()), abstractStep, traversal);
        }
        if (null != this.vertexPropertyCriterion) {
            Cloneable temp;
            char propertyType;
            OrStep checkPropertyCriterion = new OrStep(traversal, new DefaultTraversal().addStep(new ClassFilterStep(traversal, VertexProperty.class, false)), new DefaultTraversal().addStep(new TraversalFilterStep<VertexProperty>(traversal, this.vertexPropertyCriterion)));
            Traversal.Admin nonCheckPropertyCriterion = new DefaultTraversal().addStep(new TraversalFilterStep<VertexProperty>(traversal, this.vertexPropertyCriterion));
            for (Step step : traversal.getSteps()) {
                if (!(step instanceof TraversalParent)) continue;
                if (step instanceof PropertyMapStep) {
                    propertyType = SubgraphStrategy.processesPropertyType(step.getPreviousStep());
                    if ('p' == propertyType) continue;
                    temp = new DefaultTraversal();
                    temp.addStep(new PropertiesStep((Traversal.Admin)temp, PropertyType.PROPERTY, ((PropertyMapStep)step).getPropertyKeys()));
                    if ('v' == propertyType) {
                        TraversalHelper.insertTraversal(0, nonCheckPropertyCriterion.clone(), temp);
                    } else {
                        temp.addStep(checkPropertyCriterion.clone());
                    }
                    ((PropertyMapStep)step).setPropertyTraversal((Traversal.Admin<Element, Property>)temp);
                    continue;
                }
                Stream.concat(((TraversalParent)((Object)step)).getGlobalChildren().stream(), ((TraversalParent)((Object)step)).getLocalChildren().stream()).filter(t -> t instanceof ElementValueTraversal).forEach(t -> {
                    char propertyType = SubgraphStrategy.processesPropertyType(step.getPreviousStep());
                    if ('p' != propertyType) {
                        DefaultTraversal temp = new DefaultTraversal();
                        temp.addStep(new PropertiesStep(temp, PropertyType.PROPERTY, ((ElementValueTraversal)t).getPropertyKey()));
                        if ('v' == propertyType) {
                            TraversalHelper.insertTraversal(0, nonCheckPropertyCriterion.clone(), temp);
                        } else {
                            temp.addStep(checkPropertyCriterion.clone());
                        }
                        temp.addStep(new PropertyValueStep(temp));
                        temp.setParent((TraversalParent)((Object)step));
                        ((ElementValueTraversal)t).setBypassTraversal(temp);
                    }
                });
            }
            for (PropertiesStep propertiesStep : TraversalHelper.getStepsOfAssignableClass(PropertiesStep.class, traversal)) {
                propertyType = SubgraphStrategy.processesPropertyType(propertiesStep.getPreviousStep());
                if ('p' == propertyType) continue;
                if (PropertyType.PROPERTY == propertiesStep.getReturnType()) {
                    if ('v' == propertyType) {
                        temp = nonCheckPropertyCriterion.clone();
                        TraversalHelper.insertTraversal(propertiesStep, temp, traversal);
                        TraversalHelper.copyLabels(propertiesStep, temp.getEndStep(), true);
                        continue;
                    }
                    temp = checkPropertyCriterion.clone();
                    TraversalHelper.insertAfterStep(temp, propertiesStep, traversal);
                    TraversalHelper.copyLabels(propertiesStep, temp, true);
                    continue;
                }
                PropertiesStep propertiesStep2 = new PropertiesStep(traversal, PropertyType.PROPERTY, propertiesStep.getPropertyKeys());
                TraversalHelper.replaceStep(propertiesStep, propertiesStep2, traversal);
                PropertyValueStep propertyValueStep = new PropertyValueStep(traversal);
                TraversalHelper.copyLabels(propertiesStep, propertyValueStep, false);
                if ('v' == propertyType) {
                    TraversalHelper.insertAfterStep(propertyValueStep, propertiesStep2, traversal);
                    TraversalHelper.insertTraversal(propertiesStep2, nonCheckPropertyCriterion.clone(), traversal);
                    continue;
                }
                TraversalHelper.insertAfterStep(propertyValueStep, propertiesStep2, traversal);
                TraversalHelper.insertAfterStep(checkPropertyCriterion.clone(), propertiesStep2, traversal);
            }
        }
    }

    @Override
    public Configuration getConfiguration() {
        HashMap map = new HashMap();
        if (null != this.vertexCriterion) {
            map.put(VERTICES, this.vertexCriterion);
        }
        if (null != this.edgeCriterion) {
            map.put(EDGES, this.edgeCriterion);
        }
        if (null != this.vertexPropertyCriterion) {
            map.put(VERTEX_PROPERTIES, this.vertexPropertyCriterion);
        }
        return new MapConfiguration(map);
    }

    @Override
    public Set<Class<? extends TraversalStrategy.DecorationStrategy>> applyPost() {
        return POSTS;
    }

    public Traversal<Vertex, ?> getVertexCriterion() {
        return this.vertexCriterion;
    }

    public Traversal<Edge, ?> getEdgeCriterion() {
        return this.edgeCriterion;
    }

    public Traversal<VertexProperty, ?> getVertexPropertyCriterion() {
        return this.vertexPropertyCriterion;
    }

    public static SubgraphStrategy create(Configuration configuration) {
        Builder builder = SubgraphStrategy.build();
        if (configuration.containsKey(VERTICES)) {
            builder.vertices((Traversal)configuration.getProperty(VERTICES));
        }
        if (configuration.containsKey(EDGES)) {
            builder.edges((Traversal)configuration.getProperty(EDGES));
        }
        if (configuration.containsKey(VERTEX_PROPERTIES)) {
            builder.vertexProperties((Traversal)configuration.getProperty(VERTEX_PROPERTIES));
        }
        return builder.create();
    }

    public static Builder build() {
        return new Builder();
    }

    public static final class Builder {
        private Traversal<Vertex, ?> vertexPredicate = null;
        private Traversal<Edge, ?> edgePredicate = null;
        private Traversal<VertexProperty, ?> vertexPropertyPredicate = null;

        private Builder() {
        }

        public Builder vertices(Traversal<Vertex, ?> vertexPredicate) {
            this.vertexPredicate = vertexPredicate;
            return this;
        }

        public Builder edges(Traversal<Edge, ?> edgePredicate) {
            this.edgePredicate = edgePredicate;
            return this;
        }

        public Builder vertexProperties(Traversal<VertexProperty, ?> vertexPropertyPredicate) {
            this.vertexPropertyPredicate = vertexPropertyPredicate;
            return this;
        }

        @Deprecated
        public Builder vertexCriterion(Traversal<Vertex, ?> predicate) {
            return this.vertices(predicate);
        }

        @Deprecated
        public Builder edgeCriterion(Traversal<Edge, ?> predicate) {
            return this.edges(predicate);
        }

        public SubgraphStrategy create() {
            if (null == this.vertexPredicate && null == this.edgePredicate && null == this.vertexPropertyPredicate) {
                throw new IllegalStateException("A subgraph must be filtered by a vertex, edge, or vertex property criterion");
            }
            return new SubgraphStrategy(this.vertexPredicate, this.edgePredicate, this.vertexPropertyPredicate);
        }
    }
}

