/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.process.traversal.step.util.event;

import org.apache.tinkerpop.gremlin.process.traversal.step.util.event.MutationListener;
import org.apache.tinkerpop.gremlin.structure.Edge;
import org.apache.tinkerpop.gremlin.structure.Graph;
import org.apache.tinkerpop.gremlin.structure.Property;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.apache.tinkerpop.gremlin.structure.VertexProperty;

public class ConsoleMutationListener
implements MutationListener {
    private final Graph graph;

    public ConsoleMutationListener(Graph graph) {
        this.graph = graph;
    }

    @Override
    public void vertexAdded(Vertex vertex) {
        System.out.println("Vertex [" + vertex.toString() + "] added to graph [" + this.graph.toString() + "]");
    }

    @Override
    public void vertexRemoved(Vertex vertex) {
        System.out.println("Vertex [" + vertex.toString() + "] removed from graph [" + this.graph.toString() + "]");
    }

    @Override
    public void vertexPropertyRemoved(VertexProperty vertexProperty) {
        System.out.println("Vertex Property [" + vertexProperty.toString() + "] removed from graph [" + this.graph.toString() + "]");
    }

    @Override
    public void edgeAdded(Edge edge) {
        System.out.println("Edge [" + edge.toString() + "] added to graph [" + this.graph.toString() + "]");
    }

    @Override
    public void edgeRemoved(Edge edge) {
        System.out.println("Edge [" + edge.toString() + "] removed from graph [" + this.graph.toString() + "]");
    }

    @Override
    public void edgePropertyRemoved(Edge element, Property removedValue) {
        System.out.println("Edge [" + element.toString() + "] property with value of [" + removedValue + "] removed in graph [" + this.graph.toString() + "]");
    }

    @Override
    public void edgePropertyChanged(Edge element, Property oldValue, Object setValue) {
        System.out.println("Edge [" + element.toString() + "] property change value from [" + oldValue + "] to [" + setValue + "] in graph [" + this.graph.toString() + "]");
    }

    @Override
    public void vertexPropertyPropertyChanged(VertexProperty element, Property oldValue, Object setValue) {
        System.out.println("VertexProperty [" + element.toString() + "] property change value from [" + oldValue + "] to [" + setValue + "] in graph [" + this.graph.toString() + "]");
    }

    @Override
    public void vertexPropertyPropertyRemoved(VertexProperty element, Property oldValue) {
        System.out.println("VertexProperty [" + element.toString() + "] property with value of [" + oldValue + "] removed in graph [" + this.graph.toString() + "]");
    }

    @Override
    public void vertexPropertyChanged(Vertex element, Property oldValue, Object setValue, Object ... vertexPropertyKeyValues) {
        System.out.println("Vertex [" + element.toString() + "] property [" + oldValue + "] change to [" + setValue + "] in graph [" + this.graph.toString() + "]");
    }

    public String toString() {
        return MutationListener.class.getSimpleName() + "[" + this.graph + "]";
    }
}

