/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.process.computer.bulkloading;

import org.apache.commons.configuration.Configuration;
import org.apache.tinkerpop.gremlin.process.computer.bulkloading.BulkLoader;
import org.apache.tinkerpop.gremlin.process.computer.bulkloading.BulkLoaderVertexProgram;
import org.apache.tinkerpop.gremlin.process.traversal.dsl.graph.GraphTraversal;
import org.apache.tinkerpop.gremlin.process.traversal.dsl.graph.GraphTraversalSource;
import org.apache.tinkerpop.gremlin.structure.Edge;
import org.apache.tinkerpop.gremlin.structure.Graph;
import org.apache.tinkerpop.gremlin.structure.T;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.apache.tinkerpop.gremlin.structure.VertexProperty;

public class OneTimeBulkLoader
implements BulkLoader {
    private boolean userSuppliedIds = false;

    @Override
    public Vertex getOrCreateVertex(Vertex vertex, Graph graph, GraphTraversalSource g) {
        GraphTraversal<Vertex, Vertex> t = g.addV(vertex.label());
        return (Vertex)(this.useUserSuppliedIds() ? t.property(T.id, vertex.id(), new Object[0]) : t).next();
    }

    @Override
    public Edge getOrCreateEdge(Edge edge, Vertex outVertex, Vertex inVertex, Graph graph, GraphTraversalSource g) {
        return this.createEdge(edge, outVertex, inVertex, graph, g);
    }

    @Override
    public VertexProperty getOrCreateVertexProperty(VertexProperty<?> property, Vertex vertex, Graph graph, GraphTraversalSource g) {
        return this.createVertexProperty(property, vertex, graph, g);
    }

    @Override
    public Vertex getVertex(Vertex vertex, Graph graph, GraphTraversalSource g) {
        return this.getVertexById(vertex.id(), graph, g);
    }

    @Override
    public boolean useUserSuppliedIds() {
        return this.userSuppliedIds;
    }

    @Override
    public boolean keepOriginalIds() {
        return false;
    }

    @Override
    public String getVertexIdProperty() {
        return null;
    }

    @Override
    public void configure(Configuration configuration) {
        if (configuration.containsKey(BulkLoaderVertexProgram.USER_SUPPLIED_IDS_CFG_KEY)) {
            this.userSuppliedIds = configuration.getBoolean(BulkLoaderVertexProgram.USER_SUPPLIED_IDS_CFG_KEY);
        }
    }
}

