/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.jsr223;

import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.MapConfiguration;
import org.apache.tinkerpop.gremlin.process.traversal.Bytecode;
import org.apache.tinkerpop.gremlin.process.traversal.Translator;
import org.apache.tinkerpop.gremlin.process.traversal.Traversal;
import org.apache.tinkerpop.gremlin.process.traversal.TraversalSource;
import org.apache.tinkerpop.gremlin.process.traversal.step.util.BulkSet;
import org.apache.tinkerpop.gremlin.process.traversal.step.util.Tree;
import org.apache.tinkerpop.gremlin.process.traversal.strategy.TraversalStrategyProxy;
import org.apache.tinkerpop.gremlin.structure.util.StringFactory;

public final class JavaTranslator<S extends TraversalSource, T extends Traversal.Admin<?, ?>>
implements Translator.StepTranslator<S, T> {
    private final S traversalSource;
    private final Class anonymousTraversal;
    private static final Map<Class<?>, Map<String, List<Method>>> GLOBAL_METHOD_CACHE = new ConcurrentHashMap();

    private JavaTranslator(S traversalSource) {
        this.traversalSource = traversalSource;
        this.anonymousTraversal = traversalSource.getAnonymousTraversalClass().orElse(null);
    }

    public static <S extends TraversalSource, T extends Traversal.Admin<?, ?>> JavaTranslator<S, T> of(S traversalSource) {
        return new JavaTranslator<S, T>(traversalSource);
    }

    @Override
    public S getTraversalSource() {
        return this.traversalSource;
    }

    @Override
    public T translate(Bytecode bytecode) {
        Object dynamicSource = this.traversalSource;
        Traversal.Admin traversal = null;
        for (Bytecode.Instruction instruction : bytecode.getSourceInstructions()) {
            dynamicSource = (TraversalSource)this.invokeMethod(dynamicSource, TraversalSource.class, instruction.getOperator(), instruction.getArguments());
        }
        boolean spawned = false;
        for (Bytecode.Instruction instruction : bytecode.getStepInstructions()) {
            if (!spawned) {
                traversal = (Traversal.Admin)this.invokeMethod(dynamicSource, Traversal.class, instruction.getOperator(), instruction.getArguments());
                spawned = true;
                continue;
            }
            this.invokeMethod(traversal, Traversal.class, instruction.getOperator(), instruction.getArguments());
        }
        return (T)traversal;
    }

    @Override
    public String getTargetLanguage() {
        return "gremlin-java";
    }

    public String toString() {
        return StringFactory.translatorString(this);
    }

    private Object translateObject(Object object) {
        if (object instanceof Bytecode.Binding) {
            return this.translateObject(((Bytecode.Binding)object).value());
        }
        if (object instanceof Bytecode) {
            try {
                Traversal.Admin traversal = (Traversal.Admin)this.anonymousTraversal.getMethod("start", new Class[0]).invoke(null, new Object[0]);
                for (Bytecode.Instruction instruction : ((Bytecode)object).getStepInstructions()) {
                    this.invokeMethod(traversal, Traversal.class, instruction.getOperator(), instruction.getArguments());
                }
                return traversal;
            }
            catch (Throwable e) {
                throw new IllegalStateException(e.getMessage());
            }
        }
        if (object instanceof TraversalStrategyProxy) {
            HashMap map = new HashMap();
            Configuration configuration = ((TraversalStrategyProxy)object).getConfiguration();
            configuration.getKeys().forEachRemaining(key -> map.put(key, this.translateObject(configuration.getProperty(key))));
            try {
                return map.isEmpty() ? ((TraversalStrategyProxy)object).getStrategyClass().getMethod("instance", new Class[0]).invoke(null, new Object[0]) : ((TraversalStrategyProxy)object).getStrategyClass().getMethod("create", Configuration.class).invoke(null, new MapConfiguration(map));
            }
            catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
                throw new IllegalStateException(e.getMessage(), e);
            }
        }
        if (object instanceof Map) {
            Tree map = object instanceof Tree ? new Tree() : (object instanceof LinkedHashMap ? new LinkedHashMap(((Map)object).size()) : new HashMap(((Map)object).size()));
            for (Map.Entry entry : ((Map)object).entrySet()) {
                map.put(this.translateObject(entry.getKey()), this.translateObject(entry.getValue()));
            }
            return map;
        }
        if (object instanceof List) {
            ArrayList<Object> list = new ArrayList<Object>(((List)object).size());
            for (Object o : (List)object) {
                list.add(this.translateObject(o));
            }
            return list;
        }
        if (object instanceof BulkSet) {
            BulkSet<Object> bulkSet = new BulkSet<Object>();
            for (Map.Entry entry : ((BulkSet)object).asBulk().entrySet()) {
                bulkSet.add(this.translateObject(entry.getKey()), entry.getValue());
            }
            return bulkSet;
        }
        if (object instanceof Set) {
            HashSet set = object instanceof LinkedHashSet ? new LinkedHashSet(((Set)object).size()) : new HashSet(((Set)object).size());
            for (Object o : (Set)object) {
                set.add(this.translateObject(o));
            }
            return set;
        }
        return object;
    }

    private Object invokeMethod(Object delegate, Class returnType, String methodName, Object ... arguments) {
        Map methodCache = GLOBAL_METHOD_CACHE.getOrDefault(delegate.getClass(), new HashMap());
        if (methodCache.isEmpty()) {
            JavaTranslator.buildMethodCache(delegate, methodCache);
        }
        Object[] argumentsCopy = new Object[arguments.length];
        for (int i = 0; i < arguments.length; ++i) {
            argumentsCopy[i] = this.translateObject(arguments[i]);
        }
        try {
            for (Method method : (List)methodCache.get(methodName)) {
                if (!returnType.isAssignableFrom(method.getReturnType()) || method.getParameterCount() != argumentsCopy.length && (method.getParameterCount() <= 0 || !method.getParameters()[method.getParameters().length - 1].isVarArgs())) continue;
                Parameter[] parameters = method.getParameters();
                Object[] newArguments = new Object[parameters.length];
                boolean found = true;
                for (int i = 0; i < parameters.length; ++i) {
                    if (parameters[i].isVarArgs()) {
                        Class<?> parameterClass = parameters[i].getType().getComponentType();
                        if (argumentsCopy.length > i && !parameterClass.isAssignableFrom(argumentsCopy[i].getClass())) {
                            found = false;
                            break;
                        }
                        Object[] varArgs = (Object[])Array.newInstance(parameterClass, argumentsCopy.length - i);
                        int counter = 0;
                        for (int j = i; j < argumentsCopy.length; ++j) {
                            varArgs[counter++] = argumentsCopy[j];
                        }
                        newArguments[i] = varArgs;
                        break;
                    }
                    if (!(i < argumentsCopy.length && (parameters[i].getType().isAssignableFrom(argumentsCopy[i].getClass()) || parameters[i].getType().isPrimitive() && (Number.class.isAssignableFrom(argumentsCopy[i].getClass()) || argumentsCopy[i].getClass().equals(Boolean.class) || argumentsCopy[i].getClass().equals(Byte.class) || argumentsCopy[i].getClass().equals(Character.class))))) {
                        found = false;
                        break;
                    }
                    newArguments[i] = argumentsCopy[i];
                }
                if (!found) continue;
                return 0 == newArguments.length ? method.invoke(delegate, new Object[0]) : method.invoke(delegate, newArguments);
            }
        }
        catch (Throwable e) {
            throw new IllegalStateException(e.getMessage() + ":" + methodName + "(" + Arrays.toString(argumentsCopy) + ")", e);
        }
        throw new IllegalStateException("Could not locate method: " + delegate.getClass().getSimpleName() + "." + methodName + "(" + Arrays.toString(argumentsCopy) + ")");
    }

    private static synchronized void buildMethodCache(Object delegate, Map<String, List<Method>> methodCache) {
        if (methodCache.isEmpty()) {
            for (Method method : delegate.getClass().getMethods()) {
                if (method.getName().equals("addV") && method.getParameterCount() == 1 && method.getParameters()[0].getType().equals(Object[].class)) continue;
                List<Method> list = methodCache.get(method.getName());
                if (null == list) {
                    list = new ArrayList<Method>();
                    methodCache.put(method.getName(), list);
                }
                list.add(method);
            }
            GLOBAL_METHOD_CACHE.put(delegate.getClass(), methodCache);
        }
    }
}

