/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.jsr223;

import java.util.Collections;
import java.util.List;
import org.apache.tinkerpop.gremlin.jsr223.GremlinScriptEngineFactory;
import org.apache.tinkerpop.gremlin.jsr223.GremlinScriptEngineManager;
import org.apache.tinkerpop.gremlin.util.Gremlin;

public abstract class AbstractGremlinScriptEngineFactory
implements GremlinScriptEngineFactory {
    private final String engineName;
    private final String languageName;
    private final List<String> extensions;
    private final List<String> mimeTypes;
    protected GremlinScriptEngineManager manager;

    public AbstractGremlinScriptEngineFactory(String engineName, String languageName, List<String> extensions, List<String> mimeTypes) {
        this.engineName = engineName;
        this.languageName = languageName;
        this.extensions = Collections.unmodifiableList(extensions);
        this.mimeTypes = Collections.unmodifiableList(mimeTypes);
    }

    @Override
    public void setCustomizerManager(GremlinScriptEngineManager manager) {
        this.manager = manager;
    }

    @Override
    public String getEngineName() {
        return this.engineName;
    }

    @Override
    public String getEngineVersion() {
        return Gremlin.version();
    }

    @Override
    public List<String> getExtensions() {
        return this.extensions;
    }

    @Override
    public String getLanguageName() {
        return this.languageName;
    }

    @Override
    public String getLanguageVersion() {
        return Gremlin.version();
    }

    @Override
    public List<String> getMimeTypes() {
        return this.mimeTypes;
    }

    @Override
    public List<String> getNames() {
        return Collections.singletonList(this.languageName);
    }

    @Override
    public Object getParameter(String key) {
        if (key.equals("javax.script.engine")) {
            return this.getEngineName();
        }
        if (key.equals("javax.script.engine_version")) {
            return this.getEngineVersion();
        }
        if (key.equals("javax.script.name")) {
            return this.engineName;
        }
        if (key.equals("javax.script.language")) {
            return this.getLanguageName();
        }
        if (key.equals("javax.script.language_version")) {
            return this.getLanguageVersion();
        }
        return null;
    }

    @Override
    public String getProgram(String ... statements) {
        String program = "";
        for (String statement : statements) {
            program = program + statement + System.lineSeparator();
        }
        return program;
    }
}

