/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.driver.simple;

import io.netty.bootstrap.Bootstrap;
import io.netty.buffer.PooledByteBufAllocator;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.handler.codec.http.HttpClientCodec;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpObjectAggregator;
import io.netty.handler.codec.http.websocketx.WebSocketClientHandshakerFactory;
import io.netty.handler.codec.http.websocketx.WebSocketVersion;
import java.io.IOException;
import java.net.URI;
import java.util.concurrent.TimeUnit;
import org.apache.tinkerpop.gremlin.driver.handler.WebSocketClientHandler;
import org.apache.tinkerpop.gremlin.driver.handler.WebSocketGremlinRequestEncoder;
import org.apache.tinkerpop.gremlin.driver.handler.WebSocketGremlinResponseDecoder;
import org.apache.tinkerpop.gremlin.driver.message.RequestMessage;
import org.apache.tinkerpop.gremlin.driver.ser.GryoMessageSerializerV3d0;
import org.apache.tinkerpop.gremlin.driver.simple.AbstractClient;

public class WebSocketClient
extends AbstractClient {
    private final Channel channel;

    public WebSocketClient() {
        this(URI.create("ws://localhost:8182/gremlin"));
    }

    public WebSocketClient(URI uri) {
        super("ws-client-%d");
        Bootstrap b = (Bootstrap)new Bootstrap().group(this.group);
        b.option(ChannelOption.ALLOCATOR, (Object)PooledByteBufAllocator.DEFAULT);
        String protocol = uri.getScheme();
        if (!"ws".equals(protocol)) {
            throw new IllegalArgumentException("Unsupported protocol: " + protocol);
        }
        try {
            final WebSocketClientHandler wsHandler = new WebSocketClientHandler(WebSocketClientHandshakerFactory.newHandshaker((URI)uri, (WebSocketVersion)WebSocketVersion.V13, null, (boolean)false, (HttpHeaders)HttpHeaders.EMPTY_HEADERS, (int)65536));
            final GryoMessageSerializerV3d0 serializer = new GryoMessageSerializerV3d0();
            ((Bootstrap)b.channel(NioSocketChannel.class)).handler((ChannelHandler)new ChannelInitializer<SocketChannel>(){

                protected void initChannel(SocketChannel ch) {
                    ChannelPipeline p = ch.pipeline();
                    p.addLast(new ChannelHandler[]{new HttpClientCodec(), new HttpObjectAggregator(65536), wsHandler, new WebSocketGremlinRequestEncoder(true, serializer), new WebSocketGremlinResponseDecoder(serializer), WebSocketClient.this.callbackResponseHandler});
                }
            });
            this.channel = b.connect(uri.getHost(), uri.getPort()).sync().channel();
            wsHandler.handshakeFuture().get(10000L, TimeUnit.MILLISECONDS);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    @Override
    public void writeAndFlush(RequestMessage requestMessage) throws Exception {
        this.channel.writeAndFlush((Object)requestMessage).get();
    }

    @Override
    public void close() throws IOException {
        try {
            this.channel.close().get();
        }
        catch (Exception exception) {
        }
        finally {
            this.group.shutdownGracefully().awaitUninterruptibly();
        }
    }
}

