/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.storage.impl.local.paginated.wal;

import com.orientechnologies.common.serialization.types.OLongSerializer;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.OAbstractPageWALRecord;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.OLogSequenceNumber;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.OOperationUnitId;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.OWALChanges;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.OWALPageChangesPortion;

public class OUpdatePageRecord
extends OAbstractPageWALRecord {
    private OWALChanges changes;
    private OLogSequenceNumber prevLsn;

    public OUpdatePageRecord() {
    }

    public OUpdatePageRecord(long pageIndex, long fileId, OOperationUnitId operationUnitId, OWALChanges changes, OLogSequenceNumber prevLsn) {
        super(pageIndex, fileId, operationUnitId);
        this.changes = changes;
        this.prevLsn = prevLsn;
    }

    public OWALChanges getChanges() {
        return this.changes;
    }

    @Override
    public int serializedSize() {
        int serializedSize = super.serializedSize();
        serializedSize += this.changes.serializedSize();
        return serializedSize += 16;
    }

    public OLogSequenceNumber getPrevLsn() {
        return this.prevLsn;
    }

    @Override
    public int toStream(byte[] content, int offset) {
        offset = super.toStream(content, offset);
        offset = this.changes.toStream(offset, content);
        OLongSerializer.INSTANCE.serializeNative(this.prevLsn.getSegment(), content, offset, new Object[0]);
        OLongSerializer.INSTANCE.serializeNative(this.prevLsn.getPosition(), content, offset += 8, new Object[0]);
        return offset += 8;
    }

    @Override
    public int fromStream(byte[] content, int offset) {
        offset = super.fromStream(content, offset);
        this.changes = new OWALPageChangesPortion();
        offset = this.changes.fromStream(offset, content);
        long segment = OLongSerializer.INSTANCE.deserializeNative(content, offset);
        long position = OLongSerializer.INSTANCE.deserializeNative(content, offset += 8);
        this.prevLsn = new OLogSequenceNumber(segment, position);
        return offset += 8;
    }

    @Override
    public boolean isUpdateMasterRecord() {
        return false;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        OUpdatePageRecord that = (OUpdatePageRecord)o;
        if (this.lsn == null && that.lsn == null) {
            return true;
        }
        if (this.lsn == null) {
            return false;
        }
        if (that.lsn == null) {
            return false;
        }
        return this.lsn.equals(that.lsn);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.lsn.hashCode();
        return result;
    }
}

