/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.storage.impl.local.paginated.wal;

import com.orientechnologies.common.concur.executors.SubScheduledExecutorService;
import com.orientechnologies.common.concur.lock.OInterruptedException;
import com.orientechnologies.common.exception.OException;
import com.orientechnologies.common.io.OIOException;
import com.orientechnologies.common.io.OIOUtils;
import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.common.serialization.types.OLongSerializer;
import com.orientechnologies.common.thread.OScheduledThreadPoolExecutorWithLogging;
import com.orientechnologies.common.util.OUncaughtExceptionHandler;
import com.orientechnologies.orient.core.config.OGlobalConfiguration;
import com.orientechnologies.orient.core.exception.OStorageException;
import com.orientechnologies.orient.core.storage.OStorageAbstract;
import com.orientechnologies.orient.core.storage.impl.local.OCheckpointRequestListener;
import com.orientechnologies.orient.core.storage.impl.local.OLowDiskSpaceInformation;
import com.orientechnologies.orient.core.storage.impl.local.OLowDiskSpaceListener;
import com.orientechnologies.orient.core.storage.impl.local.paginated.OLocalPaginatedStorage;
import com.orientechnologies.orient.core.storage.impl.local.paginated.atomicoperations.OAtomicOperationMetadata;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.OAbstractWriteAheadLog;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.OAtomicUnitEndRecord;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.OAtomicUnitStartRecord;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.OLogSegment;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.OLogSegmentV1;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.OLogSegmentV2;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.OLogSequenceNumber;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.OOperationUnitId;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.OOperationUnitRecord;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.OWALPage;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.OWALRecord;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.OWALRecordsFactory;
import com.orientechnologies.orient.core.storage.impl.local.statistic.OPerformanceStatisticManager;
import com.orientechnologies.orient.core.storage.impl.local.statistic.OSessionStoragePerformanceStatistic;
import java.io.EOFException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.FileChannel;
import java.nio.file.FileStore;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentNavigableMap;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.stream.Stream;
import java.util.zip.CRC32;

public class ODiskWriteAheadLog
extends OAbstractWriteAheadLog {
    public static final String MASTER_RECORD_EXTENSION = ".wmr";
    public static final String WAL_SEGMENT_EXTENSION = ".wal";
    private static final int MASTER_RECORD_SIZE = 20;
    private static final int ONE_KB = 1024;
    private static final int ONE_MB = 0x100000;
    private final long walSizeHardLimit;
    private long walSizeLimit;
    private final long freeSpaceLimit;
    private volatile long freeSpace;
    private volatile OLogSequenceNumber end;
    private final List<OLogSegment> logSegments;
    private final int maxPagesCacheSize;
    private final int commitDelay;
    private final long maxSegmentSize;
    private final Path walLocation;
    private final FileChannel masterRecordLSNHolder;
    private final FileStore fileStore;
    private final int fileTTL;
    private final int segmentBufferSize;
    private final OLocalPaginatedStorage storage;
    private final OPerformanceStatisticManager performanceStatisticManager;
    private boolean useFirstMasterRecord;
    private volatile long logSize;
    private Path masterRecordPath;
    private OLogSequenceNumber firstMasterRecord;
    private OLogSequenceNumber secondMasterRecord;
    private volatile OLogSequenceNumber flushedLsn;
    private final ConcurrentSkipListMap<OLogSequenceNumber, Integer> cutTillLimits;
    private volatile long cacheOverflowCount;
    private boolean segmentCreationFlag;
    private final Condition segmentCreationComplete;
    private final Set<OOperationUnitId> activeOperations;
    private final List<WeakReference<OLowDiskSpaceListener>> lowDiskSpaceListeners;
    private final List<WeakReference<OCheckpointRequestListener>> fullCheckpointListeners;
    private final OScheduledThreadPoolExecutorWithLogging autoFileCloser;
    private final OScheduledThreadPoolExecutorWithLogging commitExecutor;
    private final ConcurrentNavigableMap<OLogSequenceNumber, Runnable> events;

    public ODiskWriteAheadLog(OLocalPaginatedStorage storage) throws IOException {
        this(storage.getConfiguration().getContextConfiguration().getValueAsInteger(OGlobalConfiguration.WAL_CACHE_SIZE), storage.getConfiguration().getContextConfiguration().getValueAsInteger(OGlobalConfiguration.WAL_COMMIT_TIMEOUT), storage.getConfiguration().getContextConfiguration().getValueAsInteger(OGlobalConfiguration.WAL_MAX_SEGMENT_SIZE) * 0x100000, storage.getConfiguration().getContextConfiguration().getValueAsString(OGlobalConfiguration.WAL_LOCATION), true, storage, storage.getConfiguration().getContextConfiguration().getValueAsInteger(OGlobalConfiguration.WAL_SEGMENT_BUFFER_SIZE) * 0x100000, storage.getConfiguration().getContextConfiguration().getValueAsInteger(OGlobalConfiguration.WAL_FILE_AUTOCLOSE_INTERVAL));
    }

    @Override
    public void addLowDiskSpaceListener(OLowDiskSpaceListener listener) {
        this.lowDiskSpaceListeners.add(new WeakReference<OLowDiskSpaceListener>(listener));
    }

    @Override
    public void removeLowDiskSpaceListener(OLowDiskSpaceListener listener) {
        ArrayList<WeakReference<OLowDiskSpaceListener>> itemsToRemove = new ArrayList<WeakReference<OLowDiskSpaceListener>>();
        for (WeakReference<OLowDiskSpaceListener> ref : this.lowDiskSpaceListeners) {
            OLowDiskSpaceListener lowDiskSpaceListener = (OLowDiskSpaceListener)ref.get();
            if (lowDiskSpaceListener != null && !lowDiskSpaceListener.equals(listener)) continue;
            itemsToRemove.add(ref);
        }
        this.lowDiskSpaceListeners.removeAll(itemsToRemove);
    }

    @Override
    public void addFullCheckpointListener(OCheckpointRequestListener listener) {
        this.fullCheckpointListeners.add(new WeakReference<OCheckpointRequestListener>(listener));
    }

    @Override
    public void removeFullCheckpointListener(OCheckpointRequestListener listener) {
        ArrayList<WeakReference<OCheckpointRequestListener>> itemsToRemove = new ArrayList<WeakReference<OCheckpointRequestListener>>();
        for (WeakReference<OCheckpointRequestListener> ref : this.fullCheckpointListeners) {
            OCheckpointRequestListener fullCheckpointRequestListener = (OCheckpointRequestListener)ref.get();
            if (fullCheckpointRequestListener != null && !fullCheckpointRequestListener.equals(listener)) continue;
            itemsToRemove.add(ref);
        }
        this.fullCheckpointListeners.removeAll(itemsToRemove);
    }

    public ODiskWriteAheadLog(int maxPagesCacheSize, int commitDelay, long maxSegmentSize, String walPath, boolean filterWALFiles, OLocalPaginatedStorage storage, int segmentBufferSize, int fileTTL) throws IOException {
        this.walSizeLimit = this.walSizeHardLimit = OGlobalConfiguration.WAL_MAX_SIZE.getValueAsLong() * 1024L * 1024L;
        this.freeSpaceLimit = OGlobalConfiguration.DISK_CACHE_FREE_SPACE_LIMIT.getValueAsLong() * 1024L * 1024L;
        this.freeSpace = -1L;
        this.logSegments = new ArrayList<OLogSegment>();
        this.useFirstMasterRecord = true;
        this.cutTillLimits = new ConcurrentSkipListMap();
        this.cacheOverflowCount = 0L;
        this.segmentCreationFlag = false;
        this.segmentCreationComplete = this.syncObject.newCondition();
        this.activeOperations = new HashSet<OOperationUnitId>();
        this.lowDiskSpaceListeners = new CopyOnWriteArrayList<WeakReference<OLowDiskSpaceListener>>();
        this.fullCheckpointListeners = new CopyOnWriteArrayList<WeakReference<OCheckpointRequestListener>>();
        this.events = new ConcurrentSkipListMap<OLogSequenceNumber, Runnable>();
        this.fileTTL = fileTTL;
        this.segmentBufferSize = segmentBufferSize;
        this.maxPagesCacheSize = maxPagesCacheSize;
        this.commitDelay = commitDelay;
        this.maxSegmentSize = maxSegmentSize;
        this.storage = storage;
        this.performanceStatisticManager = storage.getPerformanceStatisticManager();
        this.autoFileCloser = new OScheduledThreadPoolExecutorWithLogging(1, r -> {
            Thread thread = new Thread(OStorageAbstract.storageThreadGroup, r);
            thread.setDaemon(true);
            thread.setName("WAL Closer Task (" + this.getStorage().getName() + ")");
            thread.setUncaughtExceptionHandler(new OUncaughtExceptionHandler());
            return thread;
        });
        this.autoFileCloser.setMaximumPoolSize(1);
        this.commitExecutor = new OScheduledThreadPoolExecutorWithLogging(1, r -> {
            Thread thread = new Thread(OStorageAbstract.storageThreadGroup, r);
            thread.setDaemon(true);
            thread.setName("OrientDB WAL Flush Task (" + this.getStorage().getName() + ")");
            thread.setUncaughtExceptionHandler(new OUncaughtExceptionHandler());
            return thread;
        });
        this.commitExecutor.setMaximumPoolSize(1);
        try {
            this.walLocation = this.calculateWalPath(this.storage, walPath);
            this.fileStore = Files.getFileStore(this.walLocation);
            Locale locale = storage.getConfiguration().getLocaleInstance();
            String storageName = storage.getName();
            Stream<Path> walFiles = filterWALFiles ? Files.find(this.walLocation, 1, (path, attributes) -> ODiskWriteAheadLog.validateName(path.getFileName().toString(), storageName, locale), new FileVisitOption[0]) : Files.find(this.walLocation, 1, (path, attrs) -> ODiskWriteAheadLog.validateSimpleName(path.getFileName().toString(), locale), new FileVisitOption[0]);
            if (walFiles == null) {
                throw new IllegalStateException("Location passed in WAL does not exist, or IO error was happened. DB cannot work in durable mode in such case");
            }
            this.logSize = 0L;
            walFiles.forEach(path -> {
                try {
                    OLogSegment logSegment;
                    FileChannel channel = FileChannel.open(path, StandardOpenOption.READ);
                    if (channel.size() / (long)OWALPage.PAGE_SIZE < 1L) {
                        channel.close();
                        logSegment = new OLogSegmentV2(this, (Path)path, maxPagesCacheSize, fileTTL, segmentBufferSize, new SubScheduledExecutorService(this.autoFileCloser), new SubScheduledExecutorService(this.commitExecutor));
                    } else {
                        channel.position(4L);
                        ByteBuffer mBuffer = ByteBuffer.allocateDirect(8).order(ByteOrder.nativeOrder());
                        OIOUtils.readByteBuffer(mBuffer, channel);
                        channel.close();
                        long magicNumber = mBuffer.getLong(0);
                        logSegment = magicNumber == 4207608830L ? new OLogSegmentV1(this, (Path)path, maxPagesCacheSize, fileTTL, segmentBufferSize, new SubScheduledExecutorService(this.autoFileCloser), new SubScheduledExecutorService(this.commitExecutor)) : new OLogSegmentV2(this, (Path)path, maxPagesCacheSize, fileTTL, segmentBufferSize, new SubScheduledExecutorService(this.autoFileCloser), new SubScheduledExecutorService(this.commitExecutor));
                    }
                    logSegment.init();
                    this.logSegments.add(logSegment);
                    this.logSize += logSegment.filledUpTo();
                }
                catch (IOException e) {
                    throw OException.wrapException(new OStorageException("Error during file initialization for storage '" + this.storage.getName() + "'"), e);
                }
            });
            if (this.logSegments.isEmpty()) {
                OLogSegmentV2 logSegment = new OLogSegmentV2(this, this.walLocation.resolve(this.getSegmentName(0L)), maxPagesCacheSize, fileTTL, segmentBufferSize, new SubScheduledExecutorService(this.autoFileCloser), new SubScheduledExecutorService(this.commitExecutor));
                logSegment.init();
                logSegment.startBackgroundWrite();
                this.logSegments.add(logSegment);
                this.flushedLsn = null;
            } else {
                Collections.sort(this.logSegments);
                this.logSegments.get(this.logSegments.size() - 1).startBackgroundWrite();
                this.flushedLsn = this.findFlushedLSN();
                this.end = this.calculateEndLSN();
            }
            this.masterRecordPath = this.walLocation.resolve(this.storage.getName() + MASTER_RECORD_EXTENSION);
            this.masterRecordLSNHolder = FileChannel.open(this.masterRecordPath, StandardOpenOption.CREATE, StandardOpenOption.READ, StandardOpenOption.WRITE, StandardOpenOption.SYNC);
            if (this.masterRecordLSNHolder.size() > 0L) {
                this.firstMasterRecord = this.readMasterRecord(this.storage.getName(), 0);
                this.secondMasterRecord = this.readMasterRecord(this.storage.getName(), 1);
                if (this.firstMasterRecord == null) {
                    this.useFirstMasterRecord = true;
                    this.lastCheckpoint = this.secondMasterRecord;
                } else if (this.secondMasterRecord == null) {
                    this.useFirstMasterRecord = false;
                    this.lastCheckpoint = this.firstMasterRecord;
                } else if (this.firstMasterRecord.compareTo(this.secondMasterRecord) >= 0) {
                    this.lastCheckpoint = this.firstMasterRecord;
                    this.useFirstMasterRecord = false;
                } else {
                    this.lastCheckpoint = this.secondMasterRecord;
                    this.useFirstMasterRecord = true;
                }
            }
            this.fixMasterRecords();
        }
        catch (FileNotFoundException e) {
            OLogManager.instance().error(this, "Error during file initialization for storage '%s'", e, this.storage.getName());
            throw new IllegalStateException("Error during file initialization for storage '" + this.storage.getName() + "'", e);
        }
    }

    private OLogSequenceNumber calculateEndLSN() {
        int lastIndex = this.logSegments.size() - 1;
        OLogSegment last = this.logSegments.get(lastIndex);
        while (last.filledUpTo() == 0L) {
            if (--lastIndex >= 0) {
                last = this.logSegments.get(lastIndex);
                continue;
            }
            return null;
        }
        return last.end();
    }

    void incrementCacheOverflowCount() {
        ++this.cacheOverflowCount;
    }

    public long getCacheOverflowCount() {
        return this.cacheOverflowCount;
    }

    private Path calculateWalPath(OLocalPaginatedStorage storage, String walPath) {
        if (walPath == null) {
            return storage.getStoragePath();
        }
        return Paths.get(walPath, new String[0]);
    }

    private String getSegmentName(long order) {
        return this.storage.getName() + "." + order + WAL_SEGMENT_EXTENSION;
    }

    private static boolean validateSimpleName(String name, Locale locale) {
        if (!(name = name.toLowerCase(locale)).endsWith(WAL_SEGMENT_EXTENSION)) {
            return false;
        }
        int walOrderStartIndex = name.indexOf(46);
        if (walOrderStartIndex == name.length() - 4) {
            return false;
        }
        int walOrderEndIndex = name.indexOf(46, walOrderStartIndex + 1);
        String walOrder = name.substring(walOrderStartIndex + 1, walOrderEndIndex);
        try {
            Integer.parseInt(walOrder);
        }
        catch (NumberFormatException ignore) {
            return false;
        }
        return true;
    }

    private static boolean validateName(String name, String storageName, Locale locale) {
        name = name.toLowerCase(locale);
        storageName = storageName.toLowerCase(locale);
        if (!name.endsWith(WAL_SEGMENT_EXTENSION)) {
            return false;
        }
        int walOrderStartIndex = name.indexOf(46);
        if (walOrderStartIndex == name.length() - 4) {
            return false;
        }
        String walStorageName = name.substring(0, walOrderStartIndex);
        if (!storageName.equals(walStorageName)) {
            return false;
        }
        int walOrderEndIndex = name.indexOf(46, walOrderStartIndex + 1);
        String walOrder = name.substring(walOrderStartIndex + 1, walOrderEndIndex);
        try {
            Integer.parseInt(walOrder);
        }
        catch (NumberFormatException ignore) {
            return false;
        }
        return true;
    }

    Path getWalLocation() {
        return this.walLocation;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OLogSequenceNumber begin() throws IOException {
        this.syncObject.lock();
        try {
            this.checkForClose();
            OLogSegment first = this.logSegments.get(0);
            if (first.filledUpTo() > 0L) {
                OLogSequenceNumber oLogSequenceNumber = first.begin();
                return oLogSequenceNumber;
            }
            for (int index = 1; index < this.logSegments.size(); ++index) {
                first = this.logSegments.get(index);
                if (first.filledUpTo() <= 0L) continue;
                OLogSequenceNumber oLogSequenceNumber = first.begin();
                return oLogSequenceNumber;
            }
            OLogSequenceNumber oLogSequenceNumber = null;
            return oLogSequenceNumber;
        }
        finally {
            this.syncObject.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OLogSequenceNumber begin(long segmentId) throws IOException {
        this.syncObject.lock();
        try {
            this.checkForClose();
            for (OLogSegment logSegment : this.logSegments) {
                if (logSegment.getOrder() != segmentId) continue;
                OLogSequenceNumber oLogSequenceNumber = logSegment.begin();
                return oLogSequenceNumber;
            }
        }
        finally {
            this.syncObject.unlock();
        }
        return null;
    }

    @Override
    public OLogSequenceNumber end() {
        return this.end;
    }

    @Override
    public void flush() {
        OLogSegment last;
        this.syncObject.lock();
        try {
            this.checkForClose();
            last = this.logSegments.get(this.logSegments.size() - 1);
        }
        finally {
            this.syncObject.unlock();
        }
        last.flush();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OLogSequenceNumber logAtomicOperationStartRecord(boolean isRollbackSupported, OOperationUnitId unitId) throws IOException {
        OSessionStoragePerformanceStatistic statistic = this.performanceStatisticManager.getSessionPerformanceStatistic();
        if (statistic != null) {
            statistic.startWALLogRecordTimer();
        }
        try {
            OAtomicUnitStartRecord record = new OAtomicUnitStartRecord(isRollbackSupported, unitId);
            byte[] content = OWALRecordsFactory.INSTANCE.toStream(record);
            this.syncObject.lock();
            try {
                this.checkForClose();
                OLogSequenceNumber lsn = this.internalLog(record, content);
                this.activeOperations.add(unitId);
                OLogSequenceNumber oLogSequenceNumber = lsn;
                this.syncObject.unlock();
                return oLogSequenceNumber;
            }
            catch (Throwable throwable) {
                this.syncObject.unlock();
                throw throwable;
            }
        }
        finally {
            if (statistic != null) {
                statistic.stopWALRecordTimer(true, false);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OLogSequenceNumber logAtomicOperationEndRecord(OOperationUnitId operationUnitId, boolean rollback, OLogSequenceNumber startLsn, Map<String, OAtomicOperationMetadata<?>> atomicOperationMetadata) throws IOException {
        OSessionStoragePerformanceStatistic statistic = this.performanceStatisticManager.getSessionPerformanceStatistic();
        if (statistic != null) {
            statistic.startWALLogRecordTimer();
        }
        try {
            OAtomicUnitEndRecord record = new OAtomicUnitEndRecord(operationUnitId, rollback, atomicOperationMetadata);
            byte[] content = OWALRecordsFactory.INSTANCE.toStream(record);
            this.syncObject.lock();
            try {
                this.checkForClose();
                OLogSequenceNumber lsn = this.internalLog(record, content);
                this.activeOperations.remove(operationUnitId);
                OLogSequenceNumber oLogSequenceNumber = lsn;
                this.syncObject.unlock();
                return oLogSequenceNumber;
            }
            catch (Throwable throwable) {
                this.syncObject.unlock();
                throw throwable;
            }
        }
        finally {
            if (statistic != null) {
                statistic.stopWALRecordTimer(false, true);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OLogSequenceNumber log(OWALRecord record) throws IOException {
        OSessionStoragePerformanceStatistic statistic = this.performanceStatisticManager.getSessionPerformanceStatistic();
        if (statistic != null) {
            statistic.startWALLogRecordTimer();
        }
        try {
            OLogSequenceNumber oLogSequenceNumber = this.internalLog(record, OWALRecordsFactory.INSTANCE.toStream(record));
            return oLogSequenceNumber;
        }
        finally {
            if (statistic != null) {
                statistic.stopWALRecordTimer(false, false);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private OLogSequenceNumber internalLog(OWALRecord record, byte[] recordContent) throws IOException {
        this.syncObject.lock();
        try {
            this.checkForClose();
            if (this.segmentCreationFlag && record instanceof OOperationUnitRecord && !this.activeOperations.contains(((OOperationUnitRecord)record).getOperationUnitId())) {
                while (this.segmentCreationFlag) {
                    try {
                        this.segmentCreationComplete.await();
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                        throw OException.wrapException(new OInterruptedException("Segment creation was interrupted"), e);
                    }
                }
            }
            OLogSegment last = this.logSegments.get(this.logSegments.size() - 1);
            long lastSize = last.filledUpTo();
            OLogSequenceNumber lsn = last.logRecord(recordContent);
            record.setLsn(lsn);
            this.end = lsn;
            if (record.isUpdateMasterRecord()) {
                this.lastCheckpoint = lsn;
                if (this.useFirstMasterRecord) {
                    this.firstMasterRecord = lsn;
                    this.writeMasterRecord(0, this.firstMasterRecord);
                    this.useFirstMasterRecord = false;
                } else {
                    this.secondMasterRecord = lsn;
                    this.writeMasterRecord(1, this.secondMasterRecord);
                    this.useFirstMasterRecord = true;
                }
            }
            long sizeDiff = last.filledUpTo() - lastSize;
            this.logSize += sizeDiff;
            if (last.filledUpTo() >= this.maxSegmentSize) {
                this.segmentCreationFlag = true;
                if (record instanceof OAtomicUnitEndRecord && this.activeOperations.size() == 1 || !(record instanceof OOperationUnitRecord) && this.activeOperations.isEmpty()) {
                    this.appendNewSegment(last);
                    this.segmentCreationFlag = false;
                    this.segmentCreationComplete.signalAll();
                }
            }
            if (this.walSizeHardLimit < 0L && this.freeSpace > this.freeSpaceLimit) {
                this.walSizeLimit = this.logSize + this.freeSpace / 2L;
            }
            if (this.walSizeLimit > -1L && this.logSize > this.walSizeLimit && this.logSegments.size() > 1) {
                for (WeakReference weakReference : this.fullCheckpointListeners) {
                    OCheckpointRequestListener listener = (OCheckpointRequestListener)weakReference.get();
                    if (listener == null) continue;
                    listener.requestCheckpoint();
                }
            }
            OLogSequenceNumber oLogSequenceNumber = lsn;
            return oLogSequenceNumber;
        }
        finally {
            this.syncObject.unlock();
        }
    }

    @Override
    public void moveLsnAfter(OLogSequenceNumber lsn) throws IOException {
        this.syncObject.lock();
        try {
            if (!this.activeOperations.isEmpty()) {
                throw new OStorageException("Can not change end of WAL because there are active atomic operations in the log.");
            }
            if (this.end() == null) {
                throw new OStorageException("Can not change end of WAL because WAL is empty");
            }
            if (this.end().compareTo(lsn) > 0) {
                return;
            }
            OLogSegment last = this.logSegments.get(this.logSegments.size() - 1);
            last.stopBackgroundWrite(true);
            if (last.filledUpTo() == 0L) {
                last.delete(false);
                this.logSegments.remove(this.logSegments.size() - 1);
            }
            last = new OLogSegmentV2(this, this.walLocation.resolve(this.getSegmentName(lsn.getSegment() + 1L)), this.maxPagesCacheSize, this.fileTTL, this.segmentBufferSize, new SubScheduledExecutorService(this.autoFileCloser), new SubScheduledExecutorService(this.commitExecutor));
            last.init();
            last.startBackgroundWrite();
            this.logSegments.add(last);
        }
        finally {
            this.syncObject.unlock();
        }
    }

    private void appendNewSegment(OLogSegment last) throws IOException {
        last.stopBackgroundWrite(true);
        last = new OLogSegmentV2(this, this.walLocation.resolve(this.getSegmentName(last.getOrder() + 1L)), this.maxPagesCacheSize, this.fileTTL, this.segmentBufferSize, new SubScheduledExecutorService(this.autoFileCloser), new SubScheduledExecutorService(this.commitExecutor));
        last.init();
        last.startBackgroundWrite();
        this.logSegments.add(last);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long activeSegment() {
        this.syncObject.lock();
        try {
            OLogSegment last = this.logSegments.get(this.logSegments.size() - 1);
            long l = last.getOrder();
            return l;
        }
        finally {
            this.syncObject.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public File[] nonActiveSegments(long fromSegment) {
        ArrayList<File> result = new ArrayList<File>();
        this.syncObject.lock();
        try {
            for (int i = 0; i < this.logSegments.size() - 1; ++i) {
                OLogSegment logSegment = this.logSegments.get(i);
                if (logSegment.getOrder() < fromSegment) continue;
                File fileLog = logSegment.getPath().toFile();
                result.add(fileLog);
            }
        }
        finally {
            this.syncObject.unlock();
        }
        File[] files = new File[result.size()];
        files = result.toArray(files);
        return files;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long[] nonActiveSegments() {
        long[] result;
        this.syncObject.lock();
        try {
            result = new long[this.logSegments.size() - 1];
            for (int i = 0; i < this.logSegments.size() - 1; ++i) {
                OLogSegment logSegment = this.logSegments.get(i);
                result[i] = logSegment.getOrder();
            }
        }
        finally {
            this.syncObject.unlock();
        }
        return result;
    }

    public long size() {
        return this.logSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> getWalFiles() {
        ArrayList<String> result = new ArrayList<String>();
        this.syncObject.lock();
        try {
            for (OLogSegment segment : this.logSegments) {
                result.add(segment.getPath().toString());
            }
        }
        finally {
            this.syncObject.unlock();
        }
        return result;
    }

    public Path getWMRFile() {
        this.syncObject.lock();
        try {
            Path path = this.masterRecordPath;
            return path;
        }
        finally {
            this.syncObject.unlock();
        }
    }

    @Override
    public void truncate() throws IOException {
        this.syncObject.lock();
        try {
            if (this.logSegments.size() < 2) {
                return;
            }
            ListIterator<OLogSegment> iterator = this.logSegments.listIterator(this.logSegments.size() - 1);
            while (iterator.hasPrevious()) {
                OLogSegment logSegment = iterator.previous();
                logSegment.delete(false);
                iterator.remove();
            }
            this.recalculateLogSize();
        }
        finally {
            this.syncObject.unlock();
        }
    }

    @Override
    public void close() throws IOException {
        this.close(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close(boolean flush) throws IOException {
        this.syncObject.lock();
        try {
            if (this.closed) {
                return;
            }
            this.closed = true;
            this.cutTillLimits.clear();
            for (OLogSegment logSegment : this.logSegments) {
                logSegment.close(flush);
            }
            if (!this.commitExecutor.isShutdown()) {
                this.commitExecutor.shutdown();
                try {
                    if (!this.commitExecutor.awaitTermination(OGlobalConfiguration.WAL_SHUTDOWN_TIMEOUT.getValueAsInteger(), TimeUnit.MILLISECONDS)) {
                        throw new OStorageException("WAL flush task for '" + this.getStorage().getName() + "' storage cannot be stopped");
                    }
                }
                catch (InterruptedException e) {
                    OLogManager.instance().error(this, "Cannot shutdown background WAL commit thread", e, new Object[0]);
                }
            }
            if (!this.events.isEmpty()) {
                OLogManager.instance().warn((Object)this, "There are unfired events left waiting to happen after the shutdown.", new Object[0]);
                assert (false);
            }
            if (!this.autoFileCloser.isShutdown()) {
                this.autoFileCloser.shutdown();
                try {
                    if (!this.autoFileCloser.awaitTermination(OGlobalConfiguration.WAL_SHUTDOWN_TIMEOUT.getValueAsInteger(), TimeUnit.MILLISECONDS)) {
                        throw new OStorageException("WAL file auto close tasks '" + this.getStorage().getName() + "' storage cannot be stopped");
                    }
                }
                catch (InterruptedException e) {
                    OLogManager.instance().error(this, "Shutdown of file auto close tasks was interrupted", e, new Object[0]);
                }
            }
            this.masterRecordLSNHolder.close();
        }
        finally {
            this.syncObject.unlock();
        }
    }

    @Override
    public void delete() throws IOException {
        this.delete(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void delete(boolean flush) throws IOException {
        this.syncObject.lock();
        try {
            this.close(flush);
            for (OLogSegment logSegment : this.logSegments) {
                logSegment.delete(false);
            }
            Files.deleteIfExists(this.masterRecordPath);
        }
        finally {
            this.syncObject.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OWALRecord read(OLogSequenceNumber lsn) throws IOException {
        this.syncObject.lock();
        try {
            this.checkForClose();
            long segment = lsn.getSegment();
            int index = (int)(segment - this.logSegments.get(0).getOrder());
            if (index < 0 || index >= this.logSegments.size()) {
                OWALRecord oWALRecord = null;
                return oWALRecord;
            }
            OLogSegment logSegment = this.logSegments.get(index);
            byte[] recordEntry = logSegment.readRecord(lsn);
            if (recordEntry == null) {
                OWALRecord oWALRecord = null;
                return oWALRecord;
            }
            OWALRecord record = OWALRecordsFactory.INSTANCE.fromStream(recordEntry);
            record.setLsn(lsn);
            OWALRecord oWALRecord = record;
            return oWALRecord;
        }
        finally {
            this.syncObject.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OLogSequenceNumber next(OLogSequenceNumber lsn) throws IOException {
        this.syncObject.lock();
        try {
            OLogSequenceNumber oLogSequenceNumber;
            this.checkForClose();
            long order = lsn.getSegment();
            int index = (int)(order - this.logSegments.get(0).getOrder());
            if (index < 0 || index >= this.logSegments.size()) {
                OLogSequenceNumber oLogSequenceNumber2 = null;
                return oLogSequenceNumber2;
            }
            OLogSegment logSegment = this.logSegments.get(index);
            OLogSequenceNumber nextLSN = logSegment.getNextLSN(lsn);
            while (nextLSN == null) {
                if (++index >= this.logSegments.size()) {
                    oLogSequenceNumber = null;
                    return oLogSequenceNumber;
                }
                OLogSegment nextSegment = this.logSegments.get(index);
                if (nextSegment.filledUpTo() == 0L) continue;
                nextLSN = nextSegment.begin();
            }
            oLogSequenceNumber = nextLSN;
            return oLogSequenceNumber;
        }
        finally {
            this.syncObject.unlock();
        }
    }

    @Override
    public OLogSequenceNumber getFlushedLsn() {
        return this.flushedLsn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean cutTill(OLogSequenceNumber lsn) throws IOException {
        this.syncObject.lock();
        try {
            OLogSegment logSegment;
            OLogSequenceNumber end;
            this.checkForClose();
            this.flush();
            Map.Entry<OLogSequenceNumber, Integer> firsEntry = this.cutTillLimits.firstEntry();
            if (firsEntry != null && lsn.compareTo(firsEntry.getKey()) > 0) {
                lsn = firsEntry.getKey();
            }
            int lastTruncateIndex = -1;
            int i = 0;
            while (i < this.logSegments.size() - 1 && (end = (logSegment = this.logSegments.get(i)).end()) != null && end.compareTo(lsn) < 0) {
                lastTruncateIndex = i++;
            }
            for (i = 0; i <= lastTruncateIndex; ++i) {
                logSegment = this.removeHeadSegmentFromList();
                if (logSegment == null) continue;
                logSegment.delete(false);
            }
            this.recalculateLogSize();
            this.fixMasterRecords();
            boolean bl = lastTruncateIndex != -1;
            return bl;
        }
        finally {
            this.syncObject.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cutAllSegmentsSmallerThan(long segmentId) throws IOException {
        this.syncObject.lock();
        try {
            OLogSegment logSegment;
            this.checkForClose();
            this.flush();
            Map.Entry<OLogSequenceNumber, Integer> firsEntry = this.cutTillLimits.firstEntry();
            if (firsEntry != null && segmentId > firsEntry.getKey().getSegment()) {
                segmentId = firsEntry.getKey().getSegment();
            }
            int lastTruncateIndex = -1;
            int i = 0;
            while (i < this.logSegments.size() - 1 && (logSegment = this.logSegments.get(i)).getOrder() < segmentId) {
                lastTruncateIndex = i++;
            }
            for (i = 0; i <= lastTruncateIndex; ++i) {
                logSegment = this.removeHeadSegmentFromList();
                if (logSegment == null) continue;
                logSegment.delete(false);
            }
            this.recalculateLogSize();
            this.fixMasterRecords();
        }
        finally {
            this.syncObject.unlock();
        }
    }

    @Override
    public void addCutTillLimit(OLogSequenceNumber lsn) {
        if (lsn == null) {
            throw new NullPointerException();
        }
        this.syncObject.lock();
        try {
            this.cutTillLimits.merge(lsn, 1, (a, b) -> a + b);
        }
        finally {
            this.syncObject.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeCutTillLimit(OLogSequenceNumber lsn) {
        if (lsn == null) {
            throw new NullPointerException();
        }
        this.syncObject.lock();
        try {
            Integer oldCounter = this.cutTillLimits.get(lsn);
            if (oldCounter == null) {
                throw new IllegalArgumentException(String.format("Limit %s is going to be removed but it was not added", lsn));
            }
            Integer newCounter = oldCounter - 1;
            if (newCounter == 0) {
                this.cutTillLimits.remove(lsn);
            } else {
                this.cutTillLimits.put(lsn, newCounter);
            }
        }
        finally {
            this.syncObject.unlock();
        }
    }

    private OLogSegment removeHeadSegmentFromList() {
        if (this.logSegments.size() < 2) {
            return null;
        }
        return this.logSegments.remove(0);
    }

    private void recalculateLogSize() {
        this.logSize = 0L;
        for (OLogSegment segment : this.logSegments) {
            this.logSize += segment.filledUpTo();
        }
    }

    private void fixMasterRecords() throws IOException {
        int index;
        if (this.firstMasterRecord != null) {
            index = (int)(this.firstMasterRecord.getSegment() - this.logSegments.get(0).getOrder());
            if (this.logSegments.size() <= index || index < 0) {
                this.firstMasterRecord = null;
            } else {
                OLogSegment firstMasterRecordSegment = this.logSegments.get(index);
                if (firstMasterRecordSegment.filledUpTo() <= this.firstMasterRecord.getPosition()) {
                    this.firstMasterRecord = null;
                }
            }
        }
        if (this.secondMasterRecord != null) {
            index = (int)(this.secondMasterRecord.getSegment() - this.logSegments.get(0).getOrder());
            if (this.logSegments.size() <= index || index < 0) {
                this.secondMasterRecord = null;
            } else {
                OLogSegment secondMasterRecordSegment = this.logSegments.get(index);
                if (secondMasterRecordSegment.filledUpTo() <= this.secondMasterRecord.getPosition()) {
                    this.secondMasterRecord = null;
                }
            }
        }
        if (this.firstMasterRecord != null && this.secondMasterRecord != null) {
            return;
        }
        if (this.firstMasterRecord == null && this.secondMasterRecord == null) {
            this.masterRecordLSNHolder.truncate(0L);
            this.masterRecordLSNHolder.force(true);
            this.lastCheckpoint = null;
        } else {
            if (this.secondMasterRecord == null) {
                this.secondMasterRecord = this.firstMasterRecord;
            } else {
                this.firstMasterRecord = this.secondMasterRecord;
            }
            this.lastCheckpoint = this.firstMasterRecord;
            this.writeMasterRecord(0, this.firstMasterRecord);
            this.writeMasterRecord(1, this.secondMasterRecord);
        }
    }

    private OLogSequenceNumber readMasterRecord(String storageName, int index) throws IOException {
        long masterPosition = (long)index * 20L;
        if (this.masterRecordLSNHolder.size() < masterPosition + 20L) {
            OLogManager.instance().debug((Object)this, "Cannot restore %d WAL master record for storage %s", index, storageName);
            return null;
        }
        CRC32 crc32 = new CRC32();
        try {
            ByteBuffer buffer = ByteBuffer.allocate(20);
            OIOUtils.readByteBuffer(buffer, this.masterRecordLSNHolder, masterPosition, true);
            buffer.rewind();
            int firstCRC = buffer.getInt();
            long segment = buffer.getLong();
            long position = buffer.getLong();
            byte[] serializedLSN = new byte[16];
            OLongSerializer.INSTANCE.serializeLiteral(segment, serializedLSN, 0);
            OLongSerializer.INSTANCE.serializeLiteral(position, serializedLSN, 8);
            crc32.update(serializedLSN);
            if (firstCRC != (int)crc32.getValue()) {
                OLogManager.instance().error(this, "Cannot restore %d WAL master record for storage %s crc check is failed", null, index, storageName);
                return null;
            }
            return new OLogSequenceNumber(segment, position);
        }
        catch (EOFException eofException) {
            OLogManager.instance().debug((Object)this, "Cannot restore %d WAL master record for storage %s", eofException, index, storageName);
            return null;
        }
    }

    private void writeMasterRecord(int index, OLogSequenceNumber masterRecord) throws IOException {
        this.masterRecordLSNHolder.position();
        CRC32 crc32 = new CRC32();
        byte[] serializedLSN = new byte[16];
        OLongSerializer.INSTANCE.serializeLiteral(masterRecord.getSegment(), serializedLSN, 0);
        OLongSerializer.INSTANCE.serializeLiteral(masterRecord.getPosition(), serializedLSN, 8);
        crc32.update(serializedLSN);
        ByteBuffer buffer = ByteBuffer.allocate(20);
        buffer.putInt((int)crc32.getValue());
        buffer.putLong(masterRecord.getSegment());
        buffer.putLong(masterRecord.getPosition());
        buffer.rewind();
        OIOUtils.writeByteBuffer(buffer, this.masterRecordLSNHolder, (long)index * 20L);
    }

    private OLogSequenceNumber findFlushedLSN() {
        for (int segment = this.logSegments.size() - 1; segment >= 0; --segment) {
            OLogSegment logSegment = this.logSegments.get(segment);
            OLogSequenceNumber flushedLSN = logSegment.end();
            if (flushedLSN == null) {
                continue;
            }
            return flushedLSN;
        }
        return null;
    }

    private OLocalPaginatedStorage getStorage() {
        return this.storage;
    }

    void setFlushedLsn(OLogSequenceNumber newLsn) {
        OLogSequenceNumber oldLsn = this.flushedLsn;
        if (oldLsn != null && newLsn.compareTo(oldLsn) <= 0) {
            throw new IllegalStateException("new flushed LSN must be newer than the old one, old = " + oldLsn + ", new = " + newLsn);
        }
        this.flushedLsn = newLsn;
        this.fireEventsFor(newLsn);
    }

    public void checkFreeSpace() throws IOException {
        this.freeSpace = this.fileStore.getUsableSpace();
        if (this.freeSpace < 0L) {
            return;
        }
        if (this.freeSpace < this.freeSpaceLimit) {
            for (WeakReference<OLowDiskSpaceListener> listenerWeakReference : this.lowDiskSpaceListeners) {
                OLowDiskSpaceListener lowDiskSpaceListener = (OLowDiskSpaceListener)listenerWeakReference.get();
                if (lowDiskSpaceListener == null) continue;
                lowDiskSpaceListener.lowDiskSpace(new OLowDiskSpaceInformation(this.freeSpace, this.freeSpaceLimit));
            }
        }
    }

    int getCommitDelay() {
        return this.commitDelay;
    }

    @Override
    public void addEventAt(OLogSequenceNumber lsn, Runnable event) {
        OLogSequenceNumber localFlushedLsn = this.flushedLsn;
        if (localFlushedLsn != null && lsn.compareTo(localFlushedLsn) <= 0) {
            event.run();
        } else {
            this.events.put(lsn, event);
            OLogSequenceNumber potentiallyUpdatedLocalFlushedLsn = this.flushedLsn;
            if (potentiallyUpdatedLocalFlushedLsn != null && lsn.compareTo(potentiallyUpdatedLocalFlushedLsn) <= 0) {
                this.commitExecutor.execute(() -> this.fireEventsFor(potentiallyUpdatedLocalFlushedLsn));
            }
        }
    }

    @Override
    public boolean appendNewSegment() {
        this.syncObject.lock();
        try {
            if (!this.activeOperations.isEmpty()) {
                throw new OStorageException("Can not change end of WAL because there are active atomic operations in the log.");
            }
            if (this.end() == null) {
                boolean bl = false;
                return bl;
            }
            OLogSegment last = this.logSegments.get(this.logSegments.size() - 1);
            if (last.filledUpTo() == 0L) {
                boolean bl = false;
                return bl;
            }
            this.appendNewSegment(last);
            boolean bl = true;
            return bl;
        }
        catch (IOException ioe) {
            throw OException.wrapException(new OIOException("Error during appending of new segment to the WAL"), ioe);
        }
        finally {
            this.syncObject.unlock();
        }
    }

    private void fireEventsFor(OLogSequenceNumber lsn) {
        Iterator eventsToFire = this.events.headMap((Object)lsn, true).values().iterator();
        while (eventsToFire.hasNext()) {
            ((Runnable)eventsToFire.next()).run();
            eventsToFire.remove();
        }
    }
}

