/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.storage.impl.local.paginated;

import com.orientechnologies.common.io.OIOUtils;
import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.orient.core.config.OGlobalConfiguration;
import com.orientechnologies.orient.core.exception.OStorageException;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.channels.OverlappingFileLockException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public class OPaginatedStorageDirtyFlag {
    private final Path dirtyFilePath;
    private FileChannel channel;
    private FileLock fileLock;
    private volatile boolean dirtyFlag;
    private final Lock lock = new ReentrantLock();

    public OPaginatedStorageDirtyFlag(Path dirtyFilePath) {
        this.dirtyFilePath = dirtyFilePath;
    }

    public void create() throws IOException {
        this.lock.lock();
        try {
            if (Files.exists(this.dirtyFilePath, new LinkOption[0])) {
                Files.delete(this.dirtyFilePath);
            }
            this.channel = FileChannel.open(this.dirtyFilePath, StandardOpenOption.READ, StandardOpenOption.CREATE, StandardOpenOption.WRITE);
            if (OGlobalConfiguration.FILE_LOCK.getValueAsBoolean()) {
                this.lockFile();
            }
            ByteBuffer buffer = ByteBuffer.allocate(1);
            buffer.put((byte)1);
            buffer.position(0);
            OIOUtils.writeByteBuffer(buffer, this.channel, 0L);
            this.dirtyFlag = true;
        }
        finally {
            this.lock.unlock();
        }
    }

    private void lockFile() throws IOException {
        try {
            this.fileLock = this.channel.tryLock();
        }
        catch (OverlappingFileLockException e) {
            OLogManager.instance().warn((Object)this, "File is already locked by other thread", e, new Object[0]);
        }
        if (this.fileLock == null) {
            throw new OStorageException("Database is locked by another process, please shutdown process and try again");
        }
    }

    public boolean exists() {
        this.lock.lock();
        try {
            boolean bl = Files.exists(this.dirtyFilePath, new LinkOption[0]);
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    public void open() throws IOException {
        this.lock.lock();
        try {
            ByteBuffer buffer;
            if (!Files.exists(this.dirtyFilePath, new LinkOption[0])) {
                this.channel = FileChannel.open(this.dirtyFilePath, StandardOpenOption.WRITE, StandardOpenOption.READ, StandardOpenOption.CREATE);
                buffer = ByteBuffer.allocate(1);
                OIOUtils.writeByteBuffer(buffer, this.channel, 0L);
            } else {
                this.channel = FileChannel.open(this.dirtyFilePath, StandardOpenOption.WRITE, StandardOpenOption.READ, StandardOpenOption.CREATE);
            }
            if (OGlobalConfiguration.FILE_LOCK.getValueAsBoolean()) {
                this.lockFile();
            }
            buffer = ByteBuffer.allocate(1);
            OIOUtils.readByteBuffer(buffer, this.channel, 0L, true);
            buffer.position(0);
            this.dirtyFlag = buffer.get() > 0;
        }
        finally {
            this.lock.unlock();
        }
    }

    public void close() throws IOException {
        this.lock.lock();
        try {
            if (this.channel == null) {
                return;
            }
            if (Files.exists(this.dirtyFilePath, new LinkOption[0])) {
                if (this.fileLock != null) {
                    this.fileLock.release();
                    this.fileLock = null;
                }
                this.channel.close();
                this.channel = null;
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    public void delete() throws IOException {
        this.lock.lock();
        try {
            if (this.channel == null) {
                return;
            }
            if (Files.exists(this.dirtyFilePath, new LinkOption[0])) {
                if (this.fileLock != null) {
                    this.fileLock.release();
                    this.fileLock = null;
                }
                this.channel.close();
                this.channel = null;
                Files.delete(this.dirtyFilePath);
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    public void makeDirty() throws IOException {
        if (this.dirtyFlag) {
            return;
        }
        this.lock.lock();
        try {
            if (this.dirtyFlag) {
                return;
            }
            ByteBuffer buffer = ByteBuffer.allocate(1);
            buffer.put((byte)1);
            buffer.position(0);
            OIOUtils.writeByteBuffer(buffer, this.channel, 0L);
            this.dirtyFlag = true;
        }
        finally {
            this.lock.unlock();
        }
    }

    public void clearDirty() throws IOException {
        if (!this.dirtyFlag) {
            return;
        }
        this.lock.lock();
        try {
            if (!this.dirtyFlag) {
                return;
            }
            ByteBuffer buffer = ByteBuffer.allocate(1);
            OIOUtils.writeByteBuffer(buffer, this.channel, 0L);
            this.dirtyFlag = false;
        }
        finally {
            this.lock.unlock();
        }
    }

    public boolean isDirty() {
        return this.dirtyFlag;
    }
}

