/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.storage.impl.local.paginated;

import com.orientechnologies.common.collection.closabledictionary.OClosableLinkedContainer;
import com.orientechnologies.common.directmemory.OByteBufferPool;
import com.orientechnologies.common.io.OFileUtils;
import com.orientechnologies.common.io.OIOUtils;
import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.common.parser.OSystemVariableResolver;
import com.orientechnologies.orient.core.command.OCommandOutputListener;
import com.orientechnologies.orient.core.compression.impl.OZIPCompressionUtil;
import com.orientechnologies.orient.core.config.OContextConfiguration;
import com.orientechnologies.orient.core.config.OGlobalConfiguration;
import com.orientechnologies.orient.core.exception.OStorageException;
import com.orientechnologies.orient.core.storage.OChecksumMode;
import com.orientechnologies.orient.core.storage.OStorage;
import com.orientechnologies.orient.core.storage.cache.OReadCache;
import com.orientechnologies.orient.core.storage.cache.local.OWOWCache;
import com.orientechnologies.orient.core.storage.fs.OFileClassic;
import com.orientechnologies.orient.core.storage.impl.local.OAbstractPaginatedStorage;
import com.orientechnologies.orient.core.storage.impl.local.OStorageConfigurationSegment;
import com.orientechnologies.orient.core.storage.impl.local.OStorageVariableParser;
import com.orientechnologies.orient.core.storage.impl.local.paginated.OPaginatedStorageDirtyFlag;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.ODiskWriteAheadLog;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.OLogSequenceNumber;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.OWriteAheadLog;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

public class OLocalPaginatedStorage
extends OAbstractPaginatedStorage {
    private static final String[] ALL_FILE_EXTENSIONS = new String[]{".ocf", ".pls", ".pcl", ".oda", ".odh", ".otx", ".ocs", ".oef", ".oem", ".oet", ".fl", ".wal", ".wmr", ".hib", ".him", ".hit", ".hnb", ".cpm", ".sbt", ".cm", ".irs", ".sbc", ".nbt", ".stt"};
    private static final int ONE_KB = 1024;
    private final int DELETE_MAX_RETRIES;
    private final int DELETE_WAIT_TIME;
    private final OStorageVariableParser variableParser;
    private final OPaginatedStorageDirtyFlag dirtyFlag;
    private final Path storagePath;
    private final OClosableLinkedContainer<Long, OFileClassic> files;

    public OLocalPaginatedStorage(String name, String filePath, String mode, int id, OReadCache readCache, OClosableLinkedContainer<Long, OFileClassic> files) throws IOException {
        super(name, filePath, mode, id);
        this.files = files;
        this.readCache = readCache;
        File f = new File(this.url);
        String sp = f.exists() || !OLocalPaginatedStorage.exists(Paths.get(f.getParent(), new String[0])) ? OSystemVariableResolver.resolveSystemVariables(OFileUtils.getPath(new File(this.url).getPath())) : OSystemVariableResolver.resolveSystemVariables(OFileUtils.getPath(new File(this.url).getParent()));
        this.storagePath = Paths.get(OIOUtils.getPathFromDatabaseName(sp), new String[0]);
        this.variableParser = new OStorageVariableParser(this.storagePath);
        this.configuration = new OStorageConfigurationSegment(this);
        this.DELETE_MAX_RETRIES = this.getConfiguration().getContextConfiguration().getValueAsInteger(OGlobalConfiguration.FILE_DELETE_RETRY);
        this.DELETE_WAIT_TIME = this.getConfiguration().getContextConfiguration().getValueAsInteger(OGlobalConfiguration.FILE_DELETE_DELAY);
        this.dirtyFlag = new OPaginatedStorageDirtyFlag(this.storagePath.resolve("dirty.fl"));
    }

    @Override
    public void create(OContextConfiguration contextConfiguration) throws IOException {
        try {
            this.stateLock.acquireWriteLock();
            try {
                Path storageFolder = this.storagePath;
                if (!Files.exists(storageFolder, new LinkOption[0])) {
                    Files.createDirectories(storageFolder, new FileAttribute[0]);
                }
                super.create(contextConfiguration);
            }
            finally {
                this.stateLock.releaseWriteLock();
            }
        }
        catch (RuntimeException e) {
            throw this.logAndPrepareForRethrow(e);
        }
        catch (Error e) {
            throw this.logAndPrepareForRethrow(e);
        }
        catch (Throwable t) {
            throw this.logAndPrepareForRethrow(t);
        }
    }

    @Override
    protected String normalizeName(String name) {
        int firstIndexOf = name.lastIndexOf(47);
        int secondIndexOf = name.lastIndexOf(File.separator);
        if (firstIndexOf >= 0 || secondIndexOf >= 0) {
            return name.substring(Math.max(firstIndexOf, secondIndexOf) + 1);
        }
        return name;
    }

    @Override
    public boolean exists() {
        try {
            if (this.status == OStorage.STATUS.OPEN) {
                return true;
            }
            return OLocalPaginatedStorage.exists(this.storagePath);
        }
        catch (RuntimeException e) {
            throw this.logAndPrepareForRethrow(e);
        }
        catch (Error e) {
            throw this.logAndPrepareForRethrow(e);
        }
        catch (Throwable t) {
            throw this.logAndPrepareForRethrow(t);
        }
    }

    @Override
    public String getURL() {
        return "plocal:" + this.url;
    }

    public Path getStoragePath() {
        return this.storagePath;
    }

    public OStorageVariableParser getVariableParser() {
        return this.variableParser;
    }

    @Override
    public String getType() {
        return "plocal";
    }

    /*
     * Exception decompiling
     */
    @Override
    public List<String> backup(OutputStream out, Map<String, Object> options, Callable<Object> callable, OCommandOutputListener iOutput, int compressionLevel, int bufferSize) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void restore(InputStream in, Map<String, Object> options, Callable<Object> callable, OCommandOutputListener iListener) throws IOException {
        try {
            if (!this.isClosed()) {
                this.close(true, false);
            }
            try {
                block18: {
                    this.stateLock.acquireWriteLock();
                    File dbDir = new File(OIOUtils.getPathFromDatabaseName(OSystemVariableResolver.resolveSystemVariables(this.url)));
                    File[] storageFiles = dbDir.listFiles();
                    if (storageFiles != null) {
                        block11: for (File f : storageFiles) {
                            for (String ext : ALL_FILE_EXTENSIONS) {
                                if (!f.getPath().endsWith(ext)) continue;
                                f.delete();
                                continue block11;
                            }
                        }
                    }
                    OZIPCompressionUtil.uncompressDirectory(in, this.getStoragePath().toString(), iListener);
                    Path cacheStateFile = this.getStoragePath().resolve("cache.stt");
                    if (Files.exists(cacheStateFile, new LinkOption[0])) {
                        String message = "the cache state file (cache.stt) is found in the backup, deleting the file";
                        OLogManager.instance().warn((Object)this, message, new Object[0]);
                        if (iListener != null) {
                            iListener.onMessage('\n' + message);
                        }
                        try {
                            Files.deleteIfExists(cacheStateFile);
                        }
                        catch (IOException e) {
                            message = "unable to delete the backed up cache state file (cache.stt), please delete it manually";
                            OLogManager.instance().warn((Object)this, message, e, new Object[0]);
                            if (iListener == null) break block18;
                            iListener.onMessage('\n' + message);
                        }
                    }
                }
                if (callable != null) {
                    try {
                        callable.call();
                    }
                    catch (Exception e) {
                        OLogManager.instance().error(this, "Error on calling callback on database restore", e, new Object[0]);
                    }
                }
            }
            finally {
                this.stateLock.releaseWriteLock();
            }
            this.open(null, null, new OContextConfiguration());
        }
        catch (RuntimeException e) {
            throw this.logAndPrepareForRethrow(e);
        }
        catch (Error e) {
            throw this.logAndPrepareForRethrow(e);
        }
        catch (Throwable t) {
            throw this.logAndPrepareForRethrow(t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected OLogSequenceNumber copyWALToIncrementalBackup(ZipOutputStream zipOutputStream, long startSegment) throws IOException {
        File[] nonActiveSegments;
        OLogSequenceNumber lastLSN;
        long freezeId = this.getAtomicOperationsManager().freezeAtomicOperations(null, null);
        try {
            lastLSN = this.writeAheadLog.end();
            this.writeAheadLog.appendNewSegment();
            nonActiveSegments = this.writeAheadLog.nonActiveSegments(startSegment);
        }
        finally {
            this.getAtomicOperationsManager().releaseAtomicOperations(freezeId);
        }
        for (File nonActiveSegment : nonActiveSegments) {
            try (FileInputStream fileInputStream = new FileInputStream(nonActiveSegment);
                 BufferedInputStream bufferedInputStream = new BufferedInputStream(fileInputStream);){
                ZipEntry entry = new ZipEntry(nonActiveSegment.getName());
                zipOutputStream.putNextEntry(entry);
                try {
                    int br;
                    byte[] buffer = new byte[4096];
                    while ((br = bufferedInputStream.read(buffer)) >= 0) {
                        zipOutputStream.write(buffer, 0, br);
                    }
                }
                finally {
                    zipOutputStream.closeEntry();
                }
            }
        }
        return lastLSN;
    }

    @Override
    protected File createWalTempDirectory() {
        File walDirectory = new File(this.getStoragePath().toFile(), "walIncrementalBackupRestoreDirectory");
        if (walDirectory.exists()) {
            OFileUtils.deleteRecursively(walDirectory);
        }
        if (!walDirectory.mkdirs()) {
            throw new OStorageException("Can not create temporary directory to store files created during incremental backup");
        }
        return walDirectory;
    }

    @Override
    protected void addFileToDirectory(String name, InputStream stream, File directory) throws IOException {
        byte[] buffer = new byte[4096];
        int rb = -1;
        int bl = 0;
        File walBackupFile = new File(directory, name);
        try (FileOutputStream outputStream = new FileOutputStream(walBackupFile);
             BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(outputStream);){
            while (true) {
                if (bl < buffer.length && (rb = stream.read(buffer, bl, buffer.length - bl)) > -1) {
                    bl += rb;
                    continue;
                }
                bufferedOutputStream.write(buffer, 0, bl);
                bl = 0;
                if (rb < 0) break;
            }
        }
    }

    @Override
    protected OWriteAheadLog createWalFromIBUFiles(File directory) throws IOException {
        ODiskWriteAheadLog restoreWAL = new ODiskWriteAheadLog(OGlobalConfiguration.WAL_CACHE_SIZE.getValueAsInteger(), OGlobalConfiguration.WAL_COMMIT_TIMEOUT.getValueAsInteger(), (long)OGlobalConfiguration.WAL_MAX_SEGMENT_SIZE.getValueAsInteger() * 1024L * 1024L, directory.getAbsolutePath(), false, this, OGlobalConfiguration.WAL_SEGMENT_BUFFER_SIZE.getValueAsInteger() * 1024 * 1024, OGlobalConfiguration.WAL_FILE_AUTOCLOSE_INTERVAL.getValueAsInteger());
        return restoreWAL;
    }

    @Override
    protected void preOpenSteps() throws IOException {
        if (this.configuration.getBinaryFormatVersion() >= 11) {
            if (this.dirtyFlag.exists()) {
                this.dirtyFlag.open();
            } else {
                this.dirtyFlag.create();
                this.dirtyFlag.makeDirty();
            }
        } else if (this.dirtyFlag.exists()) {
            this.dirtyFlag.open();
        } else {
            this.dirtyFlag.create();
            this.dirtyFlag.clearDirty();
        }
    }

    @Override
    protected void preCreateSteps() throws IOException {
        this.dirtyFlag.create();
    }

    @Override
    protected void postCloseSteps(boolean onDelete, boolean jvmError) throws IOException {
        if (onDelete) {
            this.dirtyFlag.delete();
        } else {
            if (!jvmError) {
                this.dirtyFlag.clearDirty();
            }
            this.dirtyFlag.close();
        }
    }

    @Override
    protected void postDeleteSteps() {
        File dbDir = new File(OIOUtils.getPathFromDatabaseName(OSystemVariableResolver.resolveSystemVariables(this.url)));
        if (!dbDir.exists() || !dbDir.isDirectory()) {
            dbDir = dbDir.getParentFile();
        }
        for (int i = 0; i < this.DELETE_MAX_RETRIES; ++i) {
            if (dbDir != null && dbDir.exists() && dbDir.isDirectory()) {
                int notDeletedFiles = 0;
                File[] storageFiles = dbDir.listFiles();
                if (storageFiles == null) continue;
                block1: for (File f : storageFiles) {
                    for (String ext : ALL_FILE_EXTENSIONS) {
                        if (!f.getPath().endsWith(ext)) continue;
                        if (f.delete()) continue block1;
                        ++notDeletedFiles;
                        continue block1;
                    }
                }
                if (notDeletedFiles == 0) {
                    if (!dbDir.delete()) {
                        OLogManager.instance().error(this, "Cannot delete storage directory with path " + dbDir.getAbsolutePath() + " because directory is not empty. Files: " + Arrays.toString(dbDir.listFiles()), null, new Object[0]);
                    }
                    return;
                }
            } else {
                return;
            }
            OLogManager.instance().debug((Object)this, "Cannot delete database files because they are still locked by the OrientDB process: waiting %d ms and retrying %d/%d...", this.DELETE_WAIT_TIME, i, this.DELETE_MAX_RETRIES);
        }
        throw new OStorageException("Cannot delete database '" + this.name + "' located in: " + dbDir + ". Database files seem locked");
    }

    @Override
    protected void makeStorageDirty() throws IOException {
        this.dirtyFlag.makeDirty();
    }

    @Override
    protected void clearStorageDirty() throws IOException {
        this.dirtyFlag.clearDirty();
    }

    @Override
    protected boolean isDirty() {
        return this.dirtyFlag.isDirty();
    }

    @Override
    protected boolean isWriteAllowedDuringIncrementalBackup() {
        return true;
    }

    @Override
    protected void initWalAndDiskCache(OContextConfiguration contextConfiguration) throws IOException, InterruptedException {
        if (this.getConfiguration().getContextConfiguration().getValueAsBoolean(OGlobalConfiguration.USE_WAL)) {
            this.fuzzyCheckpointExecutor.scheduleWithFixedDelay(new PeriodicFuzzyCheckpoint(), OGlobalConfiguration.WAL_FUZZY_CHECKPOINT_INTERVAL.getValueAsInteger(), OGlobalConfiguration.WAL_FUZZY_CHECKPOINT_INTERVAL.getValueAsInteger(), TimeUnit.SECONDS);
            ODiskWriteAheadLog diskWriteAheadLog = new ODiskWriteAheadLog(this);
            diskWriteAheadLog.addLowDiskSpaceListener(this);
            diskWriteAheadLog.checkFreeSpace();
            this.writeAheadLog = diskWriteAheadLog;
            this.writeAheadLog.addFullCheckpointListener(this);
        } else {
            this.writeAheadLog = null;
        }
        long diskCacheSize = OGlobalConfiguration.DISK_CACHE_SIZE.getValueAsLong() * 1024L * 1024L;
        long writeCacheSize = (long)Math.floor((double)OGlobalConfiguration.DISK_WRITE_CACHE_PART.getValueAsInteger() / 100.0 * (double)diskCacheSize);
        OWOWCache wowCache = new OWOWCache(OGlobalConfiguration.DISK_CACHE_PAGE_SIZE.getValueAsInteger() * 1024, OByteBufferPool.instance(), this.writeAheadLog, OGlobalConfiguration.DISK_WRITE_CACHE_PAGE_FLUSH_INTERVAL.getValueAsInteger(), writeCacheSize, this, true, this.files, this.getId(), contextConfiguration.getValueAsEnum(OGlobalConfiguration.STORAGE_CHECKSUM_MODE, OChecksumMode.class));
        wowCache.addLowDiskSpaceListener(this);
        wowCache.loadRegisteredFiles();
        wowCache.addBackgroundExceptionListener(this);
        wowCache.addPageIsBrokenListener(this);
        this.writeCache = wowCache;
    }

    public static boolean exists(Path path) {
        return Files.exists(path.resolve("database.ocf"), new LinkOption[0]);
    }

    private class PeriodicFuzzyCheckpoint
    implements Runnable {
        private PeriodicFuzzyCheckpoint() {
        }

        @Override
        public void run() {
            try {
                OLocalPaginatedStorage.this.makeFuzzyCheckpoint();
            }
            catch (RuntimeException e) {
                OLogManager.instance().error(this, "Error during fuzzy checkpoint", e, new Object[0]);
            }
        }
    }
}

