/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.storage.impl.local;

import com.orientechnologies.orient.core.config.OStorageFileConfiguration;
import com.orientechnologies.orient.core.storage.fs.OFile;
import com.orientechnologies.orient.core.storage.fs.OFileClassic;
import com.orientechnologies.orient.core.storage.impl.local.paginated.OLocalPaginatedStorage;
import java.io.IOException;
import java.nio.file.Paths;

public class OSingleFileSegment {
    private final OFile file;
    private final OStorageFileConfiguration config;

    public OSingleFileSegment(OLocalPaginatedStorage iStorage, OStorageFileConfiguration iConfig) {
        this(iStorage, iConfig, iConfig.type);
    }

    public OSingleFileSegment(OLocalPaginatedStorage iStorage, OStorageFileConfiguration iConfig, String iType) {
        this.config = iConfig;
        this.file = new OFileClassic(Paths.get(iStorage.getVariableParser().resolveVariables(iConfig.path), new String[0]));
    }

    public void open() {
        this.file.open();
    }

    public void create(int iStartSize) throws IOException {
        this.file.create();
    }

    public void close() {
        if (this.file != null) {
            this.file.close();
        }
    }

    public void delete() throws IOException {
        if (this.file != null) {
            this.file.delete();
        }
    }

    public void truncate() throws IOException {
        this.file.shrink(0L);
    }

    public boolean exists() {
        return this.file.exists();
    }

    public long getSize() {
        return this.file.getFileSize();
    }

    public long getFilledUpTo() {
        return this.file.getFileSize();
    }

    public OStorageFileConfiguration getConfig() {
        return this.config;
    }

    public OFile getFile() {
        return this.file;
    }

    public void synch() throws IOException {
        this.file.synch();
    }
}

